/*
 * Decompiled with CFR 0.152.
 */
package org.asf.connective;

import java.io.IOException;
import org.asf.connective.ConnectiveHttpServer;
import org.asf.connective.ContentSource;
import org.asf.connective.RemoteClient;
import org.asf.connective.objects.HttpRequest;
import org.asf.connective.objects.HttpResponse;
import org.asf.connective.processors.HttpPushProcessor;
import org.asf.connective.processors.HttpRequestProcessor;

class DefaultContentSource
extends ContentSource {
    DefaultContentSource() {
    }

    private String sanitizePath(String path) {
        if (((String)path).contains("\\")) {
            path = ((String)path).replace("\\", "/");
        }
        while (((String)path).startsWith("/")) {
            path = ((String)path).substring(1);
        }
        while (((String)path).endsWith("/")) {
            path = ((String)path).substring(0, ((String)path).length() - 1);
        }
        while (((String)path).contains("//")) {
            path = ((String)path).replace("//", "/");
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        return path;
    }

    @Override
    public boolean process(String path, HttpRequest request, HttpResponse response, RemoteClient client, ConnectiveHttpServer server) throws IOException {
        boolean compatible = false;
        HttpRequestProcessor[] processors = server.getAllRequestProcessors();
        if (request.hasRequestBody()) {
            Object supportedURL;
            Object url;
            HttpPushProcessor proc;
            HttpPushProcessor impl = null;
            for (HttpRequestProcessor p : processors) {
                if (!(p instanceof HttpPushProcessor) || (proc = (HttpPushProcessor)p).supportsChildPaths()) continue;
                url = request.getRequestPath();
                if (!((String)url).endsWith("/")) {
                    url = (String)url + "/";
                }
                if (!((String)(supportedURL = proc.path())).endsWith("/")) {
                    supportedURL = (String)supportedURL + "/";
                }
                if (!((String)url).equals(supportedURL)) continue;
                compatible = true;
                impl = proc;
                break;
            }
            if (!compatible) {
                for (HttpRequestProcessor p : processors) {
                    if (!(p instanceof HttpPushProcessor) || !(proc = (HttpPushProcessor)p).supportsChildPaths()) continue;
                    url = request.getRequestPath();
                    if (!((String)url).endsWith("/")) {
                        url = (String)url + "/";
                    }
                    if (!((String)(supportedURL = this.sanitizePath(proc.path()))).endsWith("/")) {
                        supportedURL = (String)supportedURL + "/";
                    }
                    if (!((String)url).startsWith((String)supportedURL)) continue;
                    compatible = true;
                    impl = proc;
                    break;
                }
            }
            if (compatible) {
                HttpPushProcessor processor = impl.instantiate(server, request, response);
                processor.process(path, request.getRequestMethod(), client, request.getHeaderValue("Content-Type"));
            }
        } else {
            Object supportedURL;
            Object url;
            HttpRequestProcessor impl = null;
            for (HttpRequestProcessor proc : processors) {
                if (proc instanceof HttpPushProcessor && !((HttpPushProcessor)proc).supportsNonPush() || proc.supportsChildPaths()) continue;
                url = request.getRequestPath();
                if (!((String)url).endsWith("/")) {
                    url = (String)url + "/";
                }
                if (!((String)(supportedURL = proc.path())).endsWith("/")) {
                    supportedURL = (String)supportedURL + "/";
                }
                if (!((String)url).equals(supportedURL)) continue;
                compatible = true;
                impl = proc;
                break;
            }
            if (!compatible) {
                for (HttpRequestProcessor proc : processors) {
                    if (proc instanceof HttpPushProcessor && !((HttpPushProcessor)proc).supportsNonPush() || !proc.supportsChildPaths()) continue;
                    url = request.getRequestPath();
                    if (!((String)url).endsWith("/")) {
                        url = (String)url + "/";
                    }
                    if (!((String)(supportedURL = this.sanitizePath(proc.path()))).endsWith("/")) {
                        supportedURL = (String)supportedURL + "/";
                    }
                    if (!((String)url).startsWith((String)supportedURL)) continue;
                    compatible = true;
                    impl = proc;
                    break;
                }
            }
            if (compatible) {
                HttpRequestProcessor processor = impl.instantiate(server, request, response);
                processor.process(path, request.getRequestMethod(), client);
            }
        }
        return compatible;
    }
}

