/*
 * Decompiled with CFR 0.152.
 */
package org.asf.connective.headers;

import java.util.ArrayList;
import java.util.Collection;

public class HttpHeader {
    private String name;
    private ArrayList<String> values = new ArrayList();

    public HttpHeader(String name, String value) {
        this.name = name;
        this.values.add(value);
    }

    public HttpHeader(String name) {
        this.name = name;
    }

    public static HttpHeader create(String name, String value) {
        return new HttpHeader(name, value);
    }

    public static HttpHeader create(String name) {
        return new HttpHeader(name);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        if (this.isEmpty()) {
            return null;
        }
        return this.values.get(0);
    }

    public String[] getValues() {
        return (String[])this.values.toArray(String[]::new);
    }

    public void clearValues() {
        this.values.clear();
    }

    public boolean removeValue(String value) {
        return this.values.remove(value);
    }

    public boolean containsValue(String value) {
        return this.values.contains(value);
    }

    public int getValueCount() {
        return this.values.size();
    }

    public String getValue(int index) {
        if (index < 0 || index > this.values.size()) {
            throw new IndexOutOfBoundsException(index);
        }
        return this.values.get(index);
    }

    public int addValue(String value) {
        this.values.add(value);
        return this.values.lastIndexOf(value);
    }

    public void addValues(Collection<? extends String> values) {
        this.values.addAll(values);
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public boolean hasValues() {
        return !this.isEmpty();
    }

    public String toString() {
        Object res = this.name;
        if (this.isEmpty()) {
            res = (String)res + ": [EMPTY HEADER]";
        } else {
            for (String ent : this.values) {
                if (((String)res).equals(this.name)) {
                    res = (String)res + ": " + ent.replace("\\r", "\\\\r").replace("\\n", "\\\\n").replace("\r", "\\r").replace("\n", "\\n");
                    continue;
                }
                res = (String)res + ", " + ent.replace("\\r", "\\\\r").replace("\\n", "\\\\n").replace("\r", "\\r").replace("\n", "\\n");
            }
        }
        return res;
    }
}

