/*
 * Decompiled with CFR 0.152.
 */
package org.asf.connective.impl.http_1_1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Random;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.net.ssl.SSLException;
import org.asf.connective.RemoteClient;
import org.asf.connective.headers.HeaderCollection;
import org.asf.connective.headers.HttpHeader;
import org.asf.connective.impl.http_1_1.ConnectiveHttpServer_1_1;
import org.asf.connective.io.IoUtil;
import org.asf.connective.io.LengthTrackingStream;
import org.asf.connective.objects.HttpRequest;
import org.asf.connective.objects.HttpResponse;
import org.asf.connective.tasks.AsyncTaskManager;

public class RemoteClientHttp_1_1
extends RemoteClient {
    private ConnectiveHttpServer_1_1 server;
    private Socket socket;
    private InputStream in;
    private OutputStream out;
    private String host;
    private String addr;
    protected int timeout = 5;
    protected int maxRequests = 0;
    protected int requestNumber = 0;
    protected boolean receiving = false;
    private static Random rnd = new Random();
    private int rndT = 0;
    private long tsT = 0L;
    private String originalHost;
    private String originalAddress = null;
    private String proxiedAddress = null;
    private ArrayList<String> proxies = new ArrayList();

    protected RemoteClientHttp_1_1(Socket socket, ConnectiveHttpServer_1_1 server, InputStream in, OutputStream out, Function<HttpRequest, HttpResponse> responseCreator) {
        super(server, responseCreator);
        this.server = server;
        this.socket = socket;
        this.in = in;
        this.out = out;
        InetSocketAddress addr = (InetSocketAddress)socket.getRemoteSocketAddress();
        this.addr = addr.getAddress().getHostAddress();
        this.originalHost = this.host = addr.getAddress().getCanonicalHostName();
        this.originalAddress = this.addr;
    }

    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public String getRemoteAddress() {
        return this.addr;
    }

    public void beginReceive() throws IOException {
        this.requestNumber = 0;
        this.receiving = false;
        AsyncTaskManager.runAsync(() -> this.receive());
    }

    protected void keepAlive() {
        int rndTc = this.rndT;
        long tsTc = this.tsT;
        long start = System.currentTimeMillis();
        while (!this.receiving && tsTc == this.tsT && rndTc == this.rndT) {
            if (this.receiving || tsTc != this.tsT || rndTc != this.rndT || this.socket == null) {
                return;
            }
            if (System.currentTimeMillis() - start >= (long)(this.timeout * 1000)) {
                this.closeConnection();
                break;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeConnection() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ArrayList<RemoteClientHttp_1_1> arrayList = this.server.clients;
        synchronized (arrayList) {
            this.server.clients.remove(this);
        }
        this.socket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receive() {
        HttpRequest msg = null;
        do {
            this.receiving = false;
            try {
                HttpResponse resp;
                try {
                    long len;
                    LengthTrackingStream strm;
                    long read;
                    if (msg != null && msg.getBodyStream() != null && msg.getBodyStream() instanceof LengthTrackingStream && (read = (strm = (LengthTrackingStream)msg.getBodyStream()).getBytesRead()) < (len = msg.getBodyLength())) {
                        long remaining = len - read;
                        while (remaining != 0L) {
                            if (remaining < 100000L) {
                                IoUtil.readNBytes(strm, (int)remaining);
                                continue;
                            }
                            remaining -= 100000L;
                            IoUtil.readNBytes(strm, 100000);
                        }
                    }
                }
                catch (IllegalStateException strm) {
                    // empty catch block
                }
                if ((msg = this.readRequest()) == null) {
                    resp = new HttpResponse("HTTP/1.1");
                    resp.setResponseStatus(400, "Bad request");
                    this.sendResponse(resp, null);
                    this.closeConnection();
                    return;
                }
                if (!msg.getHttpVersion().equals("HTTP/1.1")) {
                    resp = new HttpResponse(msg.getHttpVersion());
                    resp.setResponseStatus(505, "HTTP Version Not Supported");
                    this.sendResponse(resp, null);
                    this.closeConnection();
                    return;
                }
                this.processRequests(msg);
            }
            catch (Exception ex) {
                if (!this.server.connected || ex instanceof SSLException || ex instanceof SocketException) {
                    ArrayList<RemoteClientHttp_1_1> read = this.server.clients;
                    synchronized (read) {
                        this.server.clients.remove(this);
                    }
                    return;
                }
                this.getLogger().error("Failed to process request from [" + this.addr + "]", (Throwable)ex);
                if (msg == null) continue;
                HttpResponse resp = this.createResponse(msg);
                resp.setResponseStatus(500, "Internal server error");
                resp.setContent("text/html", this.server.getErrorPageGenerator().apply(resp, msg));
                try {
                    this.sendResponse(resp, msg);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.closeConnection();
                return;
            }
        } while (this.requestNumber != 0);
    }

    private void processRequests(HttpRequest msg) throws IOException {
        this.receiving = true;
        if (msg.hasHeader("X-Forwarded-For")) {
            this.proxiedAddress = null;
            this.addr = this.originalAddress;
            this.host = this.originalHost;
            this.proxies = new ArrayList();
            ArrayList<String> addresses = new ArrayList<String>();
            for (String val : msg.getHeaderValues("X-Forwarded-For")) {
                for (String addr : val.replace(" ", "").split(",")) {
                    addresses.add(addr);
                }
            }
            if (addresses.size() != 0) {
                this.proxiedAddress = (String)addresses.remove(0);
                this.proxies.add(this.originalAddress);
                for (int i = addresses.size() - 1; i >= 0; --i) {
                    this.proxies.add((String)addresses.get(i));
                }
                if (this.getServer().isAllowedProxySource(this.originalAddress)) {
                    this.addr = this.proxiedAddress;
                    this.host = this.proxiedAddress;
                    try {
                        this.host = InetAddress.getByName(this.addr).getCanonicalHostName();
                    }
                    catch (Exception i) {
                        // empty catch block
                    }
                    if (msg.hasHeader("X-Forwarded-Host")) {
                        if (msg.hasHeader("Host")) {
                            msg.addHeader("X-Proxy-Host", msg.getHeaderValue("Host"));
                        }
                        msg.addHeader("Host", msg.getHeaderValue("X-Forwarded-Host"));
                    }
                }
            }
        }
        if (msg.hasHeader("Forwarded")) {
            this.proxiedAddress = null;
            this.addr = this.originalAddress;
            this.host = this.originalHost;
            this.proxies = new ArrayList();
            String proxiedHost = null;
            ArrayList<String> addresses = new ArrayList<String>();
            for (String val : msg.getHeaderValues("Forwarded")) {
                for (String setting : val.replace(" ", "").split(",")) {
                    block17: for (String directive : setting.split(";")) {
                        if (!directive.contains("=")) continue;
                        String key = directive.substring(0, directive.indexOf("=")).toLowerCase();
                        String value = directive.substring(directive.indexOf("=") + 1);
                        switch (key) {
                            case "for": {
                                if (value.startsWith("[")) {
                                    value = value.substring(1);
                                    value = value.substring(0, value.indexOf("]"));
                                }
                                addresses.add(value);
                                continue block17;
                            }
                            case "host": {
                                if (proxiedHost != null) continue block17;
                                proxiedHost = value;
                            }
                        }
                    }
                }
            }
            if (addresses.size() != 0) {
                this.proxiedAddress = (String)addresses.remove(0);
                this.proxies.add(this.originalAddress);
                for (int i = addresses.size() - 1; i >= 0; --i) {
                    this.proxies.add((String)addresses.get(i));
                }
                if (this.getServer().isAllowedProxySource(this.originalAddress)) {
                    this.addr = this.proxiedAddress;
                    this.host = this.proxiedAddress;
                    try {
                        this.host = InetAddress.getByName(this.addr).getCanonicalHostName();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (proxiedHost != null) {
                        if (msg.hasHeader("Host")) {
                            msg.addHeader("X-Proxy-Host", msg.getHeaderValue("Host"));
                        }
                        msg.addHeader("Host", proxiedHost);
                    }
                }
            }
        }
        this.processRequest(msg);
    }

    private HttpRequest readRequest() throws IOException {
        String firstLine = this.readStreamLine(this.in);
        if (firstLine == null || firstLine.isEmpty()) {
            return null;
        }
        if (!firstLine.substring(0, 1).matches("[A-Za-z0-9]") || firstLine.split(" ").length != 3) {
            return null;
        }
        try {
            String line;
            String path = firstLine.substring(firstLine.indexOf(" ") + 1, firstLine.lastIndexOf(" "));
            String method = firstLine.substring(0, firstLine.indexOf(" ")).toUpperCase();
            String version = firstLine.substring(firstLine.lastIndexOf(" ") + 1);
            HeaderCollection headers = new HeaderCollection();
            while (!(line = this.readStreamLine(this.in)).equals("")) {
                String key = line.substring(0, line.indexOf(": "));
                String value = line.substring(line.indexOf(": ") + 2);
                if (headers.hasHeader(key)) continue;
                headers.addHeader(key, value);
            }
            LengthTrackingStream body = null;
            long contentLength = -1L;
            if (headers.hasHeader("Content-Length") && (contentLength = Long.parseLong(headers.getHeaderValue("Content-Length"))) > 0L) {
                body = new LengthTrackingStream(this.in);
            }
            return new HttpRequest(body, contentLength, headers, version, method, path);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String readStreamLine(InputStream strm) throws IOException {
        Object buffer = "";
        char ch;
        while ((ch = (char)strm.read()) != '\uffff') {
            if (ch == '\n') {
                return buffer;
            }
            if (ch == '\r') continue;
            buffer = (String)buffer + ch;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendResponse(HttpResponse response, HttpRequest sourceRequest) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        if (response.getBodyStream() != null && !response.hasHeader("Content-Length") && response.getBodyLength() >= 0L) {
            response.addHeader("Content-Length", Long.toString(response.getBodyLength()));
        }
        response.addHeader("Server", this.server.getServerName());
        response.addHeader("Date", dateFormat.format(new Date()));
        for (String name : this.server.getDefaultHeaders().getHeaderNames()) {
            if (response.hasHeader(name)) continue;
            response.addHeader(name, this.server.getDefaultHeaders().getHeaderValue(name));
        }
        if (response.getBodyLength() < 0L && response.getBodyStream() != null && sourceRequest != null && !sourceRequest.getRequestMethod().equalsIgnoreCase("HEAD") && response.getResponseCode() != 204) {
            response.addHeader("Transfer-Encoding", "chunked");
        }
        if (response.getHeaders().hasHeader("Connection") && response.getHeaders().getHeaderValue("Connection").equalsIgnoreCase("Keep-Alive") && (this.maxRequests == 0 || this.requestNumber < this.maxRequests)) {
            if (response.getHeaders().hasHeader("Keep-Alive")) {
                String keepAliveInfo = response.getHeaderValue("Keep-Alive");
                this.timeout = 5;
                this.maxRequests = 0;
                block14: for (String entry : keepAliveInfo.split(", ")) {
                    if (!entry.contains("=")) continue;
                    String key = entry.substring(0, entry.indexOf("="));
                    String value = entry.substring(entry.indexOf("=") + 1);
                    switch (key) {
                        case "timeout": {
                            if (!value.matches("^[0-9]+$")) continue block14;
                            this.timeout = Integer.parseInt(value);
                            continue block14;
                        }
                        case "max": {
                            if (!value.matches("^[0-9]+$")) continue block14;
                            this.maxRequests = Integer.parseInt(value);
                        }
                    }
                }
            } else if (this.timeout != 0 || this.maxRequests != 0) {
                response.addHeader("Keep-Alive", "timeout=" + this.timeout + ", max=" + this.maxRequests);
            }
        }
        if (!response.hasHeader("Connection") && response.getResponseCode() != 101) {
            response.addHeader("Connection", "Closed");
        } else if (response.getResponseCode() == 101) {
            response.addHeader("Connection", "Upgrade");
        }
        StringBuilder resp = new StringBuilder();
        resp.append(response.getHttpVersion()).append(" ");
        resp.append(response.getResponseCode()).append(" ");
        resp.append(response.getResponseMessage());
        if ((sourceRequest != null && sourceRequest.getRequestMethod().equals("HEAD") || response.getResponseCode() == 204 || response.getResponseCode() == 201) && response.getHeaders().hasHeader("Content-Length")) {
            response.removeHeader("Content-Length");
        }
        if ((response.getResponseCode() == 204 || response.getResponseCode() == 201) && response.getHeaders().hasHeader("Content-Type")) {
            response.removeHeader("Content-Type");
        }
        for (HttpHeader header : response.getHeaders().getHeaders()) {
            if (!header.getName().equalsIgnoreCase("connection") && header.getValue().equalsIgnoreCase("closed")) continue;
            for (String val : header.getValues()) {
                resp.append("\r\n");
                resp.append(header.getName()).append(": ");
                resp.append(val);
            }
        }
        resp.append("\r\n");
        resp.append("\r\n");
        if (response.getBodyStream() != null && sourceRequest != null && !sourceRequest.getRequestMethod().equalsIgnoreCase("HEAD") && response.getResponseCode() != 204) {
            this.out.write(resp.toString().getBytes("UTF-8"));
            if (response.getBodyLength() >= 0L) {
                long length = response.getBodyLength();
                int tr = 0;
                for (long i = 0L; i < length; i += (long)tr) {
                    tr = 0x100000;
                    if ((long)tr > length) {
                        tr = (int)length;
                    }
                    byte[] b = IoUtil.readNBytes(response.getBodyStream(), tr);
                    tr = b.length;
                    this.out.write(b);
                }
            } else {
                try {
                    while (true) {
                        byte[] buffer = new byte[0x100000];
                        int chunkSize = response.getBodyStream().read(buffer, 0, buffer.length);
                        if (chunkSize == -1) {
                            this.out.write("0\r\n".toString().getBytes("UTF-8"));
                            this.out.write("\r\n".toString().getBytes("UTF-8"));
                            break;
                        }
                        this.out.write((Integer.toString(chunkSize, 16) + "\r\n").toString().getBytes("UTF-8"));
                        this.out.write(buffer, 0, chunkSize);
                        this.out.write("\r\n".toString().getBytes("UTF-8"));
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            response.getBodyStream().close();
        } else {
            this.out.write(resp.toString().getBytes("UTF-8"));
        }
        if (response.getResponseCode() == 101) {
            response.addHeader("Upgraded", "True");
            ArrayList<RemoteClientHttp_1_1> arrayList = this.server.clients;
            synchronized (arrayList) {
                this.server.clients.remove(this);
            }
            return;
        }
        if (!response.getHeaders().hasHeader("Connection") || !response.getHeaders().getHeaderValue("Connection").equalsIgnoreCase("Keep-Alive") || this.maxRequests != 0 && this.requestNumber >= this.maxRequests) {
            this.closeConnection();
        } else {
            this.requestNumber = this.maxRequests != 0 ? ++this.requestNumber : 1;
            this.rndT = rnd.nextInt();
            this.tsT = System.currentTimeMillis();
            this.receiving = false;
            AsyncTaskManager.runAsync(() -> this.keepAlive());
            response.addHeader("Connection", "Keep-Alive");
        }
    }

    @Override
    public OutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    protected void postProcessResponse(HttpResponse response, HttpRequest msg) {
        boolean clientKeepAlive = false;
        if (msg.getHeaders().hasHeader("Connection") && Stream.of(msg.getHeaderValue("Connection").split(", ")).anyMatch(t -> t.equalsIgnoreCase("Keep-Alive"))) {
            if (msg.getHeaders().hasHeader("Keep-Alive")) {
                String keepAliveInfo = msg.getHeaders().getHeaderValue("Keep-Alive");
                this.timeout = 5;
                this.maxRequests = 0;
                block8: for (String entry : keepAliveInfo.split(", ")) {
                    if (!entry.contains("=")) continue;
                    String key = entry.substring(0, entry.indexOf("="));
                    String value = entry.substring(entry.indexOf("=") + 1);
                    switch (key) {
                        case "timeout": {
                            if (!value.matches("^[0-9]+$")) continue block8;
                            this.timeout = Integer.parseInt(value);
                            continue block8;
                        }
                        case "max": {
                            if (!value.matches("^[0-9]+$")) continue block8;
                            this.maxRequests = Integer.parseInt(value);
                        }
                    }
                }
            } else if (this.timeout != 0 || this.maxRequests != 0) {
                response.addHeader("Keep-Alive", "timeout=" + this.timeout + ", max=" + this.maxRequests);
            }
            clientKeepAlive = true;
        }
        if (clientKeepAlive) {
            response.addHeader("Connection", "Keep-Alive");
        }
    }

    @Override
    public String getRemoteHost() {
        return this.host;
    }

    @Override
    public boolean isConnected() {
        return this.socket != null;
    }

    @Override
    public String[] getProxyChain() {
        return (String[])this.proxies.toArray(String[]::new);
    }

    @Override
    public String getRemoteProxiedClientAddress() {
        return this.proxiedAddress;
    }
}

