/*
 * Decompiled with CFR 0.152.
 */
package org.asf.connective.impl.https_1_1;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.asf.connective.TlsSecuredHttpServer;
import org.asf.connective.impl.http_1_1.ConnectiveHttpServer_1_1;

public class ConnectiveHttpsServer_1_1
extends ConnectiveHttpServer_1_1
implements TlsSecuredHttpServer {
    private SSLContext context = null;

    public ConnectiveHttpsServer_1_1() {
        this.port = 8043;
    }

    @Override
    public void start() throws IOException {
        super.start();
    }

    @Override
    public void loadTlsContextFrom(File keystoreFile, char[] password) throws IOException {
        try {
            KeyStore mainStore = KeyStore.getInstance("JKS");
            mainStore.load(new FileInputStream(keystoreFile), password);
            this.loadTlsContextFrom(mainStore, password);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IOException("Failed to load keystore file from " + keystoreFile.getPath(), e);
        }
    }

    @Override
    public void loadTlsContextFrom(KeyStore keystore, char[] password) throws IOException {
        try {
            KeyManagerFactory managerFactory = KeyManagerFactory.getInstance("SunX509");
            managerFactory.init(keystore, password);
            SSLContext cont = SSLContext.getInstance("TLS");
            cont.init(managerFactory.getKeyManagers(), null, null);
            this.context = cont;
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new IOException("Failed to initialize the SSLContext with the given keystore and password", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ServerSocket getServerSocket(int port, InetAddress addr) throws IOException {
        if (this.context != null) return this.context.getServerSocketFactory().createServerSocket(port, 0, addr);
        File keystore = new File("keystore.jks");
        if (!keystore.exists()) throw new IOException("No keystore.jks file and no configuration provided to create a TLS-encrypted HTTP server instance");
        File keystorePassword = new File("keystore.jks.password");
        if (!keystorePassword.exists()) throw new IOException("Default keystore file (keystore.jks) needs another file next to it named keystore.jks.password containing the keystore password for this to function.");
        this.loadTlsContextFrom(keystore, Files.readString(keystorePassword.toPath()).toCharArray());
        return this.context.getServerSocketFactory().createServerSocket(port, 0, addr);
    }
}

