/*
 * Decompiled with CFR 0.152.
 */
package org.asf.connective.lambda;

import java.io.InputStream;
import java.util.Map;
import org.asf.connective.ConnectiveHttpServer;
import org.asf.connective.RemoteClient;
import org.asf.connective.headers.HeaderCollection;
import org.asf.connective.objects.HttpRequest;
import org.asf.connective.objects.HttpResponse;

public class LambdaRequestContext {
    private RemoteClient client;
    private HttpRequest request;
    private HttpResponse response;
    private ConnectiveHttpServer server;

    public LambdaRequestContext(RemoteClient client, HttpRequest request, HttpResponse response, ConnectiveHttpServer server) {
        this.client = client;
        this.request = request;
        this.response = response;
        this.server = server;
    }

    public RemoteClient getClient() {
        return this.client;
    }

    public ConnectiveHttpServer getServer() {
        return this.server;
    }

    public HeaderCollection getHeaders() {
        return this.getRequest().getHeaders();
    }

    public String getHeader(String name) {
        return this.getRequest().getHeaderValue(name);
    }

    public boolean hasHeader(String name) {
        return this.getRequest().hasHeader(name);
    }

    public void setResponseHeader(String header, String value) {
        this.getResponse().addHeader(header, value);
    }

    public void setResponseHeader(String header, String value, boolean append) {
        this.getResponse().addHeader(header, value, append);
    }

    public void setResponseContent(String type, String body) {
        this.getResponse().setContent(type, body);
    }

    public void setResponseContent(String body) {
        this.setResponseContent("text/plain", body);
    }

    public void setResponseContent(String type, byte[] body) {
        this.getResponse().setContent(type, body);
    }

    public void setResponseContent(byte[] body) {
        this.getResponse().setContent(body);
    }

    public HttpResponse setResponseContent(String type, InputStream body) {
        return this.getResponse().setContent(type, body);
    }

    public HttpResponse setResponseContent(InputStream body) {
        return this.getResponse().setContent(body);
    }

    public HttpResponse setResponseContent(String type, InputStream body, long length) {
        return this.getResponse().setContent(type, body, length);
    }

    public HttpResponse setResponseContent(InputStream body, long length) {
        return this.getResponse().setContent(body, length);
    }

    public HttpResponse setResponseStatus(int status, String message) {
        return this.response.setResponseStatus(status, message);
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public String getRequestPath() {
        return this.getRequest().getRequestPath();
    }

    public String getRequestQuery() {
        return this.getRequest().getRequestQuery();
    }

    public Map<String, String> getRequestQueryParameters() {
        return this.getRequest().getRequestQueryParameters();
    }

    public String getRawRequestResource() {
        return this.getRequest().getRawRequestResource();
    }

    public String getRequestMethod() {
        return this.getRequest().getRequestMethod();
    }
}

