/*
 * Decompiled with CFR 0.152.
 */
package org.asf.razorwhip.sentinel.launcher;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.asf.razorwhip.sentinel.launcher.LauncherMain;
import org.asf.razorwhip.sentinel.launcher.LauncherUtils;
import org.asf.razorwhip.sentinel.launcher.assets.ActiveArchiveInformation;
import org.asf.razorwhip.sentinel.launcher.assets.ArchiveInformation;
import org.asf.razorwhip.sentinel.launcher.assets.ArchiveMode;
import org.asf.razorwhip.sentinel.launcher.assets.AssetInformation;
import org.asf.razorwhip.sentinel.launcher.windows.VersionManagerWindow;

public class AssetManager {
    private static LauncherMain launcherWindow;
    private static JsonObject sacConfig;
    private static String assetSourceURL;
    private static boolean assetManagementAvailable;
    private static JsonArray localClientsArr;
    private static boolean dirModeDescriptorFileF;
    private static boolean dirModeSoftwareFileF;
    private static File gameDescriptorFileF;
    private static File emulationSoftwareFileF;
    private static ActiveArchiveInformation activeArchive;
    private static HashMap<String, ArchiveInformation> archiveList;
    private static AssetInformation[] collectedAssets;
    private static String[] collectedClients;

    public static ArchiveInformation[] getArchives() {
        return (ArchiveInformation[])archiveList.values().toArray(ArchiveInformation[]::new);
    }

    public static ArchiveInformation getArchive(String archiveID) {
        return archiveList.get(archiveID);
    }

    public static ActiveArchiveInformation getActiveArchive() {
        return activeArchive;
    }

    public static JsonObject getSentinelAssetControllerConfig() {
        return sacConfig;
    }

    public static String getAssetInformationRootURL() {
        return assetSourceURL;
    }

    public static boolean isAssetOnlineManagementAvailable() {
        return assetManagementAvailable;
    }

    public static boolean showVersionManager(boolean firstTime) throws IOException {
        VersionManagerWindow window;
        boolean saved;
        if (archiveList.size() == 0) {
            JsonObject archiveLst = AssetManager.loadArchiveList();
            AssetManager.loadArchives(archiveLst);
        }
        if (saved = (window = new VersionManagerWindow(AssetManager.launcherWindow.frmSentinelLauncher, firstTime)).showDialog()) {
            AssetManager.reloadSavedSettings();
        }
        return saved;
    }

    public static void reloadSavedSettings() throws IOException {
        File localVersions = new File("cache/clienthashes.json");
        if (localVersions.exists()) {
            JsonObject localHashList = JsonParser.parseString((String)Files.readString(localVersions.toPath())).getAsJsonObject();
            JsonArray clientList = JsonParser.parseString((String)Files.readString(Path.of("assets/clients.json", new String[0]))).getAsJsonArray();
            JsonObject newHashList = new JsonObject();
            for (String version : localHashList.keySet()) {
                boolean found = false;
                for (JsonElement ele : clientList) {
                    if (!ele.getAsString().equals(version)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    LauncherMain.closeClientsIfNeeded();
                    LauncherUtils.deleteDir(new File("clients/client-" + version));
                    continue;
                }
                newHashList.add(version, localHashList.get(version));
            }
            Files.writeString(localVersions.toPath(), (CharSequence)newHashList.toString(), new OpenOption[0]);
        }
        new File("lastclient.json").delete();
        AssetManager.loadClientList();
        collectedAssets = null;
        collectedClients = null;
    }

    public static boolean showClientSelector(boolean closeIfOnlyOneVersion) throws IOException {
        JsonObject settings = JsonParser.parseString((String)Files.readString(new File("assets/localdata.json").toPath())).getAsJsonObject();
        String id = settings.get("id").getAsString();
        JsonObject archiveLst = AssetManager.loadArchiveList();
        JsonObject archiveDef = archiveLst.get(id).getAsJsonObject();
        ArrayList<String> clients = new ArrayList<String>();
        for (String clientVersion : archiveDef.get("clients").getAsJsonObject().keySet()) {
            boolean found = false;
            for (JsonElement ele : localClientsArr) {
                if (!ele.getAsString().equals(clientVersion)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            clients.add(clientVersion);
        }
        String clientToStart = null;
        clientToStart = clients.size() != 1 || !closeIfOnlyOneVersion ? (String)JOptionPane.showInputDialog(null, "Select a client version to launch...", "Choose version to start", 3, null, clients.toArray(Object[]::new), null) : (String)clients.get(0);
        if (clientToStart == null) {
            return false;
        }
        JsonObject lastClient = new JsonObject();
        lastClient.addProperty("version", clientToStart);
        Files.writeString(Path.of("lastclient.json", new String[0]), (CharSequence)lastClient.toString(), new OpenOption[0]);
        return true;
    }

    static void init(LauncherMain launcherWindow, Map<String, String> softwareDescriptor, Map<String, String> gameDescriptor, boolean dirModeDescriptorFileF, boolean dirModeSoftwareFileF, File gameDescriptorFileF, File emulationSoftwareFileF) throws Exception {
        AssetManager.launcherWindow = launcherWindow;
        AssetManager.dirModeDescriptorFileF = dirModeDescriptorFileF;
        AssetManager.dirModeSoftwareFileF = dirModeSoftwareFileF;
        AssetManager.emulationSoftwareFileF = emulationSoftwareFileF;
        AssetManager.gameDescriptorFileF = gameDescriptorFileF;
        Object assetSourceURL = "sgd://assetarchiveinfo/";
        if (softwareDescriptor.containsKey("Asset-Information-Root-URL")) {
            assetSourceURL = softwareDescriptor.get("Asset-Information-Root-URL");
        } else if (gameDescriptor.containsKey("Asset-Information-Root-URL")) {
            assetSourceURL = gameDescriptor.get("Asset-Information-Root-URL");
        }
        assetSourceURL = AssetManager.parseURL((String)assetSourceURL, LauncherUtils.urlBaseDescriptorFile, LauncherUtils.urlBaseSoftwareFile, null);
        if (!((String)assetSourceURL).endsWith("/")) {
            assetSourceURL = (String)assetSourceURL + "/";
        }
        AssetManager.assetSourceURL = assetSourceURL;
        LauncherUtils.setStatus("Loading archive information...");
        LauncherUtils.log("Downloading asset archive information...");
        new File("assets").mkdirs();
        try {
            byte[] verifConfigPubKeyB = LauncherUtils.pemDecode(AssetManager.downloadString((String)assetSourceURL + "publickey.pem"));
            String configString = AssetManager.downloadString((String)assetSourceURL + "archivesettings.json").replace("\r", "");
            byte[] configSignature = AssetManager.downloadBytes((String)assetSourceURL + "archivesettings.json.sig");
            KeyFactory fac = KeyFactory.getInstance("RSA");
            PublicKey verifConfigPubKey = fac.generatePublic(new X509EncodedKeySpec(verifConfigPubKeyB));
            LauncherUtils.log("Verifying signature of SAC configuration...");
            Signature s = Signature.getInstance("Sha512WithRSA");
            s.initVerify(verifConfigPubKey);
            s.update(configString.getBytes("UTF-8"));
            if (!s.verify(configSignature)) {
                LauncherUtils.log("Verification failure!");
                JOptionPane.showMessageDialog(launcherWindow.frmSentinelLauncher, "Failed to verify the signature of the asset archive configuration.\n\nThe launcher cannot download or update assets and clients at this time.", "Launcher Error", 0);
                assetManagementAvailable = false;
            } else {
                LauncherUtils.log("Saving SAC configuration...");
                Files.writeString(Path.of("assets/sac-config.json", new String[0]), (CharSequence)configString, new OpenOption[0]);
                assetManagementAvailable = true;
            }
        }
        catch (Exception e) {
            SwingUtilities.invokeAndWait(() -> {
                Object stackTrace = "";
                Throwable t = e;
                while (t != null) {
                    for (StackTraceElement ele : t.getStackTrace()) {
                        stackTrace = (String)stackTrace + "\n     At: " + ele;
                    }
                    if ((t = t.getCause()) == null) continue;
                    stackTrace = (String)stackTrace + "\nCaused by: " + t;
                }
                System.out.println("[LAUNCHER] [SENTINEL LAUNCHER] Error occurred: " + e + (String)stackTrace);
                JOptionPane.showMessageDialog(launcherWindow.frmSentinelLauncher, "An error occured while running the launcher.\n\nError details: " + e + (String)stackTrace, "Launcher Error", 0);
            });
            assetManagementAvailable = false;
        }
        if (new File("assets/sac-config.json").exists()) {
            LauncherUtils.log("Loading SAC configuration...");
            sacConfig = JsonParser.parseString((String)Files.readString(Path.of("assets/sac-config.json", new String[0]))).getAsJsonObject();
        }
        if (assetManagementAvailable) {
            LauncherUtils.log("Downloading SAC security key...");
            try {
                String sacKeyPem = AssetManager.downloadString(AssetManager.parseURL(sacConfig.get("archiveDescriptorVerificationkey").getAsString(), LauncherUtils.urlBaseDescriptorFile, LauncherUtils.urlBaseSoftwareFile, (String)assetSourceURL));
                LauncherUtils.log("Saving SAC security key...");
                Files.writeString(Path.of("assets/sac-publickey.pem", new String[0]), (CharSequence)sacKeyPem, new OpenOption[0]);
                LauncherUtils.log("Downloading archive list...");
                String archiveList = AssetManager.downloadString(AssetManager.parseURL(sacConfig.get("assetArchiveList").getAsString(), LauncherUtils.urlBaseDescriptorFile, LauncherUtils.urlBaseSoftwareFile, (String)assetSourceURL));
                LauncherUtils.log("Saving archive list...");
                Files.writeString(Path.of("assets/assetarchives.json", new String[0]), (CharSequence)archiveList, new OpenOption[0]);
            }
            catch (IOException e) {
                assetManagementAvailable = false;
                LauncherUtils.log("Could not download SAC files, verifying state...");
                if (!(new File("assets/assetarchives.json").exists() && new File("assets/sac-publickey.pem").exists() && new File("assets/localdata.json").exists())) {
                    LauncherUtils.log("Missing critical files, unable to start the game.");
                    JOptionPane.showMessageDialog(launcherWindow.frmSentinelLauncher, "Unable to download critical files, please verify your internet connection.", "Launcher Error", 0);
                    System.exit(1);
                }
                LauncherUtils.log("Assets are available, game should be playable.");
            }
            if (assetManagementAvailable) {
                LauncherUtils.log("Verifying local asset archives...");
                File localArchiveSettings = new File("assets/localdata.json");
                if (!localArchiveSettings.exists()) {
                    LauncherUtils.log("Waiting for initial client setup...", true);
                    if (!AssetManager.showVersionManager(!localArchiveSettings.exists())) {
                        System.exit(0);
                    }
                }
            }
        } else {
            LauncherUtils.log("Could not download SAC configuration, verifying state...");
            if (!(new File("assets/assetarchives.json").exists() && new File("assets/sac-publickey.pem").exists() && new File("assets/localdata.json").exists())) {
                LauncherUtils.log("Missing critical files, unable to start the game.");
                JOptionPane.showMessageDialog(launcherWindow.frmSentinelLauncher, "Unable to download critical files, please verify your internet connection.", "Launcher Error", 0);
                System.exit(1);
            }
            LauncherUtils.log("Assets are available, game should be playable.");
        }
    }

    static void initArchiveData() throws Exception {
        JsonObject archiveDef;
        LauncherUtils.log("Loading archive settings...");
        AssetManager.loadClientList();
        JsonObject settings = JsonParser.parseString((String)Files.readString(new File("assets/localdata.json").toPath())).getAsJsonObject();
        String archiveID = settings.get("id").getAsString();
        JsonObject archiveLst = AssetManager.loadArchiveList();
        boolean valid = true;
        LauncherUtils.log("Verifying archive settings...");
        if (archiveLst.has(archiveID)) {
            archiveDef = archiveLst.get(archiveID).getAsJsonObject();
            if (!archiveDef.get("allowFullDownload").getAsBoolean() && !archiveDef.get("allowStreaming").getAsBoolean() || !archiveDef.get("allowFullDownload").getAsBoolean() && archiveDef.has("deprecated") && archiveDef.has("deprecationNotice") && archiveDef.get("deprecated").getAsBoolean()) {
                valid = false;
            } else if (!archiveDef.get("type").getAsString().matches("^[A-Za-z0-9\\-.,_ ]+$")) {
                valid = false;
            }
        } else {
            valid = false;
        }
        if (valid) {
            archiveDef = archiveLst.get(archiveID).getAsJsonObject();
            JsonObject archiveClientLst = archiveDef.get("clients").getAsJsonObject();
            boolean found = false;
            for (JsonElement entry : localClientsArr) {
                if (!archiveClientLst.has(entry.getAsString())) continue;
                found = true;
                break;
            }
            if (!found) {
                valid = false;
            }
        }
        if (!valid) {
            LauncherUtils.log("Verification failure!");
            if (!assetManagementAvailable) {
                JOptionPane.showMessageDialog(AssetManager.launcherWindow.frmSentinelLauncher, "Unable to download critical files, please verify your internet connection.", "Launcher Error", 0);
                System.exit(1);
            }
            LauncherUtils.log("Waiting for client setup...", true);
            if (!AssetManager.showVersionManager(false)) {
                System.exit(0);
            }
            settings = JsonParser.parseString((String)Files.readString(new File("assets/localdata.json").toPath())).getAsJsonObject();
            archiveID = settings.get("id").getAsString();
            archiveLst = AssetManager.loadArchiveList();
        }
        AssetManager.loadArchives(archiveLst);
        AssetManager.loadActiveArchive(settings, false);
    }

    public static void reloadArchives() throws IOException {
        LauncherUtils.log("Reloading asset data...", true);
        LauncherUtils.log("Loading archive settings...");
        AssetManager.loadClientList();
        JsonObject settings = JsonParser.parseString((String)Files.readString(new File("assets/localdata.json").toPath())).getAsJsonObject();
        JsonObject archiveLst = AssetManager.loadArchiveList();
        AssetManager.loadArchives(archiveLst);
        AssetManager.loadActiveArchive(settings, true);
    }

    public static void prepareStreamingArchiveConnection() throws IOException {
        LauncherUtils.log("Verifying connection...");
        boolean assetConnection = AssetManager.testArchiveConnection(activeArchive);
        if (AssetManager.activeArchive.streamingModeEnabled && !AssetManager.activeArchive.streamingModeOverriddenDisable && !assetConnection) {
            File localVersions;
            LauncherUtils.log("Verifying local files... Checking status of offline play...", true);
            String plat = null;
            if (System.getProperty("os.name").toLowerCase().contains("win") && !System.getProperty("os.name").toLowerCase().contains("darwin")) {
                plat = "windows";
            } else if (System.getProperty("os.name").toLowerCase().contains("darwin") || System.getProperty("os.name").toLowerCase().contains("mac")) {
                plat = "macos";
            } else if (System.getProperty("os.name").toLowerCase().contains("linux")) {
                plat = "linux";
            }
            LauncherUtils.log("Verifying clients...");
            JsonArray clientsArr = new JsonArray();
            File clientListFile = new File("assets/clients.json");
            if (clientListFile.exists()) {
                clientsArr = JsonParser.parseString((String)Files.readString(Path.of("assets/clients.json", new String[0]))).getAsJsonArray();
            }
            if (!(localVersions = new File("cache/clienthashes.json")).exists()) {
                Files.writeString(localVersions.toPath(), (CharSequence)"{}", new OpenOption[0]);
            }
            JsonObject localHashList = JsonParser.parseString((String)Files.readString(localVersions.toPath())).getAsJsonObject();
            boolean clientsUpToDate = true;
            for (JsonElement clE : clientsArr) {
                String cHash;
                String clientVersion = clE.getAsString();
                File clientFolder = new File("clients/client-" + clientVersion);
                if (!AssetManager.activeArchive.archiveClientLst.has(clientVersion)) continue;
                LauncherUtils.log("Checking for updates for " + clientVersion + "...", true);
                String oHash = "";
                if (localHashList.has(clientVersion)) {
                    oHash = localHashList.get(clientVersion).getAsString();
                }
                if (oHash.equals(cHash = AssetManager.activeArchive.descriptorDef.get("versionHashes").getAsJsonObject().get(plat).getAsJsonObject().get(clientVersion).getAsString()) && clientFolder.exists() && new File(clientFolder, ".sentinel-client-updated").exists()) continue;
                clientsUpToDate = false;
                break;
            }
            if (clientsUpToDate) {
                boolean assetsUpToDate = true;
                LauncherUtils.log("Checking for asset archive updates...");
                AssetManager.migrateAssetsIfNeeded();
                AssetInformation[] collectedAssets = AssetManager.collectAssets();
                LauncherUtils.log("Verifying assets...", true);
                for (AssetInformation asset : collectedAssets) {
                    if (asset.isUpToDate()) continue;
                    assetsUpToDate = false;
                    break;
                }
                if (assetsUpToDate) {
                    AssetManager.activeArchive.streamingModeOverriddenDisable = true;
                    return;
                }
            }
            if (assetManagementAvailable) {
                while (AssetManager.activeArchive.streamingModeEnabled && !assetConnection) {
                    assetConnection = AssetManager.testArchiveConnection(activeArchive);
                    if (JOptionPane.showConfirmDialog(AssetManager.launcherWindow.frmSentinelLauncher, "Failed to connect to the asset servers!\n\nThe archive manager will be opened, select cancel to close the launcher.", "No connection to server", 2, 0) != 0) {
                        System.exit(0);
                        return;
                    }
                    if (JOptionPane.showConfirmDialog(AssetManager.launcherWindow.frmSentinelLauncher, "Do you wish to select a different asset archive?", "Server selection", 0, 3) != 0) continue;
                    LauncherUtils.log("Waiting for client setup...", true);
                    if (!AssetManager.showVersionManager(false)) continue;
                    AssetManager.reloadArchives();
                }
            } else {
                JOptionPane.showMessageDialog(AssetManager.launcherWindow.frmSentinelLauncher, "Failed to connect to the asset servers!\n\nPlease verify your internet connection before trying again.", "No connection to server", 0);
                System.exit(1);
            }
        }
    }

    public static void verifyClients(boolean throwError) throws IOException {
        File localVersions;
        String plat = null;
        if (System.getProperty("os.name").toLowerCase().contains("win") && !System.getProperty("os.name").toLowerCase().contains("darwin")) {
            plat = "windows";
        } else if (System.getProperty("os.name").toLowerCase().contains("darwin") || System.getProperty("os.name").toLowerCase().contains("mac")) {
            plat = "macos";
        } else if (System.getProperty("os.name").toLowerCase().contains("linux")) {
            plat = "linux";
        }
        LauncherUtils.setStatus("Checking for updates...");
        LauncherUtils.log("Verifying clients...");
        JsonArray clientsArr = new JsonArray();
        File clientListFile = new File("assets/clients.json");
        if (clientListFile.exists()) {
            clientsArr = JsonParser.parseString((String)Files.readString(Path.of("assets/clients.json", new String[0]))).getAsJsonArray();
        }
        if (!(localVersions = new File("cache/clienthashes.json")).exists()) {
            Files.writeString(localVersions.toPath(), (CharSequence)"{}", new OpenOption[0]);
        }
        JsonObject localHashList = JsonParser.parseString((String)Files.readString(localVersions.toPath())).getAsJsonObject();
        for (JsonElement clE : clientsArr) {
            String cHash;
            String clientVersion = clE.getAsString();
            File clientFolder = new File("clients/client-" + clientVersion);
            if (!AssetManager.activeArchive.archiveClientLst.has(clientVersion)) continue;
            LauncherUtils.log("Checking for updates for " + clientVersion + "...", true);
            String oHash = "";
            if (localHashList.has(clientVersion)) {
                oHash = localHashList.get(clientVersion).getAsString();
            }
            if (oHash.equals(cHash = AssetManager.activeArchive.descriptorDef.get("versionHashes").getAsJsonObject().get(plat).getAsJsonObject().get(clientVersion).getAsString()) && clientFolder.exists() && new File(clientFolder, ".sentinel-client-updated").exists()) continue;
            if (AssetManager.activeArchive.mode == ArchiveMode.REMOTE) {
                LauncherUtils.log("Updating client " + clientVersion + "...", true);
            } else {
                LauncherUtils.log("Extracting client " + clientVersion + "...", true);
            }
            LauncherMain.closeClientsIfNeeded();
            if (AssetManager.activeArchive.mode == ArchiveMode.REMOTE) {
                if (AssetManager.activeArchive.connectionAvailable && assetManagementAvailable) {
                    LauncherUtils.gameDescriptor.downloadClient(AssetManager.activeArchive.archiveClientLst.get(clientVersion).getAsString(), clientVersion, clientFolder, activeArchive, AssetManager.activeArchive.archiveDef, AssetManager.activeArchive.descriptorDef, cHash);
                } else {
                    if (throwError) {
                        throw new IOException("No server connection");
                    }
                    if (assetManagementAvailable) {
                        LauncherUtils.log("Skipped client update as there is no version management.");
                        JOptionPane.showMessageDialog(AssetManager.launcherWindow.frmSentinelLauncher, "Could not update the client as there was no connection to Sentinel's servers!\n\nPlease verify your internet connection before trying again.", "No connection to server", 0);
                        System.exit(1);
                    } else {
                        LauncherUtils.log("Skipped client update as there is no asset server connection.");
                        JOptionPane.showMessageDialog(AssetManager.launcherWindow.frmSentinelLauncher, "Failed to connect to the asset servers!\n\nPlease verify your internet connection before trying again.", "No connection to server", 0);
                        System.exit(1);
                    }
                }
            } else {
                ZipEntry ent;
                ZipEntry ent2;
                if (!new File(AssetManager.activeArchive.source).exists()) {
                    if (throwError) {
                        throw new IOException("Source file does not exist");
                    }
                    LauncherUtils.log("Skipped client update as the source file is missing.");
                    JOptionPane.showMessageDialog(AssetManager.launcherWindow.frmSentinelLauncher, "Failed to copy client data from asset source file!\n\nThe archive SGA file is not presently on disk!\nFile path: " + AssetManager.activeArchive.source, "Archive file missing", 0);
                    System.exit(1);
                }
                String clientEntry = AssetManager.activeArchive.archiveClientLst.get(clientVersion).getAsString() + "/";
                LauncherUtils.log("Extracting " + clientVersion + " client...", true);
                clientFolder.mkdirs();
                ZipFile zip = new ZipFile(AssetManager.activeArchive.source);
                int count = 0;
                Enumeration<? extends ZipEntry> en = zip.entries();
                while (en.hasMoreElements() && (ent2 = en.nextElement()) != null) {
                    if (ent2.getName().equals(clientEntry) || !ent2.getName().startsWith(clientEntry)) continue;
                    ++count;
                }
                zip.close();
                LauncherUtils.resetProgressBar();
                LauncherUtils.showProgressPanel();
                LauncherUtils.setProgressMax(count);
                zip = new ZipFile(AssetManager.activeArchive.source);
                en = zip.entries();
                int max = count;
                int i = 0;
                while (en.hasMoreElements() && (ent = en.nextElement()) != null) {
                    if (ent.getName().equals(clientEntry) || !ent.getName().startsWith(clientEntry)) continue;
                    if (ent.isDirectory()) {
                        new File(clientFolder, ent.getName().substring(clientEntry.length())).mkdirs();
                    } else {
                        FileOutputStream output = new FileOutputStream(new File(clientFolder, ent.getName().substring(clientEntry.length())));
                        InputStream is = zip.getInputStream(ent);
                        is.transferTo(output);
                        is.close();
                        output.close();
                    }
                    LauncherUtils.setProgress(i++, max);
                }
                LauncherUtils.setProgress(max, max);
                zip.close();
            }
            LauncherUtils.log("Modifying client " + clientVersion + "...", true);
            LauncherUtils.gameDescriptor.modifyClient(clientFolder, clientVersion, activeArchive, AssetManager.activeArchive.archiveDef, AssetManager.activeArchive.descriptorDef);
            LauncherUtils.hideProgressPanel();
            LauncherUtils.resetProgressBar();
            if (!new File("tmp-sgdextract").exists()) {
                LauncherUtils.log("Extracting game descriptor...");
                if (!dirModeDescriptorFileF) {
                    LauncherUtils.unZip(gameDescriptorFileF, new File("cache/tmp-sgdextract"));
                } else {
                    LauncherUtils.copyDirWithoutProgress(gameDescriptorFileF, new File("cache/tmp-sgdextract"));
                }
            }
            if (new File("cache/tmp-sgdextract", "clientmodifications").exists()) {
                LauncherUtils.log("Copying game descriptor client modifications...");
                LauncherUtils.copyDirWithoutProgress(new File("cache/tmp-sgdextract", "clientmodifications"), clientFolder);
            }
            if (new File("cache/tmp-sgdextract", "clientmodifications-" + clientVersion).exists()) {
                LauncherUtils.log("Copying version-specific game descriptor client modifications...");
                LauncherUtils.copyDirWithoutProgress(new File("cache/tmp-sgdextract", "clientmodifications-" + clientVersion), clientFolder);
            }
            if (!new File("cache/tmp-svpextract").exists()) {
                LauncherUtils.log("Extracting emulation software...");
                if (!dirModeSoftwareFileF) {
                    LauncherUtils.unZip(emulationSoftwareFileF, new File("cache/tmp-svpextract"));
                } else {
                    LauncherUtils.copyDirWithoutProgress(emulationSoftwareFileF, new File("cache/tmp-svpextract"));
                }
            }
            if (new File("cache/tmp-svpextract", "clientmodifications").exists()) {
                LauncherUtils.log("Copying emulation software client modifications...");
                LauncherUtils.copyDirWithoutProgress(new File("cache/tmp-svpextract", "clientmodifications"), clientFolder);
            }
            if (new File("cache/tmp-svpextract", "clientmodifications-" + clientVersion).exists()) {
                LauncherUtils.log("Copying version-specific emulation software client modifications...");
                LauncherUtils.copyDirWithoutProgress(new File("cache/tmp-svpextract", "clientmodifications-" + clientVersion), clientFolder);
            }
            LauncherUtils.log("Copying payload client modifications...", true);
            LauncherUtils.copyDirWithoutProgress(new File("cache/payloadcache/payloaddata", "clientmodifications"), clientFolder);
            LauncherUtils.copyDirWithoutProgress(new File("cache/payloadcache/payloaddata", "clientmodifications"), clientFolder);
            localHashList.addProperty(clientVersion, cHash);
            Files.writeString(localVersions.toPath(), (CharSequence)localHashList.toString(), new OpenOption[0]);
            if (new File(clientFolder, ".sentinel-client-updated").exists()) continue;
            new File(clientFolder, ".sentinel-client-updated").createNewFile();
        }
        LauncherUtils.deleteDir(new File("cache/tmp-sgdextract"));
        LauncherUtils.deleteDir(new File("cache/tmp-svpextract"));
        LauncherUtils.hideProgressPanel();
        LauncherUtils.resetProgressBar();
        LauncherUtils.setStatus("Checking for updates...");
    }

    public static void migrateAssetsIfNeeded() throws IOException {
        File assetRootData = new File("assets/assetarchive");
        File isSentinelArchive = new File(assetRootData, "sentinelarchive");
        if (assetRootData.exists() && !isSentinelArchive.exists()) {
            AssetManager.migrateAssets();
            LauncherUtils.hideProgressPanel();
            LauncherUtils.resetProgressBar();
        } else if (!isSentinelArchive.exists()) {
            assetRootData.mkdirs();
            isSentinelArchive.createNewFile();
        }
        File assetArchive = new File(assetRootData, "assets");
        assetArchive.mkdirs();
    }

    public static void verifyAssets() throws IOException {
        LauncherUtils.setStatus("Checking for updates...");
        if (!AssetManager.activeArchive.streamingModeEnabled || AssetManager.activeArchive.streamingModeOverriddenDisable) {
            LauncherUtils.log("Checking for asset archive updates...");
            AssetManager.migrateAssetsIfNeeded();
            LauncherUtils.setStatus("Checking for updates...");
            AssetInformation[] allAssets = activeArchive.getAllAssets();
            AssetInformation[] collectedAssets = AssetManager.collectAssets();
            LauncherUtils.log("Checking for asset updates...", true);
            LinkedHashMap<String, AssetInformation> assetsNeedingDownloads = new LinkedHashMap<String, AssetInformation>();
            ArrayList<String> clientsNeedingUpdates = new ArrayList<String>();
            for (AssetInformation asset : collectedAssets) {
                if (asset.isUpToDate()) continue;
                String[] stringArray = asset.clientVersions;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String version = stringArray[i];
                    if (clientsNeedingUpdates.contains(version)) continue;
                    clientsNeedingUpdates.add(version);
                }
                if (assetsNeedingDownloads.containsKey(asset.assetHash)) continue;
                assetsNeedingDownloads.put(asset.assetHash, asset);
            }
            if (assetsNeedingDownloads.size() != 0) {
                if (AssetManager.activeArchive.mode == ArchiveMode.REMOTE) {
                    if (!AssetManager.testArchiveConnection(activeArchive) || !assetManagementAvailable) {
                        LauncherUtils.log("Skipped asset update as there is no asset server connection.");
                        JOptionPane.showMessageDialog(AssetManager.launcherWindow.frmSentinelLauncher, "Failed to connect to the asset servers!\n\nPlease verify your internet connection before trying again.", "No connection to server", 0);
                        System.exit(1);
                    }
                    LauncherUtils.log("Downloading client assets...", true);
                    LauncherUtils.gameDescriptor.downloadAssets(AssetManager.activeArchive.source, (String[])clientsNeedingUpdates.toArray(String[]::new), (AssetInformation[])assetsNeedingDownloads.values().toArray(AssetInformation[]::new), collectedAssets, allAssets, activeArchive, AssetManager.activeArchive.archiveDef, AssetManager.activeArchive.descriptorDef, AssetManager.activeArchive.assetHashes);
                } else {
                    if (!new File(AssetManager.activeArchive.source).exists()) {
                        LauncherUtils.log("Skipped asset update as the source file is missing.");
                        JOptionPane.showMessageDialog(AssetManager.launcherWindow.frmSentinelLauncher, "Failed to copy assets from asset source file!\n\nPlease make sure the following file exists: " + AssetManager.activeArchive.source, "Asset source file missing", 0);
                        System.exit(1);
                    }
                    LauncherUtils.log("Extracting client assets...", true);
                    ZipFile zip = new ZipFile(AssetManager.activeArchive.source);
                    AssetInformation[] assetsNeedingUpdates = (AssetInformation[])assetsNeedingDownloads.values().toArray(AssetInformation[]::new);
                    LauncherUtils.setProgress(0, assetsNeedingUpdates.length);
                    LauncherUtils.showProgressPanel();
                    int i = 0;
                    for (AssetInformation asset : assetsNeedingUpdates) {
                        LauncherUtils.log("Extracting asset: " + asset);
                        LauncherUtils.setStatus("Extracting " + (i + 1) + "/" + assetsNeedingUpdates.length + " assets...");
                        File assetF = new File(asset.localAssetFile.getPath() + ".tmp");
                        assetF.getParentFile().mkdirs();
                        InputStream data = zip.getInputStream(zip.getEntry("assets/" + asset.assetHash + ".sa"));
                        FileOutputStream out = new FileOutputStream(assetF);
                        data.transferTo(out);
                        data.close();
                        out.close();
                        String rHash = asset.assetHash;
                        String cHash = LauncherUtils.sha512Hash(Files.readAllBytes(assetF.toPath()));
                        if (!rHash.equals(cHash)) {
                            assetF.delete();
                            throw new IOException("Integrity check failure");
                        }
                        assetF.renameTo(asset.localAssetFile);
                        LauncherUtils.increaseProgress();
                        ++i;
                    }
                    LauncherUtils.setProgress(LauncherUtils.getProgressMax());
                    zip.close();
                }
            }
        }
    }

    public static String[] collectClients() {
        if (collectedClients != null) {
            return collectedClients;
        }
        LauncherUtils.log("Collecting game clients...");
        ArrayList<String> gameVersions = new ArrayList<String>();
        for (JsonElement clE : localClientsArr) {
            String clientVersion = clE.getAsString();
            if (!AssetManager.activeArchive.archiveClientLst.has(clientVersion)) continue;
            gameVersions.add(clientVersion);
        }
        collectedClients = (String[])gameVersions.toArray(String[]::new);
        return collectedClients;
    }

    public static AssetInformation[] collectAssets() {
        if (collectedAssets != null) {
            return collectedAssets;
        }
        String[] gameVersions = AssetManager.collectClients();
        ArrayList<JsonArray> qualityLevels = new ArrayList<JsonArray>();
        JsonArray levels = LauncherUtils.gameDescriptor.knownAssetQualityLevels();
        File enabledQualityLevelListFile = new File("assets/qualitylevels.json");
        if (enabledQualityLevelListFile.exists()) {
            try {
                JsonArray qualityLevelsArr = JsonParser.parseString((String)Files.readString(enabledQualityLevelListFile.toPath())).getAsJsonArray();
                for (JsonElement ele : qualityLevelsArr) {
                    Object lvl = ele.getAsString();
                    if (qualityLevels.contains(lvl) || !Stream.of(levels).anyMatch(arg_0 -> AssetManager.lambda$collectAssets$7((String)lvl, arg_0))) continue;
                    qualityLevels.add((JsonArray)lvl);
                }
            }
            catch (IOException qualityLevelsArr) {
                // empty catch block
            }
        }
        if (qualityLevels.size() == 0) {
            for (Object lvl : levels) {
                qualityLevels.add((JsonArray)lvl);
            }
        }
        LauncherUtils.log("Collecting asset files...", true);
        AssetInformation[] allAssets = activeArchive.getAllAssets();
        LinkedHashMap<String, AssetInformation> assets = new LinkedHashMap<String, AssetInformation>();
        for (String clientVersion : gameVersions) {
            AssetInformation[] collectedAssets;
            LauncherUtils.log("Collecting assets of " + clientVersion + "...", true);
            for (AssetInformation asset : collectedAssets = LauncherUtils.gameDescriptor.collectVersionAssets(allAssets, (String[])qualityLevels.toArray(String[]::new), clientVersion, activeArchive, AssetManager.activeArchive.archiveDef, AssetManager.activeArchive.descriptorDef, AssetManager.activeArchive.assetHashes)) {
                AssetInformation as;
                if (!assets.containsKey(asset.assetHash.toLowerCase())) {
                    as = new AssetInformation();
                    as.assetHash = asset.assetHash;
                    as.assetPath = asset.assetPath;
                    as.localAssetFile = asset.localAssetFile;
                    as.clientVersions = new String[]{clientVersion};
                    assets.put(asset.assetPath.toLowerCase(), as);
                    continue;
                }
                as = (AssetInformation)assets.get(asset.assetPath.toLowerCase());
                if (Stream.of(as.clientVersions).anyMatch(t -> t.equalsIgnoreCase(clientVersion))) continue;
                as.clientVersions = AssetManager.appendToStringArray(as.clientVersions, clientVersion);
            }
        }
        collectedAssets = (AssetInformation[])assets.values().toArray(AssetInformation[]::new);
        return collectedAssets;
    }

    private static String[] appendToStringArray(String[] source, String ele) {
        String[] res = new String[source.length + 1];
        for (int i = 0; i < source.length; ++i) {
            res[i] = source[i];
        }
        res[res.length - 1] = ele;
        return res;
    }

    private static void migrateAssets() throws IOException {
        if (!new File("assets/migrationrejected").exists()) {
            new File("assets/assetarchive").renameTo(new File("assets/migrationrejected"));
        } else if (!new File("assets/assetarchive", "sentinelmigrated").exists()) {
            LauncherUtils.copyDirWithoutProgress(new File("assets/assetarchive"), new File("assets/migrationrejected"));
        }
        File assetRootData = new File("assets/assetarchive");
        File isSentinelArchive = new File(assetRootData, "sentinelarchive");
        File assetArchive = new File(assetRootData, "assets");
        assetRootData.mkdirs();
        assetArchive.mkdirs();
        new File(assetRootData, "sentinelmigrated").createNewFile();
        File migrationSource = new File("assets/migrationrejected");
        int size = AssetManager.indexDir(migrationSource);
        LauncherUtils.log("Migrating assets to new save structure...");
        LauncherUtils.setStatus("Migrating assets to new save structure... [0/" + size + "]");
        LauncherUtils.setProgress(0, size);
        LauncherUtils.showProgressPanel();
        ArrayList<String> copiedAssets = new ArrayList<String>();
        AssetManager.migrateAssets(migrationSource, assetArchive, copiedAssets, "");
        isSentinelArchive.createNewFile();
        LauncherUtils.hideProgressPanel();
        LauncherUtils.resetProgressBar();
    }

    private static void migrateAssets(File source, File destinationRoot, ArrayList<String> copiedAssets, String prefix) throws IOException {
        if (!source.exists()) {
            return;
        }
        for (File subDir : source.listFiles(t -> t.isDirectory())) {
            AssetManager.migrateAssets(subDir, destinationRoot, copiedAssets, prefix + subDir.getName() + "/");
            LauncherUtils.increaseProgress();
            LauncherUtils.setStatus("Migrating assets to new save structure... [" + LauncherUtils.getProgress() + "/" + LauncherUtils.getProgressMax() + "]");
        }
        for (File assetFile : source.listFiles(t -> t.isFile())) {
            String path = prefix + assetFile.getName();
            AssetInformation asset = activeArchive.getAsset(path);
            if (asset != null) {
                String hash = asset.assetHash;
                if (!copiedAssets.contains(hash)) {
                    File output = new File(destinationRoot, hash + ".sa");
                    if (output.exists()) {
                        output.delete();
                    }
                    assetFile.renameTo(output);
                    copiedAssets.add(hash);
                } else {
                    assetFile.delete();
                }
            }
            LauncherUtils.increaseProgress();
            LauncherUtils.setStatus("Migrating assets to new save structure... [" + LauncherUtils.getProgress() + "/" + LauncherUtils.getProgressMax() + "]");
        }
        if (source.listFiles().length == 0) {
            source.delete();
        }
    }

    private static void loadArchives(JsonObject archiveLst) {
        archiveList.clear();
        JsonObject localArchives = null;
        File localArchivesFile = new File("assets/userarchives.json");
        if (localArchivesFile.exists()) {
            try {
                localArchives = JsonParser.parseString((String)Files.readString(localArchivesFile.toPath())).getAsJsonObject();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (String key : archiveLst.keySet()) {
            ArchiveInformation ac = AssetManager.loadArchive(key, archiveLst, localArchives);
            if (!ac.descriptorType.matches("^[A-Za-z0-9\\-.,_ ]+$")) continue;
            try {
                if (assetManagementAvailable) {
                    Object dir = AssetManager.parseURL(sacConfig.get("descriptorRoot").getAsString(), LauncherUtils.urlBaseDescriptorFile, LauncherUtils.urlBaseSoftwareFile, assetSourceURL);
                    if (!((String)dir).endsWith("/")) {
                        dir = (String)dir + "/";
                    }
                    new URL((String)dir + ac.descriptorType + ".hash").openStream().close();
                }
                archiveList.put(key, ac);
            }
            catch (IOException iOException) {}
        }
    }

    private static void loadActiveArchive(JsonObject settings, boolean isReload) throws IOException {
        JsonObject localArchives;
        LauncherUtils.setStatus("Loading archive data...");
        LauncherUtils.log("Loading data into memory...");
        String archiveID = settings.get("id").getAsString();
        JsonObject archiveDef = AssetManager.archiveList.get((Object)archiveID).archiveDef;
        boolean streamingAssets = settings.get("stream").getAsBoolean();
        if (!archiveDef.get("allowStreaming").getAsBoolean() || archiveDef.has("deprecated") && archiveDef.has("deprecationNotice") && archiveDef.get("deprecated").getAsBoolean()) {
            streamingAssets = false;
        }
        if (!archiveDef.get("allowFullDownload").getAsBoolean()) {
            streamingAssets = true;
        }
        ActiveArchiveInformation info = new ActiveArchiveInformation();
        info.archiveID = archiveID;
        info.archiveDef = archiveDef;
        info.archiveName = archiveDef.get("archiveName").getAsString();
        info.descriptorType = archiveDef.get("type").getAsString();
        File localArchivesFile = new File("assets/userarchives.json");
        if (localArchivesFile.exists() && (localArchives = JsonParser.parseString((String)Files.readString(localArchivesFile.toPath())).getAsJsonObject()).has(archiveID)) {
            info.isUserArchive = true;
        }
        info.mode = ArchiveMode.REMOTE;
        if (archiveDef.has("isSgaFile") && archiveDef.get("isSgaFile").getAsBoolean()) {
            info.mode = ArchiveMode.LOCAL;
            info.source = archiveDef.get("filePath").getAsString();
            info.supportsDownloads = true;
            info.supportsStreaming = false;
            info.archiveClientLst = archiveDef.get("clients").getAsJsonObject();
        } else {
            info.source = archiveDef.get("url").getAsString();
            info.supportsDownloads = archiveDef.get("allowFullDownload").getAsBoolean();
            info.supportsStreaming = archiveDef.get("allowStreaming").getAsBoolean();
            info.archiveClientLst = archiveDef.get("clients").getAsJsonObject();
            if (archiveDef.has("deprecated")) {
                info.isDeprecated = archiveDef.get("deprecated").getAsBoolean();
                if (info.isDeprecated && archiveDef.has("deprecationNotice")) {
                    info.deprecationNotice = archiveDef.get("deprecationNotice").getAsString();
                } else {
                    info.isDeprecated = false;
                }
            }
        }
        info.connectionAvailable = AssetManager.testArchiveConnection(info);
        if (info.supportsStreaming && !info.isDeprecated) {
            info.streamingModeEnabled = streamingAssets;
        } else if (!info.supportsStreaming) {
            info.streamingModeEnabled = false;
        }
        if (info.mode == ArchiveMode.REMOTE) {
            LauncherUtils.log("Checking for archive updates...", true);
            LauncherUtils.log("Verifying connection...");
            assetConnection = info.connectionAvailable;
            AssetManager.updateArchiveDescriptor(assetConnection, info);
        } else {
            LauncherUtils.log("Checking for archive updates...", true);
            LauncherUtils.log("Verifying connection...");
            assetConnection = info.connectionAvailable;
            AssetManager.updateLocalArchiveDescriptor(assetConnection, info);
        }
        LauncherUtils.log("Indexing assets... Please wait...", true);
        LinkedHashMap<String, String> assetHashes = new LinkedHashMap<String, String>();
        AssetManager.indexAssetHashes(assetHashes, new File("assets/descriptor/hashes.shl"));
        LinkedHashMap<String, Long> index = new LinkedHashMap<String, Long>();
        AssetManager.indexAssets(index, new File("assets/descriptor/index.sfl"));
        for (String path : ((HashMap)index).keySet()) {
            if (!assetHashes.containsKey(path)) continue;
            AssetInformation asset = new AssetInformation();
            asset.assetPath = AssetManager.sanitizePath(path);
            asset.assetHash = (String)((HashMap)assetHashes).get(path);
            asset.localAssetFile = new File("assets/assetarchive/assets", asset.assetHash + ".sa");
            info.addAsset(asset);
        }
        info.assetHashes = assetHashes;
        info.descriptorDef = JsonParser.parseString((String)Files.readString(Path.of("assets/descriptor/descriptor.json", new String[0]))).getAsJsonObject();
        collectedAssets = null;
        collectedClients = null;
        activeArchive = info;
    }

    private static ArchiveInformation loadArchive(String archiveID, JsonObject archiveLst, JsonObject userArchives) {
        JsonObject archiveDef = archiveLst.get(archiveID).getAsJsonObject();
        ArchiveInformation info = new ArchiveInformation();
        info.archiveID = archiveID;
        info.archiveDef = archiveDef;
        info.archiveName = archiveDef.get("archiveName").getAsString();
        if (userArchives != null) {
            info.isUserArchive = userArchives.has(info.archiveID);
        }
        info.descriptorType = archiveDef.get("type").getAsString();
        info.mode = ArchiveMode.REMOTE;
        if (archiveDef.has("isSgaFile") && archiveDef.get("isSgaFile").getAsBoolean()) {
            info.mode = ArchiveMode.LOCAL;
            info.source = archiveDef.get("filePath").getAsString();
            info.supportsDownloads = true;
            info.supportsStreaming = false;
            info.archiveClientLst = archiveDef.get("clients").getAsJsonObject();
        } else {
            info.source = archiveDef.get("url").getAsString();
            info.supportsDownloads = archiveDef.get("allowFullDownload").getAsBoolean();
            info.supportsStreaming = archiveDef.get("allowStreaming").getAsBoolean();
            info.archiveClientLst = archiveDef.get("clients").getAsJsonObject();
            if (archiveDef.has("deprecated")) {
                info.isDeprecated = archiveDef.get("deprecated").getAsBoolean();
                if (info.isDeprecated && archiveDef.has("deprecationNotice")) {
                    info.deprecationNotice = archiveDef.get("deprecationNotice").getAsString();
                } else {
                    info.isDeprecated = false;
                }
            }
        }
        info.connectionAvailable = AssetManager.testArchiveConnection(info);
        return info;
    }

    private static void indexAssets(HashMap<String, Long> assets, File sizeFile) throws JsonSyntaxException, IOException {
        String[] lines;
        for (String line : lines = Files.readString(sizeFile.toPath()).split("\n")) {
            if (line.isEmpty()) continue;
            String name = line.substring(0, line.indexOf(": ")).replace(";sp;", " ").replace(";cl;", ":").replace(";sl;", ";");
            String len = line.substring(line.indexOf(": ") + 2);
            assets.put(name, Long.parseLong(len));
        }
    }

    private static void indexAssetHashes(HashMap<String, String> assetHashes, File hashFile) throws JsonSyntaxException, IOException {
        String[] lines;
        for (String line : lines = Files.readString(hashFile.toPath()).split("\n")) {
            if (line.isEmpty()) continue;
            String name = line.substring(0, line.indexOf(": ")).replace(";sp;", " ").replace(";cl;", ":").replace(";sl;", ";");
            String hash = line.substring(line.indexOf(": ") + 2);
            assetHashes.put(name, hash);
        }
    }

    private static int indexDir(File dir) {
        int i = 0;
        for (File subDir : dir.listFiles(t -> t.isDirectory())) {
            i += AssetManager.indexDir(subDir) + 1;
        }
        File[] listFiles = dir.listFiles(t -> !t.isDirectory());
        for (int j = 0; j < listFiles.length; ++j) {
            ++i;
        }
        return i;
    }

    private static String sanitizePath(String path) {
        if (path.contains("\\")) {
            path = path.replace("\\", "/");
        }
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        while (path.contains("//")) {
            path = path.replace("//", "/");
        }
        return path;
    }

    public static boolean testArchiveConnection(ArchiveInformation info) {
        boolean res = true;
        res = info.mode == ArchiveMode.REMOTE ? LauncherUtils.gameDescriptor.verifyAssetConnection(info.source) : new File(info.source).exists();
        info.connectionAvailable = res;
        return res;
    }

    private static void loadClientList() throws JsonSyntaxException, IOException {
        localClientsArr = new JsonArray();
        File clientListFile = new File("assets/clients.json");
        if (clientListFile.exists()) {
            localClientsArr = JsonParser.parseString((String)Files.readString(Path.of("assets/clients.json", new String[0]))).getAsJsonArray();
        }
    }

    private static String downloadString(String url) throws IOException {
        URLConnection conn = new URL(url).openConnection();
        InputStream strm = conn.getInputStream();
        String data = new String(strm.readAllBytes(), "UTF-8");
        strm.close();
        return data;
    }

    private static byte[] downloadBytes(String url) throws IOException {
        URLConnection conn = new URL(url).openConnection();
        InputStream strm = conn.getInputStream();
        byte[] data = strm.readAllBytes();
        strm.close();
        return data;
    }

    private static String parseURL(String url, String urlBaseDescriptorFileF, String urlBaseSoftwareFileF, String sentinelAssetRoot) {
        if (((String)url).startsWith("sgd:")) {
            String source = ((String)url).substring(4);
            while (source.startsWith("/")) {
                source = source.substring(1);
            }
            url = urlBaseDescriptorFileF + source;
        } else if (((String)url).startsWith("svp:")) {
            String source = ((String)url).substring(4);
            while (source.startsWith("/")) {
                source = source.substring(1);
            }
            url = urlBaseSoftwareFileF + source;
        } else if (sentinelAssetRoot != null && ((String)url).startsWith("sac:")) {
            String source = ((String)url).substring(4);
            while (source.startsWith("/")) {
                source = source.substring(1);
            }
            url = sentinelAssetRoot + source;
        }
        return url;
    }

    private static void updateArchiveDescriptor(boolean assetConnection, ArchiveInformation archive) throws IOException {
        String cHashDescriptor = "";
        if (new File("assets/descriptor.hash").exists()) {
            cHashDescriptor = Files.readString(Path.of("assets/descriptor.hash", new String[0])).replace("\r", "").replace("\n", "");
        }
        if (assetConnection && assetManagementAvailable) {
            String rHashDescriptor;
            LauncherUtils.log("Checking for updates for the archive descriptor...");
            Object dir = AssetManager.parseURL(sacConfig.get("descriptorRoot").getAsString(), LauncherUtils.urlBaseDescriptorFile, LauncherUtils.urlBaseSoftwareFile, assetSourceURL);
            if (!((String)dir).endsWith("/")) {
                dir = (String)dir + "/";
            }
            if (!(rHashDescriptor = AssetManager.downloadString((String)dir + archive.descriptorType + ".hash").replace("\r", "").replace("\n", "")).equalsIgnoreCase(cHashDescriptor)) {
                AssetManager.downloadArchiveDescriptor(archive);
            }
        } else {
            LauncherUtils.log("Skipped archive descriptor update check as there is no asset server connection.");
            if (cHashDescriptor.equals("")) {
                JOptionPane.showMessageDialog(AssetManager.launcherWindow.frmSentinelLauncher, "Failed to connect to the asset servers!\n\nPlease verify your internet connection before trying again.", "No connection to server", 0);
                System.exit(1);
            }
        }
        LauncherUtils.hideProgressPanel();
        LauncherUtils.resetProgressBar();
    }

    private static void updateLocalArchiveDescriptor(boolean assetConnection, ArchiveInformation archive) throws IOException {
        String cHashDescriptor = "";
        if (!new File("assets/descriptor-local.version").exists()) {
            if (assetConnection) {
                ZipEntry ent;
                ZipEntry ent2;
                LauncherUtils.log("Re-extracting archive descriptor...", true);
                ZipFile zip = new ZipFile(archive.source);
                int count = 0;
                Enumeration<? extends ZipEntry> en = zip.entries();
                while (en.hasMoreElements() && (ent2 = en.nextElement()) != null) {
                    if (ent2.getName().equals("descriptor/") || !ent2.getName().startsWith("descriptor/")) continue;
                    ++count;
                }
                zip.close();
                LauncherUtils.resetProgressBar();
                LauncherUtils.showProgressPanel();
                LauncherUtils.setProgressMax(count);
                if (new File("assets/descriptor").exists()) {
                    LauncherUtils.deleteDir(new File("assets/descriptor"));
                }
                new File("assets/descriptor").mkdirs();
                zip = new ZipFile(archive.source);
                en = zip.entries();
                int max = count;
                int i = 0;
                while (en.hasMoreElements() && (ent = en.nextElement()) != null) {
                    if (ent.getName().equals("descriptor/") || !ent.getName().startsWith("descriptor/")) continue;
                    if (ent.isDirectory()) {
                        new File("assets/descriptor", ent.getName().substring("descriptor/".length())).mkdirs();
                    } else {
                        FileOutputStream output = new FileOutputStream(new File("assets/descriptor", ent.getName().substring("descriptor/".length())));
                        InputStream is = zip.getInputStream(ent);
                        is.transferTo(output);
                        is.close();
                        output.close();
                    }
                    LauncherUtils.setProgress(i++, max);
                }
                LauncherUtils.setProgress(max, max);
                zip.close();
                Files.writeString(Path.of("assets/descriptor.hash", new String[0]), (CharSequence)("local-" + LauncherUtils.sha512Hash((new File(archive.source).lastModified() + "-" + archive.source + "-" + new File(archive.source).length()).getBytes("UTF-8"))), new OpenOption[0]);
                Files.writeString(Path.of("assets/descriptor-local.version", new String[0]), (CharSequence)"latest", new OpenOption[0]);
            } else {
                LauncherUtils.log("Skipped archive descriptor update check as the source file doesnt exist.");
                if (cHashDescriptor.equals("")) {
                    JOptionPane.showMessageDialog(AssetManager.launcherWindow.frmSentinelLauncher, "Could not extract the archive descriptor!\n\nThe archive SGA file is not presently on disk!\nFile path: " + archive.source, "Archive file missing", 0);
                    System.exit(1);
                }
            }
        }
        LauncherUtils.hideProgressPanel();
        LauncherUtils.resetProgressBar();
    }

    private static void downloadArchiveDescriptor(ArchiveInformation archive) throws IOException {
        LauncherUtils.log("Updating archive information...", true);
        String dir = AssetManager.parseURL(sacConfig.get("descriptorRoot").getAsString(), LauncherUtils.urlBaseDescriptorFile, LauncherUtils.urlBaseSoftwareFile, assetSourceURL);
        String rHashDescriptor = AssetManager.downloadString(dir + archive.descriptorType + ".hash").replace("\r", "").replace("\n", "");
        LauncherUtils.resetProgressBar();
        LauncherUtils.showProgressPanel();
        LauncherUtils.downloadFile(dir + archive.descriptorType + ".zip", new File("assets/descriptor.zip"));
        LauncherUtils.hideProgressPanel();
        LauncherUtils.resetProgressBar();
        LauncherUtils.log("Verifying signature... Please wait...", true);
        if (!LauncherUtils.verifyPackageSignature(new File("assets/descriptor.zip"), new File("assets/sac-publickey.pem"))) {
            if (!LauncherUtils.isPackageSigned(new File("assets/descriptor.zip"))) {
                LauncherUtils.log("Package is unsigned.");
                if (!sacConfig.get("allowUnsignedArchiveDescriptors").getAsBoolean()) {
                    LauncherUtils.log("Package is unsigned.");
                    JOptionPane.showMessageDialog(AssetManager.launcherWindow.frmSentinelLauncher, "The archive descriptor is unsigned and this game descriptor does not support unsigned archive descriptors.\n\nPlease report this error to the project's archival team.", "Update error", 0);
                    System.exit(1);
                }
            } else {
                LauncherUtils.log("Signature verification failure.");
                JOptionPane.showMessageDialog(AssetManager.launcherWindow.frmSentinelLauncher, "Failed to verify integrity of archive descriptor file.\n\nPlease report this error to the project's archival team.", "Update error", 0);
                System.exit(1);
            }
        }
        LauncherUtils.log("Extracting archive information...", true);
        if (new File("assets/descriptor").exists()) {
            LauncherUtils.deleteDir(new File("assets/descriptor"));
        }
        LauncherUtils.unZip(new File("assets/descriptor.zip"), new File("assets/descriptor"));
        LauncherUtils.hideProgressPanel();
        LauncherUtils.resetProgressBar();
        Files.writeString(Path.of("assets/descriptor.hash", new String[0]), (CharSequence)rHashDescriptor, new OpenOption[0]);
    }

    private static JsonObject loadArchiveList() throws IOException {
        JsonObject archiveLst = JsonParser.parseString((String)Files.readString(new File("assets/assetarchives.json").toPath())).getAsJsonObject();
        File localArchivesFile = new File("assets/userarchives.json");
        if (localArchivesFile.exists()) {
            JsonObject localArchives = JsonParser.parseString((String)Files.readString(localArchivesFile.toPath())).getAsJsonObject();
            for (String id : localArchives.keySet()) {
                archiveLst.add(id, localArchives.get(id));
            }
        }
        return archiveLst;
    }

    public static void removeUserArchive(String archiveID) throws IOException {
        if (!archiveList.containsKey(archiveID) || !AssetManager.archiveList.get((Object)archiveID).isUserArchive) {
            throw new IOException("User-added archive '" + archiveID + "' could not be found!");
        }
        archiveList.remove(archiveID);
        File localArchivesFile = new File("assets/userarchives.json");
        if (localArchivesFile.exists()) {
            JsonObject localArchives = JsonParser.parseString((String)Files.readString(localArchivesFile.toPath())).getAsJsonObject();
            if (localArchives.has(archiveID)) {
                localArchives.remove(archiveID);
            }
            Files.writeString(localArchivesFile.toPath(), (CharSequence)localArchives.toString(), new OpenOption[0]);
        }
    }

    public static ArchiveInformation addUserArchive(JsonObject archiveDef) throws IOException {
        String archiveID = "user-" + UUID.randomUUID();
        while (archiveList.containsKey(archiveID)) {
            archiveID = "user-" + UUID.randomUUID();
        }
        JsonObject localArchives = new JsonObject();
        File localArchivesFile = new File("assets/userarchives.json");
        if (localArchivesFile.exists()) {
            localArchives = JsonParser.parseString((String)Files.readString(localArchivesFile.toPath())).getAsJsonObject();
        }
        localArchives.add(archiveID, (JsonElement)archiveDef);
        Files.writeString(localArchivesFile.toPath(), (CharSequence)localArchives.toString(), new OpenOption[0]);
        JsonObject archiveLst = AssetManager.loadArchiveList();
        ArchiveInformation archive = AssetManager.loadArchive(archiveID, archiveLst, localArchives);
        archiveList.put(archiveID, archive);
        return archive;
    }

    private static /* synthetic */ boolean lambda$collectAssets$7(String lvl, String t) {
        return t.equalsIgnoreCase(lvl);
    }

    static {
        assetManagementAvailable = false;
        archiveList = new LinkedHashMap<String, ArchiveInformation>();
    }
}

