/*
 * Decompiled with CFR 0.152.
 */
package org.asf.razorwhip.sentinel.launcher;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class BackgroundPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private BufferedImage img;

    public void setImage(BufferedImage img) {
        this.img = img;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.img == null) {
            return;
        }
        Graphics2D gr = (Graphics2D)g;
        gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gr.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        double wrh = (double)this.img.getWidth() / (double)this.img.getHeight();
        int newWidth = this.getWidth();
        int newHeight = (int)((double)newWidth / wrh);
        if (newHeight < this.getHeight()) {
            newHeight = this.getHeight();
            newWidth = (int)((double)newHeight * wrh);
        }
        int offX = this.getWidth() - newWidth;
        int offY = this.getHeight() - newHeight;
        g.drawImage(this.img, offX / 2, offY / 2, newWidth, newHeight, null);
    }
}

