/*
 * Decompiled with CFR 0.152.
 */
package org.asf.razorwhip.sentinel.launcher;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.nio.ByteBuffer;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;

public class DynamicClassLoader
extends URLClassLoader {
    private HashMap<String, Class<?>> loadedClasses = new HashMap();
    public static ArrayList<LoadedClassProvider> loadedClassProviders = new ArrayList();

    public DynamicClassLoader() {
        super(new URL[0], (ClassLoader)null);
    }

    public DynamicClassLoader(URL[] urls) {
        super(urls, (ClassLoader)null);
    }

    public DynamicClassLoader(String name) {
        super(name, new URL[0], null);
    }

    public DynamicClassLoader(String name, URL[] urls) {
        super(name, urls, null);
    }

    public DynamicClassLoader(String name, ClassLoader parent) {
        super(name, new URL[0], parent);
    }

    public DynamicClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    public DynamicClassLoader(URL[] urls, ClassLoader parent) {
        super(new URL[0], parent);
    }

    public DynamicClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
    }

    public DynamicClassLoader(String name, URL[] urls, ClassLoader parent) {
        super(name, urls, parent);
    }

    public DynamicClassLoader(String name, URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(name, urls, parent, factory);
    }

    public void addUrl(URL url) {
        super.addURL(url);
    }

    public void addUrls(URL[] urls) {
        for (URL url : urls) {
            super.addURL(url);
        }
    }

    public void addUrls(Iterable<URL> urls) {
        for (URL url : urls) {
            super.addURL(url);
        }
    }

    public Class<?> getLoadedClass(String name) {
        return this.loadedClasses.get(name);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        for (LoadedClassProvider prov : loadedClassProviders) {
            Class<?> cls = prov.provide(name);
            if (cls == null) continue;
            return cls;
        }
        Class<?> _class = null;
        try {
            if (this.loadedClasses.containsKey(name)) {
                return this.loadedClasses.get(name);
            }
            _class = super.findClass(name);
        }
        catch (ClassNotFoundException ex) {
            ClassLoader l = this.getParent();
            if (l == null) {
                l = Thread.currentThread().getContextClassLoader();
            }
            if (l == this) {
                l = ClassLoader.getSystemClassLoader();
            }
            _class = Class.forName(name, true, l);
        }
        if (!this.loadedClasses.containsKey(name)) {
            this.loadedClasses.put(name, _class);
        }
        return _class;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, true);
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        for (LoadedClassProvider prov : loadedClassProviders) {
            Class<?> cls = prov.provide(name);
            if (cls == null) continue;
            return cls;
        }
        if (this.loadedClasses.containsKey(name)) {
            return this.loadedClasses.get(name);
        }
        Class<?> cl = null;
        try {
            cl = this.doLoadClass(name, resolve);
        }
        catch (ClassNotFoundException | NoClassDefFoundError ex) {
            ClassLoader l = this.getParent();
            if (l == null) {
                l = Thread.currentThread().getContextClassLoader();
            }
            if (l == this) {
                l = ClassLoader.getSystemClassLoader();
            }
            cl = l.loadClass(name);
        }
        if (!this.loadedClasses.containsKey(name)) {
            this.loadedClasses.put(name, cl);
        }
        return cl;
    }

    Class<?> doLoadClass(String name, boolean resolve) throws ClassNotFoundException {
        String path = name.replaceAll("\\.", "/") + ".class";
        for (URL u : this.getURLs()) {
            try {
                if (!u.toString().endsWith(".class")) {
                    if (!u.toString().endsWith("/")) {
                        try {
                            u = new URL("jar:" + u.toString() + "!/" + path);
                        }
                        catch (MalformedURLException malformedURLException) {}
                    } else {
                        try {
                            u = new URL(u + "/" + path);
                        }
                        catch (MalformedURLException malformedURLException) {}
                    }
                } else if (!u.toString().endsWith("/" + path)) continue;
                if (name.startsWith("java.")) {
                    return ClassLoader.getSystemClassLoader().loadClass(name);
                }
                BufferedInputStream strm = new BufferedInputStream(u.openStream());
                byte[] data = strm.readAllBytes();
                strm.close();
                Class<?> cls = this.defineClass(name, ByteBuffer.wrap(data), new CodeSource(u, (Certificate[])null));
                if (resolve) {
                    this.resolveClass(cls);
                }
                return cls;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException("Cannot find class " + name);
    }

    private URL getResourceURL(String name) throws MalformedURLException {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        Class<?> caller = null;
        int index = 2;
        while (index < elements.length) {
            try {
                caller = this.loadClass(elements[index++].getClassName());
                while (caller.getTypeName().equals(Class.class.getTypeName()) || caller.getTypeName().equals(DynamicClassLoader.class.getTypeName())) {
                    caller = this.loadClass(elements[index++].getClassName());
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            ClassLoader cl = caller.getClassLoader();
            if (cl == this) {
                cl = Thread.currentThread().getContextClassLoader();
            }
            if (cl == this) {
                cl = ClassLoader.getSystemClassLoader();
            }
            try {
                URL cSource = caller.getProtectionDomain().getCodeSource().getLocation();
                Object prefix = cSource.toString();
                if (cSource.getProtocol().equals("jar")) {
                    prefix = ((String)prefix).substring(0, ((String)prefix).lastIndexOf("!"));
                    prefix = (String)prefix + "!/";
                } else if (cSource.toString().endsWith("jar")) {
                    prefix = "jar:" + (String)prefix + "!/";
                } else if (!((String)prefix).endsWith("/")) {
                    prefix = (String)prefix + "/";
                }
                prefix = (String)prefix + name;
                return new URL((String)prefix);
            }
            catch (NullPointerException nullPointerException) {
            }
        }
        return null;
    }

    @Override
    public URL getResource(String name) {
        try {
            URL resource = this.getResourceURL(name);
            if (resource == null) {
                return null;
            }
            try {
                resource.openStream().close();
            }
            catch (IOException ex) {
                return null;
            }
            return resource;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        try {
            URL resource = this.getResourceURL(name);
            if (resource == null) {
                return null;
            }
            return resource.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    public void addDefaultCp() {
        for (String entry : System.getProperty("java.class.path").split(File.pathSeparator)) {
            try {
                this.addUrl(new File(entry).toURI().toURL());
            }
            catch (MalformedURLException e) {
                try {
                    this.addUrl(new URL(entry));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
    }

    public static boolean knowsLoadedClassProvider(String name) {
        for (LoadedClassProvider prov : loadedClassProviders) {
            if (!prov.name().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static void registerLoadedClassProvider(LoadedClassProvider loadedClassProvider) {
        if (!DynamicClassLoader.knowsLoadedClassProvider(loadedClassProvider.name())) {
            loadedClassProviders.add(loadedClassProvider);
        }
    }

    public static interface LoadedClassProvider {
        public String name();

        public Class<?> provide(String var1);
    }
}

