/*
 * Decompiled with CFR 0.152.
 */
package org.asf.razorwhip.sentinel.launcher;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.BevelBorder;
import org.asf.razorwhip.sentinel.launcher.AssetManager;
import org.asf.razorwhip.sentinel.launcher.BackgroundPanel;
import org.asf.razorwhip.sentinel.launcher.LauncherUtils;
import org.asf.razorwhip.sentinel.launcher.PayloadManager;
import org.asf.razorwhip.sentinel.launcher.api.IEmulationSoftwareProvider;
import org.asf.razorwhip.sentinel.launcher.api.IGameDescriptor;
import org.asf.razorwhip.sentinel.launcher.api.ISentinelPayload;
import org.asf.razorwhip.sentinel.launcher.assets.ActiveArchiveInformation;
import org.asf.razorwhip.sentinel.launcher.assets.AssetInformation;
import org.asf.razorwhip.sentinel.launcher.experiments.SentinelExperimentManager;

public class LauncherMain {
    public static String LAUNCHER_VERSION = "1.0.0.A27";
    JFrame frmSentinelLauncher;
    private JLabel lblStatusLabel;
    private boolean shiftDown;
    private static ArrayList<String> filesToDeleteOnClientUpdate = new ArrayList();
    private static ArrayList<Long> updateActiveClientProcesses = new ArrayList();

    public static void main(String[] args) {
        SentinelExperimentManager.bindManager();
        LauncherUtils.args = args;
        if (new File("sentinel.activeprocesses.sjf").exists()) {
            try {
                JsonObject settings = JsonParser.parseString((String)Files.readString(Path.of("sentinel.activeprocesses.sjf", new String[0]))).getAsJsonObject();
                if (settings.has("processes")) {
                    for (JsonElement ele : settings.get("processes").getAsJsonArray()) {
                        updateActiveClientProcesses.add(ele.getAsLong());
                    }
                }
                if (settings.has("deleteFilesOnProcessExit")) {
                    for (JsonElement ele : settings.get("deleteFilesOnProcessExit").getAsJsonArray()) {
                        filesToDeleteOnClientUpdate.add(ele.getAsString());
                    }
                }
                new File("sentinel.activeprocesses.sjf").delete();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    LauncherMain window;
                    LauncherUtils.launcherWindow = window = new LauncherMain();
                    window.frmSentinelLauncher.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public LauncherMain() {
        this.initialize();
    }

    static void closeClientsIfNeeded() {
        if (updateActiveClientProcesses.size() == 0) {
            return;
        }
        ArrayList<ProcessHandle> handles = new ArrayList<ProcessHandle>();
        Iterator<Object> iterator = updateActiveClientProcesses.iterator();
        while (iterator.hasNext()) {
            long pid = iterator.next();
            try {
                Optional<ProcessHandle> h = ProcessHandle.of(pid);
                if (!h.isPresent() || !h.get().isAlive()) continue;
                handles.add(h.get());
            }
            catch (Exception exception) {}
        }
        if (handles.size() != 0) {
            JOptionPane.showMessageDialog(LauncherUtils.launcherWindow.frmSentinelLauncher, "Warning!\n\nSentinel found some running client processes that need to be closed before the update can be completed.\n\nPlease close the clients before proceeding, press OK to terminate all remaining client processes.", "Active client processes detected", 2);
            for (ProcessHandle handle : handles) {
                if (!handle.isAlive()) continue;
                handle.destroy();
            }
            for (String f : filesToDeleteOnClientUpdate) {
                if (!new File(f).exists()) continue;
                new File(f).delete();
            }
        }
        updateActiveClientProcesses.clear();
        filesToDeleteOnClientUpdate.clear();
    }

    private void initialize() {
        String softwareSourceClass;
        Map<String, String> softwareDescriptor;
        String descriptorSourceClass;
        Map<String, String> gameDescriptor;
        Object urlBaseSoftwareFile;
        Object urlBaseDescriptorFile;
        boolean overrodeSVP;
        boolean overrodeSGD;
        try {
            try {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e1) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e1) {
            // empty catch block
        }
        this.frmSentinelLauncher = new JFrame();
        this.frmSentinelLauncher.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 16) {
                    LauncherMain.this.shiftDown = true;
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 16) {
                    LauncherMain.this.shiftDown = false;
                }
            }
        });
        this.frmSentinelLauncher.setResizable(false);
        this.frmSentinelLauncher.setBounds(100, 100, 854, 330);
        this.frmSentinelLauncher.setDefaultCloseOperation(3);
        this.frmSentinelLauncher.setLocationRelativeTo(null);
        try {
            InputStream strmi = this.getClass().getClassLoader().getResourceAsStream("icon.png");
            this.frmSentinelLauncher.setIconImage(ImageIO.read(strmi));
            strmi.close();
        }
        catch (Exception strmi) {
            // empty catch block
        }
        try {
            FileInputStream fIN = new FileInputStream(new File("icon.png"));
            this.frmSentinelLauncher.setIconImage(ImageIO.read(fIN));
            ((InputStream)fIN).close();
        }
        catch (Exception fIN) {
            // empty catch block
        }
        BackgroundPanel panel_1 = new BackgroundPanel();
        panel_1.setForeground(Color.WHITE);
        this.frmSentinelLauncher.getContentPane().add((Component)panel_1, "Center");
        panel_1.setLayout(new BorderLayout(0, 0));
        JPanel panel_4 = new JPanel();
        panel_4.setPreferredSize(new Dimension(10, 30));
        panel_1.add((Component)panel_4, "South");
        panel_4.setBackground(new Color(10, 10, 10, 120));
        panel_4.setLayout(new BorderLayout(0, 0));
        this.lblStatusLabel = new JLabel("New label");
        panel_4.add((Component)this.lblStatusLabel, "Center");
        this.lblStatusLabel.setFont(new Font("Tahoma", 0, 14));
        this.lblStatusLabel.setForeground(Color.WHITE);
        this.lblStatusLabel.setPreferredSize(new Dimension(46, 20));
        JPanel panel_5 = new JPanel();
        panel_5.setBorder(new BevelBorder(1, null, null, null, null));
        panel_5.setPreferredSize(new Dimension(200, 10));
        panel_5.setBackground(new Color(255, 255, 255, 0));
        panel_4.add((Component)panel_5, "East");
        panel_5.setLayout(new BoxLayout(panel_5, 0));
        JProgressBar progressBar = new JProgressBar();
        panel_5.add(progressBar);
        progressBar.setPreferredSize(new Dimension(500, 14));
        progressBar.setBackground(new Color(240, 240, 240, 100));
        JPanel panelLabels = new JPanel();
        panelLabels.setBackground(Color.LIGHT_GRAY);
        panel_1.add((Component)panelLabels, "Center");
        panelLabels.setLayout(new FlowLayout(1, 5, 5));
        JPanel panel_2 = new JPanel();
        panel_2.setBackground(Color.LIGHT_GRAY);
        panel_2.setPreferredSize(new Dimension(600, 180));
        panelLabels.add(panel_2);
        panel_2.setLayout(null);
        JLabel lblNewLabel = new JLabel("<Project Name>");
        lblNewLabel.setBounds(12, 119, 576, 33);
        panel_2.add(lblNewLabel);
        lblNewLabel.setHorizontalTextPosition(0);
        lblNewLabel.setHorizontalAlignment(0);
        lblNewLabel.setFont(new Font("Dialog", 0, 22));
        panel_5.setVisible(false);
        File gameDescriptorFile = new File("gamedescriptor.sgd");
        File emulationSoftwareFile = new File("emulationsoftware.svp");
        boolean dirModeDescriptorFile = false;
        boolean dirModeSoftwareFile = false;
        try {
            File f;
            URL loc;
            Class<?> cls;
            LauncherUtils.log("Loading debug settings...");
            if (System.getProperty("debugGameDescriptorHintClass") != null) {
                LauncherUtils.log("Loading debug descriptor...");
                cls = Class.forName(System.getProperty("debugGameDescriptorHintClass"));
                loc = cls.getProtectionDomain().getCodeSource().getLocation();
                f = new File(loc.toURI());
                if (f.isDirectory()) {
                    dirModeDescriptorFile = true;
                }
                gameDescriptorFile = f;
                LauncherUtils.log("Using descriptor: " + f);
            }
            if (System.getProperty("debugEmulationSoftwareHintClass") != null) {
                LauncherUtils.log("Loading debug emulation software...");
                cls = Class.forName(System.getProperty("debugEmulationSoftwareHintClass"));
                loc = cls.getProtectionDomain().getCodeSource().getLocation();
                f = new File(loc.toURI());
                if (f.isDirectory()) {
                    dirModeSoftwareFile = true;
                }
                emulationSoftwareFile = f;
                LauncherUtils.log("Using emulation software: " + f);
            }
            new File("cache").mkdirs();
            new File("cache/keys").mkdirs();
            new File("clients").mkdirs();
            new File("payloads").mkdirs();
            if (new File("newgamedescriptor.sgd").exists()) {
                new File(gameDescriptorFile.getPath()).renameTo(new File("gamedescriptor.sgd.old"));
                new File("newgamedescriptor.sgd").renameTo(new File(gameDescriptorFile.getPath()));
                LauncherUtils.extractGameDescriptor(new File(gameDescriptorFile.getPath()), "overridden version");
                if (LauncherUtils.isPackageSigned(gameDescriptorFile)) {
                    LauncherUtils.extractPackagePublicKey(gameDescriptorFile, new File("cache/keys/gamedescriptor-publickey.pem"));
                } else if (new File("cache/keys/gamedescriptor-publickey.pem").exists()) {
                    new File("cache/keys/gamedescriptor-publickey.pem").delete();
                }
                overrodeSGD = true;
            } else {
                overrodeSGD = false;
            }
            if (new File("newemulationsoftware.svp").exists()) {
                new File(emulationSoftwareFile.getPath()).renameTo(new File("emulationsoftware.svp.old"));
                new File("newemulationsoftware.svp").renameTo(new File(emulationSoftwareFile.getPath()));
                LauncherUtils.extractEmulationSoftware(new File(emulationSoftwareFile.getPath()), "overridden version");
                if (LauncherUtils.isPackageSigned(emulationSoftwareFile)) {
                    LauncherUtils.extractPackagePublicKey(emulationSoftwareFile, new File("cache/keys/emulationsoftware-publickey.pem"));
                } else if (new File("cache/keys/emulationsoftware-publickey.pem").exists()) {
                    new File("cache/keys/emulationsoftware-publickey.pem").delete();
                }
                overrodeSVP = true;
            } else {
                overrodeSVP = false;
            }
            LauncherUtils.panel = panel_1;
            LauncherUtils.statusLabel = this.lblStatusLabel;
            LauncherUtils.progressPanel = panel_5;
            LauncherUtils.progressBar = progressBar;
            LauncherUtils.log("Checking files...");
            if (!gameDescriptorFile.exists() || !emulationSoftwareFile.exists()) {
                JOptionPane.showMessageDialog(this.frmSentinelLauncher, "Missing launcher files, please run the installer first.", "Launcher Error", 0);
                System.exit(1);
                return;
            }
            LauncherUtils.log("Preparing data source URLs...");
            urlBaseDescriptorFile = !dirModeDescriptorFile ? "jar:" + gameDescriptorFile.toURI() + "!" : gameDescriptorFile.toURI().toString();
            if (!((String)urlBaseDescriptorFile).endsWith("/")) {
                urlBaseDescriptorFile = (String)urlBaseDescriptorFile + "/";
            }
            if (!((String)(urlBaseSoftwareFile = !dirModeSoftwareFile ? "jar:" + emulationSoftwareFile.toURI() + "!" : emulationSoftwareFile.toURI().toString())).endsWith("/")) {
                urlBaseSoftwareFile = (String)urlBaseSoftwareFile + "/";
            }
            LauncherUtils.log("Loading game descriptor information...");
            gameDescriptor = LauncherUtils.parseProperties(this.getStringFrom(gameDescriptorFile, "descriptorinfo"));
            descriptorSourceClass = gameDescriptor.get("Game-Descriptor-Class");
            LauncherUtils.gameID = gameDescriptor.get("Game-ID");
            if (descriptorSourceClass == null) {
                throw new IOException("No descriptor class defined in game descriptor");
            }
            if (LauncherUtils.gameID == null) {
                throw new IOException("No game ID defined in game descriptor");
            }
            LauncherUtils.log("Loading emulation software information...");
            softwareDescriptor = LauncherUtils.parseProperties(this.getStringFrom(emulationSoftwareFile, "softwareinfo"));
            if (!softwareDescriptor.containsKey("Game-ID")) {
                throw new IOException("No game ID defined in emulation software descriptor");
            }
            softwareSourceClass = softwareDescriptor.get("Software-Class");
            LauncherUtils.softwareName = softwareDescriptor.get("Project-Name");
            LauncherUtils.softwareVersion = softwareDescriptor.get("Software-Version");
            LauncherUtils.softwareID = softwareDescriptor.get("Software-ID");
            if (softwareSourceClass == null) {
                throw new IOException("No software class defined in emulation software descriptor");
            }
            if (LauncherUtils.softwareID == null) {
                throw new IOException("No software ID defined in emulation software descriptor");
            }
            if (LauncherUtils.softwareVersion == null) {
                throw new IOException("No software version defined in emulation software descriptor");
            }
            if (LauncherUtils.softwareName == null) {
                throw new IOException("No software name defined in emulation software descriptor");
            }
            if (!softwareDescriptor.get("Game-ID").equalsIgnoreCase(LauncherUtils.getGameID())) {
                throw new IllegalArgumentException("Emulation software '" + LauncherUtils.softwareName + "' is incompatible with the current game.");
            }
            LauncherUtils.log("");
            LauncherUtils.log("");
            LauncherUtils.log("---------------------------");
            LauncherUtils.log("Welcome to the " + LauncherUtils.softwareName + " Launcher! (v" + LAUNCHER_VERSION + ")");
            LauncherUtils.log("Launcher version: " + LAUNCHER_VERSION);
            LauncherUtils.log("");
            LauncherUtils.log("Game ID: " + LauncherUtils.gameID);
            LauncherUtils.log("Emulation software ID: " + LauncherUtils.softwareID);
            LauncherUtils.log("Emulation software version: " + LauncherUtils.softwareVersion);
            LauncherUtils.log("---------------------------");
            LauncherUtils.log("");
            LauncherUtils.log("");
            this.frmSentinelLauncher.setTitle(LauncherUtils.softwareName + " Launcher");
            lblNewLabel.setText(LauncherUtils.softwareName);
            panelLabels.setVisible(false);
            try {
                this.setPanelImageFrom(emulationSoftwareFile, "banner.png", panel_1);
            }
            catch (IOException e) {
                try {
                    this.setPanelImageFrom(emulationSoftwareFile, "banner.jpg", panel_1);
                }
                catch (IOException e2) {
                    try {
                        this.setPanelImageFrom(gameDescriptorFile, "banner.png", panel_1);
                    }
                    catch (IOException e3) {
                        try {
                            this.setPanelImageFrom(gameDescriptorFile, "banner.jpg", panel_1);
                        }
                        catch (IOException e4) {
                            panelLabels.setVisible(true);
                        }
                    }
                }
            }
            try {
                this.setIconFrom(emulationSoftwareFile, "icon.png");
            }
            catch (IOException e) {
                try {
                    this.setIconFrom(gameDescriptorFile, "icon.png");
                }
                catch (IOException e2) {}
            }
        }
        catch (Exception e) {
            Object stackTrace = "";
            Throwable t = e;
            while (t != null) {
                for (StackTraceElement ele : t.getStackTrace()) {
                    stackTrace = (String)stackTrace + "\n     At: " + ele;
                }
                if ((t = t.getCause()) == null) continue;
                stackTrace = (String)stackTrace + "\nCaused by: " + t;
            }
            System.out.println("[LAUNCHER] [SENTINEL LAUNCHER] Error occurred: " + e + (String)stackTrace);
            JOptionPane.showMessageDialog(this.frmSentinelLauncher, "An error occured while running the launcher.\nUnable to continue, the launcher will now close.\n\nError details: " + e + (String)stackTrace, "Launcher Error", 0);
            System.exit(1);
            return;
        }
        LauncherUtils.urlBaseDescriptorFile = urlBaseDescriptorFile;
        LauncherUtils.urlBaseSoftwareFile = urlBaseSoftwareFile;
        boolean dirModeDescriptorFileF = dirModeDescriptorFile;
        boolean dirModeSoftwareFileF = dirModeSoftwareFile;
        File gameDescriptorFileF = gameDescriptorFile;
        File emulationSoftwareFileF = emulationSoftwareFile;
        Thread th = new Thread(() -> {
            try {
                File launcherJsonF;
                JsonObject list3;
                String latest;
                String lst;
                LauncherUtils.log("Preparing launcher...", true);
                LauncherUtils.resetProgressBar();
                PayloadManager.deletePayloadsPendingRemoval();
                boolean updatedSoftware = false;
                boolean updatedDescriptor = false;
                String descriptorClsName = descriptorSourceClass;
                String softwareClsName = softwareSourceClass;
                if (!dirModeDescriptorFileF && gameDescriptor.containsKey("Update-List-URL") && gameDescriptor.containsKey("Game-Descriptor-Version")) {
                    block75: {
                        LauncherUtils.log("Checking for game descriptor updates...");
                        try {
                            String current;
                            lst = null;
                            try {
                                lst = this.downloadString((String)gameDescriptor.get("Update-List-URL"));
                            }
                            catch (IOException e) {
                                LauncherUtils.log("Could not download update list!");
                            }
                            if (lst == null || (latest = (list3 = JsonParser.parseString((String)lst).getAsJsonObject()).get("latest").getAsString()).equals(current = (String)gameDescriptor.get("Game-Descriptor-Version"))) break block75;
                            LauncherUtils.log("Updating game descriptor to " + latest + "...", true);
                            JsonObject versionData = list3.get("versions").getAsJsonObject().get(latest).getAsJsonObject();
                            String url = versionData.get("url").getAsString();
                            LauncherUtils.resetProgressBar();
                            LauncherUtils.downloadFile(url, new File("gamedescriptor.sgd.tmp"));
                            String remoteHash = versionData.get("hash").getAsString();
                            String localHash = LauncherUtils.sha256Hash(Files.readAllBytes(Path.of("gamedescriptor.sgd.tmp", new String[0])));
                            boolean hashSuccess = true;
                            if (!localHash.equals(remoteHash)) {
                                LauncherUtils.resetProgressBar();
                                LauncherUtils.downloadFile(url, new File("gamedescriptor.sgd.tmp"));
                                localHash = LauncherUtils.sha256Hash(Files.readAllBytes(Path.of("gamedescriptor.sgd.tmp", new String[0])));
                                if (!localHash.equals(remoteHash)) {
                                    new File("gamedescriptor.sgd.tmp").delete();
                                    if (JOptionPane.showConfirmDialog(this.frmSentinelLauncher, "Failed to verify the integrity of the downloaded game descriptor file, the update will not be applied!\n\nThe launcher will continue with version " + current + ", if you cancel, the launcher will be closed.", "Integrity check failure", 2, 0) == 2) {
                                        System.exit(1);
                                    }
                                    hashSuccess = false;
                                }
                            }
                            if (hashSuccess) {
                                block76: {
                                    LauncherUtils.resetProgressBar();
                                    LauncherUtils.hideProgressPanel();
                                    LauncherUtils.log("Verifying signature...", true);
                                    if (!LauncherUtils.verifyPackageSignature(new File("gamedescriptor.sgd.tmp"), new File("cache/keys/gamedescriptor-publickey.pem"))) {
                                        while (JOptionPane.showConfirmDialog(this.frmSentinelLauncher, "WARNING! Failed to verify package signature!\n\nFailed to verify the update of the game descriptor file!\nThe file that was downloaded may have been tampered with, proceed with caution!\n\nIt is recommended to contact the developers if possible and ask them if the keys have changed between versions " + current + " and " + latest + ".\n\nDo you wish to continue with the update? Selecting no will cancel the update.", "Warning", 0, 2) == 0) {
                                            if (JOptionPane.showConfirmDialog(this.frmSentinelLauncher, "Are you sure you want to ignore the file signature?", "Warning", 0, 2) != 0) continue;
                                            break block76;
                                        }
                                        hashSuccess = false;
                                    }
                                }
                                LauncherUtils.resetProgressBar();
                                LauncherUtils.showProgressPanel();
                            }
                            if (!hashSuccess) break block75;
                            new File(gameDescriptorFileF.getPath()).renameTo(new File("gamedescriptor.sgd.old"));
                            new File("gamedescriptor.sgd.tmp").renameTo(new File(gameDescriptorFileF.getPath()));
                            updatedDescriptor = true;
                            LauncherUtils.log("Extracting game descriptor...", true);
                            PayloadManager.discoverPayloads();
                            LauncherUtils.extractGameDescriptor(new File(gameDescriptorFileF.getPath()), latest);
                            PayloadManager.indexPayloads();
                            LauncherUtils.log("Reloading launcher...", true);
                            LauncherUtils.hideProgressPanel();
                            LauncherUtils.resetProgressBar();
                            LauncherUtils.log("Loading game descriptor information...");
                            gameDescriptor.clear();
                            gameDescriptor.putAll(LauncherUtils.parseProperties(this.getStringFrom(new File(gameDescriptorFileF.getPath()), "descriptorinfo")));
                            descriptorClsName = (String)gameDescriptor.get("Game-Descriptor-Class");
                            LauncherUtils.gameID = (String)gameDescriptor.get("Game-ID");
                            if (descriptorClsName == null) {
                                throw new IOException("No descriptor class defined in game descriptor");
                            }
                            if (LauncherUtils.gameID == null) {
                                throw new IOException("No game ID defined in game descriptor");
                            }
                            try {
                                InputStream strmi = this.getClass().getClassLoader().getResourceAsStream("icon.png");
                                this.frmSentinelLauncher.setIconImage(ImageIO.read(strmi));
                                strmi.close();
                            }
                            catch (Exception strmi) {
                                // empty catch block
                            }
                            try {
                                FileInputStream fIN = new FileInputStream(new File("icon.png"));
                                this.frmSentinelLauncher.setIconImage(ImageIO.read(fIN));
                                ((InputStream)fIN).close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            LauncherUtils.log("Updated game descriptor to " + latest + "!");
                        }
                        catch (Exception e) {
                            try {
                                if (updatedDescriptor) {
                                    updatedDescriptor = false;
                                    new File(gameDescriptorFileF.getPath()).delete();
                                    new File("gamedescriptor.sgd.old").renameTo(new File(gameDescriptorFileF.getPath()));
                                }
                                SwingUtilities.invokeAndWait(() -> {
                                    Object stackTrace = "";
                                    Throwable t = e;
                                    while (t != null) {
                                        for (StackTraceElement ele : t.getStackTrace()) {
                                            stackTrace = (String)stackTrace + "\n     At: " + ele;
                                        }
                                        if ((t = t.getCause()) == null) continue;
                                        stackTrace = (String)stackTrace + "\nCaused by: " + t;
                                    }
                                    System.out.println("[LAUNCHER] [SENTINEL LAUNCHER] Error occurred: " + e + (String)stackTrace);
                                    JOptionPane.showMessageDialog(this.frmSentinelLauncher, "An error occured while updating the game descriptor file.\n\nError details: " + e + (String)stackTrace + "\n\nThe update has been cancelled.", "Update Error", 0);
                                });
                            }
                            catch (InterruptedException | InvocationTargetException list2) {
                                // empty catch block
                            }
                        }
                    }
                    LauncherUtils.setStatus("Preparing launcher...");
                }
                if (!dirModeSoftwareFileF && softwareDescriptor.containsKey("Update-List-URL")) {
                    block77: {
                        LauncherUtils.log("Checking for software updates...");
                        try {
                            lst = null;
                            try {
                                lst = this.downloadString((String)softwareDescriptor.get("Update-List-URL"));
                            }
                            catch (IOException e) {
                                LauncherUtils.log("Could not download update list!");
                            }
                            if (lst == null || (latest = (list3 = JsonParser.parseString((String)lst).getAsJsonObject()).get("latest").getAsString()).equals(LauncherUtils.softwareVersion)) break block77;
                            LauncherUtils.log("Updating emulation software to " + latest + "...", true);
                            JsonObject versionData = list3.get("versions").getAsJsonObject().get(latest).getAsJsonObject();
                            String url = versionData.get("url").getAsString();
                            LauncherUtils.resetProgressBar();
                            LauncherUtils.downloadFile(url, new File("emulationsoftware.svp.tmp"));
                            String remoteHash = versionData.get("hash").getAsString();
                            String localHash = LauncherUtils.sha256Hash(Files.readAllBytes(Path.of("emulationsoftware.svp.tmp", new String[0])));
                            boolean hashSuccess = true;
                            if (!localHash.equals(remoteHash)) {
                                LauncherUtils.resetProgressBar();
                                LauncherUtils.downloadFile(url, new File("emulationsoftware.svp.tmp"));
                                localHash = LauncherUtils.sha256Hash(Files.readAllBytes(Path.of("emulationsoftware.svp.tmp", new String[0])));
                                if (!localHash.equals(remoteHash)) {
                                    new File("emulationsoftware.svp.tmp").delete();
                                    if (JOptionPane.showConfirmDialog(this.frmSentinelLauncher, "Failed to verify the integrity of the downloaded emulation software update, the update will not be applied!\n\nThe launcher will continue with version " + LauncherUtils.softwareVersion + ", if you cancel, the launcher will be closed.", "Integrity check failure", 2, 0) == 2) {
                                        System.exit(1);
                                    }
                                    hashSuccess = false;
                                }
                            }
                            if (hashSuccess) {
                                block78: {
                                    LauncherUtils.resetProgressBar();
                                    LauncherUtils.hideProgressPanel();
                                    LauncherUtils.log("Verifying signature...", true);
                                    if (!LauncherUtils.verifyPackageSignature(new File("emulationsoftware.svp.tmp"), new File("cache/keys/emulationsoftware-publickey.pem"))) {
                                        while (JOptionPane.showConfirmDialog(this.frmSentinelLauncher, "WARNING! Failed to verify package signature!\n\nFailed to verify the update of the emulation software package '" + LauncherUtils.softwareName + "'!\nThe file that was downloaded may have been tampered with, proceed with caution!\n\nIt is recommended to contact the developers if possible and ask them if the keys have changed between versions " + LauncherUtils.softwareVersion + " and " + latest + ".\n\nDo you wish to continue with the update? Selecting no will cancel the update.", "Warning", 0, 2) == 0) {
                                            if (JOptionPane.showConfirmDialog(this.frmSentinelLauncher, "Are you sure you want to ignore the file signature?", "Warning", 0, 2) != 0) continue;
                                            break block78;
                                        }
                                        hashSuccess = false;
                                    }
                                }
                                LauncherUtils.resetProgressBar();
                                LauncherUtils.showProgressPanel();
                            }
                            if (!hashSuccess) break block77;
                            new File(emulationSoftwareFileF.getPath()).renameTo(new File("emulationsoftware.svp.old"));
                            new File("emulationsoftware.svp.tmp").renameTo(new File(emulationSoftwareFileF.getPath()));
                            updatedSoftware = true;
                            LauncherUtils.log("Extracting emulation software..", true);
                            PayloadManager.discoverPayloads();
                            LauncherUtils.extractEmulationSoftware(new File(emulationSoftwareFileF.getPath()), latest);
                            PayloadManager.indexPayloads();
                            LauncherUtils.log("Reloading launcher...", true);
                            LauncherUtils.hideProgressPanel();
                            LauncherUtils.resetProgressBar();
                            softwareDescriptor.clear();
                            softwareDescriptor.putAll(LauncherUtils.parseProperties(this.getStringFrom(new File(emulationSoftwareFileF.getPath()), "softwareinfo")));
                            if (!softwareDescriptor.containsKey("Game-ID")) {
                                throw new IOException("No game ID defined in emulation software descriptor");
                            }
                            LauncherUtils.softwareName = (String)softwareDescriptor.get("Project-Name");
                            softwareClsName = (String)softwareDescriptor.get("Software-Class");
                            LauncherUtils.softwareVersion = (String)softwareDescriptor.get("Software-Version");
                            LauncherUtils.softwareID = (String)softwareDescriptor.get("Software-ID");
                            if (softwareClsName == null) {
                                throw new IOException("No software class defined in emulation software descriptor");
                            }
                            if (LauncherUtils.softwareID == null) {
                                throw new IOException("No software ID defined in emulation software descriptor");
                            }
                            if (LauncherUtils.softwareVersion == null) {
                                throw new IOException("No software version defined in emulation software descriptor");
                            }
                            if (LauncherUtils.softwareName == null) {
                                throw new IOException("No software name defined in emulation software descriptor");
                            }
                            if (!((String)softwareDescriptor.get("Game-ID")).equalsIgnoreCase(LauncherUtils.getGameID())) {
                                throw new IllegalArgumentException("Emulation software '" + LauncherUtils.softwareName + "' is incompatible with the current game.");
                            }
                            LauncherUtils.log(LauncherUtils.softwareName + " Launcher v" + LAUNCHER_VERSION);
                            LauncherUtils.log("Game ID: " + LauncherUtils.gameID);
                            LauncherUtils.log("Emulation software ID: " + LauncherUtils.softwareID);
                            LauncherUtils.log("Emulation software version: " + LauncherUtils.softwareVersion);
                            SwingUtilities.invokeAndWait(() -> {
                                this.frmSentinelLauncher.setTitle(LauncherUtils.softwareName + " Launcher");
                                lblNewLabel.setText(LauncherUtils.softwareName);
                                panelLabels.setVisible(false);
                                try {
                                    this.setPanelImageFrom(new File(emulationSoftwareFileF.getPath()), "banner.png", panel_1);
                                }
                                catch (IOException e) {
                                    try {
                                        this.setPanelImageFrom(new File(emulationSoftwareFileF.getPath()), "banner.jpg", panel_1);
                                    }
                                    catch (IOException e2) {
                                        try {
                                            this.setPanelImageFrom(new File(gameDescriptorFileF.getPath()), "banner.png", panel_1);
                                        }
                                        catch (IOException e3) {
                                            try {
                                                this.setPanelImageFrom(new File(gameDescriptorFileF.getPath()), "banner.jpg", panel_1);
                                            }
                                            catch (IOException e4) {
                                                panelLabels.setVisible(true);
                                            }
                                        }
                                    }
                                }
                                try {
                                    this.setIconFrom(emulationSoftwareFileF, "icon.png");
                                }
                                catch (IOException e) {
                                    try {
                                        this.setIconFrom(gameDescriptorFileF, "icon.png");
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                            });
                            try {
                                InputStream strmi = this.getClass().getClassLoader().getResourceAsStream("icon.png");
                                this.frmSentinelLauncher.setIconImage(ImageIO.read(strmi));
                                strmi.close();
                            }
                            catch (Exception strmi) {
                                // empty catch block
                            }
                            try {
                                FileInputStream fIN = new FileInputStream(new File("icon.png"));
                                this.frmSentinelLauncher.setIconImage(ImageIO.read(fIN));
                                ((InputStream)fIN).close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            LauncherUtils.log("Updated emulation software to " + latest + "!");
                        }
                        catch (Exception e) {
                            try {
                                if (updatedSoftware) {
                                    updatedSoftware = false;
                                    new File(emulationSoftwareFileF.getPath()).delete();
                                    new File("emulationsoftware.svp.old").renameTo(new File(emulationSoftwareFileF.getPath()));
                                }
                                SwingUtilities.invokeAndWait(() -> {
                                    Object stackTrace = "";
                                    Throwable t = e;
                                    while (t != null) {
                                        for (StackTraceElement ele : t.getStackTrace()) {
                                            stackTrace = (String)stackTrace + "\n     At: " + ele;
                                        }
                                        if ((t = t.getCause()) == null) continue;
                                        stackTrace = (String)stackTrace + "\nCaused by: " + t;
                                    }
                                    System.out.println("[LAUNCHER] [SENTINEL LAUNCHER] Error occurred: " + e + (String)stackTrace);
                                    JOptionPane.showMessageDialog(this.frmSentinelLauncher, "An error occured while updating emulation software.\n\nError details: " + e + (String)stackTrace + "\n\nThe update has been cancelled.", "Update Error", 0);
                                });
                            }
                            catch (InterruptedException | InvocationTargetException list3) {
                                // empty catch block
                            }
                        }
                    }
                    LauncherUtils.setStatus("Preparing launcher...");
                }
                if (overrodeSVP) {
                    updatedSoftware = true;
                }
                if (overrodeSGD) {
                    updatedDescriptor = true;
                }
                if (updatedDescriptor && !updatedSoftware && !dirModeSoftwareFileF) {
                    LauncherUtils.log("Re-extracting software...", true);
                    LauncherUtils.resetProgressBar();
                    LauncherUtils.showProgressPanel();
                    PayloadManager.discoverPayloads();
                    LauncherUtils.extractEmulationSoftware(emulationSoftwareFileF, LauncherUtils.softwareVersion);
                    PayloadManager.indexPayloads();
                    LauncherUtils.setStatus("Preparing launcher...");
                }
                if ((updatedDescriptor || updatedSoftware) && !new File("cache/payloadcache/requireupdate").exists() && new File("cache/payloadcache").exists()) {
                    new File("cache/payloadcache/requireupdate").createNewFile();
                }
                LauncherUtils.hideProgressPanel();
                LauncherUtils.resetProgressBar();
                LauncherUtils.addUrlToComponentClassLoader(new File(gameDescriptorFileF.getPath()).toURI().toURL());
                LauncherUtils.addUrlToComponentClassLoader(emulationSoftwareFileF.toURI().toURL());
                try {
                    LauncherUtils.log("Loading game descriptor class...");
                    Class<?> gameDescr = LauncherUtils.loader.loadClass(descriptorClsName);
                    if (!IGameDescriptor.class.isAssignableFrom(gameDescr)) {
                        throw new IllegalArgumentException(descriptorClsName + " does not implement " + IGameDescriptor.class.getTypeName());
                    }
                    Constructor<?> gdCt = gameDescr.getConstructor(new Class[0]);
                    LauncherUtils.gameDescriptor = (IGameDescriptor)gdCt.newInstance(new Object[0]);
                    LauncherUtils.gameDescriptor.init();
                    if (updatedDescriptor) {
                        new File("gamedescriptor.sgd.old").delete();
                        LauncherUtils.gameDescriptor.postUpdate();
                    }
                }
                catch (Exception e) {
                    if (updatedDescriptor) {
                        new File("gamedescriptor.sgd.old").renameTo(new File("newgamedescriptor.sgd"));
                    }
                    if (updatedSoftware) {
                        new File("emulationsoftware.svp.old").renameTo(new File("newemulationsoftware.svp"));
                    }
                    throw e;
                }
                try {
                    LauncherUtils.log("Loading emulation software provider class...");
                    Class<?> softProv = LauncherUtils.loader.loadClass(softwareClsName);
                    if (!IEmulationSoftwareProvider.class.isAssignableFrom(softProv)) {
                        throw new IllegalArgumentException(softwareClsName + " does not implement " + IEmulationSoftwareProvider.class.getTypeName());
                    }
                    Constructor<?> sfCt = softProv.getConstructor(new Class[0]);
                    LauncherUtils.emulationSoftware = (IEmulationSoftwareProvider)sfCt.newInstance(new Object[0]);
                    LauncherUtils.emulationSoftware.init();
                    if (updatedSoftware) {
                        new File("emulationsoftware.svp.old").delete();
                        LauncherUtils.emulationSoftware.postUpdate();
                    }
                }
                catch (Exception e) {
                    if (updatedSoftware) {
                        new File("emulationsoftware.svp.old").renameTo(new File("newemulationsoftware.svp"));
                    }
                    throw e;
                }
                if (!(System.getProperty("os.name").toLowerCase().contains("win") && !System.getProperty("os.name").toLowerCase().contains("darwin") || System.getProperty("os.name").toLowerCase().contains("darwin") || System.getProperty("os.name").toLowerCase().contains("mac") || System.getProperty("os.name").toLowerCase().contains("linux"))) {
                    JOptionPane.showMessageDialog(null, "Unsupported platform!\nThe launcher cannot load on your device, please contact support for more info.\n\nOS Name: " + System.getProperty("os.name"), "Launcher Error", 0);
                    System.exit(1);
                    return;
                }
                File shutdownConfirmed = new File("confirmedshutdown");
                if (!shutdownConfirmed.exists()) {
                    JOptionPane.showMessageDialog(this.frmSentinelLauncher, "Unfortunately the Edge project is being shut down, please note that after the 1st of May, our asset servers will not be supported anymore and can shut down at any moment.\n\nEdge is being shut down due to internal management problems, our management team had collapsed, we were left without a co-owner and our admin team had drastically\nshrunk, with lack of admins and moderators we decided that keeping the discord open was a recipe for disaster as it would likely have gone unmoderated.\nThe Edge servers are being shut down mostly because of money problems and our codebase was in shambles too, it was no longer doable unfortunately.\n\nWe recommend switching over to either SoDOff (https://discord.gg/6FK3rJcyKC) or Rider's Guild (https://discord.gg/qVZBYghHxB).\nFor more details, please go to our Discord server (which is now read-only): https://discord.gg/7daHe53ZAT\n\n\nPlease note that Edge HAS been designed with the potential situation of a shutdown in mind.\nThis means, once you have successfully launched Project Edge at least once after closing this message, YOU WILL ALWAYS BE ABLE TO PLAY THE GAME as long as your launcher remains intact.\nSupport for Project Edge remains until the 1st of May, if you have troubble, please go to our discord server: https://discord.gg/7daHe53ZAT\n\n\nWe thank you for the amazing journey we had, unfortunately it has come to an end. - Denzaya", "Project Edge is Shutting Down", 2);
                    shutdownConfirmed.createNewFile();
                }
                if ((launcherJsonF = new File("../launcher.json")).exists()) {
                    JsonObject launcherJson = null;
                    boolean needsToCutTies = false;
                    try {
                        launcherJson = JsonParser.parseString((String)Files.readString(launcherJsonF.toPath())).getAsJsonObject();
                        if (launcherJson.has("launcherUpdateListUrl") && !launcherJson.get("launcherUpdateListUrl").getAsString().isBlank()) {
                            needsToCutTies = true;
                        }
                    }
                    catch (Throwable url) {
                        // empty catch block
                    }
                    if (needsToCutTies) {
                        launcherJson.addProperty("launcherUpdateListUrl", "");
                        Files.writeString(launcherJsonF.toPath(), (CharSequence)new Gson().newBuilder().setPrettyPrinting().create().toJson((JsonElement)launcherJson), new OpenOption[0]);
                        JOptionPane.showMessageDialog(this.frmSentinelLauncher, "The launcher has successfully cut ties with the Project Edge content update servers.\n\nThis copy of Project Edge is now safe from destruction as the entire automatic update system has been destroyed.\nFrom now on, nobody can abuse the update system anymore to push out a destruction update, your copy will always remain functional.\n\nPlease do note that the connection with the Edge asset archive servers remains, however due to them only serving game files during initial download they cannot be used to terminate your copy of the game.\nThis also means that you will be able to add/remove custom archive servers even after edge fully shuts down.\n\nWe thank you for all the support you gave us over the months of Edge's life, fly safe and keep exploring!", "Successfully cut ties with servers", 1);
                    }
                }
                AssetManager.init(this, softwareDescriptor, gameDescriptor, dirModeDescriptorFileF, dirModeSoftwareFileF, gameDescriptorFileF, emulationSoftwareFileF);
                LauncherUtils.setStatus("Loading archive data...");
                AssetManager.initArchiveData();
                LauncherUtils.setStatus("Press shift for options... (5)");
                LauncherUtils.log("Checking for manual input...");
                for (int i = 0; i < 50; ++i) {
                    LauncherUtils.setStatus("Press shift for options... (" + (5 - i / 10) + ")");
                    if (this.shiftDown) {
                        LauncherUtils.log("Manual input received!", true);
                        LauncherUtils.emulationSoftware.showOptionWindow();
                        AssetManager.reloadArchives();
                        break;
                    }
                    Thread.sleep(100L);
                }
                LauncherUtils.setStatus("Checking for updates...");
                AssetManager.prepareStreamingArchiveConnection();
                AssetManager.verifyClients(false);
                AssetManager.verifyAssets();
                LauncherUtils.hideProgressPanel();
                LauncherUtils.resetProgressBar();
                LauncherUtils.setStatus("Checking for updates...");
                LauncherUtils.gameDescriptor.onPreloadPayloadManager();
                LauncherUtils.emulationSoftware.onPreloadPayloadManager();
                PayloadManager.checkForUpdates();
                LauncherUtils.log("Discovering payloads...");
                PayloadManager.discoverPayloads();
                PayloadManager.showPayloadManagementWindowIfNeeded();
                LauncherUtils.log("Loading payloads...", true);
                PayloadManager.initPayloads();
                LauncherUtils.gameDescriptor.onPostloadPayloadManager();
                LauncherUtils.emulationSoftware.onPostloadPayloadManager();
                PayloadManager.postInitPayloads();
                LauncherUtils.log("Preparing to start the game...", true);
                JsonObject lastClient = new JsonObject();
                if (!new File("lastclient.json").exists() && !AssetManager.showClientSelector(true)) {
                    System.exit(0);
                }
                lastClient = JsonParser.parseString((String)Files.readString(Path.of("lastclient.json", new String[0]))).getAsJsonObject();
                String lastVersion = lastClient.get("version").getAsString();
                File modificationDir = new File("assetmodifications");
                File clientDir = new File("clients/client-" + lastVersion);
                ActiveArchiveInformation archive = AssetManager.getActiveArchive();
                modificationDir.mkdirs();
                if (archive.streamingModeEnabled && !archive.streamingModeOverriddenDisable) {
                    LauncherUtils.gameDescriptor.prepareLaunchWithStreamingAssets(archive.source, AssetManager.collectAssets(), AssetManager.getActiveArchive().getAllAssets(), modificationDir, archive, archive.archiveDef, archive.descriptorDef, lastVersion, clientDir, () -> LauncherUtils.emulationSoftware.prepareLaunchWithStreamingAssets(archive.source, AssetManager.collectAssets(), AssetManager.getActiveArchive().getAllAssets(), modificationDir, archive, archive.archiveDef, archive.descriptorDef, lastVersion, clientDir, () -> {
                        int i = 0;
                        String[] payloads = PayloadManager.getLoadedPayloadIds();
                        this.callPrepareWithStreamingForPayload(payloads, i, archive.source, AssetManager.collectAssets(), AssetManager.getActiveArchive().getAllAssets(), modificationDir, archive, archive.archiveDef, archive.descriptorDef, lastVersion, clientDir, () -> {
                            LauncherUtils.log("Launching game...", true);
                            LauncherUtils.emulationSoftware.onGameStarting(lastVersion, clientDir);
                            for (String pl : PayloadManager.getLoadedPayloadIds()) {
                                ISentinelPayload p = PayloadManager.getPayload(pl);
                                if (p == null) continue;
                                p.onGameStarting(lastVersion, clientDir);
                            }
                            LauncherUtils.gameDescriptor.startGameWithStreamingAssets(archive.source, AssetManager.collectAssets(), AssetManager.getActiveArchive().getAllAssets(), modificationDir, archive, archive.archiveDef, archive.descriptorDef, lastVersion, clientDir, () -> {
                                LauncherUtils.log("Launch success!", true);
                                this.frmSentinelLauncher.setVisible(false);
                                LauncherUtils.emulationSoftware.onGameLaunchSuccess(lastVersion, clientDir);
                                for (String pl : PayloadManager.getLoadedPayloadIds()) {
                                    ISentinelPayload p = PayloadManager.getPayload(pl);
                                    if (p == null) continue;
                                    p.onGameLaunchSuccess(lastVersion, clientDir);
                                }
                            }, () -> {
                                LauncherUtils.log("Game exited.", true);
                                LauncherUtils.emulationSoftware.onGameExit(lastVersion, clientDir);
                                for (String pl : PayloadManager.getLoadedPayloadIds()) {
                                    ISentinelPayload p = PayloadManager.getPayload(pl);
                                    if (p == null) continue;
                                    p.onGameExit(lastVersion, clientDir);
                                }
                                System.exit(0);
                            }, error -> this.launchGameError((String)error));
                        }, error -> this.launchGameError((String)error));
                    }, error -> this.launchGameError((String)error)), error -> this.launchGameError((String)error));
                } else {
                    LauncherUtils.gameDescriptor.prepareLaunchWithLocalAssets(AssetManager.collectAssets(), AssetManager.getActiveArchive().getAllAssets(), modificationDir, archive, archive.archiveDef, archive.descriptorDef, lastVersion, clientDir, () -> LauncherUtils.emulationSoftware.prepareLaunchWithLocalAssets(AssetManager.collectAssets(), AssetManager.getActiveArchive().getAllAssets(), modificationDir, archive, archive.archiveDef, archive.descriptorDef, lastVersion, clientDir, () -> {
                        int i = 0;
                        String[] payloads = PayloadManager.getLoadedPayloadIds();
                        this.callPrepareWithLocalForPayload(payloads, i, AssetManager.collectAssets(), AssetManager.getActiveArchive().getAllAssets(), modificationDir, archive, archive.archiveDef, archive.descriptorDef, lastVersion, clientDir, () -> {
                            LauncherUtils.log("Launching game...", true);
                            LauncherUtils.emulationSoftware.onGameStarting(lastVersion, clientDir);
                            for (String pl : PayloadManager.getLoadedPayloadIds()) {
                                ISentinelPayload p = PayloadManager.getPayload(pl);
                                if (p == null) continue;
                                p.onGameStarting(lastVersion, clientDir);
                            }
                            LauncherUtils.gameDescriptor.startGameWithLocalAssets(AssetManager.collectAssets(), AssetManager.getActiveArchive().getAllAssets(), modificationDir, archive, archive.archiveDef, archive.descriptorDef, lastVersion, clientDir, () -> {
                                LauncherUtils.log("Launch success!", true);
                                this.frmSentinelLauncher.setVisible(false);
                                LauncherUtils.emulationSoftware.onGameLaunchSuccess(lastVersion, clientDir);
                                for (String pl : PayloadManager.getLoadedPayloadIds()) {
                                    ISentinelPayload p = PayloadManager.getPayload(pl);
                                    if (p == null) continue;
                                    p.onGameLaunchSuccess(lastVersion, clientDir);
                                }
                            }, () -> {
                                LauncherUtils.log("Game exited.", true);
                                LauncherUtils.emulationSoftware.onGameExit(lastVersion, clientDir);
                                for (String pl : PayloadManager.getLoadedPayloadIds()) {
                                    ISentinelPayload p = PayloadManager.getPayload(pl);
                                    if (p == null) continue;
                                    p.onGameExit(lastVersion, clientDir);
                                }
                                System.exit(0);
                            }, error -> this.launchGameError((String)error));
                        }, error -> this.launchGameError((String)error));
                    }, error -> this.launchGameError((String)error)), error -> this.launchGameError((String)error));
                }
            }
            catch (Exception e) {
                try {
                    SwingUtilities.invokeAndWait(() -> {
                        Object stackTrace = "";
                        Throwable t = e;
                        while (t != null) {
                            for (StackTraceElement ele : t.getStackTrace()) {
                                stackTrace = (String)stackTrace + "\n     At: " + ele;
                            }
                            if ((t = t.getCause()) == null) continue;
                            stackTrace = (String)stackTrace + "\nCaused by: " + t;
                        }
                        System.out.println("[LAUNCHER] [SENTINEL LAUNCHER] Error occurred: " + e + (String)stackTrace);
                        JOptionPane.showMessageDialog(this.frmSentinelLauncher, "An error occured while running the launcher.\nUnable to continue, the launcher will now close.\n\nError details: " + e + (String)stackTrace, "Launcher Error", 0);
                        System.exit(1);
                    });
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
        }, "Launcher Thread");
        th.setDaemon(true);
        th.start();
    }

    private void callPrepareWithStreamingForPayload(String[] payloads, int index, String assetArchiveURL, AssetInformation[] collectedAssets, AssetInformation[] allAssets, File assetModifications, ActiveArchiveInformation archive, JsonObject archiveDef, JsonObject descriptorDef, String clientVersion, File clientDir, Runnable successCallback, Consumer<String> errorCallback) {
        if (index < payloads.length) {
            ISentinelPayload p = PayloadManager.getPayload(payloads[index]);
            if (p != null) {
                p.prepareLaunchWithStreamingAssets(assetArchiveURL, collectedAssets, allAssets, assetModifications, archive, archiveDef, descriptorDef, clientVersion, clientDir, () -> this.callPrepareWithStreamingForPayload(payloads, index + 1, assetArchiveURL, collectedAssets, allAssets, assetModifications, archive, archiveDef, descriptorDef, clientVersion, clientDir, successCallback, errorCallback), error -> this.launchGameError((String)error));
            } else {
                this.callPrepareWithStreamingForPayload(payloads, index + 1, assetArchiveURL, collectedAssets, allAssets, assetModifications, archive, archiveDef, descriptorDef, clientVersion, clientDir, successCallback, errorCallback);
            }
        } else {
            successCallback.run();
        }
    }

    private void callPrepareWithLocalForPayload(String[] payloads, int index, AssetInformation[] collectedAssets, AssetInformation[] allAssets, File assetModifications, ActiveArchiveInformation archive, JsonObject archiveDef, JsonObject descriptorDef, String clientVersion, File clientDir, Runnable successCallback, Consumer<String> errorCallback) {
        if (index < payloads.length) {
            ISentinelPayload p = PayloadManager.getPayload(payloads[index]);
            if (p != null) {
                p.prepareLaunchWithLocalAssets(collectedAssets, allAssets, assetModifications, archive, archiveDef, descriptorDef, clientVersion, clientDir, () -> this.callPrepareWithLocalForPayload(payloads, index + 1, collectedAssets, allAssets, assetModifications, archive, archiveDef, descriptorDef, clientVersion, clientDir, successCallback, errorCallback), error -> this.launchGameError((String)error));
            } else {
                this.callPrepareWithLocalForPayload(payloads, index + 1, collectedAssets, allAssets, assetModifications, archive, archiveDef, descriptorDef, clientVersion, clientDir, successCallback, errorCallback);
            }
        } else {
            successCallback.run();
        }
    }

    private void launchGameError(String error) {
        LauncherUtils.setStatus("Error occurred!");
        System.out.println("[LAUNCHER] [SENTINEL LAUNCHER] Error occurred: " + error);
        JOptionPane.showMessageDialog(this.frmSentinelLauncher, "An error occured while preparing to start the game.\n\n" + error + "\n\nUnable to continue, the launcher will now close.", "Launcher Error", 0);
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPanelImageFrom(File file, String entry, BackgroundPanel panel) throws IOException {
        if (file.isDirectory()) {
            FileInputStream strm = new FileInputStream(new File(file, entry));
            BufferedImage img = ImageIO.read(strm);
            panel.setImage(img);
            strm.close();
            return;
        }
        try (ZipFile f = new ZipFile(file);){
            ZipEntry ent = f.getEntry(entry);
            if (ent == null) {
                throw new FileNotFoundException("Entry " + entry + " not found in " + file);
            }
            InputStream strm = f.getInputStream(ent);
            BufferedImage img = ImageIO.read(strm);
            panel.setImage(img);
            strm.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIconFrom(File file, String entry) throws IOException {
        if (file.isDirectory()) {
            FileInputStream strm = new FileInputStream(new File(file, entry));
            BufferedImage img = ImageIO.read(strm);
            this.frmSentinelLauncher.setIconImage(img);
            strm.close();
            return;
        }
        try (ZipFile f = new ZipFile(file);){
            ZipEntry ent = f.getEntry(entry);
            if (ent == null) {
                throw new FileNotFoundException("Entry " + entry + " not found in " + file);
            }
            InputStream strm = f.getInputStream(ent);
            BufferedImage img = ImageIO.read(strm);
            this.frmSentinelLauncher.setIconImage(img);
            strm.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStringFrom(File file, String entry) throws IOException {
        if (file.isDirectory()) {
            FileInputStream strm = new FileInputStream(new File(file, entry));
            String res = new String(strm.readAllBytes(), "UTF-8");
            strm.close();
            return res;
        }
        try (ZipFile f = new ZipFile(file);){
            ZipEntry ent = f.getEntry(entry);
            if (ent == null) {
                throw new FileNotFoundException("Entry " + entry + " not found in " + file);
            }
            InputStream strm = f.getInputStream(ent);
            String res = new String(strm.readAllBytes(), "UTF-8");
            strm.close();
            String string = res;
            return string;
        }
    }

    private String downloadString(String url) throws IOException {
        URLConnection conn = new URL(url).openConnection();
        InputStream strm = conn.getInputStream();
        String data = new String(strm.readAllBytes(), "UTF-8");
        strm.close();
        return data;
    }
}

