/*
 * Decompiled with CFR 0.152.
 */
package org.asf.razorwhip.sentinel.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.asf.razorwhip.sentinel.launcher.BackgroundPanel;
import org.asf.razorwhip.sentinel.launcher.DynamicClassLoader;
import org.asf.razorwhip.sentinel.launcher.LauncherMain;
import org.asf.razorwhip.sentinel.launcher.api.IEmulationSoftwareProvider;
import org.asf.razorwhip.sentinel.launcher.api.IGameDescriptor;
import org.asf.razorwhip.sentinel.launcher.api.ObjectTag;

public class LauncherUtils {
    static String[] args;
    static BackgroundPanel panel;
    static JPanel progressPanel;
    static JProgressBar progressBar;
    static JLabel statusLabel;
    static DynamicClassLoader loader;
    static String gameID;
    static String softwareID;
    static String softwareVersion;
    static String softwareName;
    static LauncherMain launcherWindow;
    static IGameDescriptor gameDescriptor;
    static IEmulationSoftwareProvider emulationSoftware;
    public static String urlBaseSoftwareFile;
    public static String urlBaseDescriptorFile;
    private static HashMap<String, ObjectTag> tags;
    private static final char[] HEX_ARRAY;

    static void addUrlToComponentClassLoader(URL url) {
        loader.addUrl(url);
    }

    public static JFrame getLauncherWindow() {
        return LauncherUtils.launcherWindow.frmSentinelLauncher;
    }

    public static ObjectTag addTag(String name) {
        ObjectTag tag = LauncherUtils.getTag(name);
        if (tag != null) {
            return tag;
        }
        tag = new ObjectTag();
        tags.put(name.toLowerCase(), tag);
        return tag;
    }

    public static ObjectTag getTag(String name) {
        return tags.get(name.toLowerCase());
    }

    public static ObjectTag removeTag(String name) {
        return tags.remove(name.toLowerCase());
    }

    public static boolean hasTag(String name) {
        return tags.containsKey(name.toLowerCase());
    }

    public static String[] getProgramArguments() {
        return args;
    }

    public static IGameDescriptor getGameDescriptor() {
        return gameDescriptor;
    }

    public static String getGameID() {
        return gameID;
    }

    public static String getSoftwareID() {
        return softwareID;
    }

    public static String getSoftwareVersion() {
        return softwareVersion;
    }

    public static String getSoftwareName() {
        return softwareName;
    }

    public static IEmulationSoftwareProvider getEmulationSoftware() {
        return emulationSoftware;
    }

    public static void showProgressPanel() {
        if (progressPanel == null) {
            return;
        }
        try {
            SwingUtilities.invokeAndWait(() -> {
                progressPanel.setVisible(true);
                progressPanel.repaint();
                panel.repaint();
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    public static boolean isProgressPanelVisible() {
        if (progressPanel == null) {
            return false;
        }
        return progressPanel.isVisible();
    }

    public static void hideProgressPanel() {
        if (progressPanel == null) {
            return;
        }
        try {
            SwingUtilities.invokeAndWait(() -> {
                progressPanel.setVisible(false);
                panel.repaint();
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    public static void resetProgressBar() {
        if (progressBar == null) {
            return;
        }
        try {
            SwingUtilities.invokeAndWait(() -> {
                progressBar.setMaximum(100);
                progressBar.setValue(0);
                progressBar.repaint();
                progressPanel.repaint();
                panel.repaint();
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    public static void setProgress(int value, int max) {
        if (progressBar == null) {
            return;
        }
        try {
            SwingUtilities.invokeAndWait(() -> {
                progressBar.setMaximum(max);
                progressBar.setValue(value);
                progressBar.repaint();
                progressPanel.repaint();
                panel.repaint();
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    public static void setProgress(int value) {
        if (progressBar == null) {
            return;
        }
        try {
            SwingUtilities.invokeAndWait(() -> {
                progressBar.setValue(value);
                progressBar.repaint();
                progressPanel.repaint();
                panel.repaint();
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    public static int getProgress() {
        return progressBar.getValue();
    }

    public static int getProgressMax() {
        return progressBar.getMaximum();
    }

    public static void increaseProgress(int value) {
        if (progressBar == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            if (progressBar.getValue() + value > progressBar.getMaximum()) {
                progressBar.setValue(progressBar.getMaximum());
            } else {
                progressBar.setValue(progressBar.getValue() + value);
            }
            progressBar.repaint();
            progressPanel.repaint();
            panel.repaint();
        });
    }

    public static void increaseProgress() {
        if (progressBar == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            if (progressBar.getValue() + 1 > progressBar.getMaximum()) {
                progressBar.setValue(progressBar.getMaximum());
            } else {
                progressBar.setValue(progressBar.getValue() + 1);
            }
            progressBar.repaint();
            progressPanel.repaint();
            panel.repaint();
        });
    }

    public static void setProgressMax(int max) {
        if (progressBar == null) {
            return;
        }
        try {
            SwingUtilities.invokeAndWait(() -> {
                progressBar.setMaximum(max);
                progressBar.repaint();
                progressPanel.repaint();
                panel.repaint();
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    public static void log(String message, boolean statusUpdate) {
        try {
            if (statusLabel != null) {
                SwingUtilities.invokeAndWait(() -> {
                    if (statusUpdate) {
                        statusLabel.setText(" " + message);
                        panel.repaint();
                    }
                });
            }
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
        System.out.println("[LAUNCHER] [SENTINEL LAUNCHER] " + message);
    }

    public static void log(String message) {
        System.out.println("[LAUNCHER] [SENTINEL LAUNCHER] " + message);
    }

    public static String getStatusMessage() {
        if (statusLabel == null) {
            return null;
        }
        return statusLabel.getText();
    }

    public static void setStatus(String message) {
        try {
            if (statusLabel != null) {
                SwingUtilities.invokeAndWait(() -> {
                    statusLabel.setText(" " + message);
                    panel.repaint();
                });
            }
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    public static Map<String, String> parseProperties(String props) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String line : props.replace("\r", "").split("\n")) {
            if (line.isEmpty() || line.startsWith("#") || !line.contains(": ")) continue;
            String key = line;
            String value = "";
            if (key.contains(": ")) {
                value = key.substring(key.indexOf(": ") + 2);
                key = key.substring(0, key.indexOf(": "));
            }
            properties.put(key, value);
        }
        return properties;
    }

    public static String downloadString(String url) throws IOException {
        URLConnection conn = new URL(url).openConnection();
        InputStream strm = conn.getInputStream();
        String data = new String(strm.readAllBytes(), "UTF-8");
        strm.close();
        return data;
    }

    private static int indexDir(File dir) {
        int i = 0;
        if (Files.isSymbolicLink(dir.toPath())) {
            return 1;
        }
        for (File subDir : dir.listFiles(t -> t.isDirectory())) {
            i += LauncherUtils.indexDir(subDir) + 1;
        }
        File[] listFiles = dir.listFiles(t -> !t.isDirectory());
        for (int j = 0; j < listFiles.length; ++j) {
            ++i;
        }
        return i;
    }

    public static void deleteDir(File dir) {
        if (!dir.exists()) {
            return;
        }
        if (Files.isSymbolicLink(dir.toPath())) {
            dir.delete();
            return;
        }
        for (File subDir : dir.listFiles(t -> t.isDirectory())) {
            LauncherUtils.deleteDir(subDir);
        }
        for (File file : dir.listFiles(t -> !t.isDirectory())) {
            file.delete();
        }
        dir.delete();
    }

    public static void copyDirWithProgress(File source, File destination) throws IOException {
        if (!source.exists()) {
            return;
        }
        LauncherUtils.setProgress(0, LauncherUtils.indexDir(source));
        LauncherUtils.showProgressPanel();
        LauncherUtils.copyDirWithProgressI(source, destination);
    }

    private static void copyDirWithProgressI(File source, File destination) throws IOException {
        if (!source.exists()) {
            return;
        }
        destination.mkdirs();
        for (File subDir : source.listFiles(t -> t.isDirectory())) {
            LauncherUtils.copyDirWithProgressI(subDir, new File(destination, subDir.getName()));
            LauncherUtils.increaseProgress();
        }
        for (File file : source.listFiles(t -> !t.isDirectory())) {
            Files.copy(file.toPath(), new File(destination, file.getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
            LauncherUtils.increaseProgress();
        }
    }

    public static void copyDirWithoutProgress(File source, File destination) throws IOException {
        if (!source.exists()) {
            return;
        }
        destination.mkdirs();
        for (File subDir : source.listFiles(t -> t.isDirectory())) {
            LauncherUtils.copyDirWithoutProgress(subDir, new File(destination, subDir.getName()));
        }
        for (File file : source.listFiles(t -> !t.isDirectory())) {
            Files.copy(file.toPath(), new File(destination, file.getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static void downloadFile(String url, File outp) throws IOException {
        byte[] b;
        LauncherUtils.resetProgressBar();
        LauncherUtils.showProgressPanel();
        URLConnection urlConnection = new URL(url).openConnection();
        try {
            int l = urlConnection.getContentLength();
            if (progressBar != null) {
                SwingUtilities.invokeAndWait(() -> {
                    progressBar.setMaximum(l < 1000 ? 1 : l / 1000);
                    progressBar.setValue(0);
                    progressBar.repaint();
                    progressPanel.repaint();
                    panel.repaint();
                });
            }
        }
        catch (InterruptedException | InvocationTargetException l) {
            // empty catch block
        }
        InputStream data = urlConnection.getInputStream();
        FileOutputStream out = new FileOutputStream(outp);
        while ((b = data.readNBytes(1000)).length != 0) {
            out.write(b);
            if (progressBar == null) continue;
            SwingUtilities.invokeLater(() -> {
                progressBar.setValue(progressBar.getValue() + 1);
                progressBar.repaint();
                progressPanel.repaint();
                panel.repaint();
            });
        }
        out.close();
        data.close();
        try {
            if (progressBar != null) {
                SwingUtilities.invokeAndWait(() -> {
                    progressBar.setValue(progressBar.getMaximum());
                    progressBar.repaint();
                    progressPanel.repaint();
                    panel.repaint();
                });
            }
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    public static void unZip(File input, File output) throws IOException {
        ZipEntry ent;
        LauncherUtils.resetProgressBar();
        LauncherUtils.showProgressPanel();
        output.mkdirs();
        ZipFile archive = new ZipFile(input);
        int count = 0;
        Enumeration<? extends ZipEntry> en = archive.entries();
        while (en.hasMoreElements()) {
            en.nextElement();
            ++count;
        }
        archive.close();
        archive = new ZipFile(input);
        en = archive.entries();
        try {
            int fcount = count;
            if (progressBar != null) {
                SwingUtilities.invokeAndWait(() -> {
                    progressBar.setMaximum(fcount);
                    progressBar.setValue(0);
                    progressBar.repaint();
                    progressPanel.repaint();
                    panel.repaint();
                });
            }
        }
        catch (InterruptedException | InvocationTargetException fcount) {
            // empty catch block
        }
        while (en.hasMoreElements() && (ent = en.nextElement()) != null) {
            if (ent.isDirectory()) {
                new File(output, ent.getName()).mkdirs();
            } else {
                File out = new File(output, ent.getName());
                if (out.getParentFile() != null && !out.getParentFile().exists()) {
                    out.getParentFile().mkdirs();
                }
                FileOutputStream os = new FileOutputStream(out);
                InputStream is = archive.getInputStream(ent);
                is.transferTo(os);
                is.close();
                os.close();
            }
            if (progressBar == null) continue;
            SwingUtilities.invokeLater(() -> {
                progressBar.setValue(progressBar.getValue() + 1);
                progressBar.repaint();
                progressPanel.repaint();
                panel.repaint();
            });
        }
        try {
            if (progressBar != null) {
                SwingUtilities.invokeAndWait(() -> {
                    progressBar.setValue(progressBar.getMaximum());
                    progressBar.repaint();
                    progressPanel.repaint();
                    panel.repaint();
                });
            }
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
        archive.close();
    }

    public static void unTarGz(File input, File output) throws IOException {
        ArchiveEntry ent;
        output.mkdirs();
        FileInputStream file = new FileInputStream(input);
        GZIPInputStream gzip = new GZIPInputStream(file);
        TarArchiveInputStream tar = new TarArchiveInputStream((InputStream)gzip);
        int count = 0;
        while (tar.getNextEntry() != null) {
            ++count;
        }
        tar.close();
        gzip.close();
        ((InputStream)file).close();
        file = new FileInputStream(input);
        gzip = new GZIPInputStream(file);
        tar = new TarArchiveInputStream((InputStream)gzip);
        try {
            int fcount = count;
            if (progressBar != null) {
                SwingUtilities.invokeAndWait(() -> {
                    progressBar.setMaximum(fcount);
                    progressBar.setValue(0);
                    progressBar.repaint();
                    progressPanel.repaint();
                    panel.repaint();
                });
            }
        }
        catch (InterruptedException | InvocationTargetException fcount) {
            // empty catch block
        }
        while ((ent = tar.getNextEntry()) != null) {
            if (ent.isDirectory()) {
                new File(output, ent.getName()).mkdirs();
            } else {
                File out = new File(output, ent.getName());
                if (out.getParentFile() != null && !out.getParentFile().exists()) {
                    out.getParentFile().mkdirs();
                }
                FileOutputStream os = new FileOutputStream(out);
                TarArchiveInputStream is = tar;
                is.transferTo(os);
                os.close();
            }
            if (progressBar == null) continue;
            SwingUtilities.invokeLater(() -> {
                progressBar.setValue(progressBar.getValue() + 1);
                progressBar.repaint();
                progressPanel.repaint();
                panel.repaint();
            });
        }
        try {
            if (progressBar != null) {
                SwingUtilities.invokeAndWait(() -> {
                    progressBar.setValue(progressBar.getMaximum());
                    progressBar.repaint();
                    progressPanel.repaint();
                    panel.repaint();
                });
            }
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
        tar.close();
        gzip.close();
        ((InputStream)file).close();
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String sha256Hash(byte[] data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(data);
            return LauncherUtils.bytesToHex(hash).toLowerCase();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String sha512Hash(byte[] data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-512");
            byte[] hash = digest.digest(data);
            return LauncherUtils.bytesToHex(hash).toLowerCase();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isPackageSigned(File packageFile) throws IOException {
        ZipFile zip = new ZipFile(packageFile);
        boolean signed = zip.getEntry("SENTINEL.PACKAGESIGNATURE.SIG") != null;
        zip.close();
        return signed;
    }

    public static void extractPackagePublicKey(File packageFile, File publicKeyOutputFile) throws IOException {
        ZipFile zip = new ZipFile(packageFile);
        ZipEntry keyEntry = zip.getEntry("SENTINEL.PACKAGEKEY.PEM");
        if (keyEntry == null) {
            zip.close();
            throw new IOException("Package does not have a key");
        }
        InputStream strm = zip.getInputStream(keyEntry);
        if (publicKeyOutputFile.getParentFile() != null) {
            publicKeyOutputFile.getParentFile().mkdirs();
        }
        FileOutputStream fOut = new FileOutputStream(publicKeyOutputFile);
        strm.transferTo(fOut);
        fOut.close();
        strm.close();
        zip.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifyPackageSignature(File packageFile, File publicKeyFile) throws IOException {
        boolean hasSignature;
        ZipFile zip = new ZipFile(packageFile);
        ZipEntry sigEntry = zip.getEntry("SENTINEL.PACKAGESIGNATURE.SIG");
        boolean bl = hasSignature = sigEntry != null;
        if (!hasSignature) {
            zip.close();
            return !publicKeyFile.exists();
        }
        InputStream strm = zip.getInputStream(sigEntry);
        byte[] sig = strm.readAllBytes();
        strm.close();
        if (!publicKeyFile.exists()) {
            ZipEntry keyEntry = zip.getEntry("SENTINEL.PACKAGEKEY.PEM");
            if (keyEntry == null) {
                zip.close();
                return false;
            }
            strm = zip.getInputStream(keyEntry);
            if (publicKeyFile.getParentFile() != null) {
                publicKeyFile.getParentFile().mkdirs();
            }
            FileOutputStream fOut = new FileOutputStream(publicKeyFile);
            strm.transferTo(fOut);
            fOut.close();
            strm.close();
        }
        byte[] key = LauncherUtils.pemDecode(Files.readString(publicKeyFile.toPath()));
        File zipTemp = new File(packageFile.getPath() + ".vtp");
        try {
            FileOutputStream fO = new FileOutputStream(zipTemp);
            ZipOutputStream zO = new ZipOutputStream(fO);
            try {
                FileInputStream fIn = new FileInputStream(packageFile);
                ZipInputStream zIn = new ZipInputStream(fIn);
                try {
                    ZipEntry entry = zIn.getNextEntry();
                    while (entry != null) {
                        if (entry.getName().equals("SENTINEL.PACKAGESIGNATURE.SIG")) {
                            entry = zIn.getNextEntry();
                            continue;
                        }
                        zO.putNextEntry(entry);
                        if (!entry.getName().replace("\\", "/").endsWith("/")) {
                            zIn.transferTo(zO);
                        }
                        zO.closeEntry();
                        entry = zIn.getNextEntry();
                    }
                    zip.close();
                }
                finally {
                    zIn.close();
                    fIn.close();
                }
            }
            finally {
                zO.close();
                fO.close();
            }
            try {
                byte[] data;
                int i;
                KeyFactory fac = KeyFactory.getInstance("RSA");
                PublicKey publicKey = fac.generatePublic(new X509EncodedKeySpec(key));
                Signature s = Signature.getInstance("Sha512WithRSA");
                s.initVerify(publicKey);
                FileInputStream fIn = new FileInputStream(zipTemp);
                while ((i = fIn.read(data = new byte[20480])) > 0) {
                    s.update(data, 0, i);
                }
                fIn.close();
                boolean bl2 = s.verify(sig);
                return bl2;
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
                throw new IOException("Signature verification error", e);
            }
        }
        finally {
            zipTemp.delete();
        }
    }

    public static boolean verifyVersionRequirement(String version, String versionCheck) {
        for (String filter : versionCheck.split("\\|\\|")) {
            if (!LauncherUtils.verifyVersionRequirementPart(version, filter = filter.trim())) continue;
            return true;
        }
        return false;
    }

    private static boolean verifyVersionRequirementPart(String version, String versionCheck) {
        block0: for (String filter : versionCheck.split("&")) {
            int i2;
            int val;
            int i;
            int[] valuesVersionCheck;
            int[] valuesVersionCurrent;
            if ((filter = filter.trim()).startsWith("!=")) {
                if (!version.equals(filter.substring(2))) continue;
                return false;
            }
            if (filter.startsWith("==")) {
                if (version.equals(filter.substring(2))) continue;
                return false;
            }
            if (filter.startsWith(">=")) {
                valuesVersionCurrent = LauncherUtils.parseVersionValues(version);
                valuesVersionCheck = LauncherUtils.parseVersionValues(filter.substring(2));
                for (i = 0; i < valuesVersionCheck.length; ++i) {
                    val = valuesVersionCheck[i];
                    if (i > valuesVersionCurrent.length) continue block0;
                    i2 = 0;
                    if (i < valuesVersionCurrent.length) {
                        i2 = valuesVersionCurrent[i];
                    }
                    if (i2 >= val) continue;
                    return false;
                }
                continue;
            }
            if (filter.startsWith("<=")) {
                valuesVersionCurrent = LauncherUtils.parseVersionValues(version);
                valuesVersionCheck = LauncherUtils.parseVersionValues(filter.substring(2));
                for (i = 0; i < valuesVersionCheck.length; ++i) {
                    val = valuesVersionCheck[i];
                    if (i > valuesVersionCurrent.length) continue block0;
                    i2 = 0;
                    if (i < valuesVersionCurrent.length) {
                        i2 = valuesVersionCurrent[i];
                    }
                    if (i2 <= val) continue;
                    return false;
                }
                continue;
            }
            if (filter.startsWith(">")) {
                valuesVersionCurrent = LauncherUtils.parseVersionValues(version);
                valuesVersionCheck = LauncherUtils.parseVersionValues(filter.substring(1));
                for (i = 0; i < valuesVersionCheck.length; ++i) {
                    val = valuesVersionCheck[i];
                    if (i > valuesVersionCurrent.length) continue block0;
                    i2 = 0;
                    if (i < valuesVersionCurrent.length) {
                        i2 = valuesVersionCurrent[i];
                    }
                    if (i2 > val) continue;
                    return false;
                }
                continue;
            }
            if (filter.startsWith("<")) {
                valuesVersionCurrent = LauncherUtils.parseVersionValues(version);
                valuesVersionCheck = LauncherUtils.parseVersionValues(filter.substring(1));
                for (i = 0; i < valuesVersionCheck.length; ++i) {
                    val = valuesVersionCheck[i];
                    if (i > valuesVersionCurrent.length) continue block0;
                    i2 = 0;
                    if (i < valuesVersionCurrent.length) {
                        i2 = valuesVersionCurrent[i];
                    }
                    if (i2 < val) continue;
                    return false;
                }
                continue;
            }
            if (version.equals(filter)) continue;
            return false;
        }
        return true;
    }

    private static int[] parseVersionValues(String version) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        Object buffer = "";
        for (char ch : version.toCharArray()) {
            if (ch == '-' || ch == '.') {
                if (!((String)buffer).isEmpty()) {
                    if (((String)buffer).matches("^[0-9]+$")) {
                        try {
                            values.add(Integer.parseInt((String)buffer));
                        }
                        catch (Exception e) {
                            values.add(Integer.valueOf(((String)buffer).charAt(0)));
                        }
                    } else if (((String)buffer).matches("^[^0-9]+$")) {
                        values.add(Integer.valueOf(((String)buffer).charAt(0)));
                    } else {
                        for (char ch2 : ((String)buffer).toCharArray()) {
                            values.add(Integer.valueOf(ch2));
                        }
                    }
                }
                buffer = "";
                continue;
            }
            buffer = (String)buffer + ch;
        }
        if (!((String)buffer).isEmpty()) {
            if (((String)buffer).matches("^[0-9]+$")) {
                try {
                    values.add(Integer.parseInt((String)buffer));
                }
                catch (Exception e) {
                    values.add(Integer.valueOf(((String)buffer).charAt(0)));
                }
            } else if (((String)buffer).matches("^[^0-9]+$")) {
                values.add(Integer.valueOf(((String)buffer).charAt(0)));
            } else {
                for (char ch : ((String)buffer).toCharArray()) {
                    values.add(Integer.valueOf(ch));
                }
            }
        }
        int[] arr = new int[values.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (Integer)values.get(i);
        }
        return arr;
    }

    static byte[] pemDecode(String pem) {
        String base64 = pem.replace("\r", "");
        while (base64.startsWith("-")) {
            base64 = base64.substring(1);
        }
        while (!base64.startsWith("-")) {
            base64 = base64.substring(1);
        }
        while (base64.startsWith("-")) {
            base64 = base64.substring(1);
        }
        base64 = base64.replace("\n", "");
        while (base64.endsWith("-")) {
            base64 = base64.substring(0, base64.length() - 1);
        }
        while (!base64.endsWith("-")) {
            base64 = base64.substring(0, base64.length() - 1);
        }
        while (base64.endsWith("-")) {
            base64 = base64.substring(0, base64.length() - 1);
        }
        return Base64.getDecoder().decode(base64);
    }

    static void extractEmulationSoftware(File sourceFile, String version) throws IOException {
        LauncherUtils.log("Extracting software package...");
        LauncherUtils.deleteDir(new File("cache/emulationsoftwaretmp"));
        LauncherUtils.unZip(sourceFile, new File("cache/emulationsoftwaretmp"));
        if (new File("cache/emulationsoftwaretmp", "baseserver").exists()) {
            LauncherUtils.log("Updating server software to " + version + "...", true);
            LauncherUtils.copyDirWithProgress(new File("cache/emulationsoftwaretmp", "baseserver"), new File("server"));
        }
        if (new File("cache/emulationsoftwaretmp", "expandedserver").exists()) {
            LauncherUtils.log("Updating extra server files to " + version + "...", true);
            LauncherUtils.copyDirWithProgress(new File("cache/emulationsoftwaretmp", "expandedserver"), new File("server"));
        }
        if (new File("cache/emulationsoftwaretmp", "rootdata").exists()) {
            LauncherUtils.log("Updating data to " + version + "...", true);
            LauncherUtils.copyDirWithProgress(new File("cache/emulationsoftwaretmp", "rootdata"), new File("."));
        }
        if (new File("cache/emulationsoftwaretmp", "assetmodifications").exists()) {
            LauncherUtils.log("Updating asset modifications to " + version + "...", true);
            LauncherUtils.copyDirWithProgress(new File("cache/emulationsoftwaretmp", "assetmodifications"), new File("assetmodifications"));
        }
        for (File clientDir : new File("clients").listFiles(t -> t.getName().startsWith("client-") && t.isDirectory())) {
            String clientVersion = clientDir.getName().substring("client-".length());
            LauncherUtils.log("Updating " + clientVersion + " client modifications to " + version + "...", true);
            File modsSpecific = new File("cache/emulationsoftwaretmp", "clientmodifications-" + clientVersion);
            File modsGeneral = new File("cache/emulationsoftwaretmp", "clientmodifications");
            if (!modsSpecific.exists() && !modsGeneral.exists()) continue;
            LauncherMain.closeClientsIfNeeded();
            LauncherUtils.copyDirWithProgress(modsGeneral, clientDir);
            LauncherUtils.copyDirWithProgress(modsSpecific, clientDir);
        }
        if (new File("cache/emulationsoftwaretmp", "defaultpayloads").exists()) {
            LauncherUtils.log("Updating default payloads to " + version + "...", true);
            LauncherUtils.copyDirWithProgress(new File("cache/emulationsoftwaretmp", "defaultpayloads"), new File("payloads"));
        }
        LauncherUtils.deleteDir(new File("cache/emulationsoftwaretmp"));
    }

    static void extractGameDescriptor(File sourceFile, String version) throws IOException {
        LauncherUtils.log("Extracting game descriptor package...");
        LauncherUtils.deleteDir(new File("cache/gamedescriptortmp"));
        LauncherUtils.unZip(sourceFile, new File("cache/gamedescriptortmp"));
        if (new File("cache/gamedescriptortmp", "defaultpayloads").exists()) {
            LauncherUtils.log("Updating default payloads to " + version + "...", true);
            LauncherUtils.copyDirWithProgress(new File("cache/gamedescriptortmp", "defaultpayloads"), new File("payloads"));
        }
        if (new File("cache/gamedescriptortmp", "rootdata").exists()) {
            LauncherUtils.log("Updating data to " + version + "...", true);
            LauncherUtils.copyDirWithProgress(new File("cache/gamedescriptortmp", "rootdata"), new File("."));
        }
        if (new File("cache/gamedescriptortmp", "assetmodifications").exists()) {
            LauncherUtils.log("Updating asset modifications to " + version + "...", true);
            LauncherUtils.copyDirWithProgress(new File("cache/gamedescriptortmp", "assetmodifications"), new File("assetmodifications"));
        }
        for (File clientDir : new File("clients").listFiles(t -> t.getName().startsWith("client-") && t.isDirectory())) {
            String clientVersion = clientDir.getName().substring("client-".length());
            LauncherUtils.log("Updating " + clientVersion + " client modifications to " + version + "...", true);
            File modsSpecific = new File("cache/gamedescriptortmp", "clientmodifications-" + clientVersion);
            File modsGeneral = new File("cache/gamedescriptortmp", "clientmodifications");
            if (!modsSpecific.exists() && !modsGeneral.exists()) continue;
            LauncherMain.closeClientsIfNeeded();
            LauncherUtils.copyDirWithProgress(modsGeneral, clientDir);
            LauncherUtils.copyDirWithProgress(modsSpecific, clientDir);
        }
        LauncherUtils.deleteDir(new File("cache/gamedescriptortmp"));
    }

    static {
        loader = new DynamicClassLoader();
        tags = new HashMap();
        HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    }
}

