/*
 * Decompiled with CFR 0.152.
 */
package org.asf.razorwhip.sentinel.launcher;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.asf.razorwhip.sentinel.launcher.LauncherMain;
import org.asf.razorwhip.sentinel.launcher.LauncherUtils;
import org.asf.razorwhip.sentinel.launcher.api.ISentinelPayload;
import org.asf.razorwhip.sentinel.launcher.api.PayloadType;
import org.asf.razorwhip.sentinel.launcher.windows.PayloadManagerWindow;

public class PayloadManager {
    private static boolean discoveredPayloads;
    private static ArrayList<String> payloadLoadOrder;
    private static LinkedHashMap<String, PayloadEntry> payloads;

    public static ISentinelPayload getPayload(String id) {
        if (!PayloadManager.isPayloadLoaded(id)) {
            return null;
        }
        return PayloadManager.payloads.get((Object)id).payloadObject;
    }

    public static boolean isPayloadLoaded(String id) {
        return payloads.containsKey(id);
    }

    public static String[] getLoadedPayloadIds() {
        return (String[])payloadLoadOrder.toArray(String[]::new);
    }

    public static void deletePayloadsPendingRemoval() throws IOException {
        if (new File("payloadstoremove.json").exists()) {
            JsonArray payloadsToRemove = JsonParser.parseString((String)Files.readString(Path.of("payloadstoremove.json", new String[0]))).getAsJsonArray();
            for (JsonElement ele : payloadsToRemove) {
                File payloadF = new File("payloads", ele.getAsString());
                try {
                    Map<String, String> descriptor = LauncherUtils.parseProperties(PayloadManager.getStringFrom(payloadF, "payloadinfo"));
                    String id = payloadF.getName();
                    if (descriptor.containsKey("Payload-ID")) {
                        id = descriptor.get("Payload-ID");
                    }
                    if (new File("cache/payloadcache/payloadverificationkeys", id + ".pem").exists()) {
                        new File("cache/payloadcache/payloadverificationkeys", id + ".pem").delete();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!payloadF.exists()) continue;
                payloadF.delete();
            }
            new File("payloadstoremove.json").delete();
        }
    }

    public static void discoverPayloads() throws IOException {
        new File("payloads").mkdirs();
        JsonObject index = new JsonObject();
        if (new File("activepayloads.json").exists()) {
            index = JsonParser.parseString((String)Files.readString(Path.of("activepayloads.json", new String[0]))).getAsJsonObject();
        }
        for (File spf : new File("payloads").listFiles(t -> t.isFile() && t.getName().endsWith(".spf"))) {
            if (index.has(spf.getName())) continue;
            discoveredPayloads = true;
            try {
                Map<String, String> descriptor = LauncherUtils.parseProperties(PayloadManager.getStringFrom(spf, "payloadinfo"));
                String id = spf.getName();
                if (descriptor.containsKey("Payload-ID")) {
                    id = descriptor.get("Payload-ID");
                }
                if (!LauncherUtils.isPackageSigned(spf) || !LauncherUtils.verifyPackageSignature(new File("cache/payloadcache/payloadverificationkeys", id + ".pem"), spf)) continue;
                LauncherUtils.extractPackagePublicKey(new File("cache/payloadcache/payloadverificationkeys", id + ".pem"), spf);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        PayloadManager.indexPayloads();
    }

    public static JsonObject indexPayloads() throws IOException {
        new File("payloads").mkdirs();
        JsonObject index = new JsonObject();
        if (new File("activepayloads.json").exists()) {
            index = JsonParser.parseString((String)Files.readString(Path.of("activepayloads.json", new String[0]))).getAsJsonObject();
        }
        JsonObject newIndex = new JsonObject();
        for (File spf : new File("payloads").listFiles(t -> t.isFile() && t.getName().endsWith(".spf"))) {
            if (!index.has(spf.getName())) {
                newIndex.addProperty(spf.getName(), Boolean.valueOf(false));
                continue;
            }
            newIndex.addProperty(spf.getName(), Boolean.valueOf(index.get(spf.getName()).getAsBoolean()));
        }
        Files.writeString(Path.of("activepayloads.json", new String[0]), (CharSequence)newIndex.toString(), new OpenOption[0]);
        return newIndex;
    }

    public static void showPayloadManagementWindowIfNeeded() throws IOException {
        if (discoveredPayloads) {
            LauncherUtils.log("Opening payload manager...", true);
            discoveredPayloads = false;
            JOptionPane.showMessageDialog(null, "Discovered new payloads!", "Payloads detected", 1);
            PayloadManager.showPayloadManagementWindow();
        }
    }

    public static boolean showPayloadManagementWindow() throws IOException {
        JsonObject lastIndex = PayloadManager.indexPayloads();
        PayloadManagerWindow window = new PayloadManagerWindow(LauncherUtils.getLauncherWindow());
        if (window.showDialog()) {
            JsonObject index = new JsonObject();
            if (new File("activepayloads.json").exists()) {
                index = JsonParser.parseString((String)Files.readString(Path.of("activepayloads.json", new String[0]))).getAsJsonObject();
            }
            JsonArray payloadsToRemove = new JsonArray();
            for (String oldKey : lastIndex.keySet()) {
                if (index.has(oldKey)) continue;
                payloadsToRemove.add(oldKey);
            }
            if (payloadsToRemove.size() != 0) {
                Files.writeString(Path.of("payloadstoremove.json", new String[0]), (CharSequence)payloadsToRemove.toString(), new OpenOption[0]);
                LauncherUtils.log("Requesting restart via exit code 237...");
                System.exit(237);
            }
            return true;
        }
        PayloadManager.indexPayloads();
        return false;
    }

    public static void initPayloads() throws IOException {
        LauncherUtils.log("Preparing to load payloads...");
        JsonObject index = PayloadManager.indexPayloads();
        new File("cache/payloadcache/payloadverificationkeys").mkdirs();
        JsonObject payloadHashes = new JsonObject();
        if (new File("cache/payloadcache", "payloadhashes.json").exists()) {
            payloadHashes = JsonParser.parseString((String)Files.readString(Path.of("cache/payloadcache/payloadhashes.json", new String[0]))).getAsJsonObject();
        }
        ArrayList<String> updatedPayloadFiles = new ArrayList<String>();
        ArrayList<String> removedPayloadFiles = new ArrayList<String>();
        while (true) {
            String[] classes;
            String[] ids;
            updatedPayloadFiles.clear();
            removedPayloadFiles.clear();
            payloadLoadOrder.clear();
            payloads.clear();
            for (File spf : new File("payloads").listFiles(t -> t.isFile() && t.getName().endsWith(".spf"))) {
                String cHash;
                if (!payloadHashes.has(spf.getName())) {
                    updatedPayloadFiles.add(spf.getName());
                    payloadHashes.addProperty(spf.getName(), LauncherUtils.sha512Hash(Files.readAllBytes(spf.toPath())));
                    continue;
                }
                String oHash = payloadHashes.get(spf.getName()).getAsString();
                if (oHash.equals(cHash = LauncherUtils.sha512Hash(Files.readAllBytes(spf.toPath())))) continue;
                updatedPayloadFiles.add(spf.getName());
                payloadHashes.addProperty(spf.getName(), cHash);
            }
            for (String file : payloadHashes.keySet()) {
                if (new File("payloads", file).exists()) continue;
                removedPayloadFiles.add(file);
            }
            for (String file : removedPayloadFiles) {
                payloadHashes.remove(file);
            }
            boolean showManager = false;
            for (String file : (String[])updatedPayloadFiles.toArray(String[]::new)) {
                File spf = new File("payloads", file);
                Map<String, String> descriptor = LauncherUtils.parseProperties(PayloadManager.getStringFrom(spf, "payloadinfo"));
                Object name = spf.getName();
                String id = spf.getName();
                if (descriptor.containsKey("Payload-ID")) {
                    name = descriptor.get("Payload-ID");
                    id = name;
                }
                if (descriptor.containsKey("Payload-Name")) {
                    name = descriptor.get("Payload-Name");
                }
                if (LauncherUtils.verifyPackageSignature(spf, new File("cache/payloadcache/payloadverificationkeys", id + ".pem"))) continue;
                JOptionPane.showMessageDialog(null, "ERROR! Failed to verify package signature!\n\nFailed to verify the update of the payload file for '" + (String)name + "'!\nThe file that was added or updated may have been tampered with, proceed with caution!\n\nThe payload file has been deleted from disk, use the payload manager to re-add it.", "Signature error", 0);
                spf.delete();
                updatedPayloadFiles.remove(file);
                removedPayloadFiles.add(file);
                payloadHashes.remove(file);
                showManager = true;
            }
            LauncherUtils.log("Removing deleted payloads...", true);
            for (String file : removedPayloadFiles) {
                LauncherUtils.deleteDir(new File("cache/payloadcache/payloads/" + file));
            }
            LauncherUtils.log("Extracting updated payloads...", true);
            for (String file : updatedPayloadFiles) {
                Map<String, String> descriptor;
                LauncherUtils.log("Extracting payload " + file + "...");
                LauncherUtils.unZip(new File("payloads", file), new File("cache/payloadcache/payloads/" + file));
                File payloadDataFolder = new File("cache/payloadcache/payloads/" + file, "payloaddata");
                if (!payloadDataFolder.exists() || !(descriptor = LauncherUtils.parseProperties(PayloadManager.getStringFrom(new File("cache/payloadcache/payloads/" + file), "payloadinfo"))).containsKey("Resource-Target") || !descriptor.containsKey("Resource-Target-Path")) continue;
                File target = new File(new File(new File("cache/payloadcache/payloads/" + file), descriptor.get("Resource-Target")), descriptor.get("Resource-Target-Path"));
                target.getParentFile().mkdirs();
                payloadDataFolder.renameTo(target);
            }
            LauncherUtils.resetProgressBar();
            LauncherUtils.hideProgressPanel();
            if (removedPayloadFiles.size() != 0 || updatedPayloadFiles.size() != 0) {
                new File("cache/payloadcache/requireupdate").createNewFile();
            }
            Files.writeString(Path.of("cache/payloadcache/payloadhashes.json", new String[0]), (CharSequence)payloadHashes.toString(), new OpenOption[0]);
            LauncherUtils.log("Preparing to load payloads...", true);
            LauncherUtils.log("Finding payloads...");
            for (File spf : new File("payloads").listFiles(t -> t.isFile() && t.getName().endsWith(".spf"))) {
                boolean enabled = index.has(spf.getName()) && index.get(spf.getName()).getAsBoolean();
                PayloadManager.loadPayloadFile(spf, new File("cache/payloadcache/payloads", spf.getName()), index, enabled);
            }
            JsonObject oldPayloadCache = new JsonObject();
            File cacheFile = new File("cache/payloadcache/payloadhashes-sgdsvp.json");
            if (cacheFile.exists()) {
                oldPayloadCache = JsonParser.parseString((String)Files.readString(Path.of("cache/payloadcache/payloadhashes-sgdsvp.json", new String[0]))).getAsJsonObject();
            }
            boolean updated = false;
            LauncherUtils.log("Synchronizing payloads...", true);
            File[] spfs = new ArrayList();
            File[] sPayloadList = new ArrayList();
            HashMap<String, String> hashListSPayloads = new HashMap<String, String>();
            LauncherUtils.log("Finding descriptor-controlled payloads...");
            for (File spf : LauncherUtils.gameDescriptor.getExtraPayloadFiles()) {
                spfs.add(spf);
            }
            LauncherUtils.log("Finding emulation-software-controlled payloads...");
            for (File spf : LauncherUtils.emulationSoftware.getExtraPayloadFiles()) {
                spfs.add(spf);
            }
            LauncherUtils.log("Loading discovered payloads...");
            for (File spf : spfs) {
                Map<String, String> descriptor = LauncherUtils.parseProperties(PayloadManager.getStringFrom(spf, "payloadinfo"));
                String id = spf.getName();
                if (descriptor.containsKey("Payload-ID")) {
                    id = descriptor.get("Payload-ID");
                }
                sPayloadList.add(id);
                File fD = spf;
                if (!fD.isDirectory()) {
                    String oHash;
                    String hash = LauncherUtils.sha512Hash(Files.readAllBytes(spf.toPath()));
                    String string = oHash = oldPayloadCache.has(id) ? oldPayloadCache.get(id).getAsString() : "";
                    if (!oHash.equals(hash)) {
                        LauncherUtils.log("Extracting payload " + spf.getName() + "...", true);
                        LauncherUtils.unZip(spf, new File("cache/payloadcache/payloads-sgdsvp/", id));
                        LauncherUtils.resetProgressBar();
                        LauncherUtils.hideProgressPanel();
                        updated = true;
                    }
                    hashListSPayloads.put(id, hash);
                    oldPayloadCache.addProperty(id, hash);
                    fD = new File("cache/payloadcache/payloads-sgdsvp/", id);
                } else if (!new File("cache/payloadcache/requireupdate").exists()) {
                    updated = true;
                }
                PayloadManager.loadPayloadFile(spf, fD, index, true);
            }
            for (String id : ids = (String[])oldPayloadCache.keySet().toArray(String[]::new)) {
                if (hashListSPayloads.containsKey(id)) continue;
                oldPayloadCache.remove(id);
                LauncherUtils.deleteDir(new File("cache/payloadcache/payloads-sgdsvp/", id));
                updated = true;
            }
            if (updated && !new File("cache/payloadcache/requireupdate").exists()) {
                new File("cache/payloadcache/requireupdate").createNewFile();
            }
            Files.writeString(Path.of("cache/payloadcache/payloadhashes-sgdsvp.json", new String[0]), (CharSequence)oldPayloadCache.toString(), new OpenOption[0]);
            if (System.getProperty("debugPayloadFiles") != null || System.getProperty("debugPayloadHintClasses") != null) {
                LauncherUtils.log("Loading debug payloads...", true);
                if (System.getProperty("debugPayloadDirectories") != null) {
                    String[] files;
                    for (String file : files = System.getProperty("debugPayloadDirectories").split(File.pathSeparator)) {
                        File spfD = new File(file);
                        PayloadManager.loadPayloadFile(spfD, spfD, index, true);
                    }
                }
                if (System.getProperty("debugPayloadHintClasses") != null) {
                    for (String clsN : classes = System.getProperty("debugPayloadHintClasses").split(":")) {
                        LauncherUtils.log("Loading hint class: " + clsN);
                        try {
                            File f;
                            Class<?> cls = Class.forName(clsN);
                            URL loc = cls.getProtectionDomain().getCodeSource().getLocation();
                            File fD = f = new File(loc.toURI());
                            if (!fD.isDirectory()) {
                                LauncherUtils.log("Extracting payload " + f.getName() + "...");
                                LauncherUtils.unZip(f, new File("cache/payloadcache/payloadsdebug/" + clsN));
                                fD = new File("cache/payloadcache/payloadsdebug/" + clsN);
                                LauncherUtils.resetProgressBar();
                                LauncherUtils.hideProgressPanel();
                            }
                            PayloadManager.loadPayloadFile(f, fD, index, true);
                        }
                        catch (Exception e) {
                            throw new IOException("Hint class load failure", e);
                        }
                    }
                }
            }
            LauncherUtils.setStatus("Preparing to load payloads...");
            LauncherUtils.log("Compiling load order...");
            classes = payloads.keySet().iterator();
            while (classes.hasNext()) {
                String id = (String)classes.next();
                PayloadEntry payload = payloads.get(id);
                if (!payload.enabled || payloadLoadOrder.contains(payload.id) || PayloadManager.loadPayload(payload, payloadLoadOrder, payloads)) continue;
                showManager = true;
            }
            if (!showManager) break;
            if (PayloadManager.showPayloadManagementWindow()) continue;
            System.exit(1);
        }
        LauncherUtils.resetProgressBar();
        LauncherUtils.hideProgressPanel();
        boolean indexChange = false;
        if (!new File("cache/payloadcache/lastactive.json").exists()) {
            indexChange = true;
        } else if (!Files.readString(new File("cache/payloadcache/lastactive.json").toPath()).equals(index.toString())) {
            indexChange = true;
        }
        if (!new File("cache/payloadcache/requireupdate").exists() && indexChange) {
            new File("cache/payloadcache/requireupdate").createNewFile();
        }
        if (indexChange) {
            Files.writeString(Path.of("cache/payloadcache/lastactive.json", new String[0]), (CharSequence)index.toString(), new OpenOption[0]);
        }
        if (new File("cache/payloadcache/requireupdate").exists() || System.getProperty("debugPayloadFiles") != null || System.getProperty("debugPayloadHintClasses") != null) {
            String clientVersion;
            LauncherUtils.deleteDir(new File("cache/payloadcache/payloaddata"));
            new File("cache/payloadcache/payloaddata").mkdirs();
            LauncherUtils.resetProgressBar();
            LauncherUtils.showProgressPanel();
            LauncherUtils.log("Gathering payload files...", true);
            int count = 0;
            for (String id : payloadLoadOrder) {
                count += PayloadManager.indexDir(new File(PayloadManager.payloads.get((Object)id).payloadExtractedDir, "server"));
                count += PayloadManager.indexDir(new File(PayloadManager.payloads.get((Object)id).payloadExtractedDir, "rootdata"));
                count += PayloadManager.indexDir(new File(PayloadManager.payloads.get((Object)id).payloadExtractedDir, "assetmodifications"));
                for (File clientDir : new File("clients").listFiles(t -> t.getName().startsWith("client-") && t.isDirectory())) {
                    clientVersion = clientDir.getName().substring("client-".length());
                    count += PayloadManager.indexDir(new File(PayloadManager.payloads.get((Object)id).payloadExtractedDir, "clientmodifications"));
                    count += PayloadManager.indexDir(new File(PayloadManager.payloads.get((Object)id).payloadExtractedDir, "clientmodifications-" + clientVersion));
                }
            }
            LauncherUtils.setProgressMax(count);
            for (String id : payloadLoadOrder) {
                LauncherUtils.log("Gathering payload files: " + PayloadManager.payloads.get((Object)id).name);
                PayloadManager.copyDirWithProgress(new File(PayloadManager.payloads.get((Object)id).payloadExtractedDir, "server"), new File("cache/payloadcache/payloaddata", "server"), "", null, null);
                PayloadManager.copyDirWithProgress(new File(PayloadManager.payloads.get((Object)id).payloadExtractedDir, "rootdata"), new File("cache/payloadcache/payloaddata", "rootdata"), "", null, null);
                PayloadManager.copyDirWithProgress(new File(PayloadManager.payloads.get((Object)id).payloadExtractedDir, "assetmodifications"), new File("cache/payloadcache/payloaddata", "assetmodifications"), "", null, null);
                for (File clientDir : new File("clients").listFiles(t -> t.getName().startsWith("client-") && t.isDirectory())) {
                    clientVersion = clientDir.getName().substring("client-".length());
                    PayloadManager.copyDirWithProgress(new File(PayloadManager.payloads.get((Object)id).payloadExtractedDir, "clientmodifications"), new File("cache/payloadcache/payloaddata", "clientmodifications"), "", null, null);
                    PayloadManager.copyDirWithProgress(new File(PayloadManager.payloads.get((Object)id).payloadExtractedDir, "clientmodifications-" + clientVersion), new File("cache/payloadcache/payloaddata", "clientmodifications-" + clientVersion), "", null, null);
                }
            }
            LauncherUtils.log("Loading previous payload file list...", true);
            ArrayList<String> lastFiles = new ArrayList<String>();
            ArrayList<String> newIndex = new ArrayList<String>();
            File payloadIndexFile = new File("cache/payloadcache/index.sfl");
            if (payloadIndexFile.exists()) {
                for (String line : Files.readAllLines(payloadIndexFile.toPath())) {
                    lastFiles.add(line);
                }
            }
            LauncherUtils.log("Applying payloads...", true);
            count = 0;
            count += PayloadManager.indexDir(new File("cache/payloadcache/payloaddata", "server"));
            count += PayloadManager.indexDir(new File("cache/payloadcache/payloaddata", "rootdata"));
            count += PayloadManager.indexDir(new File("cache/payloadcache/payloaddata", "assetmodifications"));
            for (File clientDir : new File("clients").listFiles(t -> t.getName().startsWith("client-") && t.isDirectory())) {
                String clientVersion2 = clientDir.getName().substring("client-".length());
                count += PayloadManager.indexDir(new File("cache/payloadcache/payloaddata", "clientmodifications"));
                count += PayloadManager.indexDir(new File("cache/payloadcache/payloaddata", "clientmodifications-" + clientVersion2));
            }
            LauncherUtils.resetProgressBar();
            LauncherUtils.setProgressMax(count);
            PayloadManager.copyDirWithProgress(new File("cache/payloadcache/payloaddata", "server"), new File("server"), "server/", lastFiles, newIndex);
            PayloadManager.copyDirWithProgress(new File("cache/payloadcache/payloaddata", "rootdata"), new File("."), "", lastFiles, newIndex);
            PayloadManager.copyDirWithProgress(new File("cache/payloadcache/payloaddata", "assetmodifications"), new File("assetmodifications"), "assetmodifications/", lastFiles, newIndex);
            for (File clientDir : new File("clients").listFiles(t -> t.getName().startsWith("client-") && t.isDirectory())) {
                String clientVersion3 = clientDir.getName().substring("client-".length());
                File modsGeneral = new File("cache/payloadcache/payloaddata", "clientmodifications");
                File modsSpecific = new File("cache/payloadcache/payloaddata", "clientmodifications-" + clientVersion3);
                if (!modsSpecific.exists() && !modsGeneral.exists()) continue;
                LauncherMain.closeClientsIfNeeded();
                PayloadManager.copyDirWithProgress(modsGeneral, clientDir, clientDir.getName(), lastFiles, newIndex);
                PayloadManager.copyDirWithProgress(modsSpecific, clientDir, "", lastFiles, newIndex);
            }
            Object indexStr = "";
            for (String file : newIndex) {
                if (((String)indexStr).isEmpty()) {
                    indexStr = file;
                    continue;
                }
                indexStr = (String)indexStr + "\n" + file;
            }
            Files.writeString(payloadIndexFile.toPath(), (CharSequence)indexStr, new OpenOption[0]);
            for (String file : lastFiles) {
                if (!new File(file).exists()) continue;
                new File(file).delete();
            }
            if (new File("cache/payloadcache/requireupdate").exists()) {
                new File("cache/payloadcache/requireupdate").delete();
            }
            LauncherUtils.resetProgressBar();
            LauncherUtils.hideProgressPanel();
        }
        if (System.getProperty("debugPayloadFiles") != null || System.getProperty("debugPayloadHintClasses") != null) {
            new File("cache/payloadcache/requireupdate").createNewFile();
        }
        LauncherUtils.log("Loading payload classes...");
        LauncherUtils.setStatus("Loading payloads..");
        for (String id : payloadLoadOrder) {
            PayloadEntry payload = payloads.get(id);
            if (payload.type != PayloadType.PAYLOAD) continue;
            LauncherUtils.log("Loading payload: " + id);
            if (!payload.descriptor.containsKey("Payload-Class")) {
                throw new IOException("Payload " + id + " does not have a payload class field in its descriptor!");
            }
            LauncherUtils.addUrlToComponentClassLoader(payload.payloadFile.toURI().toURL());
            try {
                Class<?> payloadCls = LauncherUtils.loader.loadClass(payload.descriptor.get("Payload-Class"));
                if (!ISentinelPayload.class.isAssignableFrom(payloadCls)) {
                    throw new IllegalArgumentException(payload.descriptor.get("Payload-Class") + " does not implement " + ISentinelPayload.class.getTypeName());
                }
                Constructor<?> pCt = payloadCls.getConstructor(new Class[0]);
                payload.payloadObject = (ISentinelPayload)pCt.newInstance(new Object[0]);
                LauncherUtils.log("Pre-initializing: " + payload.id);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException("Payload loading error occurred", e);
            }
            if (payload.payloadObject == null) continue;
            LauncherUtils.log("Pre-initializing: " + payload.id);
            payload.payloadObject.preInit();
        }
        LauncherUtils.log("Initializing payloads...");
        for (String id : payloadLoadOrder) {
            PayloadEntry payload = payloads.get(id);
            if (payload.payloadObject == null) continue;
            LauncherUtils.log("Initializing: " + payload.id);
            payload.payloadObject.init();
        }
    }

    static void postInitPayloads() {
        LauncherUtils.log("Post-initializing payloads...");
        for (String id : payloadLoadOrder) {
            PayloadEntry payload = payloads.get(id);
            if (payload.payloadObject == null) continue;
            LauncherUtils.log("Post-initializing: " + payload.id);
            payload.payloadObject.postInit();
        }
    }

    private static void loadPayloadFile(File spf, File extractedDir, JsonObject index, boolean enabled) throws IOException {
        LauncherUtils.log("Loading payload file: " + spf.getPath());
        Map<String, String> descriptor = LauncherUtils.parseProperties(PayloadManager.getStringFrom(spf, "payloadinfo"));
        PayloadEntry payload = new PayloadEntry();
        payload.id = spf.getName();
        payload.name = spf.getName();
        payload.version = "default";
        payload.descriptor = descriptor;
        payload.payloadFile = spf;
        payload.payloadExtractedDir = extractedDir;
        payload.enabled = enabled;
        String type = "Full";
        if (descriptor.containsKey("Type")) {
            type = descriptor.get("Type");
        }
        if (!(type = type.toLowerCase()).equals("resource") && !type.equals("full")) {
            index.remove(spf.getName());
            return;
        }
        PayloadType payloadType = payload.type = type.equals("resource") ? PayloadType.RESOURCE : PayloadType.PAYLOAD;
        if (descriptor.containsKey("Payload-ID")) {
            payload.name = payload.id = descriptor.get("Payload-ID");
        }
        if (descriptor.containsKey("Payload-Name")) {
            payload.name = descriptor.get("Payload-Name");
        }
        if (descriptor.containsKey("Payload-Version")) {
            payload.version = descriptor.get("Payload-Version");
        }
        if (descriptor.containsKey("Game-ID") && !descriptor.get("Game-ID").equalsIgnoreCase(LauncherUtils.getGameID())) {
            index.remove(spf.getName());
            return;
        }
        if (descriptor.containsKey("Software-ID") && !descriptor.get("Software-ID").equalsIgnoreCase(LauncherUtils.getSoftwareID())) {
            index.remove(spf.getName());
            return;
        }
        payload.dependencies = new PayloadDependency[0];
        payload.optionalDependencies = new PayloadDependency[0];
        payload.loadBefore = new String[0];
        payload.conflictsWith = new PayloadDependency[0];
        try {
            PayloadDependency dependency;
            JsonObject dep;
            JsonObject depsConfig = JsonParser.parseString((String)PayloadManager.getStringFrom(spf, "dependencies.json")).getAsJsonObject();
            ArrayList<PayloadDependency> deps = new ArrayList<PayloadDependency>();
            ArrayList<PayloadDependency> optDeps = new ArrayList<PayloadDependency>();
            ArrayList<String> loadBefore = new ArrayList<String>();
            ArrayList<PayloadDependency> conflicts = new ArrayList<PayloadDependency>();
            if (depsConfig.has("dependencies")) {
                for (JsonElement ele : depsConfig.get("dependencies").getAsJsonArray()) {
                    dep = ele.getAsJsonObject();
                    dependency = new PayloadDependency();
                    dependency.id = dep.get("id").getAsString();
                    if (dep.has("version")) {
                        dependency.version = dep.get("version").getAsString();
                        dependency.versionString = dep.has("versionString") ? dep.get("versionString").getAsString() : dependency.version;
                    }
                    if (dep.has("url")) {
                        dependency.url = dep.get("url").getAsString();
                    }
                    deps.add(dependency);
                }
            }
            if (depsConfig.has("optionalDependencies")) {
                for (JsonElement ele : depsConfig.get("optionalDependencies").getAsJsonArray()) {
                    dep = ele.getAsJsonObject();
                    dependency = new PayloadDependency();
                    dependency.id = dep.get("id").getAsString();
                    if (dep.has("version")) {
                        dependency.version = dep.get("version").getAsString();
                        dependency.versionString = dep.has("versionString") ? dep.get("versionString").getAsString() : dependency.version;
                    }
                    optDeps.add(dependency);
                }
            }
            if (depsConfig.has("conflicts")) {
                for (JsonElement ele : depsConfig.get("conflicts").getAsJsonArray()) {
                    dep = ele.getAsJsonObject();
                    PayloadDependency conflict = new PayloadDependency();
                    conflict.id = dep.get("id").getAsString();
                    if (dep.has("version")) {
                        conflict.version = dep.get("version").getAsString();
                    }
                    conflicts.add(conflict);
                }
            }
            if (depsConfig.has("loadBefore")) {
                for (JsonElement ele : depsConfig.get("loadBefore").getAsJsonArray()) {
                    loadBefore.add(ele.getAsString());
                }
            }
            payload.dependencies = (PayloadDependency[])deps.toArray(PayloadDependency[]::new);
            payload.loadBefore = (String[])loadBefore.toArray(String[]::new);
            payload.conflictsWith = (PayloadDependency[])conflicts.toArray(PayloadDependency[]::new);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (payloads.containsKey(payload.id)) {
            JOptionPane.showMessageDialog(null, "WARNING! Payload conflict detected!\n\nPayload ID: " + payload.id + "\nTwo or more files provide this payload ID.\n\nFile 1: " + PayloadManager.payloads.get((Object)payload.id).payloadFile.getName() + "\nFile 2: " + payload.payloadFile.getName() + "\n\nThe first file will be used.", "Warning", 2);
            index.remove(spf.getName());
            return;
        }
        payloads.put(payload.id, payload);
    }

    private static boolean loadPayload(PayloadEntry payload, ArrayList<String> payloadLoadOrder, LinkedHashMap<String, PayloadEntry> payloads) {
        PayloadEntry dependency;
        for (PayloadDependency dep : payload.dependencies) {
            if (!payloads.containsKey(dep.id)) {
                JOptionPane.showMessageDialog(null, "There were dependency errors, the payload manager will be opened.", "Dependency error", 0);
                return false;
            }
            dependency = payloads.get(dep.id);
            if (dep.version != null && !LauncherUtils.verifyVersionRequirement(dependency.version, dep.version)) {
                JOptionPane.showMessageDialog(null, "There were dependency errors, the payload manager will be opened.", "Dependency error", 0);
                return false;
            }
            if (PayloadManager.loadPayload(payloads.get(dep.id), payloadLoadOrder, payloads)) continue;
            return false;
        }
        for (PayloadDependency dep : payload.optionalDependencies) {
            if (!payloads.containsKey(dep.id)) continue;
            dependency = payloads.get(dep.id);
            if (!(dep.version != null ? LauncherUtils.verifyVersionRequirement(dependency.version, dep.version) && !PayloadManager.loadPayload(payloads.get(dep.id), payloadLoadOrder, payloads) : !PayloadManager.loadPayload(payloads.get(dep.id), payloadLoadOrder, payloads))) continue;
            return false;
        }
        for (PayloadDependency conflict : payload.conflictsWith) {
            if (payloads.containsKey(conflict.id)) {
                if (conflict.version != null) continue;
                JOptionPane.showMessageDialog(null, "There were conflict errors, the payload manager will be opened.", "Dependency error", 0);
                return false;
            }
            if (LauncherUtils.verifyVersionRequirement(payloads.get((Object)conflict.id).version, conflict.version)) continue;
            JOptionPane.showMessageDialog(null, "There were conflict errors, the payload manager will be opened.", "Dependency error", 0);
            return false;
        }
        for (String id : payloads.keySet()) {
            PayloadEntry p = payloads.get(id);
            if (!p.enabled || !Stream.of(p.loadBefore).anyMatch(t -> t.equals(payload.id)) || payloadLoadOrder.contains(p.id)) continue;
            payloadLoadOrder.add(p.id);
        }
        if (!payloadLoadOrder.contains(payload.id)) {
            payloadLoadOrder.add(payload.id);
        }
        return true;
    }

    public static void checkForUpdates() throws IOException {
        LauncherUtils.log("Checking for payload updates...", true);
        new File("payloads").mkdirs();
        for (File spf : new File("payloads").listFiles(t -> t.isFile() && t.getName().endsWith(".spf"))) {
            boolean updatedFile;
            block17: {
                Map<String, String> descriptor = LauncherUtils.parseProperties(PayloadManager.getStringFrom(spf, "payloadinfo"));
                if (!descriptor.containsKey("Update-List-URL") || !descriptor.containsKey("Payload-Version")) continue;
                String name = spf.getName();
                String id = spf.getName();
                if (descriptor.containsKey("Payload-ID")) {
                    id = name = descriptor.get("Payload-ID");
                }
                if (descriptor.containsKey("Payload-Name")) {
                    name = descriptor.get("Payload-Name");
                }
                LauncherUtils.log("Checking for updates for " + name + "...", true);
                updatedFile = false;
                LauncherUtils.resetProgressBar();
                try {
                    String current;
                    JsonObject list;
                    String latest;
                    String lst = null;
                    try {
                        lst = LauncherUtils.downloadString(descriptor.get("Update-List-URL"));
                    }
                    catch (IOException e) {
                        LauncherUtils.log("Could not download update list!");
                    }
                    if (lst == null || (latest = (list = JsonParser.parseString((String)lst).getAsJsonObject()).get("latest").getAsString()).equals(current = descriptor.get("Payload-Version"))) break block17;
                    LauncherUtils.log("Updating " + name + " to " + latest + "...", true);
                    JsonObject versionData = list.get("versions").getAsJsonObject().get(latest).getAsJsonObject();
                    String url = versionData.get("url").getAsString();
                    LauncherUtils.resetProgressBar();
                    LauncherUtils.downloadFile(url, new File("payloads", spf.getName() + ".tmp"));
                    String remoteHash = versionData.get("hash").getAsString();
                    String localHash = LauncherUtils.sha256Hash(Files.readAllBytes(new File("payloads", spf.getName() + ".tmp").toPath()));
                    boolean hashSuccess = true;
                    if (!localHash.equals(remoteHash)) {
                        LauncherUtils.resetProgressBar();
                        LauncherUtils.downloadFile(url, new File("payloads", spf.getName() + ".tmp"));
                        localHash = LauncherUtils.sha256Hash(Files.readAllBytes(new File("payloads", spf.getName() + ".tmp").toPath()));
                        if (!localHash.equals(remoteHash)) {
                            new File("payloads", spf.getName() + ".tmp").delete();
                            if (JOptionPane.showConfirmDialog(null, "Failed to verify the integrity of the downloaded payload file for '" + name + "', the update will not be applied!\n\nThe launcher will continue with version " + current + ", if you cancel, the launcher will be closed.", "Integrity check failure", 2, 0) == 2) {
                                System.exit(1);
                            }
                            hashSuccess = false;
                        }
                    }
                    if (hashSuccess) {
                        block18: {
                            LauncherUtils.log("Verifying signature...", true);
                            LauncherUtils.resetProgressBar();
                            LauncherUtils.hideProgressPanel();
                            if (!LauncherUtils.verifyPackageSignature(new File("payloads", spf.getName() + ".tmp"), new File("cache/payloadcache/payloadverificationkeys", id + ".pem"))) {
                                while (JOptionPane.showConfirmDialog(null, "WARNING! Failed to verify package signature!\n\nFailed to verify the update of the payload file for '" + name + "'!\nThe file that was downloaded may have been tampered with, proceed with caution!\n\nIt is recommended to contact the developers if possible and ask them if the keys have changed between versions " + current + " and " + latest + ".\n\nDo you wish to continue with the update? Selecting no will cancel the update.", "Warning", 0, 2) == 0) {
                                    if (JOptionPane.showConfirmDialog(null, "Are you sure you want to ignore the file signature?", "Warning", 0, 2) != 0) continue;
                                    break block18;
                                }
                                hashSuccess = false;
                            }
                        }
                        LauncherUtils.resetProgressBar();
                        LauncherUtils.showProgressPanel();
                    }
                    if (hashSuccess) {
                        new File("payloads", spf.getName()).renameTo(new File("payloads", spf.getName() + ".old"));
                        new File("payloads", spf.getName() + ".tmp").renameTo(new File("payloads", spf.getName()));
                        updatedFile = true;
                        LauncherUtils.log("Updated '" + name + "' to " + latest + "!");
                    }
                }
                catch (Exception e) {
                    try {
                        if (updatedFile) {
                            updatedFile = false;
                            new File("payloads", spf.getName()).delete();
                            new File("payloads", spf.getName() + ".old").renameTo(new File("payloads", spf.getName()));
                        }
                        String nameF = name;
                        SwingUtilities.invokeAndWait(() -> {
                            Object stackTrace = "";
                            for (StackTraceElement ele : e.getStackTrace()) {
                                stackTrace = (String)stackTrace + "\n     At: " + ele;
                            }
                            System.out.println("[LAUNCHER] [SENTINEL LAUNCHER] Error occurred: " + e + (String)stackTrace);
                            JOptionPane.showMessageDialog(null, "An error occured while updating payload '" + nameF + "'.\n\nError details: " + e + (String)stackTrace + "\n\nThe update has been cancelled.", "Update Error", 0);
                        });
                    }
                    catch (InterruptedException | InvocationTargetException exception) {
                        // empty catch block
                    }
                }
            }
            if (!updatedFile) continue;
            new File("payloads", spf.getName() + ".old").delete();
        }
        LauncherUtils.hideProgressPanel();
        LauncherUtils.resetProgressBar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStringFrom(File file, String entry) throws IOException {
        if (file.isDirectory()) {
            FileInputStream strm = new FileInputStream(new File(file, entry));
            String res = new String(strm.readAllBytes(), "UTF-8");
            strm.close();
            return res;
        }
        try (ZipFile f = new ZipFile(file);){
            ZipEntry ent = f.getEntry(entry);
            if (ent == null) {
                throw new FileNotFoundException("Entry " + entry + " not found in " + file);
            }
            InputStream strm = f.getInputStream(ent);
            String res = new String(strm.readAllBytes(), "UTF-8");
            strm.close();
            String string = res;
            return string;
        }
    }

    private static int indexDir(File dir) {
        if (!dir.exists()) {
            return 0;
        }
        int i = 0;
        for (File subDir : dir.listFiles(t -> t.isDirectory())) {
            i += PayloadManager.indexDir(subDir) + 1;
        }
        File[] listFiles = dir.listFiles(t -> !t.isDirectory());
        for (int j = 0; j < listFiles.length; ++j) {
            ++i;
        }
        return i;
    }

    private static void copyDirWithProgress(File source, File destination, String prefix, ArrayList<String> lastFiles, ArrayList<String> index) throws IOException {
        if (!source.exists()) {
            return;
        }
        destination.mkdirs();
        for (File subDir : source.listFiles(t -> t.isDirectory())) {
            PayloadManager.copyDirWithProgress(subDir, new File(destination, subDir.getName()), prefix + subDir.getName() + "/", lastFiles, index);
            LauncherUtils.increaseProgress();
        }
        for (File file : source.listFiles(t -> !t.isDirectory())) {
            if (lastFiles != null && lastFiles.contains(prefix + file.getName())) {
                lastFiles.remove(prefix + file.getName());
                if (index != null && !index.contains(prefix + file.getName())) {
                    index.add(prefix + file.getName());
                }
            } else if (index != null && !index.contains(prefix + file.getName()) && !new File(destination, file.getName()).exists()) {
                index.add(prefix + file.getName());
            }
            Files.copy(file.toPath(), new File(destination, file.getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
            LauncherUtils.increaseProgress();
        }
    }

    static {
        payloadLoadOrder = new ArrayList();
        payloads = new LinkedHashMap();
    }

    public static class PayloadEntry {
        public File payloadFile;
        public File payloadExtractedDir;
        public String id;
        public String name;
        public String version;
        public PayloadType type;
        public PayloadDependency[] dependencies;
        public PayloadDependency[] optionalDependencies;
        public PayloadDependency[] conflictsWith;
        public String[] loadBefore;
        public Map<String, String> descriptor;
        public ISentinelPayload payloadObject;
        public boolean enabled;
    }

    public static class PayloadDependency {
        public String id;
        public String version;
        public String versionString;
        public String url;
    }
}

