/*
 * Decompiled with CFR 0.152.
 */
package org.asf.razorwhip.sentinel.launcher.assets;

import com.google.gson.JsonObject;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.asf.razorwhip.sentinel.launcher.assets.ArchiveInformation;
import org.asf.razorwhip.sentinel.launcher.assets.AssetInformation;

public class ActiveArchiveInformation
extends ArchiveInformation {
    public JsonObject descriptorDef;
    private Map<String, AssetInformation> assets = new LinkedHashMap<String, AssetInformation>();
    public Map<String, String> assetHashes = new LinkedHashMap<String, String>();
    public boolean streamingModeEnabled;
    public boolean streamingModeOverriddenDisable;

    public void clearAssets() {
        this.assets.clear();
    }

    public void addAsset(AssetInformation asset) {
        this.assets.put(ActiveArchiveInformation.sanitizePath(asset.assetPath.toLowerCase()), asset);
    }

    public AssetInformation getAsset(String path) {
        return this.assets.get(ActiveArchiveInformation.sanitizePath(path.toLowerCase()));
    }

    public File getAssetFile(String path) {
        AssetInformation asset = this.getAsset(path);
        if (asset == null) {
            return null;
        }
        return asset.localAssetFile;
    }

    public String getAssetHash(String path) {
        AssetInformation asset = this.getAsset(path);
        if (asset == null) {
            return null;
        }
        return asset.assetHash;
    }

    public AssetInformation[] getAllAssets() {
        return (AssetInformation[])this.assets.values().toArray(AssetInformation[]::new);
    }

    private static String sanitizePath(String path) {
        if (path.contains("\\")) {
            path = path.replace("\\", "/");
        }
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        while (path.contains("//")) {
            path = path.replace("//", "/");
        }
        return path;
    }
}

