/*
 * Decompiled with CFR 0.152.
 */
package org.asf.razorwhip.sentinel.launcher.experiments;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.asf.razorwhip.sentinel.launcher.experiments.api.IExperiment;

public abstract class ExperimentManager {
    protected static ExperimentManager implementation;
    private boolean inited = false;
    private boolean enabled;
    private JsonObject managerConfig;
    private JsonObject managerCache;
    private HashMap<String, ArrayList<IExperiment>> experimentInterfaces = new HashMap();
    private HashMap<String, String> experimentPrettyNames = new HashMap();
    private LinkedHashMap<String, Boolean> experiments = new LinkedHashMap();
    private ArrayList<String> experimentsNeedingReinit = new ArrayList();

    private void initManager() {
        if (this.inited) {
            return;
        }
        this.inited = true;
        try {
            this.managerConfig = this.loadExperimentConfig();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.managerCache = this.loadExperimentCache();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.managerConfig.has("enabled")) {
            this.enabled = this.managerConfig.get("enabled").getAsBoolean();
        }
        this.init();
        try {
            this.saveConfig();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ExperimentManager getInstance() {
        return implementation;
    }

    protected abstract void init();

    protected abstract void saveExperimentConfig(JsonObject var1) throws IOException;

    protected abstract JsonObject loadExperimentConfig() throws IOException;

    protected abstract void saveExperimentCache(JsonObject var1) throws IOException;

    protected abstract JsonObject loadExperimentCache() throws IOException;

    public String[] getExperiments() {
        return (String[])this.experiments.keySet().toArray(String[]::new);
    }

    public String getExperimentName(String key) {
        this.initManager();
        return this.experimentPrettyNames.getOrDefault(key, key);
    }

    public void setExperimentName(String key, String name) throws IllegalArgumentException {
        this.initManager();
        if (!this.experiments.containsKey(key)) {
            throw new IllegalArgumentException("Experiment '" + key + "' does not exist");
        }
        this.experimentPrettyNames.put(key, name);
    }

    public void registerExperiment(String key) {
        this.initManager();
        if (!this.experiments.containsKey(key)) {
            JsonObject enabledExperiments = new JsonObject();
            if (this.managerConfig.has("experiments")) {
                enabledExperiments = this.managerConfig.get("experiments").getAsJsonObject();
            }
            this.experiments.put(key, enabledExperiments.has(key) ? enabledExperiments.get(key).getAsBoolean() : false);
        }
    }

    public void registerExperimentInterface(String key, IExperiment inter) throws IllegalArgumentException {
        this.initManager();
        if (!this.experiments.containsKey(key)) {
            throw new IllegalArgumentException("Experiment '" + key + "' does not exist");
        }
        if (!this.experimentInterfaces.containsKey(key)) {
            this.experimentInterfaces.put(key, new ArrayList());
        }
        if (this.experimentInterfaces.get(key).contains(inter)) {
            return;
        }
        this.experimentInterfaces.get(key).add(inter);
        JsonObject experimentConfig = new JsonObject();
        JsonObject experimentSettings = new JsonObject();
        if (this.managerConfig.has("configurations")) {
            experimentSettings = this.managerConfig.get("configurations").getAsJsonObject();
        }
        if (experimentSettings.has(key)) {
            experimentConfig = experimentSettings.get(key).getAsJsonObject();
        }
        inter.onLoadConfig(experimentConfig);
        boolean oldState = false;
        if (this.managerCache.has(key)) {
            oldState = this.managerCache.get(key).getAsBoolean();
        }
        if (oldState != this.isExperimentEnabled(key)) {
            if (this.isExperimentEnabled(key)) {
                inter.onEnable();
            } else {
                inter.onDisable();
            }
            this.managerCache.addProperty(key, Boolean.valueOf(this.isExperimentEnabled(key)));
            this.experimentsNeedingReinit.add(key);
            try {
                this.saveExperimentCache(this.managerCache);
            }
            catch (IOException iOException) {}
        } else if (this.experimentsNeedingReinit.contains(key)) {
            if (this.isExperimentEnabled(key)) {
                inter.onEnable();
            } else {
                inter.onDisable();
            }
        }
        if (this.isExperimentEnabled(key)) {
            inter.onLoad();
        }
    }

    public void enable() throws IOException {
        this.initManager();
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        this.saveConfig();
    }

    public boolean isEnabled() {
        this.initManager();
        if (System.getProperty("enableAllExperiments") != null) {
            return true;
        }
        return this.enabled;
    }

    public boolean isExperimentEnabled(String key) {
        this.initManager();
        if (!this.experiments.containsKey(key)) {
            return false;
        }
        if (System.getProperty("enableAllExperiments") != null) {
            return true;
        }
        return this.experiments.get(key);
    }

    public void setExperimentEnabled(String key, boolean state) throws IOException, IllegalArgumentException {
        this.initManager();
        if (!this.experiments.containsKey(key)) {
            throw new IllegalArgumentException("Experiment '" + key + "' does not exist");
        }
        if (this.experiments.get(key) == state) {
            return;
        }
        boolean oldState = this.isExperimentEnabled(key);
        this.experiments.put(key, state);
        this.experimentsNeedingReinit.remove(key);
        if (oldState != state && this.experimentInterfaces.containsKey(key)) {
            for (IExperiment inter : this.experimentInterfaces.get(key)) {
                if (state) {
                    inter.onEnable();
                    inter.onLoad();
                    continue;
                }
                if (System.getProperty("enableAllExperiments") != null) continue;
                inter.onDisable();
            }
        }
        this.saveConfig();
    }

    public void saveConfig() throws IOException {
        this.initManager();
        this.managerConfig.addProperty("enabled", Boolean.valueOf(this.enabled));
        JsonObject enabledExperiments = new JsonObject();
        JsonObject cacheData = new JsonObject();
        if (this.managerConfig.has("experiments")) {
            enabledExperiments = this.managerConfig.get("experiments").getAsJsonObject();
        }
        this.managerConfig.add("experiments", (JsonElement)enabledExperiments);
        JsonObject experimentSettings = new JsonObject();
        if (this.managerConfig.has("configurations")) {
            experimentSettings = this.managerConfig.get("configurations").getAsJsonObject();
        }
        this.managerConfig.add("configurations", (JsonElement)experimentSettings);
        for (String experiment : this.experiments.keySet()) {
            enabledExperiments.addProperty(experiment, this.experiments.get(experiment));
            cacheData.addProperty(experiment, Boolean.valueOf(this.isExperimentEnabled(experiment)));
            JsonObject experimentConfig = new JsonObject();
            if (experimentSettings.has(experiment)) {
                experimentConfig = experimentSettings.get(experiment).getAsJsonObject();
            }
            experimentSettings.add(experiment, (JsonElement)experimentConfig);
            if (!this.experimentInterfaces.containsKey(experiment)) continue;
            for (IExperiment inter : this.experimentInterfaces.get(experiment)) {
                inter.onSaveConfig(experimentConfig);
            }
        }
        this.saveExperimentConfig(this.managerConfig);
        this.saveExperimentCache(cacheData);
        this.managerCache = cacheData;
    }
}

