/*
 * Decompiled with CFR 0.152.
 */
package org.asf.razorwhip.sentinel.launcher.experiments;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.asf.razorwhip.sentinel.launcher.LauncherUtils;
import org.asf.razorwhip.sentinel.launcher.experiments.ExperimentManager;
import org.asf.razorwhip.sentinel.launcher.experiments.SentinelDefaultExperiments;
import org.asf.razorwhip.sentinel.launcher.windows.ExperimentManagerWindow;

public class SentinelExperimentManager
extends ExperimentManager {
    public static void bindManager() {
        implementation = new SentinelExperimentManager();
    }

    public static void showExperimentManagerWindow() {
        ExperimentManagerWindow window = new ExperimentManagerWindow(LauncherUtils.getLauncherWindow());
        if (window.showDialog()) {
            LauncherUtils.log("Requesting restart via exit code 237...");
            System.exit(237);
        }
    }

    @Override
    protected void init() {
        SentinelDefaultExperiments.registerExperiments(implementation);
    }

    @Override
    protected void saveExperimentConfig(JsonObject config) throws IOException {
        Files.writeString(Path.of("experiments.json", new String[0]), (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)config), new OpenOption[0]);
    }

    @Override
    protected JsonObject loadExperimentConfig() throws IOException {
        if (!new File("experiments.json").exists()) {
            return new JsonObject();
        }
        return JsonParser.parseString((String)Files.readString(Path.of("experiments.json", new String[0]))).getAsJsonObject();
    }

    @Override
    protected void saveExperimentCache(JsonObject config) throws IOException {
        new File("cache").mkdirs();
        Files.writeString(Path.of("cache/experiments.json", new String[0]), (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)config), new OpenOption[0]);
    }

    @Override
    protected JsonObject loadExperimentCache() throws IOException {
        if (!new File("cache/experiments.json").exists()) {
            return new JsonObject();
        }
        return JsonParser.parseString((String)Files.readString(Path.of("cache/experiments.json", new String[0]))).getAsJsonObject();
    }
}

