/*
 * Decompiled with CFR 0.152.
 */
package org.asf.razorwhip.sentinel.launcher.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import org.asf.razorwhip.sentinel.launcher.LauncherUtils;

public class HashArchiveTool {
    public static void main(String[] args) throws IOException {
        if (args.length < 2 || !new File(args[0]).exists() || !new File(args[0]).isDirectory()) {
            System.err.println("Usage: sentinel-hash-archive \"<archive-path>\" \"<output-path>\"");
            System.err.println("Example: sentinel-hash-archive \"/examplearchive/assets\" \"/examplearchive/descriptorroot/hashes.shl\"");
            System.exit(1);
            return;
        }
        File p = new File(args[1]).getParentFile();
        if (p != null) {
            p.mkdirs();
        }
        FileOutputStream fO = new FileOutputStream(new File(args[1]));
        HashArchiveTool.hashFolder(new File(args[0]), fO, "");
        fO.close();
        System.out.println("Done.");
    }

    private static void hashFolder(File source, FileOutputStream outputFile, String prefix) throws IOException {
        System.out.println("Hashing /" + prefix);
        for (File dir : source.listFiles(t -> t.isDirectory())) {
            HashArchiveTool.hashFolder(dir, outputFile, prefix + dir.getName() + "/");
        }
        for (File f : source.listFiles(t -> !t.isDirectory())) {
            System.out.println("Hashing /" + prefix + f.getName());
            String hash = LauncherUtils.sha512Hash(Files.readAllBytes(f.toPath()));
            Object name = prefix + f.getName();
            name = ((String)name).replace(";", ";sl;").replace(":", ";cl;").replace(" ", ";sp;");
            outputFile.write(((String)name + ": " + hash + "\n").getBytes("UTF-8"));
        }
    }
}

