/*
 * Decompiled with CFR 0.152.
 */
package org.asf.razorwhip.sentinel.launcher.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.asf.razorwhip.sentinel.launcher.LauncherUtils;

public class SignPackageTool {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (args.length < 1 || !new File(args[0]).exists()) {
            System.err.println("Usage: sentinel-sign \"<package-file>\"");
            System.exit(1);
            return;
        }
        try {
            ZipFile zip = new ZipFile(args[0]);
            if (zip.getEntry("SENTINEL.PACKAGEKEY.PEM") != null) {
                System.err.println("Error: the file you supplied already contains a signing key, please make sure the package is unsigned");
                System.exit(1);
                zip.close();
                return;
            }
            if (zip.getEntry("SENTINEL.PACKAGESIGNATURE.SIG") != null) {
                System.err.println("Error: the file you supplied already contains a signature, please make sure the package is unsigned");
                System.exit(1);
                zip.close();
                return;
            }
            zip.close();
        }
        catch (Exception e) {
            System.err.println("Error: the file you supplied is not a valid package file");
            System.exit(1);
            return;
        }
        File input = new File(args[0]);
        File publicKey = new File(input.getParentFile() == null ? new File(".") : input.getParentFile(), "publickey.pem");
        File privateKey = new File(input.getParentFile() == null ? new File(".") : input.getParentFile(), "privatekey.pem");
        if (!publicKey.exists() || !privateKey.exists()) {
            KeyPair pair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
            Files.writeString(publicKey.toPath(), (CharSequence)SignPackageTool.pemEncode(pair.getPublic().getEncoded(), "PUBLIC"), new OpenOption[0]);
            Files.writeString(privateKey.toPath(), (CharSequence)SignPackageTool.pemEncode(pair.getPrivate().getEncoded(), "PRIVATE"), new OpenOption[0]);
        }
        KeyFactory fac = KeyFactory.getInstance("RSA");
        PrivateKey privKey = fac.generatePrivate(new PKCS8EncodedKeySpec(SignPackageTool.pemDecode(Files.readString(privateKey.toPath()))));
        PublicKey pubKey = fac.generatePublic(new X509EncodedKeySpec(SignPackageTool.pemDecode(Files.readString(publicKey.toPath()))));
        String pubKeyPem = SignPackageTool.pemEncode(pubKey.getEncoded(), "PUBLIC");
        String name = input.getAbsolutePath();
        String extension = "";
        if (name.contains(".")) {
            extension = name.substring(name.lastIndexOf("."));
            name = name.substring(0, name.lastIndexOf("."));
        }
        FileOutputStream fO = new FileOutputStream(new File(name + "-signed" + extension));
        ZipOutputStream zO = new ZipOutputStream(fO);
        FileInputStream fIn = new FileInputStream(input);
        ZipInputStream zIn = new ZipInputStream(fIn);
        try {
            byte[] data;
            int i;
            System.out.println("Copying archive...");
            ZipEntry entry = zIn.getNextEntry();
            while (entry != null) {
                zO.putNextEntry(entry);
                if (!entry.getName().replace("\\", "/").endsWith("/")) {
                    zIn.transferTo(zO);
                }
                zO.closeEntry();
                entry = zIn.getNextEntry();
            }
            ZipEntry keyEntry = new ZipEntry("SENTINEL.PACKAGEKEY.PEM");
            zO.putNextEntry(keyEntry);
            zO.write(pubKeyPem.getBytes("UTF-8"));
            zO.closeEntry();
            zO.close();
            fO.close();
            Signature s = Signature.getInstance("Sha512WithRSA");
            s.initSign(privKey);
            System.out.println("Signing archive...");
            FileInputStream fIn2 = new FileInputStream(new File(name + "-signed" + extension));
            while ((i = fIn2.read(data = new byte[20480])) > 0) {
                s.update(data, 0, i);
            }
            fIn2.close();
            byte[] sig = s.sign();
            System.out.println("Modifying archive...");
            System.out.println("Copying archive entries...");
            zIn.close();
            fIn.close();
            fIn = new FileInputStream(input);
            zIn = new ZipInputStream(fIn);
            fO = new FileOutputStream(new File(name + "-signed" + extension));
            zO = new ZipOutputStream(fO);
            entry = zIn.getNextEntry();
            while (entry != null) {
                zO.putNextEntry(entry);
                if (!entry.getName().replace("\\", "/").endsWith("/")) {
                    zIn.transferTo(zO);
                }
                zO.closeEntry();
                entry = zIn.getNextEntry();
            }
            System.out.println("Adding key to archive...");
            zO.putNextEntry(keyEntry);
            zO.write(pubKeyPem.getBytes("UTF-8"));
            zO.closeEntry();
            System.out.println("Adding signature to archive...");
            ZipEntry sigEntry = new ZipEntry("SENTINEL.PACKAGESIGNATURE.SIG");
            zO.putNextEntry(sigEntry);
            zO.write(sig);
            zO.closeEntry();
            zO.close();
            fO.close();
            System.out.println("Signature: " + LauncherUtils.bytesToHex(sig));
        }
        finally {
            zIn.close();
            fIn.close();
        }
    }

    private static byte[] pemDecode(String pem) {
        String base64 = pem.replace("\r", "");
        while (base64.startsWith("-")) {
            base64 = base64.substring(1);
        }
        while (!base64.startsWith("-")) {
            base64 = base64.substring(1);
        }
        while (base64.startsWith("-")) {
            base64 = base64.substring(1);
        }
        base64 = base64.replace("\n", "");
        while (base64.endsWith("-")) {
            base64 = base64.substring(0, base64.length() - 1);
        }
        while (!base64.endsWith("-")) {
            base64 = base64.substring(0, base64.length() - 1);
        }
        while (base64.endsWith("-")) {
            base64 = base64.substring(0, base64.length() - 1);
        }
        return Base64.getDecoder().decode(base64);
    }

    private static String pemEncode(byte[] key, String type) {
        boolean done;
        String PEM = "-----BEGIN " + type + " KEY-----";
        String base64 = new String(Base64.getEncoder().encode(key));
        block0: do {
            PEM = PEM + "\n";
            done = false;
            for (int i = 0; i < 64; ++i) {
                if (base64.isEmpty()) {
                    done = true;
                    continue block0;
                }
                PEM = PEM + base64.substring(0, 1);
                base64 = base64.substring(1);
            }
        } while (!base64.isEmpty() && !done);
        PEM = PEM + "\n";
        PEM = PEM + "-----END " + type + " KEY-----";
        return PEM;
    }
}

