/*
 * Decompiled with CFR 0.152.
 */
package org.asf.razorwhip.sentinel.launcher.tools;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;

public class SignSACConfigTool {
    public static void main(String[] args) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (args.length < 1 || !new File(args[0]).exists()) {
            System.err.println("Usage: sentinel-sign-sacconfig \"<config-file>\"");
            System.exit(1);
            return;
        }
        File input = new File(args[0]);
        File publicKey = new File(input.getParentFile() == null ? new File(".") : input.getParentFile(), "publickey.pem");
        File privateKey = new File(input.getParentFile() == null ? new File(".") : input.getParentFile(), "privatekey.pem");
        if (!publicKey.exists() || !privateKey.exists()) {
            KeyPair pair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
            Files.writeString(publicKey.toPath(), (CharSequence)SignSACConfigTool.pemEncode(pair.getPublic().getEncoded(), "PUBLIC"), new OpenOption[0]);
            Files.writeString(privateKey.toPath(), (CharSequence)SignSACConfigTool.pemEncode(pair.getPrivate().getEncoded(), "PRIVATE"), new OpenOption[0]);
        }
        KeyFactory fac = KeyFactory.getInstance("RSA");
        PrivateKey privKey = fac.generatePrivate(new PKCS8EncodedKeySpec(SignSACConfigTool.pemDecode(Files.readString(privateKey.toPath()))));
        Signature s = Signature.getInstance("Sha512WithRSA");
        s.initSign(privKey);
        String data = Files.readString(input.toPath()).replace("\r", "");
        s.update(data.getBytes("UTF-8"));
        byte[] sig = s.sign();
        Files.write(new File(args[0] + ".sig").toPath(), sig, new OpenOption[0]);
    }

    private static byte[] pemDecode(String pem) {
        String base64 = pem.replace("\r", "");
        while (base64.startsWith("-")) {
            base64 = base64.substring(1);
        }
        while (!base64.startsWith("-")) {
            base64 = base64.substring(1);
        }
        while (base64.startsWith("-")) {
            base64 = base64.substring(1);
        }
        base64 = base64.replace("\n", "");
        while (base64.endsWith("-")) {
            base64 = base64.substring(0, base64.length() - 1);
        }
        while (!base64.endsWith("-")) {
            base64 = base64.substring(0, base64.length() - 1);
        }
        while (base64.endsWith("-")) {
            base64 = base64.substring(0, base64.length() - 1);
        }
        return Base64.getDecoder().decode(base64);
    }

    private static String pemEncode(byte[] key, String type) {
        boolean done;
        String PEM = "-----BEGIN " + type + " KEY-----";
        String base64 = new String(Base64.getEncoder().encode(key));
        block0: do {
            PEM = PEM + "\n";
            done = false;
            for (int i = 0; i < 64; ++i) {
                if (base64.isEmpty()) {
                    done = true;
                    continue block0;
                }
                PEM = PEM + base64.substring(0, 1);
                base64 = base64.substring(1);
            }
        } while (!base64.isEmpty() && !done);
        PEM = PEM + "\n";
        PEM = PEM + "-----END " + type + " KEY-----";
        return PEM;
    }
}

