/*
 * Decompiled with CFR 0.152.
 */
package org.asf.razorwhip.sentinel.launcher.windows;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ArchiveCreationWindow {
    public JDialog frmCreateArchive;
    private JTextField archiveNameField;
    private JTextField creditsField;
    private CreationResult result;
    private JTextField archiveUrlField;

    public ArchiveCreationWindow() {
        this.initialize();
    }

    public CreationResult show(JDialog parent) {
        this.frmCreateArchive.dispose();
        this.frmCreateArchive = parent == null ? new JDialog() : new JDialog(parent);
        this.initialize();
        this.frmCreateArchive.setModal(true);
        this.frmCreateArchive.setLocationRelativeTo(null);
        this.frmCreateArchive.setLocationRelativeTo(parent);
        this.frmCreateArchive.setVisible(true);
        return this.result;
    }

    private void initialize() {
        this.frmCreateArchive = new JDialog();
        this.frmCreateArchive.setTitle("Archive Creation");
        this.frmCreateArchive.setBounds(100, 100, 528, 355);
        this.frmCreateArchive.setDefaultCloseOperation(2);
        this.frmCreateArchive.getContentPane().setLayout(new FlowLayout(1, 5, 5));
        this.frmCreateArchive.setLocationRelativeTo(null);
        this.frmCreateArchive.setResizable(false);
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(500, 315));
        this.frmCreateArchive.getContentPane().add(panel);
        panel.setLayout(null);
        JLabel lbl = new JLabel("Create archive details");
        lbl.setFont(new Font("Dialog", 1, 14));
        lbl.setHorizontalAlignment(0);
        lbl.setBounds(12, 12, 476, 35);
        panel.add(lbl);
        JLabel lblArchiveUrl = new JLabel("Archive URL");
        lblArchiveUrl.setBounds(12, 56, 476, 17);
        panel.add(lblArchiveUrl);
        this.archiveUrlField = new JTextField();
        this.archiveUrlField.setBounds(12, 74, 476, 21);
        panel.add(this.archiveUrlField);
        JLabel lblName = new JLabel("Archive name");
        lblName.setBounds(12, 103, 476, 17);
        panel.add(lblName);
        this.archiveNameField = new JTextField();
        this.archiveNameField.setBounds(12, 121, 476, 21);
        panel.add(this.archiveNameField);
        JLabel lblCredits = new JLabel("Hosting credits (optional, place your name or organization here)");
        lblCredits.setBounds(12, 150, 476, 17);
        panel.add(lblCredits);
        this.creditsField = new JTextField();
        this.creditsField.setBounds(12, 168, 476, 21);
        panel.add(this.creditsField);
        final JButton btnNewButton = new JButton("Create");
        this.archiveUrlField.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                btnNewButton.doClick();
            }
        });
        this.archiveNameField.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                btnNewButton.doClick();
            }
        });
        this.creditsField.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                btnNewButton.doClick();
            }
        });
        btnNewButton.setBounds(346, 276, 142, 27);
        panel.add(btnNewButton);
        JButton btnNewButton_1 = new JButton("Cancel");
        btnNewButton_1.setBounds(229, 276, 105, 27);
        panel.add(btnNewButton_1);
        final JCheckBox chckbxAllowArchiveDownloads = new JCheckBox("Allow archive downloads");
        chckbxAllowArchiveDownloads.setSelected(true);
        chckbxAllowArchiveDownloads.setBounds(8, 199, 480, 25);
        panel.add(chckbxAllowArchiveDownloads);
        final JCheckBox chckbxAllowStreaming = new JCheckBox("Allow streaming of assets");
        chckbxAllowStreaming.setSelected(true);
        chckbxAllowStreaming.setBounds(8, 228, 480, 25);
        panel.add(chckbxAllowStreaming);
        btnNewButton_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArchiveCreationWindow.this.frmCreateArchive.dispose();
            }
        });
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ArchiveCreationWindow.this.archiveNameField.getText().isEmpty()) {
                    JOptionPane.showMessageDialog(ArchiveCreationWindow.this.frmCreateArchive, "Missing archive name", "Missing details", 0);
                    return;
                }
                if (ArchiveCreationWindow.this.archiveUrlField.getText().isEmpty()) {
                    JOptionPane.showMessageDialog(ArchiveCreationWindow.this.frmCreateArchive, "Missing archive URL", "Missing details", 0);
                    return;
                }
                if (!chckbxAllowStreaming.isSelected() && !chckbxAllowArchiveDownloads.isSelected()) {
                    JOptionPane.showMessageDialog(ArchiveCreationWindow.this.frmCreateArchive, "Please allow either streaming or download, you cannot have both disabled.", "Missing details", 0);
                    return;
                }
                ArchiveCreationWindow.this.result = new CreationResult();
                ArchiveCreationWindow.this.result.archiveURL = ArchiveCreationWindow.this.archiveUrlField.getText();
                ArchiveCreationWindow.this.result.archiveName = ArchiveCreationWindow.this.archiveNameField.getText();
                ArchiveCreationWindow.this.result.creditsField = ArchiveCreationWindow.this.creditsField.getText();
                if (ArchiveCreationWindow.this.result.creditsField.isEmpty()) {
                    ArchiveCreationWindow.this.result.creditsField = null;
                }
                ArchiveCreationWindow.this.result.allowDownload = chckbxAllowArchiveDownloads.isSelected();
                ArchiveCreationWindow.this.result.allowStreaming = chckbxAllowStreaming.isSelected();
                ArchiveCreationWindow.this.frmCreateArchive.dispose();
            }
        });
    }

    public static class CreationResult {
        public String archiveURL;
        public String archiveName;
        public String creditsField;
        public boolean allowStreaming;
        public boolean allowDownload;
    }
}

