/*
 * Decompiled with CFR 0.152.
 */
package org.asf.razorwhip.sentinel.launcher.windows;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.LinkedHashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListDataListener;
import org.asf.razorwhip.sentinel.launcher.experiments.ExperimentManager;

public class ExperimentManagerWindow
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JList<ExperimentEntry> experimentListBox;
    private JButton btnOk;
    private LinkedHashMap<String, ExperimentEntry> experiments = new LinkedHashMap();
    private boolean wasCancelled = true;

    public ExperimentManagerWindow() {
        this.initialize();
    }

    public ExperimentManagerWindow(JFrame parent) {
        super(parent);
        this.initialize();
        this.setLocationRelativeTo(parent);
    }

    public boolean showDialog() {
        this.refreshExperimentList();
        this.setVisible(true);
        return !this.wasCancelled;
    }

    private void initialize() {
        this.setTitle("Experiment manager");
        this.setBounds(100, 100, 600, 659);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setModal(true);
        this.getContentPane().setLayout(new FlowLayout(1, 5, 5));
        JPanel panelMain = new JPanel();
        panelMain.setPreferredSize(new Dimension(590, 615));
        this.getContentPane().add(panelMain);
        panelMain.setLayout(null);
        final JPanel panelExperiments = new JPanel();
        panelMain.add(panelExperiments);
        panelExperiments.setLayout(null);
        panelExperiments.setVisible(ExperimentManager.getInstance().isEnabled());
        panelExperiments.setBounds(0, 0, 590, 615);
        final JPanel panelExperimentsDisabled = new JPanel();
        panelMain.add(panelExperimentsDisabled);
        panelExperimentsDisabled.setLayout(null);
        panelExperimentsDisabled.setVisible(!ExperimentManager.getInstance().isEnabled());
        panelExperimentsDisabled.setBounds(0, 0, 590, 615);
        JLabel lblNewLabel_1 = new JLabel("Experimental features are not enabled");
        lblNewLabel_1.setHorizontalAlignment(0);
        lblNewLabel_1.setBounds(12, 169, 566, 54);
        panelExperimentsDisabled.add(lblNewLabel_1);
        JButton btnCancel_1 = new JButton("Cancel");
        btnCancel_1.setBounds(12, 576, 105, 27);
        panelExperimentsDisabled.add(btnCancel_1);
        btnCancel_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExperimentManagerWindow.this.dispose();
            }
        });
        JButton btnNewButton = new JButton("Enable experimental features");
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JOptionPane.showConfirmDialog(ExperimentManagerWindow.this, "WARNING!\n\nExperimenal features, while allowing you access to work-in-progress features and mechanics,\nare by nature unstable! Enabling them may lead to unwanted issues with your game!\n\nPlease note that we do not actively support all experimental features, if you encounter issues,\nplease disable all experimental features and trying again before creating bug reports.", "Enabling experimental features", 2, 2) != 0) {
                    return;
                }
                if (JOptionPane.showConfirmDialog(ExperimentManagerWindow.this, "Enable experimental features?", "Enabling experimental features", 0, 3) != 0) {
                    return;
                }
                if (JOptionPane.showConfirmDialog(ExperimentManagerWindow.this, "Experimental features will be enabled!\n\nPress OK to proceed.", "Enabling experimental features", 2, 2) != 0) {
                    return;
                }
                try {
                    ExperimentManager.getInstance().enable();
                }
                catch (IOException e1) {
                    throw new RuntimeException(e1);
                }
                panelExperimentsDisabled.setVisible(false);
                panelExperiments.setVisible(true);
            }
        });
        btnNewButton.setBounds(32, 235, 517, 45);
        panelExperimentsDisabled.add(btnNewButton);
        JLabel lblNewLabel = new JLabel("Experiments");
        lblNewLabel.setBounds(12, 12, 566, 17);
        panelExperiments.add(lblNewLabel);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBorder(new BevelBorder(1, null, null, null, null));
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setBounds(12, 33, 566, 531);
        panelExperiments.add(scrollPane);
        this.btnOk = new JButton("Ok");
        this.btnOk.setBounds(473, 576, 105, 27);
        panelExperiments.add(this.btnOk);
        JButton btnCancel = new JButton("Cancel");
        btnCancel.setBounds(12, 576, 105, 27);
        panelExperiments.add(btnCancel);
        this.experimentListBox = new JList();
        this.experimentListBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32 || e.getKeyCode() == 10) {
                    e.consume();
                    if (ExperimentManagerWindow.this.experimentListBox.getSelectedValue() != null) {
                        ExperimentEntry entry = ExperimentManagerWindow.this.experimentListBox.getSelectedValue();
                        entry.enabled = !entry.enabled;
                        entry.box.setEnabled(entry.enabled);
                        ExperimentManagerWindow.this.experimentListBox.repaint();
                    }
                }
            }
        });
        this.experimentListBox.addMouseListener(new MouseAdapter(){

            @Override
            public synchronized void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() >= 1) {
                    Point mouse = evt.getPoint();
                    int index = ExperimentManagerWindow.this.experimentListBox.locationToIndex(mouse);
                    Point l = ExperimentManagerWindow.this.experimentListBox.indexToLocation(index);
                    if (index >= 0 && index < ExperimentManagerWindow.this.experiments.size()) {
                        Rectangle bounds = ExperimentManagerWindow.this.experimentListBox.getCellBounds(index, index);
                        ExperimentEntry entry = ExperimentManagerWindow.this.experiments.values().toArray(new ExperimentEntry[0])[index];
                        if (ExperimentManagerWindow.this.experimentListBox.getSelectedValue() == entry && entry.timeSelect != -1L && (System.currentTimeMillis() - entry.timeSelect >= 250L || evt.getClickCount() >= 2) && l.y + bounds.height >= mouse.y) {
                            entry.enabled = !entry.enabled;
                            entry.box.setEnabled(entry.enabled);
                            ExperimentManagerWindow.this.experimentListBox.repaint();
                        }
                    }
                }
            }
        });
        this.experimentListBox.setSelectionMode(0);
        this.experimentListBox.setCellRenderer(new ListCellRenderer<ExperimentEntry>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends ExperimentEntry> list, ExperimentEntry entry, int index, boolean selected, boolean cellHasFocus) {
                entry.box.setComponentOrientation(list.getComponentOrientation());
                entry.box.setFont(list.getFont());
                entry.box.setBackground(list.getBackground());
                if (cellHasFocus) {
                    entry.box.setForeground(SystemColor.blue);
                    entry.timeSelect = System.currentTimeMillis();
                } else {
                    entry.box.setForeground(SystemColor.black);
                    entry.timeSelect = -1L;
                }
                entry.box.setSelected(entry.enabled);
                entry.box.setEnabled(true);
                return entry.box;
            }
        });
        scrollPane.setViewportView(this.experimentListBox);
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExperimentManagerWindow.this.dispose();
            }
        });
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String[] experimentLst;
                    for (String experiment : experimentLst = ExperimentManager.getInstance().getExperiments()) {
                        if (!ExperimentManagerWindow.this.experiments.containsKey(experiment)) continue;
                        ExperimentManager.getInstance().setExperimentEnabled(experiment, ExperimentManagerWindow.this.experiments.get((Object)experiment).enabled);
                    }
                    ExperimentManager.getInstance().saveConfig();
                    ExperimentManagerWindow.this.wasCancelled = false;
                    ExperimentManagerWindow.this.dispose();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    private void refreshExperimentList() {
        String[] experimentLst;
        this.experiments.clear();
        for (String experiment : experimentLst = ExperimentManager.getInstance().getExperiments()) {
            ExperimentEntry payload = new ExperimentEntry();
            payload.key = experiment;
            payload.name = ExperimentManager.getInstance().getExperimentName(experiment);
            payload.enabled = ExperimentManager.getInstance().isExperimentEnabled(experiment);
            payload.box = new JCheckBox(payload.name);
            this.experiments.put(payload.key, payload);
        }
        this.experimentListBox.setModel(new ListModel<ExperimentEntry>(){

            @Override
            public int getSize() {
                return ExperimentManagerWindow.this.experiments.size();
            }

            @Override
            public ExperimentEntry getElementAt(int index) {
                return ((ExperimentEntry[])ExperimentManagerWindow.this.experiments.values().toArray(ExperimentEntry[]::new))[index];
            }

            @Override
            public void addListDataListener(ListDataListener l) {
            }

            @Override
            public void removeListDataListener(ListDataListener l) {
            }
        });
    }

    private class ExperimentEntry {
        public String key;
        public String name;
        public long timeSelect;
        public boolean enabled;
        public JCheckBox box;

        private ExperimentEntry() {
        }
    }
}

