/*
 * Decompiled with CFR 0.152.
 */
package org.asf.razorwhip.sentinel.launcher.windows;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.asf.razorwhip.sentinel.launcher.LauncherUtils;
import org.asf.razorwhip.sentinel.launcher.api.PayloadType;

public class PayloadManagerWindow
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JList<PayloadEntry> payloadListBox;
    private JButton btnOk;
    private LinkedHashMap<String, PayloadEntry> payloads = new LinkedHashMap();
    private boolean wasCancelled = true;
    private JsonObject lastIndex = new JsonObject();

    public PayloadManagerWindow() {
        this.initialize();
    }

    public PayloadManagerWindow(JFrame parent) {
        super(parent);
        this.initialize();
        this.setLocationRelativeTo(parent);
    }

    public boolean showDialog() throws IOException {
        this.payloads.clear();
        JsonObject index = new JsonObject();
        if (new File("activepayloads.json").exists()) {
            index = JsonParser.parseString((String)Files.readString(Path.of("activepayloads.json", new String[0]))).getAsJsonObject();
        }
        for (File spf : new File("payloads").listFiles(t -> t.isFile() && t.getName().endsWith(".spf"))) {
            boolean enabled = index.has(spf.getName()) && index.get(spf.getName()).getAsBoolean();
            Map<String, String> descriptor = LauncherUtils.parseProperties(this.getStringFrom(spf, "payloadinfo"));
            PayloadEntry payload = new PayloadEntry();
            payload.id = spf.getName();
            payload.name = spf.getName();
            payload.version = "default";
            payload.file = spf.getName();
            payload.enabled = enabled;
            String type = "Full";
            if (descriptor.containsKey("Type")) {
                type = descriptor.get("Type");
            }
            if (!(type = type.toLowerCase()).equals("resource") && !type.equals("full")) {
                index.remove(spf.getName());
                continue;
            }
            PayloadType payloadType = payload.type = type.equals("resource") ? PayloadType.RESOURCE : PayloadType.PAYLOAD;
            if (descriptor.containsKey("Payload-ID")) {
                payload.name = payload.id = descriptor.get("Payload-ID");
            }
            if (descriptor.containsKey("Payload-Name")) {
                payload.name = descriptor.get("Payload-Name");
            }
            if (descriptor.containsKey("Payload-Version")) {
                payload.version = descriptor.get("Payload-Version");
            }
            if (descriptor.containsKey("Game-ID") && !descriptor.get("Game-ID").equalsIgnoreCase(LauncherUtils.getGameID())) {
                index.remove(spf.getName());
                continue;
            }
            if (descriptor.containsKey("Software-ID") && !descriptor.get("Software-ID").equalsIgnoreCase(LauncherUtils.getSoftwareID())) {
                index.remove(spf.getName());
                continue;
            }
            payload.dependencies = new PayloadDependency[0];
            payload.conflictsWith = new PayloadDependency[0];
            try {
                JsonObject dep;
                JsonObject depsConfig = JsonParser.parseString((String)this.getStringFrom(spf, "dependencies.json")).getAsJsonObject();
                ArrayList<PayloadDependency> deps = new ArrayList<PayloadDependency>();
                ArrayList<PayloadDependency> conflicts = new ArrayList<PayloadDependency>();
                if (depsConfig.has("dependencies")) {
                    for (JsonElement ele : depsConfig.get("dependencies").getAsJsonArray()) {
                        dep = ele.getAsJsonObject();
                        PayloadDependency dependency = new PayloadDependency();
                        dependency.id = dep.get("id").getAsString();
                        if (dep.has("version")) {
                            dependency.version = dep.get("version").getAsString();
                            dependency.versionString = dep.has("versionString") ? dep.get("versionString").getAsString() : dependency.version;
                        }
                        if (dep.has("url")) {
                            dependency.url = dep.get("url").getAsString();
                        }
                        deps.add(dependency);
                    }
                }
                if (depsConfig.has("conflicts")) {
                    for (JsonElement ele : depsConfig.get("conflicts").getAsJsonArray()) {
                        dep = ele.getAsJsonObject();
                        PayloadDependency conflict = new PayloadDependency();
                        conflict.id = dep.get("id").getAsString();
                        if (dep.has("version")) {
                            conflict.version = dep.get("version").getAsString();
                        }
                        conflicts.add(conflict);
                    }
                }
                payload.dependencies = (PayloadDependency[])deps.toArray(PayloadDependency[]::new);
                payload.conflictsWith = (PayloadDependency[])conflicts.toArray(PayloadDependency[]::new);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            payload.box = new JCheckBox(payload.name + " (" + payload.type.toString().toLowerCase() + ")");
            if (this.payloads.containsKey(payload.id)) {
                JOptionPane.showMessageDialog(this, "WARNING! Payload conflict detected!\n\nPayload ID: " + payload.id + "\nTwo or more files provide this payload ID.\n\nFile 1: " + this.payloads.get((Object)payload.id).file + "\nFile 2: " + payload.file + "\n\nThe first file will be used.", "Warning", 2);
                index.remove(spf.getName());
                continue;
            }
            this.payloads.put(payload.id, payload);
        }
        this.lastIndex = index;
        this.refreshPayloadList();
        this.setVisible(true);
        return !this.wasCancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStringFrom(File file, String entry) throws IOException {
        if (file.isDirectory()) {
            FileInputStream strm = new FileInputStream(new File(file, entry));
            String res = new String(strm.readAllBytes(), "UTF-8");
            strm.close();
            return res;
        }
        try (ZipFile f = new ZipFile(file);){
            ZipEntry ent = f.getEntry(entry);
            if (ent == null) {
                throw new FileNotFoundException("Entry " + entry + " not found in " + file);
            }
            InputStream strm = f.getInputStream(ent);
            String res = new String(strm.readAllBytes(), "UTF-8");
            strm.close();
            String string = res;
            return string;
        }
    }

    private void initialize() {
        this.setTitle("Payload manager");
        this.setBounds(100, 100, 600, 360);
        this.setDefaultCloseOperation(0);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setModal(true);
        this.getContentPane().setLayout(new FlowLayout(1, 5, 5));
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(590, 315));
        this.getContentPane().add(panel);
        panel.setLayout(null);
        this.btnOk = new JButton("Ok");
        this.btnOk.setBounds(473, 276, 105, 27);
        panel.add(this.btnOk);
        JButton btnCancel = new JButton("Cancel");
        btnCancel.setBounds(356, 276, 105, 27);
        panel.add(btnCancel);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBorder(new BevelBorder(1, null, null, null, null));
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setBounds(12, 33, 566, 189);
        panel.add(scrollPane);
        this.payloadListBox = new JList();
        this.payloadListBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32 || e.getKeyCode() == 10) {
                    e.consume();
                    if (PayloadManagerWindow.this.payloadListBox.getSelectedValue() != null) {
                        PayloadEntry entry = PayloadManagerWindow.this.payloadListBox.getSelectedValue();
                        entry.enabled = !entry.enabled;
                        entry.box.setEnabled(entry.enabled);
                        PayloadManagerWindow.this.payloadListBox.repaint();
                        if (entry.enabled) {
                            PayloadManagerWindow.this.enableDependencies(entry);
                        } else {
                            PayloadManagerWindow.this.disableDependent(entry);
                        }
                    }
                }
            }
        });
        this.payloadListBox.addMouseListener(new MouseAdapter(){

            @Override
            public synchronized void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() >= 1) {
                    Point mouse = evt.getPoint();
                    int index = PayloadManagerWindow.this.payloadListBox.locationToIndex(mouse);
                    Point l = PayloadManagerWindow.this.payloadListBox.indexToLocation(index);
                    if (index >= 0 && index < PayloadManagerWindow.this.payloads.size()) {
                        Rectangle bounds = PayloadManagerWindow.this.payloadListBox.getCellBounds(index, index);
                        PayloadEntry entry = PayloadManagerWindow.this.payloads.values().toArray(new PayloadEntry[0])[index];
                        if (PayloadManagerWindow.this.payloadListBox.getSelectedValue() == entry && entry.timeSelect != -1L && (System.currentTimeMillis() - entry.timeSelect >= 250L || evt.getClickCount() >= 2) && l.y + bounds.height >= mouse.y) {
                            entry.enabled = !entry.enabled;
                            entry.box.setEnabled(entry.enabled);
                            PayloadManagerWindow.this.payloadListBox.repaint();
                            if (entry.enabled) {
                                PayloadManagerWindow.this.enableDependencies(entry);
                            } else {
                                PayloadManagerWindow.this.disableDependent(entry);
                            }
                        }
                    }
                }
            }
        });
        this.payloadListBox.setSelectionMode(0);
        this.payloadListBox.setCellRenderer(new ListCellRenderer<PayloadEntry>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends PayloadEntry> list, PayloadEntry entry, int index, boolean selected, boolean cellHasFocus) {
                entry.box.setComponentOrientation(list.getComponentOrientation());
                entry.box.setFont(list.getFont());
                entry.box.setBackground(list.getBackground());
                if (cellHasFocus) {
                    entry.box.setForeground(SystemColor.blue);
                    entry.timeSelect = System.currentTimeMillis();
                } else {
                    entry.box.setForeground(SystemColor.black);
                    entry.timeSelect = -1L;
                }
                entry.box.setSelected(entry.enabled);
                entry.box.setEnabled(true);
                return entry.box;
            }
        });
        scrollPane.setViewportView(this.payloadListBox);
        JLabel lblNewLabel = new JLabel("Payloads");
        lblNewLabel.setBounds(12, 12, 566, 17);
        panel.add(lblNewLabel);
        JButton btnAdd = new JButton("Add payload...");
        btnAdd.setBounds(422, 234, 156, 27);
        panel.add(btnAdd);
        final JButton btnRemove = new JButton("Delete");
        btnRemove.setEnabled(false);
        btnRemove.setBounds(12, 234, 105, 27);
        panel.add(btnRemove);
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JsonObject newIndex = new JsonObject();
                for (PayloadEntry payload : PayloadManagerWindow.this.payloads.values()) {
                    newIndex.addProperty(payload.file, Boolean.valueOf(payload.enabled));
                }
                if (!newIndex.toString().equals(PayloadManagerWindow.this.lastIndex.toString()) && JOptionPane.showConfirmDialog(PayloadManagerWindow.this, "Are you sure you want to close the payload manager without saving?", "Warning", 0, 2) != 0) {
                    return;
                }
                PayloadManagerWindow.this.dispose();
            }
        });
        this.btnOk.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    boolean allPassed;
                    do {
                        allPassed = true;
                        for (PayloadEntry payload : PayloadManagerWindow.this.payloads.values()) {
                            if (!payload.enabled) continue;
                            for (PayloadDependency dep : payload.dependencies) {
                                while (!PayloadManagerWindow.this.payloads.containsKey(dep.id)) {
                                    allPassed = false;
                                    if (dep.url == null) {
                                        JOptionPane.showMessageDialog(PayloadManagerWindow.this, "Missing payload dependencies!\n\nPayload ID: " + payload.id + "\nPayload file: " + payload.file + "\n\nMissing dependency: " + dep.id + "\n\nUnable to save at this time, please resolve these issues.", "Missing dependencies", 0);
                                        return;
                                    }
                                    if (JOptionPane.showConfirmDialog(PayloadManagerWindow.this, "Missing payload dependencies were detected.\n\nPayload ID: " + payload.id + "\nPayload file: " + payload.file + "\n\nMissing dependency: " + dep.id + "\n\nDo you wish to download this payload file?\nIf you select no, saving will be cancelled.", "Missing dependencies", 0, 3) != 0) {
                                        return;
                                    }
                                    if (JOptionPane.showConfirmDialog(PayloadManagerWindow.this, "Payload will be downloaded, this may take a bit...\n\nPress OK to start downloading.", "Payload download", 2, 1) == 2) continue;
                                    try {
                                        URL u = new URL(dep.url);
                                        File tempOut = File.createTempFile("payload-download-temp-", ".spf");
                                        try {
                                            InputStream sourceStrm = u.openStream();
                                            FileOutputStream fO = new FileOutputStream(tempOut);
                                            sourceStrm.transferTo(fO);
                                            fO.close();
                                            sourceStrm.close();
                                            PayloadManagerWindow.this.importPayload(tempOut, true);
                                            PayloadManagerWindow.this.payloads.get((Object)dep.id).enabled = true;
                                            PayloadManagerWindow.this.payloads.get((Object)dep.id).box.setSelected(true);
                                        }
                                        finally {
                                            tempOut.delete();
                                        }
                                        JOptionPane.showMessageDialog(PayloadManagerWindow.this, "Download success!", "Download status", 1);
                                    }
                                    catch (IOException e2) {
                                        JOptionPane.showMessageDialog(PayloadManagerWindow.this, "Download failed! Unable to save the new payload!", "Download status", 0);
                                        return;
                                    }
                                }
                                PayloadEntry dependency = PayloadManagerWindow.this.payloads.get(dep.id);
                                if (dep.version == null || LauncherUtils.verifyVersionRequirement(dependency.version, dep.version)) continue;
                                allPassed = false;
                                JOptionPane.showMessageDialog(PayloadManagerWindow.this, "Payload dependency mismatch!\n\nPayload ID: " + payload.id + "\nPayload file: " + payload.file + "\n\nFailed dependency: " + dep.id + "\n\nExpected version: " + dep.versionString + "\nCurrent version: " + dependency.version + "\n\nUnable to save at this time, please resolve these issues.", "Dependency mismatch", 0);
                                return;
                            }
                            for (PayloadDependency conflict : payload.conflictsWith) {
                                if (PayloadManagerWindow.this.payloads.containsKey(conflict.id)) {
                                    if (conflict.version != null) continue;
                                    JOptionPane.showMessageDialog(PayloadManagerWindow.this, "Conflict detected!\n\nPayload ID: " + payload.id + "\nPayload name: " + payload.name + "\nPayload file: " + payload.file + "\n\nConflicting payload: " + conflict.id + "\n\nThe payload '" + payload.id + "' cannot run with '" + conflict.id + "' installed!\n\nUnable to save at this time, please resolve these issues.", "Dependency mismatch", 0);
                                    return;
                                }
                                if (LauncherUtils.verifyVersionRequirement(PayloadManagerWindow.this.payloads.get((Object)conflict.id).version, conflict.version)) continue;
                                JOptionPane.showMessageDialog(PayloadManagerWindow.this, "Conflict detected!\n\nPayload ID: " + payload.id + "\nPayload name: " + payload.name + "\nPayload file: " + payload.file + "\n\nConflicting payload: " + conflict.id + "\n\nAffected versions: " + conflict.versionString + "\n\n\nThe payload '" + payload.id + "' cannot run with the current version of '" + conflict.id + "'!\n\nUnable to save at this time, please resolve these issues.", "Dependency mismatch", 0);
                                return;
                            }
                        }
                    } while (!allPassed);
                    JsonObject newIndex = new JsonObject();
                    for (PayloadEntry payload : PayloadManagerWindow.this.payloads.values()) {
                        newIndex.addProperty(payload.file, Boolean.valueOf(payload.enabled));
                    }
                    if (!newIndex.toString().equals(PayloadManagerWindow.this.lastIndex.toString())) {
                        Files.writeString(Path.of("activepayloads.json", new String[0]), (CharSequence)newIndex.toString(), new OpenOption[0]);
                    }
                    PayloadManagerWindow.this.wasCancelled = false;
                    PayloadManagerWindow.this.dispose();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.payloadListBox.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                btnRemove.setEnabled(PayloadManagerWindow.this.payloadListBox.getSelectedValue() != null);
            }
        });
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File spf;
                JFileChooser chooser = new JFileChooser();
                FileFilter filter = new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().endsWith(".spf");
                    }

                    @Override
                    public String getDescription() {
                        return "Sentinel payload files (*.spf)";
                    }
                };
                chooser.addChoosableFileFilter(filter);
                chooser.setFileFilter(filter);
                if (chooser.showDialog(PayloadManagerWindow.this, "Select") == 0 && (spf = chooser.getSelectedFile()) != null) {
                    try {
                        PayloadManagerWindow.this.importPayload(spf, false);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JOptionPane.showConfirmDialog(PayloadManagerWindow.this, "Are you sure you want to remove this payload?\n\nRemoving a payload will delete all the payloads that are dependent on it!", "Warning", 0, 2) != 0) {
                    return;
                }
                PayloadEntry entry = PayloadManagerWindow.this.payloadListBox.getSelectedValue();
                this.removePayload(entry);
                PayloadManagerWindow.this.refreshPayloadList();
            }

            private void removePayload(PayloadEntry payload) {
                PayloadManagerWindow.this.payloads.remove(payload.id);
                for (PayloadEntry dep : (PayloadEntry[])PayloadManagerWindow.this.payloads.values().toArray(PayloadEntry[]::new)) {
                    if (!Stream.of(dep.dependencies).anyMatch(t -> t.id.equals(payload.id))) continue;
                    this.removePayload(dep);
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JsonObject newIndex = new JsonObject();
                for (PayloadEntry payload : PayloadManagerWindow.this.payloads.values()) {
                    newIndex.addProperty(payload.file, Boolean.valueOf(payload.enabled));
                }
                if (!newIndex.toString().equals(PayloadManagerWindow.this.lastIndex.toString()) && JOptionPane.showConfirmDialog(PayloadManagerWindow.this, "Are you sure you want to close the payload manager without saving?", "Warning", 0, 2) != 0) {
                    return;
                }
                PayloadManagerWindow.this.dispose();
            }
        });
    }

    protected boolean importPayload(File spf, boolean throwError) throws IOException {
        try {
            Map<String, String> descriptor = LauncherUtils.parseProperties(this.getStringFrom(spf, "payloadinfo"));
            String type = "Full";
            if (descriptor.containsKey("Type")) {
                type = descriptor.get("Type");
            }
            if (!(type = type.toLowerCase()).equals("resource") && !type.equals("full")) {
                JOptionPane.showMessageDialog(this, "The payload you selected has an invalid type!", "Error", 0);
                return false;
            }
            if (descriptor.containsKey("Game-ID") && !descriptor.get("Game-ID").equalsIgnoreCase(LauncherUtils.getGameID())) {
                if (throwError) {
                    throw new IOException("Incompatible payload");
                }
                JOptionPane.showMessageDialog(this, "The payload you selected is not compatible with the game or emulation software!", "Error", 0);
                return false;
            }
            if (descriptor.containsKey("Software-ID") && !descriptor.get("Software-ID").equalsIgnoreCase(LauncherUtils.getSoftwareID())) {
                if (throwError) {
                    throw new IOException("Incompatible payload");
                }
                JOptionPane.showMessageDialog(this, "The payload you selected is not compatible with the game or emulation software!", "Error", 0);
                return false;
            }
            String id = spf.getName();
            if (descriptor.containsKey("Payload-ID")) {
                id = descriptor.get("Payload-ID");
            }
            if (this.payloads.containsKey(id)) {
                if (throwError) {
                    throw new IOException("Payload conflict");
                }
                JOptionPane.showMessageDialog(this, "The payload you selected is already present!", "Error", 0);
                return false;
            }
            if (LauncherUtils.isPackageSigned(spf) && LauncherUtils.verifyPackageSignature(new File("cache/payloadcache/payloadverificationkeys", id + ".pem"), spf)) {
                LauncherUtils.extractPackagePublicKey(new File("cache/payloadcache/payloadverificationkeys", id + ".pem"), spf);
            } else if (LauncherUtils.isPackageSigned(spf)) {
                if (throwError) {
                    throw new IOException("Incompatible payload");
                }
                JOptionPane.showMessageDialog(this, "Payload signature failed to verify! Please verify the authenticity of this payload!", "Error", 0);
                return false;
            }
            Object name = id.endsWith(".spf") ? id : id + ".spf";
            int i = 1;
            while (new File("payloads", (String)name).exists()) {
                name = id + "-" + i++ + ".spf";
            }
            Files.copy(spf.toPath(), new File("payloads", (String)name).toPath(), new CopyOption[0]);
            spf = new File("payloads", (String)name);
            PayloadEntry payload = new PayloadEntry();
            payload.id = name;
            payload.name = name;
            payload.version = "default";
            payload.file = name;
            payload.enabled = false;
            PayloadType payloadType = payload.type = type.equals("resource") ? PayloadType.RESOURCE : PayloadType.PAYLOAD;
            if (descriptor.containsKey("Payload-ID")) {
                payload.name = payload.id = descriptor.get("Payload-ID");
            }
            if (descriptor.containsKey("Payload-Name")) {
                payload.name = descriptor.get("Payload-Name");
            }
            if (descriptor.containsKey("Payload-Version")) {
                payload.version = descriptor.get("Payload-Version");
            }
            payload.dependencies = new PayloadDependency[0];
            payload.conflictsWith = new PayloadDependency[0];
            try {
                JsonObject dep;
                JsonObject depsConfig = JsonParser.parseString((String)this.getStringFrom(spf, "dependencies.json")).getAsJsonObject();
                ArrayList<PayloadDependency> deps = new ArrayList<PayloadDependency>();
                ArrayList<PayloadDependency> conflicts = new ArrayList<PayloadDependency>();
                if (depsConfig.has("dependencies")) {
                    for (JsonElement ele : depsConfig.get("dependencies").getAsJsonArray()) {
                        dep = ele.getAsJsonObject();
                        PayloadDependency dependency = new PayloadDependency();
                        dependency.id = dep.get("id").getAsString();
                        if (dep.has("version")) {
                            dependency.version = dep.get("version").getAsString();
                            dependency.versionString = dep.has("versionString") ? dep.get("versionString").getAsString() : dependency.version;
                        }
                        if (dep.has("url")) {
                            dependency.url = dep.get("url").getAsString();
                        }
                        deps.add(dependency);
                    }
                }
                if (depsConfig.has("conflicts")) {
                    for (JsonElement ele : depsConfig.get("conflicts").getAsJsonArray()) {
                        dep = ele.getAsJsonObject();
                        PayloadDependency conflict = new PayloadDependency();
                        conflict.id = dep.get("id").getAsString();
                        if (dep.has("version")) {
                            conflict.version = dep.get("version").getAsString();
                        }
                        conflicts.add(conflict);
                    }
                }
                payload.dependencies = (PayloadDependency[])deps.toArray(PayloadDependency[]::new);
                payload.conflictsWith = (PayloadDependency[])conflicts.toArray(PayloadDependency[]::new);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            payload.box = new JCheckBox(payload.name + " (" + payload.type.toString().toLowerCase() + ")");
            this.payloads.put(payload.id, payload);
            this.refreshPayloadList();
        }
        catch (Exception e2) {
            if (throwError) {
                throw new IOException("Incompatible payload");
            }
            JOptionPane.showMessageDialog(this, "Failed to load payload file!", "Error", 0);
            return false;
        }
        return true;
    }

    private void refreshPayloadList() {
        this.payloadListBox.setModel(new ListModel<PayloadEntry>(){

            @Override
            public int getSize() {
                return PayloadManagerWindow.this.payloads.size();
            }

            @Override
            public PayloadEntry getElementAt(int index) {
                return ((PayloadEntry[])PayloadManagerWindow.this.payloads.values().toArray(PayloadEntry[]::new))[index];
            }

            @Override
            public void addListDataListener(ListDataListener l) {
            }

            @Override
            public void removeListDataListener(ListDataListener l) {
            }
        });
    }

    private void disableDependent(PayloadEntry payload) {
        for (PayloadEntry dep : (PayloadEntry[])this.payloads.values().toArray(PayloadEntry[]::new)) {
            if (!Stream.of(dep.dependencies).anyMatch(t -> t.id.equals(payload.id))) continue;
            dep.box.setSelected(false);
            dep.enabled = false;
            this.disableDependent(dep);
        }
    }

    private void enableDependencies(PayloadEntry payload) {
        for (PayloadDependency dep : payload.dependencies) {
            if (!this.payloads.containsKey(dep.id)) continue;
            PayloadEntry d = this.payloads.get(dep.id);
            d.box.setSelected(true);
            d.enabled = true;
            this.enableDependencies(d);
        }
    }

    private class PayloadEntry {
        public String file;
        public String id;
        public String name;
        public String version;
        public PayloadType type;
        public PayloadDependency[] dependencies;
        public PayloadDependency[] conflictsWith;
        public long timeSelect;
        public boolean enabled;
        public JCheckBox box;

        private PayloadEntry() {
        }
    }

    private class PayloadDependency {
        public String id;
        public String version;
        public String versionString;
        public String url;

        private PayloadDependency() {
        }
    }
}

