/*
 * Decompiled with CFR 0.152.
 */
package org.asf.razorwhip.sentinel.launcher.windows;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.UUID;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.asf.razorwhip.sentinel.launcher.AssetManager;
import org.asf.razorwhip.sentinel.launcher.LauncherUtils;
import org.asf.razorwhip.sentinel.launcher.assets.ArchiveInformation;
import org.asf.razorwhip.sentinel.launcher.assets.ArchiveMode;
import org.asf.razorwhip.sentinel.launcher.assets.AssetInformation;
import org.asf.razorwhip.sentinel.launcher.windows.ArchiveCreationWindow;
import org.asf.razorwhip.sentinel.launcher.windows.ArchiveDefSnippetViewer;

public class VersionManagerWindow
extends JDialog {
    private static final long serialVersionUID = 1L;
    private boolean firstTime = false;
    private JCheckBox checkBoxDownload;
    private JList<ClientEntry> clientListBox;
    private JComboBox<ArchiveInformation> archiveSelector;
    private JComboBox<QualityLevelEntry> qualityLevelBox;
    private JLabel lblQualityLevels;
    private JButton btnExport;
    private JButton btnImport;
    private JButton btnAdd;
    private JButton btnRemove;
    private JButton btnCancel;
    private JButton btnOk;
    private boolean isFirstSelection;
    private ArrayList<QualityLevelEntry> qualityLevelElements = new ArrayList();
    private ArrayList<ClientEntry> clients = new ArrayList();
    private ArchiveInformation lastArchive;
    private boolean downloadFinished;
    private JLabel lblThanks;
    private boolean wasCancelled = true;
    private boolean warnedArchiveChange = false;
    private boolean updateDescriptor = true;
    private JButton btnDelete;

    public VersionManagerWindow() {
        this.initialize();
    }

    public VersionManagerWindow(JFrame parent, boolean firstTime) {
        super(parent);
        this.firstTime = firstTime;
        this.initialize();
        this.setLocationRelativeTo(parent);
    }

    public boolean showDialog() throws IOException {
        JsonObject clients;
        this.clients.clear();
        this.lastArchive = null;
        this.isFirstSelection = false;
        File localArchiveSettings = new File("assets/localdata.json");
        if (localArchiveSettings.exists()) {
            JsonObject settings = JsonParser.parseString((String)Files.readString(localArchiveSettings.toPath())).getAsJsonObject();
            String id = settings.get("id").getAsString();
            boolean streaming = settings.get("stream").getAsBoolean();
            for (ArchiveInformation entry : AssetManager.getArchives()) {
                if (!entry.archiveID.equals(id)) continue;
                this.lastArchive = entry;
                this.archiveSelector.setSelectedItem(entry);
                this.checkBoxDownload.setEnabled(!entry.isDeprecated && entry.supportsDownloads && entry.supportsStreaming);
                this.lblQualityLevels.setVisible(this.checkBoxDownload.isSelected());
                this.qualityLevelBox.setVisible(this.checkBoxDownload.isSelected());
                this.btnExport.setEnabled(this.lastArchive != null && this.lastArchive.mode == ArchiveMode.REMOTE && this.lastArchive.supportsDownloads);
                this.btnDelete.setVisible(this.lastArchive != null && this.lastArchive.isUserArchive);
                this.btnDelete.setEnabled(true);
                break;
            }
            this.checkBoxDownload.setSelected(!streaming);
        } else if (AssetManager.getArchives().length > 0) {
            this.lastArchive = AssetManager.getArchives()[0];
            this.isFirstSelection = true;
            this.checkBoxDownload.setVisible(this.lastArchive.mode == ArchiveMode.REMOTE);
            this.checkBoxDownload.setEnabled(!this.lastArchive.isDeprecated && this.lastArchive.supportsDownloads && this.lastArchive.supportsStreaming);
            this.checkBoxDownload.setSelected(!this.lastArchive.supportsStreaming);
            this.lblQualityLevels.setVisible(this.checkBoxDownload.isSelected());
            this.qualityLevelBox.setVisible(this.checkBoxDownload.isSelected());
            this.btnExport.setEnabled(this.lastArchive != null && this.lastArchive.mode == ArchiveMode.REMOTE && this.lastArchive.supportsDownloads);
            this.btnDelete.setVisible(this.lastArchive != null && this.lastArchive.isUserArchive);
            this.btnDelete.setEnabled(true);
        }
        this.archiveSelector.setModel(new ComboBoxModel<ArchiveInformation>(){
            private ArchiveInformation selected;

            @Override
            public int getSize() {
                return AssetManager.getArchives().length;
            }

            @Override
            public ArchiveInformation getElementAt(int index) {
                return AssetManager.getArchives()[index];
            }

            @Override
            public void setSelectedItem(Object anItem) {
                this.selected = (ArchiveInformation)anItem;
            }

            @Override
            public Object getSelectedItem() {
                return this.selected;
            }

            @Override
            public void addListDataListener(ListDataListener l) {
            }

            @Override
            public void removeListDataListener(ListDataListener l) {
            }
        });
        this.archiveSelector.setSelectedItem(this.lastArchive);
        JsonArray clientsArr = new JsonArray();
        File clientListFile = new File("assets/clients.json");
        if (clientListFile.exists()) {
            clientsArr = JsonParser.parseString((String)Files.readString(Path.of("assets/clients.json", new String[0]))).getAsJsonArray();
        }
        for (JsonElement c : clientsArr) {
            ClientEntry entry = new ClientEntry();
            entry.version = c.getAsString();
            this.clients.add(entry);
        }
        if (AssetManager.getArchives().length == 1 && this.lastArchive != null && this.firstTime && (clients = this.lastArchive.archiveClientLst).size() == 1) {
            String client = ((String[])clients.keySet().toArray(String[]::new))[0];
            boolean found = false;
            for (JsonElement c : clientsArr) {
                if (!c.getAsString().equals(client)) continue;
                found = true;
                break;
            }
            if (!found) {
                clientsArr.add(client);
                Files.writeString(Path.of("assets/clients.json", new String[0]), (CharSequence)clientsArr.toString(), new OpenOption[0]);
            }
            JsonObject settings = new JsonObject();
            settings.addProperty("id", this.lastArchive.archiveID);
            settings.addProperty("stream", Boolean.valueOf(!this.checkBoxDownload.isSelected()));
            Files.writeString(localArchiveSettings.toPath(), (CharSequence)settings.toString(), new OpenOption[0]);
            return true;
        }
        this.updateDescriptor = true;
        this.refreshClientList();
        this.setVisible(true);
        return !this.wasCancelled;
    }

    private void initialize() {
        this.setTitle("Version manager");
        this.setBounds(100, 100, 600, 697);
        this.setDefaultCloseOperation(0);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setModal(true);
        this.getContentPane().setLayout(new FlowLayout(1, 5, 5));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!VersionManagerWindow.this.btnCancel.isEnabled()) {
                    if (JOptionPane.showConfirmDialog(VersionManagerWindow.this, "WARNING! The version manager is presently busy!\nClosing the version manager while its busy WILL RESTART THE LAUNCHER!\n\nAre you sure you want to continue?", "Warning", 0, 2) != 0) {
                        return;
                    }
                    System.exit(237);
                    return;
                }
                if (JOptionPane.showConfirmDialog(VersionManagerWindow.this, "Are you sure you want to close the version manager without saving?", "Warning", 0, 2) != 0) {
                    return;
                }
                VersionManagerWindow.this.dispose();
            }
        });
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(590, 655));
        this.getContentPane().add(panel);
        panel.setLayout(null);
        this.btnOk = new JButton("Ok");
        this.btnOk.setBounds(473, 616, 105, 27);
        panel.add(this.btnOk);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.setBounds(356, 616, 105, 27);
        panel.add(this.btnCancel);
        JLabel lblAssetArchive = new JLabel("Asset archive");
        lblAssetArchive.setBounds(12, 12, 566, 17);
        panel.add(lblAssetArchive);
        this.archiveSelector = new JComboBox();
        this.archiveSelector.setBounds(12, 34, 350, 26);
        panel.add(this.archiveSelector);
        this.btnImport = new JButton("Add...");
        this.btnImport.setBounds(473, 34, 105, 26);
        panel.add(this.btnImport);
        this.btnExport = new JButton("Export...");
        this.btnExport.setBounds(366, 34, 105, 26);
        panel.add(this.btnExport);
        this.btnDelete = new JButton("Remove");
        this.btnDelete.setBounds(473, 62, 105, 26);
        panel.add(this.btnDelete);
        this.checkBoxDownload = new JCheckBox("Download all assets to local device for offline play (WILL TAKE TIME)");
        this.checkBoxDownload.setSelected(true);
        this.checkBoxDownload.setEnabled(false);
        this.btnExport.setEnabled(this.lastArchive != null && this.lastArchive.mode == ArchiveMode.REMOTE && this.lastArchive.supportsDownloads);
        this.btnDelete.setVisible(this.lastArchive != null && this.lastArchive.isUserArchive);
        this.checkBoxDownload.setBounds(8, 63, 459, 25);
        panel.add(this.checkBoxDownload);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBorder(new BevelBorder(1, null, null, null, null));
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setBounds(12, 140, 566, 352);
        panel.add(scrollPane);
        this.clientListBox = new JList();
        this.clientListBox.setSelectionMode(0);
        scrollPane.setViewportView(this.clientListBox);
        JLabel lblNewLabel = new JLabel("Clients");
        lblNewLabel.setBounds(12, 119, 566, 17);
        panel.add(lblNewLabel);
        this.lblQualityLevels = new JLabel("Quality levels to download");
        this.lblQualityLevels.setBounds(356, 554, 222, 17);
        panel.add(this.lblQualityLevels);
        this.qualityLevelBox = new JComboBox<QualityLevelEntry>(){
            private static final long serialVersionUID = 1L;

            @Override
            public void setPopupVisible(boolean visible) {
                if (visible) {
                    super.setPopupVisible(visible);
                }
            }
        };
        this.qualityLevelBox.setBounds(356, 577, 222, 27);
        panel.add(this.qualityLevelBox);
        this.lblQualityLevels.setVisible(this.checkBoxDownload.isSelected());
        this.qualityLevelBox.setVisible(this.checkBoxDownload.isSelected());
        this.checkBoxDownload.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                VersionManagerWindow.this.lblQualityLevels.setVisible(VersionManagerWindow.this.checkBoxDownload.isSelected());
                VersionManagerWindow.this.qualityLevelBox.setVisible(VersionManagerWindow.this.checkBoxDownload.isSelected());
            }
        });
        String[] levels = LauncherUtils.getGameDescriptor().knownAssetQualityLevels();
        this.loadQualityLevelBox(this.qualityLevelBox, levels);
        this.btnAdd = new JButton("Add client...");
        this.btnAdd.setBounds(473, 497, 105, 27);
        panel.add(this.btnAdd);
        this.btnRemove = new JButton("Delete");
        this.btnRemove.setEnabled(false);
        this.btnRemove.setBounds(12, 497, 105, 27);
        panel.add(this.btnRemove);
        this.lblThanks = new JLabel("Assets kindly mirrored by ...");
        this.lblThanks.setVisible(false);
        this.lblThanks.setBounds(12, 621, 326, 17);
        panel.add(this.lblThanks);
        this.archiveSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                SwingUtilities.invokeLater(() -> {
                    if (VersionManagerWindow.this.archiveSelector.getSelectedItem() == null) {
                        VersionManagerWindow.this.checkBoxDownload.setEnabled(false);
                        VersionManagerWindow.this.lblQualityLevels.setVisible(false);
                        VersionManagerWindow.this.qualityLevelBox.setVisible(false);
                        VersionManagerWindow.this.btnExport.setEnabled(false);
                        VersionManagerWindow.this.btnDelete.setVisible(false);
                    } else {
                        ArchiveInformation eA = (ArchiveInformation)VersionManagerWindow.this.archiveSelector.getSelectedItem();
                        if (VersionManagerWindow.this.lastArchive == null || !eA.archiveID.equals(VersionManagerWindow.this.lastArchive.archiveID)) {
                            if (VersionManagerWindow.this.lastArchive != null && !VersionManagerWindow.this.warnedArchiveChange && !VersionManagerWindow.this.firstTime) {
                                if (JOptionPane.showConfirmDialog(VersionManagerWindow.this, "WARNING! Changing the asset archive will very likely trigger a full re-download!\n\nAre you sure you want to continue?", "Warning", 0, 2) != 0) {
                                    VersionManagerWindow.this.archiveSelector.setSelectedItem(VersionManagerWindow.this.lastArchive);
                                    return;
                                }
                                VersionManagerWindow.this.warnedArchiveChange = true;
                            }
                            VersionManagerWindow.this.updateDescriptor = true;
                            if (eA.isDeprecated) {
                                String message = eA.deprecationNotice;
                                JOptionPane.showMessageDialog(VersionManagerWindow.this, "Warning! The archive you selected has been deprecated and may be removed!\n\n" + message, "Deprecated archive", 2);
                            }
                            if (eA.isDeprecated || !eA.supportsDownloads || !eA.supportsStreaming) {
                                VersionManagerWindow.this.checkBoxDownload.setEnabled(false);
                                VersionManagerWindow.this.checkBoxDownload.setSelected(eA.isDeprecated || !eA.supportsStreaming);
                                VersionManagerWindow.this.lblQualityLevels.setVisible(VersionManagerWindow.this.checkBoxDownload.isSelected());
                                VersionManagerWindow.this.qualityLevelBox.setVisible(VersionManagerWindow.this.checkBoxDownload.isSelected());
                            } else {
                                VersionManagerWindow.this.checkBoxDownload.setEnabled(true);
                                VersionManagerWindow.this.lblQualityLevels.setVisible(VersionManagerWindow.this.checkBoxDownload.isSelected());
                                VersionManagerWindow.this.qualityLevelBox.setVisible(VersionManagerWindow.this.checkBoxDownload.isSelected());
                            }
                            VersionManagerWindow.this.isFirstSelection = false;
                            VersionManagerWindow.this.lastArchive = eA;
                            VersionManagerWindow.this.checkBoxDownload.setVisible(VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE);
                            VersionManagerWindow.this.btnExport.setText(VersionManagerWindow.this.lastArchive == null || VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE ? "Export..." : "Delete");
                            VersionManagerWindow.this.btnExport.setEnabled(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE && VersionManagerWindow.this.lastArchive.supportsDownloads);
                            VersionManagerWindow.this.btnDelete.setVisible(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.isUserArchive);
                            VersionManagerWindow.this.btnDelete.setEnabled(true);
                            VersionManagerWindow.this.refreshClientList();
                        }
                    }
                });
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VersionManagerWindow.this.dispose();
            }
        });
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String message;
                if (VersionManagerWindow.this.isFirstSelection && VersionManagerWindow.this.lastArchive.isDeprecated && JOptionPane.showConfirmDialog(VersionManagerWindow.this, "Warning! The archive you selected has been deprecated and may be removed!\n\n" + (message = VersionManagerWindow.this.lastArchive.deprecationNotice) + "\n\nDo you want to continue?", "Deprecated archive", 0, 2) != 0) {
                    return;
                }
                if (VersionManagerWindow.this.checkBoxDownload.isSelected()) {
                    boolean wasEnabledRemove = VersionManagerWindow.this.btnRemove.isEnabled();
                    VersionManagerWindow.this.btnOk.setEnabled(false);
                    VersionManagerWindow.this.qualityLevelBox.setEnabled(false);
                    VersionManagerWindow.this.btnCancel.setEnabled(false);
                    VersionManagerWindow.this.archiveSelector.setEnabled(false);
                    VersionManagerWindow.this.btnAdd.setEnabled(false);
                    boolean chBoxWasEnabled = VersionManagerWindow.this.checkBoxDownload.isEnabled();
                    VersionManagerWindow.this.checkBoxDownload.setEnabled(false);
                    VersionManagerWindow.this.clientListBox.setEnabled(false);
                    VersionManagerWindow.this.btnExport.setEnabled(false);
                    VersionManagerWindow.this.btnDelete.setEnabled(false);
                    VersionManagerWindow.this.btnImport.setEnabled(false);
                    VersionManagerWindow.this.btnRemove.setEnabled(false);
                    VersionManagerWindow.this.btnOk.setText("Busy...");
                    Thread th = new Thread(() -> {
                        try {
                            if (!VersionManagerWindow.this.updateDescriptorIfNeeded(chBoxWasEnabled, wasEnabledRemove)) {
                                return;
                            }
                            JsonObject archiveDescriptor = JsonParser.parseString((String)Files.readString(Path.of("assets/descriptor/descriptor.json", new String[0]))).getAsJsonObject();
                            SwingUtilities.invokeAndWait(() -> {
                                VersionManagerWindow.this.lblThanks.setText("Indexing assets...");
                                VersionManagerWindow.this.lblThanks.setVisible(true);
                            });
                            LauncherUtils.log("Indexing assets... Please wait...", true);
                            HashMap<String, String> assetHashes = new HashMap<String, String>();
                            LinkedHashMap<String, AssetInformation> assetsList = new LinkedHashMap<String, AssetInformation>();
                            VersionManagerWindow.this.indexAssetHashes(assetHashes, new File("assets/descriptor/hashes.shl"));
                            for (String string : assetHashes.keySet()) {
                                AssetInformation assetInformation = new AssetInformation();
                                assetInformation.assetPath = string;
                                assetInformation.assetHash = assetHashes.get(string);
                                assetInformation.localAssetFile = new File("assets/assetarchive/assets", assetInformation.assetHash + ".sa");
                                assetsList.put(assetInformation.assetPath.toLowerCase(), assetInformation);
                            }
                            LauncherUtils.log("Collecting game clients...");
                            ArrayList<String> versions = new ArrayList<String>();
                            for (ClientEntry clientEntry : VersionManagerWindow.this.clients) {
                                if (!VersionManagerWindow.this.lastArchive.archiveClientLst.has(clientEntry.version)) continue;
                                versions.add(clientEntry.version);
                            }
                            SwingUtilities.invokeAndWait(() -> {
                                VersionManagerWindow.this.lblThanks.setText("Collecting assets...");
                                VersionManagerWindow.this.lblThanks.setVisible(true);
                            });
                            LauncherUtils.log("Collecting assets...", true);
                            LinkedHashMap<String, AssetInformation> linkedHashMap = new LinkedHashMap<String, AssetInformation>();
                            for (String string : versions) {
                                AssetInformation[] collectedAssets;
                                SwingUtilities.invokeAndWait(() -> {
                                    VersionManagerWindow.this.lblThanks.setText("Collecting assets of " + string + "...");
                                    VersionManagerWindow.this.lblThanks.setVisible(true);
                                });
                                ArrayList<String> lvls = new ArrayList<String>();
                                for (QualityLevelEntry qualityLevelEntry : VersionManagerWindow.this.qualityLevelElements) {
                                    if (!qualityLevelEntry.enabled) continue;
                                    lvls.add(qualityLevelEntry.level);
                                }
                                LauncherUtils.log("Collecting assets of " + string + "...");
                                for (AssetInformation asset : collectedAssets = LauncherUtils.getGameDescriptor().collectVersionAssets((AssetInformation[])((HashMap)assetsList).values().toArray(AssetInformation[]::new), (String[])lvls.toArray(String[]::new), string, VersionManagerWindow.this.lastArchive, VersionManagerWindow.this.lastArchive.archiveDef, archiveDescriptor, assetHashes)) {
                                    if (linkedHashMap.containsKey(asset.assetHash.toLowerCase())) continue;
                                    AssetInformation as = new AssetInformation();
                                    as.assetHash = asset.assetHash;
                                    as.assetPath = asset.assetPath;
                                    as.localAssetFile = asset.localAssetFile;
                                    linkedHashMap.put(asset.assetHash.toLowerCase(), as);
                                }
                            }
                            SwingUtilities.invokeAndWait(() -> {
                                VersionManagerWindow.this.lblThanks.setText("Collecting updated assets...");
                                VersionManagerWindow.this.lblThanks.setVisible(true);
                            });
                            LauncherUtils.log("Collecting updated assets...", true);
                            LinkedHashMap<String, AssetInformation> linkedHashMap2 = new LinkedHashMap<String, AssetInformation>();
                            for (AssetInformation asset : linkedHashMap.values()) {
                                if (asset.isUpToDate() || linkedHashMap2.containsKey(asset.assetHash)) continue;
                                linkedHashMap2.put(asset.assetHash, asset);
                            }
                            LauncherUtils.log("Collected " + linkedHashMap2.size() + " updated asset(s)", true);
                            if (linkedHashMap2.size() != 0) {
                                void var12_38;
                                SwingUtilities.invokeAndWait(() -> {
                                    VersionManagerWindow.this.lblThanks.setText("Collecting asset size...");
                                    VersionManagerWindow.this.lblThanks.setVisible(true);
                                });
                                HashMap<String, Long> hashMap = new HashMap<String, Long>();
                                VersionManagerWindow.this.indexAssetSizes(hashMap, new File("assets/descriptor/index.sfl"));
                                long size = 0L;
                                for (AssetInformation asset : linkedHashMap2.values()) {
                                    size += hashMap.getOrDefault(asset.assetPath, 0L).longValue();
                                }
                                String string = size + "b";
                                if (size >= 1024L) {
                                    String string2 = (size /= 1024L) + "kb";
                                }
                                if (size >= 1024L) {
                                    String string3 = (size /= 1024L) + "mb";
                                }
                                if (size >= 1024L) {
                                    String string4 = (size /= 1024L) + "gb";
                                }
                                void sizeStrF = var12_38;
                                SwingUtilities.invokeAndWait(() -> this.lambda$actionPerformed$7((String)sizeStrF));
                                if (JOptionPane.showConfirmDialog(VersionManagerWindow.this, VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE ? "WARNING! This operation will download " + (String)var12_38 + " of asset data!\n\nAre you sure you want to continue?" : "WARNING! This operation will extract " + (String)var12_38 + " of asset data!\n\nAre you sure you want to continue?", "Warning", 0, 2) != 0) {
                                    SwingUtilities.invokeLater(() -> {
                                        VersionManagerWindow.this.btnOk.setEnabled(true);
                                        VersionManagerWindow.this.btnCancel.setEnabled(true);
                                        VersionManagerWindow.this.archiveSelector.setEnabled(true);
                                        VersionManagerWindow.this.btnAdd.setEnabled(true);
                                        VersionManagerWindow.this.checkBoxDownload.setVisible(VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE);
                                        VersionManagerWindow.this.checkBoxDownload.setEnabled(chBoxWasEnabled);
                                        VersionManagerWindow.this.btnExport.setEnabled(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE && VersionManagerWindow.this.lastArchive.supportsDownloads);
                                        VersionManagerWindow.this.btnDelete.setVisible(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.isUserArchive);
                                        VersionManagerWindow.this.btnDelete.setEnabled(true);
                                        VersionManagerWindow.this.btnImport.setEnabled(true);
                                        VersionManagerWindow.this.qualityLevelBox.setEnabled(true);
                                        VersionManagerWindow.this.clientListBox.setEnabled(true);
                                        VersionManagerWindow.this.btnRemove.setEnabled(wasEnabledRemove);
                                        VersionManagerWindow.this.btnOk.setText("Ok");
                                        VersionManagerWindow.this.lblThanks.setVisible(VersionManagerWindow.this.lastArchive != null);
                                        VersionManagerWindow.this.lblThanks.setText("");
                                        if (VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.archiveDef.has("thanksTo")) {
                                            VersionManagerWindow.this.lblThanks.setText("Assets kindly mirrored by " + VersionManagerWindow.this.lastArchive.archiveDef.get("thanksTo").getAsString());
                                        }
                                    });
                                    return;
                                }
                            }
                            SwingUtilities.invokeLater(() -> {
                                VersionManagerWindow.this.btnOk.setEnabled(true);
                                VersionManagerWindow.this.btnCancel.setEnabled(true);
                                VersionManagerWindow.this.archiveSelector.setEnabled(true);
                                VersionManagerWindow.this.btnAdd.setEnabled(true);
                                VersionManagerWindow.this.checkBoxDownload.setVisible(VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE);
                                VersionManagerWindow.this.checkBoxDownload.setEnabled(chBoxWasEnabled);
                                VersionManagerWindow.this.btnExport.setEnabled(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE && VersionManagerWindow.this.lastArchive.supportsDownloads);
                                VersionManagerWindow.this.btnDelete.setVisible(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.isUserArchive);
                                VersionManagerWindow.this.btnDelete.setEnabled(true);
                                VersionManagerWindow.this.btnImport.setEnabled(true);
                                VersionManagerWindow.this.qualityLevelBox.setEnabled(true);
                                VersionManagerWindow.this.clientListBox.setEnabled(true);
                                VersionManagerWindow.this.btnRemove.setEnabled(wasEnabledRemove);
                                VersionManagerWindow.this.btnOk.setText("Ok");
                                VersionManagerWindow.this.lblThanks.setVisible(VersionManagerWindow.this.lastArchive != null);
                                VersionManagerWindow.this.lblThanks.setText("");
                                if (VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.archiveDef.has("thanksTo")) {
                                    VersionManagerWindow.this.lblThanks.setText("Assets kindly mirrored by " + VersionManagerWindow.this.lastArchive.archiveDef.get("thanksTo").getAsString());
                                }
                                VersionManagerWindow.this.doSave();
                            });
                        }
                        catch (Exception e2) {
                            Object stackTrace = "";
                            Throwable t = e2;
                            while (t != null) {
                                for (StackTraceElement stackTraceElement : t.getStackTrace()) {
                                    stackTrace = (String)stackTrace + "\n     At: " + stackTraceElement;
                                }
                                if ((t = t.getCause()) == null) continue;
                                stackTrace = (String)stackTrace + "\nCaused by: " + t;
                            }
                            JOptionPane.showMessageDialog(VersionManagerWindow.this, "An error occurred!\n\nError details: " + e2 + (String)stackTrace, "Launcher error", 0);
                            VersionManagerWindow.this.downloadFinished = true;
                            SwingUtilities.invokeLater(() -> {
                                VersionManagerWindow.this.btnOk.setEnabled(true);
                                VersionManagerWindow.this.btnCancel.setEnabled(true);
                                VersionManagerWindow.this.archiveSelector.setEnabled(true);
                                VersionManagerWindow.this.btnAdd.setEnabled(true);
                                VersionManagerWindow.this.checkBoxDownload.setVisible(VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE);
                                VersionManagerWindow.this.checkBoxDownload.setEnabled(chBoxWasEnabled);
                                VersionManagerWindow.this.btnExport.setEnabled(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE && VersionManagerWindow.this.lastArchive.supportsDownloads);
                                VersionManagerWindow.this.btnDelete.setVisible(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.isUserArchive);
                                VersionManagerWindow.this.btnDelete.setEnabled(true);
                                VersionManagerWindow.this.btnImport.setEnabled(true);
                                VersionManagerWindow.this.qualityLevelBox.setEnabled(true);
                                VersionManagerWindow.this.clientListBox.setEnabled(true);
                                VersionManagerWindow.this.btnRemove.setEnabled(wasEnabledRemove);
                                VersionManagerWindow.this.btnOk.setText("Ok");
                                VersionManagerWindow.this.lblThanks.setVisible(VersionManagerWindow.this.lastArchive != null);
                                VersionManagerWindow.this.lblThanks.setText("");
                                if (VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.archiveDef.has("thanksTo")) {
                                    VersionManagerWindow.this.lblThanks.setText("Assets kindly mirrored by " + VersionManagerWindow.this.lastArchive.archiveDef.get("thanksTo").getAsString());
                                }
                            });
                        }
                    });
                    th.setDaemon(true);
                    th.start();
                    return;
                }
                if (new File("assets/descriptor.hash").exists()) {
                    new File("assets/descriptor.hash").delete();
                }
                if (new File("assets/descriptor-local.version").exists()) {
                    new File("assets/descriptor-local.version").delete();
                }
                VersionManagerWindow.this.doSave();
            }
        });
        this.clientListBox.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                VersionManagerWindow.this.btnRemove.setEnabled(VersionManagerWindow.this.clientListBox.getSelectedValue() != null);
            }
        });
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JsonObject clientLst = VersionManagerWindow.this.lastArchive.archiveClientLst;
                ArrayList<String> versions = new ArrayList<String>();
                for (String version : clientLst.keySet()) {
                    if (VersionManagerWindow.this.clients.stream().anyMatch(t -> t.version.equals(version))) continue;
                    versions.add(version);
                }
                String ver = (String)JOptionPane.showInputDialog(VersionManagerWindow.this, "Select a client version to add...", "Add version", 3, null, versions.toArray(Object[]::new), null);
                if (ver != null) {
                    ClientEntry ent = new ClientEntry();
                    ent.version = ver;
                    VersionManagerWindow.this.clients.add(ent);
                    VersionManagerWindow.this.refreshClientList();
                }
            }
        });
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JOptionPane.showConfirmDialog(VersionManagerWindow.this, "WARNING! Deleting a client will delete all files related to it!\n\nAre you sure you want to continue?", "Warning", 0, 2) != 0) {
                    return;
                }
                ClientEntry entry = VersionManagerWindow.this.clientListBox.getSelectedValue();
                VersionManagerWindow.this.clients.remove(entry);
                VersionManagerWindow.this.refreshClientList();
            }
        });
        this.btnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VersionManagerWindow.this.lastArchive == null) {
                    return;
                }
                if (VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE) {
                    int selected = JOptionPane.showOptionDialog(VersionManagerWindow.this, "Welcome to the archive export tool!\nHere you can create a archive SGA file or server folder based on your current archive settings!\n\nWARNING! Please note that exporting an archive WILL SAVE THE CURRENT ARCHIVE SETTINGS,\nIT WILL ALSO DOWNLOAD ALL ASSETS WITH ALL QUALITY LEVELS REGARDLESS OF QUALITY SETTINGS.\n\nPlease select a operation...\n ", "Archive Exporter", -1, 3, null, new Object[]{"Export as SGA file", "Create archive server folder", "Cancel"}, "Cancel");
                    if (selected == 2 || selected == -1) {
                        return;
                    }
                    boolean wasEnabledRemove = VersionManagerWindow.this.btnRemove.isEnabled();
                    VersionManagerWindow.this.btnOk.setEnabled(false);
                    VersionManagerWindow.this.qualityLevelBox.setEnabled(false);
                    VersionManagerWindow.this.btnCancel.setEnabled(false);
                    VersionManagerWindow.this.archiveSelector.setEnabled(false);
                    VersionManagerWindow.this.btnAdd.setEnabled(false);
                    boolean chBoxWasEnabled = VersionManagerWindow.this.checkBoxDownload.isEnabled();
                    VersionManagerWindow.this.checkBoxDownload.setEnabled(false);
                    VersionManagerWindow.this.clientListBox.setEnabled(false);
                    VersionManagerWindow.this.btnExport.setEnabled(false);
                    VersionManagerWindow.this.btnImport.setEnabled(false);
                    VersionManagerWindow.this.btnRemove.setEnabled(false);
                    VersionManagerWindow.this.btnDelete.setEnabled(false);
                    VersionManagerWindow.this.btnOk.setText("Busy...");
                    Thread th = new Thread(() -> {
                        try {
                            SwingUtilities.invokeAndWait(() -> {
                                VersionManagerWindow.this.lblThanks.setText("Saving settings...");
                                VersionManagerWindow.this.lblThanks.setVisible(true);
                            });
                            LauncherUtils.log("Saving settings...", true);
                            VersionManagerWindow.this.saveSettings();
                            SwingUtilities.invokeAndWait(() -> {
                                VersionManagerWindow.this.lblThanks.setText("Reloading asset manager...");
                                VersionManagerWindow.this.lblThanks.setVisible(true);
                            });
                            LauncherUtils.log("Reloading asset manager...", true);
                            AssetManager.reloadSavedSettings();
                            if (!VersionManagerWindow.this.updateDescriptorIfNeeded(chBoxWasEnabled, wasEnabledRemove)) {
                                return;
                            }
                            JsonObject archiveDescriptor = JsonParser.parseString((String)Files.readString(Path.of("assets/descriptor/descriptor.json", new String[0]))).getAsJsonObject();
                            SwingUtilities.invokeAndWait(() -> {
                                VersionManagerWindow.this.lblThanks.setText("Indexing assets...");
                                VersionManagerWindow.this.lblThanks.setVisible(true);
                            });
                            LauncherUtils.log("Indexing assets... Please wait...", true);
                            HashMap<String, String> assetHashes = new HashMap<String, String>();
                            LinkedHashMap<String, AssetInformation> assetsList = new LinkedHashMap<String, AssetInformation>();
                            VersionManagerWindow.this.indexAssetHashes(assetHashes, new File("assets/descriptor/hashes.shl"));
                            for (String string : assetHashes.keySet()) {
                                AssetInformation assetInformation = new AssetInformation();
                                assetInformation.assetPath = string;
                                assetInformation.assetHash = assetHashes.get(string);
                                assetInformation.localAssetFile = new File("assets/assetarchive/assets", assetInformation.assetHash + ".sa");
                                assetsList.put(assetInformation.assetPath.toLowerCase(), assetInformation);
                            }
                            LauncherUtils.log("Collecting game clients...");
                            ArrayList<String> versions = new ArrayList<String>();
                            for (ClientEntry clientEntry : VersionManagerWindow.this.clients) {
                                if (!VersionManagerWindow.this.lastArchive.archiveClientLst.has(clientEntry.version)) continue;
                                versions.add(clientEntry.version);
                            }
                            SwingUtilities.invokeAndWait(() -> {
                                VersionManagerWindow.this.lblThanks.setText("Collecting assets...");
                                VersionManagerWindow.this.lblThanks.setVisible(true);
                            });
                            LauncherUtils.log("Collecting assets...", true);
                            LinkedHashMap<String, AssetInformation> linkedHashMap = new LinkedHashMap<String, AssetInformation>();
                            for (String clientVersion : versions) {
                                AssetInformation[] collectedAssets;
                                SwingUtilities.invokeAndWait(() -> {
                                    VersionManagerWindow.this.lblThanks.setText("Collecting assets of " + clientVersion + "...");
                                    VersionManagerWindow.this.lblThanks.setVisible(true);
                                });
                                LauncherUtils.log("Collecting assets of " + clientVersion + "...");
                                for (AssetInformation asset : collectedAssets = LauncherUtils.getGameDescriptor().collectVersionAssets((AssetInformation[])((HashMap)assetsList).values().toArray(AssetInformation[]::new), LauncherUtils.getGameDescriptor().knownAssetQualityLevels(), clientVersion, VersionManagerWindow.this.lastArchive, VersionManagerWindow.this.lastArchive.archiveDef, archiveDescriptor, assetHashes)) {
                                    AssetInformation as;
                                    if (!linkedHashMap.containsKey(asset.assetHash.toLowerCase())) {
                                        as = new AssetInformation();
                                        as.assetHash = asset.assetHash;
                                        as.assetPath = asset.assetPath;
                                        as.localAssetFile = asset.localAssetFile;
                                        as.clientVersions = new String[]{clientVersion};
                                        linkedHashMap.put(asset.assetPath.toLowerCase(), as);
                                        continue;
                                    }
                                    as = (AssetInformation)linkedHashMap.get(asset.assetPath.toLowerCase());
                                    if (Stream.of(as.clientVersions).anyMatch(t -> t.equalsIgnoreCase(clientVersion))) continue;
                                    as.clientVersions = VersionManagerWindow.appendToStringArray(as.clientVersions, clientVersion);
                                }
                            }
                            SwingUtilities.invokeAndWait(() -> {
                                VersionManagerWindow.this.lblThanks.setText("Collecting updated assets...");
                                VersionManagerWindow.this.lblThanks.setVisible(true);
                            });
                            LauncherUtils.log("Collecting updated assets...", true);
                            ArrayList<String> arrayList = new ArrayList<String>();
                            LinkedHashMap<String, AssetInformation> assetsNeedingDownloads = new LinkedHashMap<String, AssetInformation>();
                            for (AssetInformation asset : linkedHashMap.values()) {
                                if (asset.isUpToDate()) continue;
                                for (String version : asset.clientVersions) {
                                    if (arrayList.contains(version)) continue;
                                    arrayList.add(version);
                                }
                                if (assetsNeedingDownloads.containsKey(asset.assetHash)) continue;
                                assetsNeedingDownloads.put(asset.assetHash, asset);
                            }
                            LauncherUtils.log("Collected " + assetsNeedingDownloads.size() + " updated asset(s)", true);
                            if (assetsNeedingDownloads.size() != 0) {
                                SwingUtilities.invokeAndWait(() -> {
                                    VersionManagerWindow.this.lblThanks.setText("Collecting asset size...");
                                    VersionManagerWindow.this.lblThanks.setVisible(true);
                                });
                                HashMap<String, Long> assetSizes = new HashMap<String, Long>();
                                VersionManagerWindow.this.indexAssetSizes(assetSizes, new File("assets/descriptor/index.sfl"));
                                long size = 0L;
                                for (AssetInformation asset : assetsNeedingDownloads.values()) {
                                    size += assetSizes.getOrDefault(asset.assetPath, 0L).longValue();
                                }
                                String sizeStr = size + "b";
                                if (size >= 1024L) {
                                    sizeStr = (size /= 1024L) + "kb";
                                }
                                if (size >= 1024L) {
                                    sizeStr = (size /= 1024L) + "mb";
                                }
                                if (size >= 1024L) {
                                    sizeStr = (size /= 1024L) + "gb";
                                }
                                String sizeStrF = sizeStr;
                                SwingUtilities.invokeAndWait(() -> {
                                    if (VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE) {
                                        VersionManagerWindow.this.lblThanks.setText("Need to download " + sizeStrF);
                                    } else {
                                        VersionManagerWindow.this.lblThanks.setText("Need to extract " + sizeStrF);
                                    }
                                    VersionManagerWindow.this.lblThanks.setVisible(true);
                                });
                                if (JOptionPane.showConfirmDialog(VersionManagerWindow.this, VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE ? "WARNING! This operation will download " + sizeStr + " of asset data!\n\nAre you sure you want to continue?" : "WARNING! This operation will extract " + sizeStr + " of asset data!\n\nAre you sure you want to continue?", "Warning", 0, 2) != 0) {
                                    SwingUtilities.invokeLater(() -> {
                                        VersionManagerWindow.this.btnOk.setEnabled(true);
                                        VersionManagerWindow.this.btnCancel.setEnabled(true);
                                        VersionManagerWindow.this.archiveSelector.setEnabled(true);
                                        VersionManagerWindow.this.btnAdd.setEnabled(true);
                                        VersionManagerWindow.this.checkBoxDownload.setVisible(VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE);
                                        VersionManagerWindow.this.checkBoxDownload.setEnabled(chBoxWasEnabled);
                                        VersionManagerWindow.this.btnExport.setEnabled(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE && VersionManagerWindow.this.lastArchive.supportsDownloads);
                                        VersionManagerWindow.this.btnDelete.setVisible(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.isUserArchive);
                                        VersionManagerWindow.this.btnDelete.setEnabled(true);
                                        VersionManagerWindow.this.btnImport.setEnabled(true);
                                        VersionManagerWindow.this.qualityLevelBox.setEnabled(true);
                                        VersionManagerWindow.this.clientListBox.setEnabled(true);
                                        VersionManagerWindow.this.btnRemove.setEnabled(wasEnabledRemove);
                                        VersionManagerWindow.this.btnOk.setText("Ok");
                                        VersionManagerWindow.this.lblThanks.setVisible(VersionManagerWindow.this.lastArchive != null);
                                        VersionManagerWindow.this.lblThanks.setText("");
                                        if (VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.archiveDef.has("thanksTo")) {
                                            VersionManagerWindow.this.lblThanks.setText("Assets kindly mirrored by " + VersionManagerWindow.this.lastArchive.archiveDef.get("thanksTo").getAsString());
                                        }
                                    });
                                    return;
                                }
                            }
                            SwingUtilities.invokeAndWait(() -> {
                                VersionManagerWindow.this.lblThanks.setText("Preparing to export...");
                                VersionManagerWindow.this.lblThanks.setVisible(true);
                            });
                            LauncherUtils.setStatus("Preparing to export...");
                            LauncherUtils.log("Determining mode...");
                            File outputFile = null;
                            if (selected == 0) {
                                LauncherUtils.log("SGA mode, requesting user save file selection...");
                                SwingUtilities.invokeAndWait(() -> {
                                    VersionManagerWindow.this.lblThanks.setText("Awaiting user selection...");
                                    VersionManagerWindow.this.lblThanks.setVisible(true);
                                });
                                LauncherUtils.log("Awaiting user selection...");
                                JFileChooser f = new JFileChooser();
                                f.setDialogTitle("Choose where to save...");
                                FileFilter filter = new FileFilter(){

                                    @Override
                                    public boolean accept(File f) {
                                        return f.isDirectory() || f.getName().endsWith(".sga");
                                    }

                                    @Override
                                    public String getDescription() {
                                        return "Sentinel game asset archive files (*.sga)";
                                    }
                                };
                                f.addChoosableFileFilter(filter);
                                f.setFileFilter(filter);
                                f.showSaveDialog(VersionManagerWindow.this);
                                if (f.getSelectedFile() != null) {
                                    outputFile = f.getSelectedFile();
                                }
                            } else if (selected == 1) {
                                LauncherUtils.log("Server folder mode, requesting user save file selection...");
                                SwingUtilities.invokeAndWait(() -> {
                                    VersionManagerWindow.this.lblThanks.setText("Awaiting user selection...");
                                    VersionManagerWindow.this.lblThanks.setVisible(true);
                                });
                                LauncherUtils.log("Awaiting user selection...");
                                JFileChooser f = new JFileChooser();
                                f.setDialogTitle("Choose where to save...");
                                f.setFileSelectionMode(1);
                                f.showSaveDialog(VersionManagerWindow.this);
                                if (f.getSelectedFile() != null) {
                                    outputFile = f.getSelectedFile();
                                }
                            }
                            if (outputFile == null) {
                                SwingUtilities.invokeLater(() -> {
                                    VersionManagerWindow.this.downloadFinished = true;
                                    VersionManagerWindow.this.btnOk.setEnabled(true);
                                    VersionManagerWindow.this.btnCancel.setEnabled(true);
                                    VersionManagerWindow.this.archiveSelector.setEnabled(true);
                                    VersionManagerWindow.this.btnAdd.setEnabled(true);
                                    VersionManagerWindow.this.checkBoxDownload.setVisible(VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE);
                                    VersionManagerWindow.this.checkBoxDownload.setEnabled(chBoxWasEnabled);
                                    VersionManagerWindow.this.btnExport.setEnabled(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE && VersionManagerWindow.this.lastArchive.supportsDownloads);
                                    VersionManagerWindow.this.btnDelete.setVisible(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.isUserArchive);
                                    VersionManagerWindow.this.btnDelete.setEnabled(true);
                                    VersionManagerWindow.this.btnImport.setEnabled(true);
                                    VersionManagerWindow.this.qualityLevelBox.setEnabled(true);
                                    VersionManagerWindow.this.clientListBox.setEnabled(true);
                                    VersionManagerWindow.this.btnRemove.setEnabled(wasEnabledRemove);
                                    VersionManagerWindow.this.btnOk.setText("Ok");
                                    VersionManagerWindow.this.lblThanks.setVisible(VersionManagerWindow.this.lastArchive != null);
                                    VersionManagerWindow.this.lblThanks.setText("");
                                    if (VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.archiveDef.has("thanksTo")) {
                                        VersionManagerWindow.this.lblThanks.setText("Assets kindly mirrored by " + VersionManagerWindow.this.lastArchive.archiveDef.get("thanksTo").getAsString());
                                    }
                                });
                                return;
                            }
                            VersionManagerWindow.this.downloadFinished = false;
                            Thread th2 = new Thread(() -> {
                                Object lastMsg = "";
                                while (!VersionManagerWindow.this.downloadFinished) {
                                    try {
                                        String pref = LauncherUtils.getStatusMessage();
                                        int percentage = (int)(100.0f / (float)LauncherUtils.getProgressMax() * (float)LauncherUtils.getProgress());
                                        Object suff = " [" + percentage + "%]";
                                        if (!LauncherUtils.isProgressPanelVisible()) {
                                            suff = "";
                                        }
                                        String sF = suff;
                                        if (!((String)lastMsg).equals(pref + (String)suff)) {
                                            lastMsg = pref + (String)suff;
                                            SwingUtilities.invokeAndWait(() -> {
                                                if (!VersionManagerWindow.this.downloadFinished) {
                                                    VersionManagerWindow.this.lblThanks.setText(pref + sF);
                                                }
                                            });
                                        }
                                        Thread.sleep(100L);
                                    }
                                    catch (InterruptedException | InvocationTargetException e1) {
                                        break;
                                    }
                                }
                            });
                            th2.setDaemon(true);
                            th2.start();
                            LauncherUtils.log("Preparing assets...", true);
                            AssetManager.migrateAssetsIfNeeded();
                            LauncherUtils.hideProgressPanel();
                            LauncherUtils.resetProgressBar();
                            LauncherUtils.setStatus("Checking for updates...");
                            try {
                                AssetManager.verifyClients(true);
                                LauncherUtils.hideProgressPanel();
                                LauncherUtils.resetProgressBar();
                            }
                            catch (IOException e2) {
                                LauncherUtils.hideProgressPanel();
                                LauncherUtils.resetProgressBar();
                                JOptionPane.showMessageDialog(VersionManagerWindow.this, "Server connection could not be established with the archive server!\n\nCannot export as there are clients that are not up to date!", "No server connection", 0);
                                SwingUtilities.invokeLater(() -> {
                                    VersionManagerWindow.this.downloadFinished = true;
                                    VersionManagerWindow.this.btnOk.setEnabled(true);
                                    VersionManagerWindow.this.btnCancel.setEnabled(true);
                                    VersionManagerWindow.this.archiveSelector.setEnabled(true);
                                    VersionManagerWindow.this.btnAdd.setEnabled(true);
                                    VersionManagerWindow.this.checkBoxDownload.setVisible(VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE);
                                    VersionManagerWindow.this.checkBoxDownload.setEnabled(chBoxWasEnabled);
                                    VersionManagerWindow.this.btnExport.setEnabled(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE && VersionManagerWindow.this.lastArchive.supportsDownloads);
                                    VersionManagerWindow.this.btnDelete.setVisible(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.isUserArchive);
                                    VersionManagerWindow.this.btnDelete.setEnabled(true);
                                    VersionManagerWindow.this.btnImport.setEnabled(true);
                                    VersionManagerWindow.this.qualityLevelBox.setEnabled(true);
                                    VersionManagerWindow.this.clientListBox.setEnabled(true);
                                    VersionManagerWindow.this.btnRemove.setEnabled(wasEnabledRemove);
                                    VersionManagerWindow.this.btnOk.setText("Ok");
                                    VersionManagerWindow.this.lblThanks.setVisible(VersionManagerWindow.this.lastArchive != null);
                                    VersionManagerWindow.this.lblThanks.setText("");
                                    if (VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.archiveDef.has("thanksTo")) {
                                        VersionManagerWindow.this.lblThanks.setText("Assets kindly mirrored by " + VersionManagerWindow.this.lastArchive.archiveDef.get("thanksTo").getAsString());
                                    }
                                });
                                return;
                            }
                            LauncherUtils.log("Verifying assets...", true);
                            if (assetsNeedingDownloads.size() != 0) {
                                if (!AssetManager.testArchiveConnection(VersionManagerWindow.this.lastArchive)) {
                                    JOptionPane.showMessageDialog(VersionManagerWindow.this, "Server connection could not be established with the archive server!\n\nCannot export as there are assets that need to be updated!", "No server connection", 0);
                                    SwingUtilities.invokeLater(() -> {
                                        VersionManagerWindow.this.downloadFinished = true;
                                        VersionManagerWindow.this.btnOk.setEnabled(true);
                                        VersionManagerWindow.this.btnCancel.setEnabled(true);
                                        VersionManagerWindow.this.archiveSelector.setEnabled(true);
                                        VersionManagerWindow.this.btnAdd.setEnabled(true);
                                        VersionManagerWindow.this.checkBoxDownload.setVisible(VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE);
                                        VersionManagerWindow.this.checkBoxDownload.setEnabled(chBoxWasEnabled);
                                        VersionManagerWindow.this.btnExport.setEnabled(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE && VersionManagerWindow.this.lastArchive.supportsDownloads);
                                        VersionManagerWindow.this.btnDelete.setVisible(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.isUserArchive);
                                        VersionManagerWindow.this.btnDelete.setEnabled(true);
                                        VersionManagerWindow.this.btnImport.setEnabled(true);
                                        VersionManagerWindow.this.qualityLevelBox.setEnabled(true);
                                        VersionManagerWindow.this.clientListBox.setEnabled(true);
                                        VersionManagerWindow.this.btnRemove.setEnabled(wasEnabledRemove);
                                        VersionManagerWindow.this.btnOk.setText("Ok");
                                        VersionManagerWindow.this.lblThanks.setVisible(VersionManagerWindow.this.lastArchive != null);
                                        VersionManagerWindow.this.lblThanks.setText("");
                                        if (VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.archiveDef.has("thanksTo")) {
                                            VersionManagerWindow.this.lblThanks.setText("Assets kindly mirrored by " + VersionManagerWindow.this.lastArchive.archiveDef.get("thanksTo").getAsString());
                                        }
                                    });
                                    return;
                                }
                                LauncherUtils.log("Downloading client assets...", true);
                                LauncherUtils.getGameDescriptor().downloadAssets(VersionManagerWindow.this.lastArchive.source, (String[])arrayList.toArray(String[]::new), (AssetInformation[])assetsNeedingDownloads.values().toArray(AssetInformation[]::new), (AssetInformation[])linkedHashMap.values().toArray(AssetInformation[]::new), (AssetInformation[])((HashMap)assetsList).values().toArray(AssetInformation[]::new), AssetManager.getActiveArchive(), VersionManagerWindow.this.lastArchive.archiveDef, archiveDescriptor, assetHashes);
                            }
                            LauncherUtils.log("Preparing to export archive...", true);
                            if (selected == 0) {
                                LauncherUtils.log("Preparing output file...");
                                FileOutputStream fO = new FileOutputStream(outputFile);
                                ZipOutputStream zO = new ZipOutputStream(fO);
                                try {
                                    int max = 1;
                                    LinkedHashMap<String, AssetInformation> deduped = new LinkedHashMap<String, AssetInformation>();
                                    for (AssetInformation asset : linkedHashMap.values()) {
                                        if (deduped.containsKey(asset.assetHash)) continue;
                                        deduped.put(asset.assetHash, asset);
                                    }
                                    int descriptorIndexSize = VersionManagerWindow.indexDir(new File("assets/descriptor"));
                                    max += versions.size() * 100;
                                    max += deduped.size();
                                    LauncherUtils.resetProgressBar();
                                    LauncherUtils.setProgress(0, max += descriptorIndexSize);
                                    LauncherUtils.showProgressPanel();
                                    String plat = null;
                                    if (System.getProperty("os.name").toLowerCase().contains("win") && !System.getProperty("os.name").toLowerCase().contains("darwin")) {
                                        plat = "windows";
                                    } else if (System.getProperty("os.name").toLowerCase().contains("darwin") || System.getProperty("os.name").toLowerCase().contains("mac")) {
                                        plat = "macos";
                                    } else if (System.getProperty("os.name").toLowerCase().contains("linux")) {
                                        plat = "linux";
                                    }
                                    int i = 0;
                                    int p = 0;
                                    LauncherUtils.log("Adding clients...");
                                    LauncherUtils.setStatus("Archiving... Adding " + i + "/" + versions.size() + " clients...");
                                    ZipEntry ent = new ZipEntry("clients/");
                                    zO.putNextEntry(ent);
                                    zO.closeEntry();
                                    for (String version : versions) {
                                        LauncherUtils.log("Adding " + version + "...");
                                        LauncherUtils.setStatus("Archiving... Adding " + (i + 1) + "/" + versions.size() + " clients... [0%]");
                                        ent = new ZipEntry("clients/client-" + version + "/");
                                        zO.putNextEntry(ent);
                                        zO.closeEntry();
                                        int maxM = max;
                                        int in = i++;
                                        int progStart = LauncherUtils.getProgress();
                                        String cHash = archiveDescriptor.get("versionHashes").getAsJsonObject().get(plat).getAsJsonObject().get(version).getAsString();
                                        LauncherUtils.getGameDescriptor().addCleanClientFilesToArchiveFile(zO, version, "clients/client-" + version + "/", outputFile, VersionManagerWindow.this.lastArchive, VersionManagerWindow.this.lastArchive.archiveDef, archiveDescriptor, cHash, (val, mx) -> {
                                            float step = 100.0f / (float)mx.intValue();
                                            LauncherUtils.setProgress(progStart + (int)(step * (float)val.intValue()), maxM);
                                            LauncherUtils.setStatus("Archiving... Adding " + (in + 1) + "/" + versions.size() + " clients... [" + (int)(step * (float)val.intValue()) + "%]");
                                        });
                                        p = progStart + 100;
                                        LauncherUtils.setProgress(p, max);
                                    }
                                    ent = new ZipEntry("assets/");
                                    zO.putNextEntry(ent);
                                    zO.closeEntry();
                                    i = 0;
                                    LauncherUtils.log("Adding asset files...");
                                    LauncherUtils.setStatus("Archiving... Copying " + i + "/" + deduped.size() + " assets... [0%]");
                                    for (AssetInformation asset : deduped.values()) {
                                        float step = 100.0f / (float)deduped.size();
                                        LauncherUtils.log("Adding " + asset.assetPath + "...");
                                        LauncherUtils.setStatus("Archiving... Added " + (i + 1) + "/" + deduped.size() + " assets... [" + (int)(step * (float)i) + "%]");
                                        ent = new ZipEntry("assets/" + asset.assetHash + ".sa");
                                        zO.putNextEntry(ent);
                                        FileInputStream fIn = new FileInputStream(asset.localAssetFile);
                                        fIn.transferTo(zO);
                                        fIn.close();
                                        zO.closeEntry();
                                        ++i;
                                        LauncherUtils.setProgress(++p, max);
                                    }
                                    ent = new ZipEntry("descriptor/");
                                    zO.putNextEntry(ent);
                                    zO.closeEntry();
                                    i = 0;
                                    LauncherUtils.log("Adding descriptor files...");
                                    LauncherUtils.setStatus("Archiving... Copying " + i + "/" + descriptorIndexSize + " descriptor files...");
                                    VersionManagerWindow.this.transferDescriptor(new File("assets/descriptor"), zO, "", i, descriptorIndexSize);
                                    LauncherUtils.log("Creating archive information file...", true);
                                    JsonObject archiveInfoJson = new JsonObject();
                                    archiveInfoJson.addProperty("type", VersionManagerWindow.this.lastArchive.descriptorType);
                                    JsonObject clientLst = new JsonObject();
                                    for (String version : versions) {
                                        clientLst.addProperty(version, "clients/client-" + version);
                                    }
                                    archiveInfoJson.add("clients", (JsonElement)clientLst);
                                    ent = new ZipEntry("archiveinfo.json");
                                    zO.putNextEntry(ent);
                                    zO.write(new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)archiveInfoJson).getBytes("UTF-8"));
                                    zO.closeEntry();
                                    LauncherUtils.hideProgressPanel();
                                    LauncherUtils.resetProgressBar();
                                    LauncherUtils.log("Finished! Archive saved to " + outputFile.getPath() + "!", true);
                                    JOptionPane.showMessageDialog(VersionManagerWindow.this, "Archive created successfully!\n\nArchive has been saved to '" + outputFile.getPath() + "'", "Archive created successfully", 1);
                                }
                                finally {
                                    zO.close();
                                    fO.close();
                                }
                            } else if (selected == 1) {
                                LauncherUtils.log("Creating output folders...");
                                File outputAssets = new File(outputFile, "assets");
                                File outputClients = new File(outputFile, "clients");
                                File archiveInfo = new File(outputFile, "sentinelarchiveinfo.json");
                                outputAssets.mkdirs();
                                outputClients.mkdirs();
                                int max = 1 + versions.size() + linkedHashMap.size();
                                LauncherUtils.resetProgressBar();
                                LauncherUtils.setProgress(0, max);
                                LauncherUtils.showProgressPanel();
                                String plat = null;
                                if (System.getProperty("os.name").toLowerCase().contains("win") && !System.getProperty("os.name").toLowerCase().contains("darwin")) {
                                    plat = "windows";
                                } else if (System.getProperty("os.name").toLowerCase().contains("darwin") || System.getProperty("os.name").toLowerCase().contains("mac")) {
                                    plat = "macos";
                                } else if (System.getProperty("os.name").toLowerCase().contains("linux")) {
                                    plat = "linux";
                                }
                                int i = 0;
                                int p = 0;
                                LauncherUtils.log("Copying clients...");
                                LauncherUtils.setStatus("Creating archive... Copying " + i + "/" + versions.size() + " clients...");
                                LinkedHashMap<String, String> clientPaths = new LinkedHashMap<String, String>();
                                for (String version : versions) {
                                    File clientOutputFile;
                                    File f;
                                    LauncherUtils.log("Copying " + version + "...");
                                    LauncherUtils.setStatus("Creating archive... Copying " + (i + 1) + "/" + versions.size() + " clients...");
                                    String cHash = archiveDescriptor.get("versionHashes").getAsJsonObject().get(plat).getAsJsonObject().get(version).getAsString();
                                    for (f = clientOutputFile = LauncherUtils.getGameDescriptor().addClientToArchiveFolder(version, outputClients, outputFile, VersionManagerWindow.this.lastArchive, VersionManagerWindow.this.lastArchive.archiveDef, archiveDescriptor, cHash); f != null && !f.getAbsolutePath().equalsIgnoreCase(outputFile.getAbsolutePath()); f = f.getParentFile()) {
                                    }
                                    if (f == null) {
                                        throw new IOException("Game descriptor returned a client path that is not relative to the archive: " + clientOutputFile);
                                    }
                                    String pth = outputFile.toPath().relativize(clientOutputFile.toPath()).toString();
                                    clientPaths.put(version, pth);
                                    ++i;
                                    LauncherUtils.setProgress(++p, max);
                                }
                                i = 0;
                                LauncherUtils.log("Copying asset files...");
                                LauncherUtils.setStatus("Creating archive... Copying " + i + "/" + linkedHashMap.size() + " assets...");
                                for (AssetInformation asset : linkedHashMap.values()) {
                                    LauncherUtils.log("Copying " + asset.assetPath + "...");
                                    LauncherUtils.setStatus("Creating archive... Copying " + (i + 1) + "/" + linkedHashMap.size() + " assets...");
                                    File output = new File(outputAssets, asset.assetPath);
                                    output.getParentFile().mkdirs();
                                    Files.copy(asset.localAssetFile.toPath(), output.toPath(), StandardCopyOption.REPLACE_EXISTING);
                                    ++i;
                                    LauncherUtils.setProgress(++p, max);
                                }
                                LauncherUtils.log("Waiting for user input...", true);
                                ArchiveCreationWindow window = new ArchiveCreationWindow();
                                ArchiveCreationWindow.CreationResult res = window.show(VersionManagerWindow.this);
                                if (res != null) {
                                    LauncherUtils.log("Creating archive information file...", true);
                                    Object urlBase = res.archiveURL;
                                    if (!((String)urlBase).endsWith("/")) {
                                        urlBase = (String)urlBase + "/";
                                    }
                                    JsonObject archiveInfoJson = new JsonObject();
                                    archiveInfoJson.addProperty("archiveName", res.archiveName);
                                    if (res.creditsField != null) {
                                        archiveInfoJson.addProperty("thanksTo", res.creditsField);
                                    }
                                    archiveInfoJson.addProperty("type", VersionManagerWindow.this.lastArchive.descriptorType);
                                    archiveInfoJson.addProperty("allowFullDownload", Boolean.valueOf(res.allowDownload));
                                    archiveInfoJson.addProperty("allowStreaming", Boolean.valueOf(res.allowStreaming));
                                    archiveInfoJson.addProperty("deprecated", Boolean.valueOf(false));
                                    archiveInfoJson.addProperty("deprecationNotice", "");
                                    JsonObject clientLst = new JsonObject();
                                    for (String version : versions) {
                                        clientLst.addProperty(version, (String)clientPaths.get(version));
                                    }
                                    archiveInfoJson.add("clients", (JsonElement)clientLst);
                                    Files.writeString(archiveInfo.toPath(), (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)archiveInfoJson), new OpenOption[0]);
                                    LauncherUtils.hideProgressPanel();
                                    LauncherUtils.resetProgressBar();
                                    LauncherUtils.log("Finished! Archive saved to " + outputFile.getPath() + "!", true);
                                    JOptionPane.showMessageDialog(VersionManagerWindow.this, "Archive created successfully!\n\nArchive has been saved to '" + outputFile.getPath() + "'", "Archive created successfully", 1);
                                    String id = UUID.randomUUID().toString();
                                    while (AssetManager.getArchive(id) != null) {
                                        id = UUID.randomUUID().toString();
                                    }
                                    JsonObject entry = new JsonObject();
                                    entry.add(id, (JsonElement)archiveInfoJson);
                                    ArchiveDefSnippetViewer viewer = new ArchiveDefSnippetViewer();
                                    viewer.show(VersionManagerWindow.this, new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)entry));
                                } else {
                                    LauncherUtils.hideProgressPanel();
                                    LauncherUtils.resetProgressBar();
                                }
                            }
                            VersionManagerWindow.this.downloadFinished = true;
                            SwingUtilities.invokeLater(() -> {
                                VersionManagerWindow.this.downloadFinished = true;
                                VersionManagerWindow.this.btnOk.setEnabled(true);
                                VersionManagerWindow.this.btnCancel.setEnabled(true);
                                VersionManagerWindow.this.archiveSelector.setEnabled(true);
                                VersionManagerWindow.this.btnAdd.setEnabled(true);
                                VersionManagerWindow.this.checkBoxDownload.setVisible(VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE);
                                VersionManagerWindow.this.checkBoxDownload.setEnabled(chBoxWasEnabled);
                                VersionManagerWindow.this.btnExport.setEnabled(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE && VersionManagerWindow.this.lastArchive.supportsDownloads);
                                VersionManagerWindow.this.btnDelete.setVisible(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.isUserArchive);
                                VersionManagerWindow.this.btnDelete.setEnabled(true);
                                VersionManagerWindow.this.btnImport.setEnabled(true);
                                VersionManagerWindow.this.qualityLevelBox.setEnabled(true);
                                VersionManagerWindow.this.clientListBox.setEnabled(true);
                                VersionManagerWindow.this.btnRemove.setEnabled(wasEnabledRemove);
                                VersionManagerWindow.this.btnOk.setText("Ok");
                                VersionManagerWindow.this.lblThanks.setVisible(VersionManagerWindow.this.lastArchive != null);
                                VersionManagerWindow.this.lblThanks.setText("");
                                if (VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.archiveDef.has("thanksTo")) {
                                    VersionManagerWindow.this.lblThanks.setText("Assets kindly mirrored by " + VersionManagerWindow.this.lastArchive.archiveDef.get("thanksTo").getAsString());
                                }
                            });
                        }
                        catch (Exception e2) {
                            Object stackTrace = "";
                            Throwable t2 = e2;
                            while (t2 != null) {
                                for (StackTraceElement ele : t2.getStackTrace()) {
                                    stackTrace = (String)stackTrace + "\n     At: " + ele;
                                }
                                if ((t2 = t2.getCause()) == null) continue;
                                stackTrace = (String)stackTrace + "\nCaused by: " + t2;
                            }
                            JOptionPane.showMessageDialog(VersionManagerWindow.this, "An error occurred!\n\nError details: " + e2 + (String)stackTrace, "Export error", 0);
                            VersionManagerWindow.this.downloadFinished = true;
                            SwingUtilities.invokeLater(() -> {
                                VersionManagerWindow.this.btnOk.setEnabled(true);
                                VersionManagerWindow.this.btnCancel.setEnabled(true);
                                VersionManagerWindow.this.archiveSelector.setEnabled(true);
                                VersionManagerWindow.this.btnAdd.setEnabled(true);
                                VersionManagerWindow.this.checkBoxDownload.setVisible(VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE);
                                VersionManagerWindow.this.checkBoxDownload.setEnabled(chBoxWasEnabled);
                                VersionManagerWindow.this.btnDelete.setVisible(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.isUserArchive);
                                VersionManagerWindow.this.btnExport.setEnabled(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE && VersionManagerWindow.this.lastArchive.supportsDownloads);
                                VersionManagerWindow.this.btnDelete.setVisible(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.isUserArchive);
                                VersionManagerWindow.this.btnDelete.setEnabled(true);
                                VersionManagerWindow.this.btnImport.setEnabled(true);
                                VersionManagerWindow.this.qualityLevelBox.setEnabled(true);
                                VersionManagerWindow.this.clientListBox.setEnabled(true);
                                VersionManagerWindow.this.btnRemove.setEnabled(wasEnabledRemove);
                                VersionManagerWindow.this.btnOk.setText("Ok");
                                VersionManagerWindow.this.lblThanks.setVisible(VersionManagerWindow.this.lastArchive != null);
                                VersionManagerWindow.this.lblThanks.setText("");
                                if (VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.archiveDef.has("thanksTo")) {
                                    VersionManagerWindow.this.lblThanks.setText("Assets kindly mirrored by " + VersionManagerWindow.this.lastArchive.archiveDef.get("thanksTo").getAsString());
                                }
                            });
                        }
                    });
                    th.setDaemon(true);
                    th.start();
                }
            }
        });
        this.btnImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = JOptionPane.showOptionDialog(VersionManagerWindow.this, "Welcome to the archive import tool!\nHere you can add local and unofficial archives to Sentinel.\n\nPlease select a operation...\n ", "Archive Exporter", -1, 3, null, new Object[]{"Import SGA file", "Add fan-run remote server", "Cancel"}, "Cancel");
                if (selected == 2 || selected == -1) {
                    return;
                }
                boolean wasEnabledRemove = VersionManagerWindow.this.btnRemove.isEnabled();
                VersionManagerWindow.this.btnOk.setEnabled(false);
                VersionManagerWindow.this.qualityLevelBox.setEnabled(false);
                VersionManagerWindow.this.btnCancel.setEnabled(false);
                VersionManagerWindow.this.archiveSelector.setEnabled(false);
                VersionManagerWindow.this.btnAdd.setEnabled(false);
                boolean chBoxWasEnabled = VersionManagerWindow.this.checkBoxDownload.isEnabled();
                VersionManagerWindow.this.checkBoxDownload.setEnabled(false);
                VersionManagerWindow.this.clientListBox.setEnabled(false);
                VersionManagerWindow.this.btnExport.setEnabled(false);
                VersionManagerWindow.this.btnImport.setEnabled(false);
                VersionManagerWindow.this.btnRemove.setEnabled(false);
                VersionManagerWindow.this.btnDelete.setEnabled(false);
                Thread th = new Thread(() -> {
                    block17: {
                        try {
                            VersionManagerWindow.this.btnOk.setText("Busy...");
                            SwingUtilities.invokeAndWait(() -> {
                                VersionManagerWindow.this.lblThanks.setText("Preparing to import...");
                                VersionManagerWindow.this.lblThanks.setVisible(true);
                            });
                            LauncherUtils.setStatus("Preparing to import...");
                            LauncherUtils.log("Determining mode...");
                            if (selected == 0) {
                                ArchiveInformation archive;
                                LauncherUtils.log("SGA mode, requesting user file selection...");
                                SwingUtilities.invokeAndWait(() -> {
                                    VersionManagerWindow.this.lblThanks.setText("Awaiting user selection...");
                                    VersionManagerWindow.this.lblThanks.setVisible(true);
                                });
                                LauncherUtils.log("Awaiting user selection...");
                                JFileChooser f = new JFileChooser();
                                f.setDialogTitle("Choose SGA file to load...");
                                FileFilter filter = new FileFilter(){

                                    @Override
                                    public boolean accept(File f) {
                                        return f.isDirectory() || f.getName().endsWith(".sga");
                                    }

                                    @Override
                                    public String getDescription() {
                                        return "Sentinel game asset archive files (*.sga)";
                                    }
                                };
                                f.addChoosableFileFilter(filter);
                                f.setFileFilter(filter);
                                f.showOpenDialog(VersionManagerWindow.this);
                                if (f.getSelectedFile() == null) {
                                    SwingUtilities.invokeLater(() -> {
                                        VersionManagerWindow.this.btnOk.setEnabled(true);
                                        VersionManagerWindow.this.btnCancel.setEnabled(true);
                                        VersionManagerWindow.this.archiveSelector.setEnabled(true);
                                        VersionManagerWindow.this.btnAdd.setEnabled(true);
                                        VersionManagerWindow.this.checkBoxDownload.setEnabled(chBoxWasEnabled);
                                        VersionManagerWindow.this.btnDelete.setVisible(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.isUserArchive);
                                        VersionManagerWindow.this.btnExport.setEnabled(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE && VersionManagerWindow.this.lastArchive.supportsDownloads);
                                        VersionManagerWindow.this.btnDelete.setVisible(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.isUserArchive);
                                        VersionManagerWindow.this.btnDelete.setEnabled(true);
                                        VersionManagerWindow.this.btnImport.setEnabled(true);
                                        VersionManagerWindow.this.qualityLevelBox.setEnabled(true);
                                        VersionManagerWindow.this.clientListBox.setEnabled(true);
                                        VersionManagerWindow.this.btnRemove.setEnabled(wasEnabledRemove);
                                        VersionManagerWindow.this.btnOk.setText("Ok");
                                        VersionManagerWindow.this.lblThanks.setVisible(VersionManagerWindow.this.lastArchive != null);
                                        VersionManagerWindow.this.lblThanks.setText("");
                                        if (VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.archiveDef.has("thanksTo")) {
                                            VersionManagerWindow.this.lblThanks.setText("Assets kindly mirrored by " + VersionManagerWindow.this.lastArchive.archiveDef.get("thanksTo").getAsString());
                                        }
                                    });
                                }
                                LauncherUtils.log("Reading SGA file...");
                                SwingUtilities.invokeAndWait(() -> {
                                    VersionManagerWindow.this.lblThanks.setText("Reading SGA file...");
                                    VersionManagerWindow.this.lblThanks.setVisible(true);
                                });
                                ZipFile zip = new ZipFile(f.getSelectedFile());
                                ZipEntry entry = zip.getEntry("archiveinfo.json");
                                if (entry == null) {
                                    zip.close();
                                    JOptionPane.showMessageDialog(VersionManagerWindow.this, "Invalid SGA file was selected.\n\nPlease select a valid Sentinel Archive File.", "Import error", 0);
                                    SwingUtilities.invokeLater(() -> {
                                        VersionManagerWindow.this.btnOk.setEnabled(true);
                                        VersionManagerWindow.this.btnCancel.setEnabled(true);
                                        VersionManagerWindow.this.archiveSelector.setEnabled(true);
                                        VersionManagerWindow.this.btnAdd.setEnabled(true);
                                        VersionManagerWindow.this.checkBoxDownload.setEnabled(chBoxWasEnabled);
                                        VersionManagerWindow.this.btnDelete.setVisible(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.isUserArchive);
                                        VersionManagerWindow.this.btnExport.setEnabled(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE && VersionManagerWindow.this.lastArchive.supportsDownloads);
                                        VersionManagerWindow.this.btnDelete.setVisible(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.isUserArchive);
                                        VersionManagerWindow.this.btnDelete.setEnabled(true);
                                        VersionManagerWindow.this.btnImport.setEnabled(true);
                                        VersionManagerWindow.this.qualityLevelBox.setEnabled(true);
                                        VersionManagerWindow.this.clientListBox.setEnabled(true);
                                        VersionManagerWindow.this.btnRemove.setEnabled(wasEnabledRemove);
                                        VersionManagerWindow.this.btnOk.setText("Ok");
                                        VersionManagerWindow.this.lblThanks.setVisible(VersionManagerWindow.this.lastArchive != null);
                                        VersionManagerWindow.this.lblThanks.setText("");
                                        if (VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.archiveDef.has("thanksTo")) {
                                            VersionManagerWindow.this.lblThanks.setText("Assets kindly mirrored by " + VersionManagerWindow.this.lastArchive.archiveDef.get("thanksTo").getAsString());
                                        }
                                    });
                                }
                                InputStream strm = zip.getInputStream(entry);
                                JsonObject archiveDetails = JsonParser.parseString((String)new String(strm.readAllBytes(), "UTF-8")).getAsJsonObject();
                                strm.close();
                                LauncherUtils.log("Adding archive...");
                                SwingUtilities.invokeAndWait(() -> {
                                    VersionManagerWindow.this.lblThanks.setText("Adding archive...");
                                    VersionManagerWindow.this.lblThanks.setVisible(true);
                                });
                                archiveDetails.addProperty("isSgaFile", Boolean.valueOf(true));
                                archiveDetails.addProperty("allowFullDownload", Boolean.valueOf(true));
                                archiveDetails.addProperty("allowStreaming", Boolean.valueOf(false));
                                archiveDetails.addProperty("archiveName", f.getSelectedFile().getName());
                                archiveDetails.addProperty("filePath", f.getSelectedFile().getCanonicalPath());
                                VersionManagerWindow.this.lastArchive = archive = AssetManager.addUserArchive(archiveDetails);
                                VersionManagerWindow.this.saveSettings();
                                if (new File("assets/descriptor.hash").exists()) {
                                    new File("assets/descriptor.hash").delete();
                                }
                                if (new File("assets/descriptor-local.version").exists()) {
                                    new File("assets/descriptor-local.version").delete();
                                }
                                SwingUtilities.invokeAndWait(() -> {
                                    VersionManagerWindow.this.btnOk.setEnabled(true);
                                    VersionManagerWindow.this.btnCancel.setEnabled(true);
                                    VersionManagerWindow.this.archiveSelector.setEnabled(true);
                                    VersionManagerWindow.this.btnAdd.setEnabled(true);
                                    VersionManagerWindow.this.checkBoxDownload.setEnabled(chBoxWasEnabled);
                                    VersionManagerWindow.this.btnDelete.setVisible(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.isUserArchive);
                                    VersionManagerWindow.this.btnExport.setEnabled(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE && VersionManagerWindow.this.lastArchive.supportsDownloads);
                                    VersionManagerWindow.this.btnDelete.setVisible(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.isUserArchive);
                                    VersionManagerWindow.this.btnDelete.setEnabled(true);
                                    VersionManagerWindow.this.btnImport.setEnabled(true);
                                    VersionManagerWindow.this.qualityLevelBox.setEnabled(true);
                                    VersionManagerWindow.this.clientListBox.setEnabled(true);
                                    VersionManagerWindow.this.btnRemove.setEnabled(wasEnabledRemove);
                                    VersionManagerWindow.this.btnOk.setText("Ok");
                                    VersionManagerWindow.this.lblThanks.setVisible(VersionManagerWindow.this.lastArchive != null);
                                    VersionManagerWindow.this.lblThanks.setText("");
                                    if (VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.archiveDef.has("thanksTo")) {
                                        VersionManagerWindow.this.lblThanks.setText("Assets kindly mirrored by " + VersionManagerWindow.this.lastArchive.archiveDef.get("thanksTo").getAsString());
                                    }
                                    VersionManagerWindow.this.checkBoxDownload.setEnabled(!VersionManagerWindow.this.lastArchive.isDeprecated && VersionManagerWindow.this.lastArchive.supportsDownloads && VersionManagerWindow.this.lastArchive.supportsStreaming);
                                    VersionManagerWindow.this.checkBoxDownload.setSelected(!VersionManagerWindow.this.lastArchive.supportsStreaming);
                                    VersionManagerWindow.this.lblQualityLevels.setVisible(VersionManagerWindow.this.checkBoxDownload.isSelected());
                                    VersionManagerWindow.this.qualityLevelBox.setVisible(VersionManagerWindow.this.checkBoxDownload.isSelected());
                                    VersionManagerWindow.this.btnExport.setEnabled(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE && VersionManagerWindow.this.lastArchive.supportsDownloads);
                                    VersionManagerWindow.this.btnDelete.setVisible(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.isUserArchive);
                                    VersionManagerWindow.this.btnDelete.setEnabled(true);
                                    VersionManagerWindow.this.archiveSelector.setSelectedItem(VersionManagerWindow.this.lastArchive);
                                    VersionManagerWindow.this.refreshClientList();
                                });
                                break block17;
                            }
                            if (selected != 1) break block17;
                            LauncherUtils.log("Remote server mode, requesting URL...");
                            SwingUtilities.invokeAndWait(() -> {
                                VersionManagerWindow.this.lblThanks.setText("Awaiting URL input...");
                                VersionManagerWindow.this.lblThanks.setVisible(true);
                            });
                            LauncherUtils.log("Awaiting URL input...");
                            String url = JOptionPane.showInputDialog(VersionManagerWindow.this, "Server URL", "Add server", 3);
                            if (url == null) {
                                SwingUtilities.invokeLater(() -> {
                                    VersionManagerWindow.this.btnOk.setEnabled(true);
                                    VersionManagerWindow.this.btnCancel.setEnabled(true);
                                    VersionManagerWindow.this.archiveSelector.setEnabled(true);
                                    VersionManagerWindow.this.btnAdd.setEnabled(true);
                                    VersionManagerWindow.this.checkBoxDownload.setEnabled(chBoxWasEnabled);
                                    VersionManagerWindow.this.btnDelete.setVisible(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.isUserArchive);
                                    VersionManagerWindow.this.btnExport.setEnabled(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE && VersionManagerWindow.this.lastArchive.supportsDownloads);
                                    VersionManagerWindow.this.btnDelete.setVisible(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.isUserArchive);
                                    VersionManagerWindow.this.btnDelete.setEnabled(true);
                                    VersionManagerWindow.this.btnImport.setEnabled(true);
                                    VersionManagerWindow.this.qualityLevelBox.setEnabled(true);
                                    VersionManagerWindow.this.clientListBox.setEnabled(true);
                                    VersionManagerWindow.this.btnRemove.setEnabled(wasEnabledRemove);
                                    VersionManagerWindow.this.btnOk.setText("Ok");
                                    VersionManagerWindow.this.lblThanks.setVisible(VersionManagerWindow.this.lastArchive != null);
                                    VersionManagerWindow.this.lblThanks.setText("");
                                    if (VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.archiveDef.has("thanksTo")) {
                                        VersionManagerWindow.this.lblThanks.setText("Assets kindly mirrored by " + VersionManagerWindow.this.lastArchive.archiveDef.get("thanksTo").getAsString());
                                    }
                                });
                                return;
                            }
                            LauncherUtils.log("Contacting server...");
                            SwingUtilities.invokeAndWait(() -> {
                                VersionManagerWindow.this.lblThanks.setText("Contacting server...");
                                VersionManagerWindow.this.lblThanks.setVisible(true);
                            });
                            try {
                                ArchiveInformation archive;
                                JsonObject archiveDetails;
                                Object archiveURL = url;
                                if (!((String)archiveURL).endsWith("/")) {
                                    archiveURL = (String)archiveURL + "/";
                                }
                                if (!((archiveDetails = JsonParser.parseString((String)LauncherUtils.downloadString((String)archiveURL + "sentinelarchiveinfo.json")).getAsJsonObject()).has("archiveName") && archiveDetails.has("type") && archiveDetails.has("allowFullDownload") && archiveDetails.has("allowStreaming") && archiveDetails.has("deprecated") && archiveDetails.has("clients") && archiveDetails.get("clients").isJsonObject())) {
                                    throw new IOException();
                                }
                                LauncherUtils.log("Adding archive...");
                                SwingUtilities.invokeAndWait(() -> {
                                    VersionManagerWindow.this.lblThanks.setText("Adding archive...");
                                    VersionManagerWindow.this.lblThanks.setVisible(true);
                                });
                                archiveDetails.addProperty("url", (String)archiveURL + "assets");
                                JsonObject clients = archiveDetails.get("clients").getAsJsonObject();
                                for (String version : clients.keySet()) {
                                    clients.addProperty(version, (String)archiveURL + clients.get(version).getAsString());
                                }
                                VersionManagerWindow.this.lastArchive = archive = AssetManager.addUserArchive(archiveDetails);
                                VersionManagerWindow.this.saveSettings();
                                if (new File("assets/descriptor.hash").exists()) {
                                    new File("assets/descriptor.hash").delete();
                                }
                                if (new File("assets/descriptor-local.version").exists()) {
                                    new File("assets/descriptor-local.version").delete();
                                }
                                SwingUtilities.invokeAndWait(() -> {
                                    VersionManagerWindow.this.btnOk.setEnabled(true);
                                    VersionManagerWindow.this.btnCancel.setEnabled(true);
                                    VersionManagerWindow.this.archiveSelector.setEnabled(true);
                                    VersionManagerWindow.this.btnAdd.setEnabled(true);
                                    VersionManagerWindow.this.checkBoxDownload.setEnabled(chBoxWasEnabled);
                                    VersionManagerWindow.this.btnDelete.setVisible(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.isUserArchive);
                                    VersionManagerWindow.this.btnExport.setEnabled(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE && VersionManagerWindow.this.lastArchive.supportsDownloads);
                                    VersionManagerWindow.this.btnDelete.setVisible(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.isUserArchive);
                                    VersionManagerWindow.this.btnDelete.setEnabled(true);
                                    VersionManagerWindow.this.btnImport.setEnabled(true);
                                    VersionManagerWindow.this.qualityLevelBox.setEnabled(true);
                                    VersionManagerWindow.this.clientListBox.setEnabled(true);
                                    VersionManagerWindow.this.btnRemove.setEnabled(wasEnabledRemove);
                                    VersionManagerWindow.this.btnOk.setText("Ok");
                                    VersionManagerWindow.this.lblThanks.setVisible(VersionManagerWindow.this.lastArchive != null);
                                    VersionManagerWindow.this.lblThanks.setText("");
                                    if (VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.archiveDef.has("thanksTo")) {
                                        VersionManagerWindow.this.lblThanks.setText("Assets kindly mirrored by " + VersionManagerWindow.this.lastArchive.archiveDef.get("thanksTo").getAsString());
                                    }
                                    VersionManagerWindow.this.checkBoxDownload.setEnabled(!VersionManagerWindow.this.lastArchive.isDeprecated && VersionManagerWindow.this.lastArchive.supportsDownloads && VersionManagerWindow.this.lastArchive.supportsStreaming);
                                    VersionManagerWindow.this.checkBoxDownload.setSelected(!VersionManagerWindow.this.lastArchive.supportsStreaming);
                                    VersionManagerWindow.this.lblQualityLevels.setVisible(VersionManagerWindow.this.checkBoxDownload.isSelected());
                                    VersionManagerWindow.this.qualityLevelBox.setVisible(VersionManagerWindow.this.checkBoxDownload.isSelected());
                                    VersionManagerWindow.this.btnExport.setEnabled(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE && VersionManagerWindow.this.lastArchive.supportsDownloads);
                                    VersionManagerWindow.this.btnDelete.setVisible(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.isUserArchive);
                                    VersionManagerWindow.this.btnDelete.setEnabled(true);
                                    VersionManagerWindow.this.archiveSelector.setSelectedItem(VersionManagerWindow.this.lastArchive);
                                    VersionManagerWindow.this.refreshClientList();
                                });
                            }
                            catch (Exception e2) {
                                JOptionPane.showMessageDialog(VersionManagerWindow.this, "Could not contact " + url + "\n\nPlease make sure this is a sentinel-exported archive source and that the host is online.", "Import error", 0);
                                SwingUtilities.invokeLater(() -> {
                                    VersionManagerWindow.this.btnOk.setEnabled(true);
                                    VersionManagerWindow.this.btnCancel.setEnabled(true);
                                    VersionManagerWindow.this.archiveSelector.setEnabled(true);
                                    VersionManagerWindow.this.btnAdd.setEnabled(true);
                                    VersionManagerWindow.this.checkBoxDownload.setVisible(VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE);
                                    VersionManagerWindow.this.checkBoxDownload.setEnabled(chBoxWasEnabled);
                                    VersionManagerWindow.this.btnDelete.setVisible(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.isUserArchive);
                                    VersionManagerWindow.this.btnExport.setEnabled(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE && VersionManagerWindow.this.lastArchive.supportsDownloads);
                                    VersionManagerWindow.this.btnDelete.setVisible(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.isUserArchive);
                                    VersionManagerWindow.this.btnDelete.setEnabled(true);
                                    VersionManagerWindow.this.btnImport.setEnabled(true);
                                    VersionManagerWindow.this.qualityLevelBox.setEnabled(true);
                                    VersionManagerWindow.this.clientListBox.setEnabled(true);
                                    VersionManagerWindow.this.btnRemove.setEnabled(wasEnabledRemove);
                                    VersionManagerWindow.this.btnOk.setText("Ok");
                                    VersionManagerWindow.this.lblThanks.setVisible(VersionManagerWindow.this.lastArchive != null);
                                    VersionManagerWindow.this.lblThanks.setText("");
                                    if (VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.archiveDef.has("thanksTo")) {
                                        VersionManagerWindow.this.lblThanks.setText("Assets kindly mirrored by " + VersionManagerWindow.this.lastArchive.archiveDef.get("thanksTo").getAsString());
                                    }
                                });
                                return;
                            }
                        }
                        catch (Exception e2) {
                            Object stackTrace = "";
                            Throwable t = e2;
                            while (t != null) {
                                for (StackTraceElement ele : t.getStackTrace()) {
                                    stackTrace = (String)stackTrace + "\n     At: " + ele;
                                }
                                if ((t = t.getCause()) == null) continue;
                                stackTrace = (String)stackTrace + "\nCaused by: " + t;
                            }
                            JOptionPane.showMessageDialog(VersionManagerWindow.this, "An error occurred!\n\nError details: " + e2 + (String)stackTrace, "Import error", 0);
                            VersionManagerWindow.this.downloadFinished = true;
                            SwingUtilities.invokeLater(() -> {
                                VersionManagerWindow.this.btnOk.setEnabled(true);
                                VersionManagerWindow.this.btnCancel.setEnabled(true);
                                VersionManagerWindow.this.archiveSelector.setEnabled(true);
                                VersionManagerWindow.this.btnAdd.setEnabled(true);
                                VersionManagerWindow.this.checkBoxDownload.setVisible(VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE);
                                VersionManagerWindow.this.checkBoxDownload.setEnabled(chBoxWasEnabled);
                                VersionManagerWindow.this.btnDelete.setVisible(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.isUserArchive);
                                VersionManagerWindow.this.btnExport.setEnabled(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE && VersionManagerWindow.this.lastArchive.supportsDownloads);
                                VersionManagerWindow.this.btnDelete.setVisible(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.isUserArchive);
                                VersionManagerWindow.this.btnDelete.setEnabled(true);
                                VersionManagerWindow.this.btnImport.setEnabled(true);
                                VersionManagerWindow.this.qualityLevelBox.setEnabled(true);
                                VersionManagerWindow.this.clientListBox.setEnabled(true);
                                VersionManagerWindow.this.btnRemove.setEnabled(wasEnabledRemove);
                                VersionManagerWindow.this.btnOk.setText("Ok");
                                VersionManagerWindow.this.lblThanks.setVisible(VersionManagerWindow.this.lastArchive != null);
                                VersionManagerWindow.this.lblThanks.setText("");
                                if (VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.archiveDef.has("thanksTo")) {
                                    VersionManagerWindow.this.lblThanks.setText("Assets kindly mirrored by " + VersionManagerWindow.this.lastArchive.archiveDef.get("thanksTo").getAsString());
                                }
                            });
                        }
                    }
                }, "Importer thread");
                th.setDaemon(true);
                th.start();
            }
        });
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.isUserArchive) {
                    if (JOptionPane.showConfirmDialog(VersionManagerWindow.this, "Are you sure you wish to remove this archive?", "Archive removal", 0, 2) != 0) {
                        return;
                    }
                    try {
                        AssetManager.removeUserArchive(VersionManagerWindow.this.lastArchive.archiveID);
                    }
                    catch (IOException e1) {
                        throw new RuntimeException(e1);
                    }
                    VersionManagerWindow.this.lastArchive = null;
                    VersionManagerWindow.this.warnedArchiveChange = true;
                    VersionManagerWindow.this.archiveSelector.setSelectedItem(null);
                    VersionManagerWindow.this.checkBoxDownload.setEnabled(false);
                    VersionManagerWindow.this.lblQualityLevels.setVisible(false);
                    VersionManagerWindow.this.qualityLevelBox.setVisible(false);
                    VersionManagerWindow.this.btnExport.setEnabled(false);
                    VersionManagerWindow.this.btnDelete.setVisible(false);
                    VersionManagerWindow.this.archiveSelector.updateUI();
                    if (AssetManager.getArchives().length > 0) {
                        VersionManagerWindow.this.lastArchive = AssetManager.getArchives()[0];
                        VersionManagerWindow.this.checkBoxDownload.setVisible(VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE);
                        VersionManagerWindow.this.checkBoxDownload.setEnabled(!VersionManagerWindow.this.lastArchive.isDeprecated && VersionManagerWindow.this.lastArchive.supportsDownloads && VersionManagerWindow.this.lastArchive.supportsStreaming);
                        VersionManagerWindow.this.checkBoxDownload.setSelected(!VersionManagerWindow.this.lastArchive.supportsStreaming);
                        VersionManagerWindow.this.lblQualityLevels.setVisible(VersionManagerWindow.this.checkBoxDownload.isSelected());
                        VersionManagerWindow.this.qualityLevelBox.setVisible(VersionManagerWindow.this.checkBoxDownload.isSelected());
                        VersionManagerWindow.this.btnExport.setEnabled(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.mode == ArchiveMode.REMOTE && VersionManagerWindow.this.lastArchive.supportsDownloads);
                        VersionManagerWindow.this.btnDelete.setVisible(VersionManagerWindow.this.lastArchive != null && VersionManagerWindow.this.lastArchive.isUserArchive);
                        VersionManagerWindow.this.btnDelete.setEnabled(true);
                        VersionManagerWindow.this.archiveSelector.setSelectedItem(VersionManagerWindow.this.lastArchive);
                        try {
                            VersionManagerWindow.this.saveSettings();
                        }
                        catch (IOException e1) {
                            throw new RuntimeException(e1);
                        }
                    }
                }
            }
        });
        this.btnOk.setEnabled(this.lastArchive != null && this.filteredClientEntryData().length != 0);
    }

    private void loadQualityLevelBox(JComboBox<QualityLevelEntry> qualityLevelBox, String[] levels) {
        final ArrayList<QualityLevelEntry> entries = new ArrayList<QualityLevelEntry>();
        ArrayList<JsonArray> qualityLevels = new ArrayList<JsonArray>();
        File enabledQualityLevelListFile = new File("assets/qualitylevels.json");
        if (enabledQualityLevelListFile.exists()) {
            try {
                JsonArray qualityLevelsArr = JsonParser.parseString((String)Files.readString(enabledQualityLevelListFile.toPath())).getAsJsonArray();
                for (JsonElement ele : qualityLevelsArr) {
                    Object lvl = ele.getAsString();
                    if (qualityLevels.contains(lvl) || !Stream.of(levels).anyMatch(arg_0 -> VersionManagerWindow.lambda$loadQualityLevelBox$1((String)lvl, arg_0))) continue;
                    qualityLevels.add((JsonArray)lvl);
                }
            }
            catch (IOException qualityLevelsArr) {
                // empty catch block
            }
        }
        if (qualityLevels.size() == 0) {
            for (Object lvl : levels) {
                qualityLevels.add((JsonArray)lvl);
            }
        }
        final QualityLevelEntry mask = new QualityLevelEntry();
        for (Iterator level : levels) {
            QualityLevelEntry lv = new QualityLevelEntry();
            lv.level = level;
            lv.enabled = qualityLevels.contains(level);
            lv.checkBox = new JCheckBox();
            lv.checkBox.setSelected(lv.enabled);
            lv.checkBox.setText(lv.toString());
            entries.add(lv);
        }
        this.qualityLevelElements = entries;
        qualityLevelBox.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList<? extends Object> list, Object lvE, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel comp = (JLabel)super.getListCellRendererComponent(list, lvE, index, isSelected, cellHasFocus);
                QualityLevelEntry lv = (QualityLevelEntry)lvE;
                if (lv == null || lv.level == null) {
                    Object str = "";
                    for (QualityLevelEntry lvl : VersionManagerWindow.this.qualityLevelElements) {
                        if (!lvl.enabled) continue;
                        if (!((String)str).isEmpty()) {
                            str = (String)str + ", ";
                        }
                        str = (String)str + lvl.level;
                    }
                    comp.setText("Quality levels: " + (String)str);
                    return comp;
                }
                lv.checkBox.setComponentOrientation(list.getComponentOrientation());
                lv.checkBox.setSelected(lv.enabled);
                lv.checkBox.setText(lv.toString());
                lv.checkBox.setForeground(comp.getForeground());
                lv.checkBox.setBackground(comp.getBackground());
                lv.checkBox.setEnabled(list.isEnabled());
                lv.checkBox.setFont(list.getFont());
                lv.checkBox.setBorder(comp.getBorder());
                return lv.checkBox;
            }
        });
        qualityLevelBox.addActionListener(e -> {
            QualityLevelEntry ent = (QualityLevelEntry)qualityLevelBox.getSelectedItem();
            if (ent != null) {
                ent.enabled = !ent.enabled;
                qualityLevelBox.setPopupVisible(true);
                qualityLevelBox.setSelectedItem(null);
                qualityLevelBox.repaint();
            }
        });
        qualityLevelBox.setModel(new ComboBoxModel<QualityLevelEntry>(){
            private QualityLevelEntry selected;

            @Override
            public int getSize() {
                return entries.size() + 1;
            }

            @Override
            public QualityLevelEntry getElementAt(int index) {
                if (index == 0) {
                    return mask;
                }
                return (QualityLevelEntry)entries.get(index - 1);
            }

            @Override
            public void setSelectedItem(Object anItem) {
                this.selected = (QualityLevelEntry)anItem;
            }

            @Override
            public Object getSelectedItem() {
                return this.selected;
            }

            @Override
            public void addListDataListener(ListDataListener l) {
            }

            @Override
            public void removeListDataListener(ListDataListener l) {
            }
        });
    }

    private ClientEntry[] filteredClientEntryData() {
        ArrayList<ClientEntry> filteredData = new ArrayList<ClientEntry>();
        if (this.lastArchive == null) {
            return new ClientEntry[0];
        }
        JsonObject clientLst = this.lastArchive.archiveClientLst;
        for (ClientEntry entry : this.clients) {
            if (this.lastArchive == null || !clientLst.has(entry.version)) continue;
            filteredData.add(entry);
        }
        return (ClientEntry[])filteredData.toArray(ClientEntry[]::new);
    }

    private static String[] appendToStringArray(String[] source, String ele) {
        String[] res = new String[source.length + 1];
        for (int i = 0; i < source.length; ++i) {
            res[i] = source[i];
        }
        res[res.length - 1] = ele;
        return res;
    }

    private void refreshClientList() {
        final ClientEntry[] filteredData = this.filteredClientEntryData();
        this.clientListBox.setModel(new ListModel<ClientEntry>(){

            @Override
            public int getSize() {
                return filteredData.length;
            }

            @Override
            public ClientEntry getElementAt(int index) {
                return filteredData[index];
            }

            @Override
            public void addListDataListener(ListDataListener l) {
            }

            @Override
            public void removeListDataListener(ListDataListener l) {
            }
        });
        this.btnOk.setEnabled(this.lastArchive != null && filteredData.length != 0);
        this.lblThanks.setVisible(this.lastArchive != null && this.lastArchive.archiveDef.has("thanksTo"));
        if (this.lastArchive != null && this.lastArchive.archiveDef.has("thanksTo")) {
            this.lblThanks.setText("Assets kindly mirrored by " + this.lastArchive.archiveDef.get("thanksTo").getAsString());
        }
    }

    private String parseURL(String url, String urlBaseDescriptorFileF, String urlBaseSoftwareFileF, String sentinelAssetRoot) {
        if (((String)url).startsWith("sgd:")) {
            String source = ((String)url).substring(4);
            while (source.startsWith("/")) {
                source = source.substring(1);
            }
            url = urlBaseDescriptorFileF + source;
        } else if (((String)url).startsWith("svp:")) {
            String source = ((String)url).substring(4);
            while (source.startsWith("/")) {
                source = source.substring(1);
            }
            url = urlBaseSoftwareFileF + source;
        } else if (sentinelAssetRoot != null && ((String)url).startsWith("sac:")) {
            String source = ((String)url).substring(4);
            while (source.startsWith("/")) {
                source = source.substring(1);
            }
            url = sentinelAssetRoot + source;
        }
        return url;
    }

    private void indexAssetHashes(HashMap<String, String> assetHashes, File hashFile) throws JsonSyntaxException, IOException {
        String[] lines;
        for (String line : lines = Files.readString(hashFile.toPath()).split("\n")) {
            if (line.isEmpty()) continue;
            String name = line.substring(0, line.indexOf(": ")).replace(";sp;", " ").replace(";cl;", ":").replace(";sl;", ";");
            String hash = line.substring(line.indexOf(": ") + 2);
            assetHashes.put(name, hash);
        }
    }

    private void indexAssetSizes(HashMap<String, Long> assetSizes, File sizeFile) throws JsonSyntaxException, IOException {
        String[] lines;
        for (String line : lines = Files.readString(sizeFile.toPath()).split("\n")) {
            if (line.isEmpty()) continue;
            String name = line.substring(0, line.indexOf(": ")).replace(";sp;", " ").replace(";cl;", ":").replace(";sl;", ";");
            String len = line.substring(line.indexOf(": ") + 2);
            assetSizes.put(name, Long.parseLong(len));
        }
    }

    private int transferDescriptor(File dir, ZipOutputStream zO, String prefix, int index, int max) throws IOException {
        ZipEntry ent;
        for (File subDir : dir.listFiles(t -> t.isDirectory())) {
            ent = new ZipEntry("descriptor/" + prefix + subDir.getName() + "/");
            zO.putNextEntry(ent);
            zO.closeEntry();
            index += this.transferDescriptor(subDir, zO, prefix + subDir.getName() + "/", index, max);
            LauncherUtils.setStatus("Archiving... Copying " + ++index + "/" + max + " descriptor files...");
            LauncherUtils.increaseProgress();
        }
        for (File f : dir.listFiles(t -> t.isFile())) {
            ent = new ZipEntry("descriptor/" + prefix + f.getName());
            zO.putNextEntry(ent);
            FileInputStream fIn = new FileInputStream(f);
            fIn.transferTo(zO);
            fIn.close();
            zO.closeEntry();
            LauncherUtils.setStatus("Archiving... Copying " + ++index + "/" + max + " descriptor files...");
            LauncherUtils.increaseProgress();
        }
        return index;
    }

    private static int indexDir(File dir) {
        int i = 0;
        for (File subDir : dir.listFiles(t -> t.isDirectory())) {
            i += VersionManagerWindow.indexDir(subDir) + 1;
        }
        File[] listFiles = dir.listFiles(t -> !t.isDirectory());
        for (int j = 0; j < listFiles.length; ++j) {
            ++i;
        }
        return i;
    }

    private boolean updateDescriptorIfNeeded(boolean chBoxWasEnabled, boolean wasEnabledRemove) throws Exception {
        if (this.updateDescriptor) {
            if (this.lastArchive.mode == ArchiveMode.REMOTE) {
                if (!AssetManager.testArchiveConnection(this.lastArchive)) {
                    LauncherUtils.log("Archive connection could not be made.");
                    JOptionPane.showMessageDialog(this, "Server connection could not be established with the archive server!\n\nCannot continue as the archive descriptor needs to be updated!", "No server connection", 0);
                    SwingUtilities.invokeLater(() -> {
                        this.btnOk.setEnabled(true);
                        this.btnCancel.setEnabled(true);
                        this.archiveSelector.setEnabled(true);
                        this.btnAdd.setEnabled(true);
                        this.checkBoxDownload.setVisible(this.lastArchive.mode == ArchiveMode.REMOTE);
                        this.checkBoxDownload.setEnabled(chBoxWasEnabled);
                        this.qualityLevelBox.setEnabled(true);
                        this.clientListBox.setEnabled(true);
                        this.btnExport.setEnabled(this.lastArchive != null && this.lastArchive.mode == ArchiveMode.REMOTE && this.lastArchive.supportsDownloads);
                        this.btnDelete.setVisible(this.lastArchive != null && this.lastArchive.isUserArchive);
                        this.btnDelete.setEnabled(true);
                        this.btnImport.setEnabled(true);
                        this.btnRemove.setEnabled(wasEnabledRemove);
                        this.btnOk.setText("Ok");
                        this.lblThanks.setVisible(this.lastArchive != null && this.lastArchive.archiveDef.has("thanksTo"));
                        if (this.lastArchive != null && this.lastArchive.archiveDef.has("thanksTo")) {
                            this.lblThanks.setText("Assets kindly mirrored by " + this.lastArchive.archiveDef.get("thanksTo").getAsString());
                        }
                    });
                    return false;
                }
                LauncherUtils.log("Downloading archive descriptor...", true);
                SwingUtilities.invokeAndWait(() -> {
                    if (!this.downloadFinished) {
                        this.lblThanks.setText("Downloading archive descriptor... Please wait... [0%]");
                        this.lblThanks.setVisible(true);
                    }
                });
                this.downloadFinished = false;
                Thread th2 = new Thread(() -> {
                    Object lastMsg = "";
                    while (!this.downloadFinished) {
                        try {
                            int percentage = (int)(100.0f / (float)LauncherUtils.getProgressMax() * (float)LauncherUtils.getProgress());
                            if (!((String)lastMsg).equals("Downloading archive descriptor... Please wait... [" + percentage + "%]")) {
                                lastMsg = "Downloading archive descriptor... Please wait... [" + percentage + "%]";
                                SwingUtilities.invokeAndWait(() -> {
                                    if (!this.downloadFinished) {
                                        this.lblThanks.setText("Downloading archive descriptor... Please wait... [" + percentage + "%]");
                                    }
                                });
                            }
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException | InvocationTargetException e1) {
                            break;
                        }
                    }
                });
                th2.setDaemon(true);
                th2.start();
                LauncherUtils.resetProgressBar();
                LauncherUtils.showProgressPanel();
                String dir = this.parseURL(AssetManager.getSentinelAssetControllerConfig().get("descriptorRoot").getAsString(), LauncherUtils.urlBaseDescriptorFile, LauncherUtils.urlBaseSoftwareFile, AssetManager.getAssetInformationRootURL());
                String rHashDescriptor = LauncherUtils.downloadString(dir + this.lastArchive.descriptorType + ".hash").replace("\r", "").replace("\n", "");
                LauncherUtils.downloadFile(dir + this.lastArchive.descriptorType + ".zip", new File("assets/descriptor.zip"));
                this.downloadFinished = true;
                LauncherUtils.hideProgressPanel();
                LauncherUtils.resetProgressBar();
                LauncherUtils.log("Verifying signature... Please wait...", true);
                SwingUtilities.invokeAndWait(() -> {
                    this.lblThanks.setText("Verifying signature... Please wait...");
                    this.lblThanks.setVisible(true);
                });
                if (!LauncherUtils.verifyPackageSignature(new File("assets/descriptor.zip"), new File("assets/sac-publickey.pem"))) {
                    if (!LauncherUtils.isPackageSigned(new File("assets/descriptor.zip"))) {
                        LauncherUtils.hideProgressPanel();
                        LauncherUtils.resetProgressBar();
                        LauncherUtils.log("Package is unsigned.");
                        if (!AssetManager.getSentinelAssetControllerConfig().get("allowUnsignedArchiveDescriptors").getAsBoolean()) {
                            LauncherUtils.log("Package is unsigned.");
                            JOptionPane.showMessageDialog(this, "The archive descriptor is unsigned and this game descriptor does not support unsigned archive descriptors.\n\nPlease report this error to the project's archival team.", "Update error", 0);
                            SwingUtilities.invokeLater(() -> {
                                this.btnOk.setEnabled(true);
                                this.btnCancel.setEnabled(true);
                                this.archiveSelector.setEnabled(true);
                                this.btnAdd.setEnabled(true);
                                this.checkBoxDownload.setVisible(this.lastArchive.mode == ArchiveMode.REMOTE);
                                this.checkBoxDownload.setEnabled(chBoxWasEnabled);
                                this.qualityLevelBox.setEnabled(true);
                                this.clientListBox.setEnabled(true);
                                this.btnExport.setEnabled(this.lastArchive != null && this.lastArchive.mode == ArchiveMode.REMOTE && this.lastArchive.supportsDownloads);
                                this.btnDelete.setVisible(this.lastArchive != null && this.lastArchive.isUserArchive);
                                this.btnDelete.setEnabled(true);
                                this.btnImport.setEnabled(true);
                                this.btnRemove.setEnabled(wasEnabledRemove);
                                this.btnOk.setText("Ok");
                                this.lblThanks.setVisible(this.lastArchive != null && this.lastArchive.archiveDef.has("thanksTo"));
                                if (this.lastArchive != null && this.lastArchive.archiveDef.has("thanksTo")) {
                                    this.lblThanks.setText("Assets kindly mirrored by " + this.lastArchive.archiveDef.get("thanksTo").getAsString());
                                }
                            });
                            return false;
                        }
                    } else {
                        LauncherUtils.hideProgressPanel();
                        LauncherUtils.resetProgressBar();
                        LauncherUtils.log("Signature verification failure.");
                        JOptionPane.showMessageDialog(this, "Failed to verify integrity of archive descriptor file.\n\nPlease report this error to the project's archival team.", "Update error", 0);
                        SwingUtilities.invokeLater(() -> {
                            this.btnOk.setEnabled(true);
                            this.btnCancel.setEnabled(true);
                            this.archiveSelector.setEnabled(true);
                            this.btnAdd.setEnabled(true);
                            this.checkBoxDownload.setVisible(this.lastArchive.mode == ArchiveMode.REMOTE);
                            this.checkBoxDownload.setEnabled(chBoxWasEnabled);
                            this.qualityLevelBox.setEnabled(true);
                            this.btnExport.setEnabled(this.lastArchive != null && this.lastArchive.mode == ArchiveMode.REMOTE && this.lastArchive.supportsDownloads);
                            this.btnDelete.setVisible(this.lastArchive != null && this.lastArchive.isUserArchive);
                            this.btnDelete.setEnabled(true);
                            this.btnImport.setEnabled(true);
                            this.clientListBox.setEnabled(true);
                            this.btnRemove.setEnabled(wasEnabledRemove);
                            this.btnOk.setText("Ok");
                            this.lblThanks.setVisible(this.lastArchive != null && this.lastArchive.archiveDef.has("thanksTo"));
                            if (this.lastArchive != null && this.lastArchive.archiveDef.has("thanksTo")) {
                                this.lblThanks.setText("Assets kindly mirrored by " + this.lastArchive.archiveDef.get("thanksTo").getAsString());
                            }
                        });
                        return false;
                    }
                }
                SwingUtilities.invokeAndWait(() -> {
                    if (!this.downloadFinished) {
                        this.lblThanks.setText("Extracting archive information... Please wait... [0%]");
                        this.lblThanks.setVisible(true);
                    }
                });
                this.downloadFinished = false;
                th2 = new Thread(() -> {
                    Object lastMsg = "";
                    while (!this.downloadFinished) {
                        try {
                            int percentage = (int)(100.0f / (float)LauncherUtils.getProgressMax() * (float)LauncherUtils.getProgress());
                            if (!((String)lastMsg).equals("Extracting archive information... Please wait... [" + percentage + "%]")) {
                                lastMsg = "Extracting archive information... Please wait... [" + percentage + "%]";
                                SwingUtilities.invokeAndWait(() -> {
                                    if (!this.downloadFinished) {
                                        this.lblThanks.setText("Extracting archive information... Please wait... [" + percentage + "%]");
                                    }
                                });
                            }
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException | InvocationTargetException e1) {
                            break;
                        }
                    }
                });
                th2.setDaemon(true);
                th2.start();
                LauncherUtils.log("Extracting archive information...", true);
                if (new File("assets/descriptor").exists()) {
                    LauncherUtils.deleteDir(new File("assets/descriptor"));
                }
                LauncherUtils.unZip(new File("assets/descriptor.zip"), new File("assets/descriptor"));
                this.downloadFinished = true;
                Files.writeString(Path.of("assets/descriptor.hash", new String[0]), (CharSequence)rHashDescriptor, new OpenOption[0]);
                LauncherUtils.hideProgressPanel();
                LauncherUtils.resetProgressBar();
                this.updateDescriptor = false;
            } else {
                ZipEntry ent;
                ZipEntry ent2;
                if (!new File(this.lastArchive.source).exists()) {
                    LauncherUtils.hideProgressPanel();
                    LauncherUtils.resetProgressBar();
                    this.updateDescriptor = false;
                    return true;
                }
                LauncherUtils.log("Re-extracting archive descriptor...", true);
                SwingUtilities.invokeAndWait(() -> {
                    if (!this.downloadFinished) {
                        this.lblThanks.setText("Re-extracting archive descriptor... Please wait... [0%]");
                        this.lblThanks.setVisible(true);
                    }
                });
                ZipFile archive = new ZipFile(this.lastArchive.source);
                int count = 0;
                Enumeration<? extends ZipEntry> en = archive.entries();
                while (en.hasMoreElements() && (ent2 = en.nextElement()) != null) {
                    if (ent2.getName().equals("descriptor/") || !ent2.getName().startsWith("descriptor/")) continue;
                    ++count;
                }
                archive.close();
                this.downloadFinished = false;
                Thread th2 = new Thread(() -> {
                    Object lastMsg = "";
                    while (!this.downloadFinished) {
                        try {
                            int percentage = (int)(100.0f / (float)LauncherUtils.getProgressMax() * (float)LauncherUtils.getProgress());
                            if (!((String)lastMsg).equals("Re-extracting archive descriptor... Please wait... [" + percentage + "%]")) {
                                lastMsg = "Re-extracting archive descriptor... Please wait... [" + percentage + "%]";
                                SwingUtilities.invokeAndWait(() -> {
                                    if (!this.downloadFinished) {
                                        this.lblThanks.setText("Re-extracting archive descriptor... Please wait... [" + percentage + "%]");
                                    }
                                });
                            }
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException | InvocationTargetException e1) {
                            break;
                        }
                    }
                });
                th2.setDaemon(true);
                th2.start();
                LauncherUtils.resetProgressBar();
                LauncherUtils.showProgressPanel();
                LauncherUtils.setProgressMax(count);
                if (new File("assets/descriptor").exists()) {
                    LauncherUtils.deleteDir(new File("assets/descriptor"));
                }
                new File("assets/descriptor").mkdirs();
                archive = new ZipFile(this.lastArchive.source);
                en = archive.entries();
                int max = count;
                int i = 0;
                while (en.hasMoreElements() && (ent = en.nextElement()) != null) {
                    if (ent.getName().equals("descriptor/") || !ent.getName().startsWith("descriptor/")) continue;
                    if (ent.isDirectory()) {
                        new File("assets/descriptor", ent.getName().substring("descriptor/".length())).mkdirs();
                    } else {
                        FileOutputStream output = new FileOutputStream(new File("assets/descriptor", ent.getName().substring("descriptor/".length())));
                        InputStream is = archive.getInputStream(ent);
                        is.transferTo(output);
                        is.close();
                        output.close();
                    }
                    LauncherUtils.setProgress(i++, max);
                }
                LauncherUtils.setProgress(max, max);
                this.downloadFinished = true;
                archive.close();
                Files.writeString(Path.of("assets/descriptor.hash", new String[0]), (CharSequence)("local-" + LauncherUtils.sha512Hash((new File(this.lastArchive.source).lastModified() + "-" + this.lastArchive.source + "-" + new File(this.lastArchive.source).length()).getBytes("UTF-8"))), new OpenOption[0]);
                Files.writeString(Path.of("assets/descriptor-local.version", new String[0]), (CharSequence)"latest", new OpenOption[0]);
                LauncherUtils.hideProgressPanel();
                LauncherUtils.resetProgressBar();
                this.updateDescriptor = false;
            }
        }
        return true;
    }

    private void saveSettings() throws IOException {
        JsonArray clientsArr = new JsonArray();
        for (ClientEntry client : this.clients) {
            clientsArr.add(client.version);
        }
        Files.writeString(Path.of("assets/clients.json", new String[0]), (CharSequence)clientsArr.toString(), new OpenOption[0]);
        File localArchiveSettings = new File("assets/localdata.json");
        JsonObject settings = new JsonObject();
        settings.addProperty("id", this.lastArchive.archiveID);
        settings.addProperty("stream", Boolean.valueOf(!this.checkBoxDownload.isSelected()));
        Files.writeString(localArchiveSettings.toPath(), (CharSequence)settings.toString(), new OpenOption[0]);
        File enabledQualityLevelListFile = new File("assets/qualitylevels.json");
        if (this.checkBoxDownload.isSelected()) {
            JsonArray arr = new JsonArray();
            for (QualityLevelEntry lv : this.qualityLevelElements) {
                if (!lv.enabled) continue;
                arr.add(lv.level);
            }
            Files.writeString(enabledQualityLevelListFile.toPath(), (CharSequence)arr.toString(), new OpenOption[0]);
        }
    }

    private void doSave() {
        try {
            this.saveSettings();
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        this.wasCancelled = false;
        this.dispose();
    }

    private static /* synthetic */ boolean lambda$loadQualityLevelBox$1(String lvl, String t) {
        return t.equalsIgnoreCase(lvl);
    }

    private class ClientEntry {
        public String version;

        private ClientEntry() {
        }

        public String toString() {
            return "Version " + this.version;
        }
    }

    private class QualityLevelEntry {
        public String level;
        public boolean enabled = true;
        public JCheckBox checkBox;

        private QualityLevelEntry() {
        }

        public String toString() {
            return this.level;
        }
    }
}

