/*
 * Decompiled with CFR 0.152.
 */
package org.asf.sentinel.launcher;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import netscape.javascript.JSObject;
import org.asf.connective.ConnectiveHttpServer;
import org.asf.connective.processors.HttpRequestProcessor;
import org.asf.sentinel.launcher.LauncherUtils;
import org.asf.sentinel.launcher.LauncherWindow;
import org.asf.sentinel.launcher.bindings.SentinelLauncherJsBindings;
import org.asf.sentinel.launcher.http.UiContentProcessor;

public class LauncherMain {
    public static String LAUNCHER_VERSION = "1.0.0.A27";
    private static boolean protocolsBound = false;
    private static ArrayList<String> filesToDeleteOnClientUpdate = new ArrayList();
    private static ArrayList<Long> updateActiveClientProcesses = new ArrayList();
    private String serverUrlBase;
    private ConnectiveHttpServer server;
    private LauncherWindow launcherWindow;
    private SentinelLauncherJsBindings bindings;
    private LauncherUtils utils;

    public LauncherMain() {
        this.initialize();
    }

    private void initialize() {
        LauncherUtils.launcherInstance = this;
        this.utils = new LauncherUtils();
        this.getUtils().log("Preparing...");
        this.getUtils().log("Configuring theme...");
        try {
            try {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e1) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e1) {
            // empty catch block
        }
        this.getUtils().log("Binding URL protocols...");
        LauncherMain.bindProtocols();
        this.getUtils().log("Starting IPC server...");
        Random rnd = new Random();
        int port = rnd.nextInt(1024, 65535);
        ConnectiveHttpServer server = ConnectiveHttpServer.create((String)"HTTP/1.1", Map.of("Address", "127.0.0.1", "Port", Integer.toString(port)));
        this.setupServer(server);
        try {
            server.start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.serverUrlBase = "http://127.0.0.1:" + port + "/";
        this.getUtils().log("Started on port " + port + "!");
        this.server = server;
        this.getUtils().log("Creating window...");
        this.launcherWindow = new LauncherWindow();
        this.launcherWindow.addPostInitListener(() -> this.postLoad());
    }

    private void setupServer(ConnectiveHttpServer server) {
        server.registerProcessor((HttpRequestProcessor)new UiContentProcessor());
    }

    private void postLoad() {
        this.bindings = new SentinelLauncherJsBindings(this);
        this.launcherWindow.getWebEngine().getLoadWorker().stateProperty().addListener((t, o, v) -> {
            JSObject win = (JSObject)this.launcherWindow.getWebEngine().executeScript("window");
            Object m = win.getMember("sentinel");
            if (m.equals("undefined")) {
                this.getUtils().log("Binding sentinel functions to JavaScript...");
                win.setMember("sentinel", this.bindings);
            }
        });
        this.launcherWindow.addPostLoadListener(t -> {
            JSObject win = (JSObject)this.launcherWindow.getWebEngine().executeScript("window");
            Object m = win.getMember("sentinel");
            if (m.equals("undefined")) {
                this.getUtils().log("Binding sentinel functions to JavaScript...");
                win.setMember("sentinel", this.bindings);
            }
            this.getUtils().log("Running sentinelInited() in javascript environment...");
            this.launcherWindow.getWebEngine().executeScript("console.log = (msg) => sentinel.log(msg)");
            this.launcherWindow.getWebEngine().executeScript("console.error = (msg) => sentinel.logError(msg)");
            this.launcherWindow.getWebEngine().executeScript("console.debug = (msg) => sentinel.logDebug(msg)");
            this.launcherWindow.getWebEngine().executeScript("sentinelInited()");
        });
        this.launcherWindow.getWebEngine().load(this.serverUrlBase + "index.html");
    }

    private static void bindProtocols() {
        if (protocolsBound) {
            return;
        }
        protocolsBound = true;
        URL.setURLStreamHandlerFactory(new URLStreamHandlerFactory(){

            @Override
            public URLStreamHandler createURLStreamHandler(String protocol) {
                switch (protocol.toLowerCase()) {
                    case "sentinel": {
                        return new URLStreamHandler(){

                            @Override
                            protected URLConnection openConnection(URL u) throws IOException {
                                if (u.getAuthority() == null) {
                                    throw new IOException("Missing scope in " + u + ", expected sentinel://<scope>/<path>");
                                }
                                switch (u.getAuthority()) {
                                    case "launcher": {
                                        return this.connectionFromClassAndFile(LauncherMain.class, u.getPath());
                                    }
                                }
                                throw new IOException("Invalid scope: " + u.getAuthority());
                            }
                        };
                    }
                }
                return null;
            }

            private URLConnection connectionFromClassAndFile(Class<?> cls, String file) throws IOException {
                try {
                    while (file.startsWith("/")) {
                        file = file.substring(1);
                    }
                    URL loc = cls.getProtectionDomain().getCodeSource().getLocation();
                    File f = new File(loc.toURI());
                    if (f.isFile()) {
                        return new URL("jar:" + f.toURI() + "!/" + file).openConnection();
                    }
                    return new File(f, file).toURI().toURL().openConnection();
                }
                catch (Exception e) {
                    throw new IOException("Could not open file " + file, e);
                }
            }
        });
    }

    public LauncherWindow getWindow() {
        return this.launcherWindow;
    }

    public SentinelLauncherJsBindings getBindings() {
        return this.bindings;
    }

    public ConnectiveHttpServer getServer() {
        return this.server;
    }

    public String getIpcServerBaseUrl() {
        return this.serverUrlBase;
    }

    public static void main(String[] args) {
        LauncherUtils.args = args;
        if (new File("sentinel.activeprocesses.sjf").exists()) {
            try {
                JsonObject settings = JsonParser.parseString((String)Files.readString(Path.of("sentinel.activeprocesses.sjf", new String[0]))).getAsJsonObject();
                if (settings.has("processes")) {
                    for (JsonElement ele : settings.get("processes").getAsJsonArray()) {
                        updateActiveClientProcesses.add(ele.getAsLong());
                    }
                }
                if (settings.has("deleteFilesOnProcessExit")) {
                    for (JsonElement ele : settings.get("deleteFilesOnProcessExit").getAsJsonArray()) {
                        filesToDeleteOnClientUpdate.add(ele.getAsString());
                    }
                }
                new File("sentinel.activeprocesses.sjf").delete();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    LauncherMain main = new LauncherMain();
                    main.launcherWindow.getFrame().setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    static void closeClientsIfNeeded() {
        if (updateActiveClientProcesses.size() == 0) {
            return;
        }
        ArrayList<ProcessHandle> handles = new ArrayList<ProcessHandle>();
        Iterator<Object> iterator = updateActiveClientProcesses.iterator();
        while (iterator.hasNext()) {
            long pid = iterator.next();
            try {
                Optional<ProcessHandle> h = ProcessHandle.of(pid);
                if (!h.isPresent() || !h.get().isAlive()) continue;
                handles.add(h.get());
            }
            catch (Exception exception) {}
        }
        if (handles.size() != 0) {
            JOptionPane.showMessageDialog(LauncherUtils.getLauncherInstance().getUtils().getLauncherFrame(), "Warning!\n\nSentinel found some running client processes that need to be closed before the update can be completed.\n\nPlease close the clients before proceeding, press OK to terminate all remaining client processes.", "Active client processes detected", 2);
            for (ProcessHandle handle : handles) {
                if (!handle.isAlive()) continue;
                handle.destroy();
            }
            for (String f : filesToDeleteOnClientUpdate) {
                if (!new File(f).exists()) continue;
                new File(f).delete();
            }
        }
        updateActiveClientProcesses.clear();
        filesToDeleteOnClientUpdate.clear();
    }

    public LauncherUtils getUtils() {
        return this.utils;
    }
}

