/*
 * Decompiled with CFR 0.152.
 */
package org.asf.sentinel.launcher;

import com.sun.javafx.application.PlatformImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import netscape.javascript.JSObject;
import org.asf.sentinel.launcher.DynamicClassLoader;
import org.asf.sentinel.launcher.LauncherMain;
import org.asf.sentinel.launcher.LauncherWindow;
import org.asf.sentinel.launcher.api.ObjectTag;

public class LauncherUtils {
    static String[] args;
    static DynamicClassLoader loader;
    static LauncherMain launcherInstance;
    private static HashMap<String, ObjectTag> tags;
    private final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    static void addUrlToComponentClassLoader(URL url) {
        loader.addUrl(url);
    }

    public static LauncherMain getLauncherInstance() {
        return launcherInstance;
    }

    public static LauncherUtils getInstance() {
        return launcherInstance.getUtils();
    }

    public void log(String message) {
        System.out.println("[LAUNCHER] [SENTINEL LAUNCHER] " + message);
    }

    public void exit() {
        if (launcherInstance.getWindow() == null || launcherInstance.getWindow() == null || launcherInstance.getWindow().getFrame() == null || !launcherInstance.getWindow().getFrame().isVisible()) {
            System.exit(0);
        }
        this.runRunnableLaterOnAwt(() -> launcherInstance.getWindow().getFrame().dispose());
    }

    public Runnable functionToRunnable(JSObject func) {
        return () -> {
            ResCont res = new ResCont();
            PlatformImpl.runAndWait(() -> {
                res.obj = func.eval("this()");
            });
        };
    }

    public void runLaterOnAwt(JSObject func) {
        SwingUtilities.invokeLater(this.functionToRunnable(func));
    }

    public void runRunnableLaterOnAwt(Runnable run) {
        SwingUtilities.invokeLater(run);
    }

    public void runOnAwtAndWait(JSObject func) throws InvocationTargetException, InterruptedException {
        SwingUtilities.invokeAndWait(this.functionToRunnable(func));
    }

    public void runRunnableOnAwtAndWait(Runnable run) throws InvocationTargetException, InterruptedException {
        SwingUtilities.invokeAndWait(run);
    }

    public JFrame getLauncherFrame() {
        return launcherInstance.getWindow().getFrame();
    }

    public LauncherWindow getLauncherWindow() {
        return launcherInstance.getWindow();
    }

    public ObjectTag addTag(String name) {
        ObjectTag tag = this.getTag(name);
        if (tag != null) {
            return tag;
        }
        tag = new ObjectTag();
        tags.put(name.toLowerCase(), tag);
        return tag;
    }

    public ObjectTag getTag(String name) {
        return tags.get(name.toLowerCase());
    }

    public ObjectTag removeTag(String name) {
        return tags.remove(name.toLowerCase());
    }

    public boolean hasTag(String name) {
        return tags.containsKey(name.toLowerCase());
    }

    public String[] getProgramArguments() {
        return args;
    }

    public Map<String, String> parseProperties(String props) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String line : props.replace("\r", "").split("\n")) {
            if (line.isEmpty() || line.startsWith("#") || !line.contains(": ")) continue;
            String key = line;
            String value = "";
            if (key.contains(": ")) {
                value = key.substring(key.indexOf(": ") + 2);
                key = key.substring(0, key.indexOf(": "));
            }
            properties.put(key, value);
        }
        return properties;
    }

    public String downloadString(String url) throws IOException {
        URLConnection conn = new URL(url).openConnection();
        InputStream strm = conn.getInputStream();
        String data = new String(strm.readAllBytes(), "UTF-8");
        strm.close();
        return data;
    }

    public void deleteDir(File dir) {
        if (!dir.exists()) {
            return;
        }
        if (Files.isSymbolicLink(dir.toPath())) {
            dir.delete();
            return;
        }
        for (File subDir : dir.listFiles(t -> t.isDirectory())) {
            this.deleteDir(subDir);
        }
        for (File file : dir.listFiles(t -> !t.isDirectory())) {
            file.delete();
        }
        dir.delete();
    }

    public void copyDir(File source, File destination) throws IOException {
        if (!source.exists()) {
            return;
        }
        destination.mkdirs();
        for (File subDir : source.listFiles(t -> t.isDirectory())) {
            this.copyDir(subDir, new File(destination, subDir.getName()));
        }
        for (File file : source.listFiles(t -> !t.isDirectory())) {
            Files.copy(file.toPath(), new File(destination, file.getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = this.HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = this.HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public String sha256Hash(byte[] data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(data);
            return this.bytesToHex(hash).toLowerCase();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public String sha512Hash(byte[] data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-512");
            byte[] hash = digest.digest(data);
            return this.bytesToHex(hash).toLowerCase();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isPackageSigned(File packageFile) throws IOException {
        ZipFile zip = new ZipFile(packageFile);
        boolean signed = zip.getEntry("SENTINEL.PACKAGESIGNATURE.SIG") != null;
        zip.close();
        return signed;
    }

    public void extractPackagePublicKey(File packageFile, File publicKeyOutputFile) throws IOException {
        ZipFile zip = new ZipFile(packageFile);
        ZipEntry keyEntry = zip.getEntry("SENTINEL.PACKAGEKEY.PEM");
        if (keyEntry == null) {
            zip.close();
            throw new IOException("Package does not have a key");
        }
        InputStream strm = zip.getInputStream(keyEntry);
        if (publicKeyOutputFile.getParentFile() != null) {
            publicKeyOutputFile.getParentFile().mkdirs();
        }
        FileOutputStream fOut = new FileOutputStream(publicKeyOutputFile);
        strm.transferTo(fOut);
        fOut.close();
        strm.close();
        zip.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyPackageSignature(File packageFile, File publicKeyFile) throws IOException {
        boolean hasSignature;
        ZipFile zip = new ZipFile(packageFile);
        ZipEntry sigEntry = zip.getEntry("SENTINEL.PACKAGESIGNATURE.SIG");
        boolean bl = hasSignature = sigEntry != null;
        if (!hasSignature) {
            zip.close();
            return !publicKeyFile.exists();
        }
        InputStream strm = zip.getInputStream(sigEntry);
        byte[] sig = strm.readAllBytes();
        strm.close();
        if (!publicKeyFile.exists()) {
            ZipEntry keyEntry = zip.getEntry("SENTINEL.PACKAGEKEY.PEM");
            if (keyEntry == null) {
                zip.close();
                return false;
            }
            strm = zip.getInputStream(keyEntry);
            if (publicKeyFile.getParentFile() != null) {
                publicKeyFile.getParentFile().mkdirs();
            }
            FileOutputStream fOut = new FileOutputStream(publicKeyFile);
            strm.transferTo(fOut);
            fOut.close();
            strm.close();
        }
        byte[] key = LauncherUtils.pemDecode(Files.readString(publicKeyFile.toPath()));
        File zipTemp = new File(packageFile.getPath() + ".vtp");
        try {
            FileOutputStream fO = new FileOutputStream(zipTemp);
            ZipOutputStream zO = new ZipOutputStream(fO);
            try {
                FileInputStream fIn = new FileInputStream(packageFile);
                ZipInputStream zIn = new ZipInputStream(fIn);
                try {
                    ZipEntry entry = zIn.getNextEntry();
                    while (entry != null) {
                        if (entry.getName().equals("SENTINEL.PACKAGESIGNATURE.SIG")) {
                            entry = zIn.getNextEntry();
                            continue;
                        }
                        zO.putNextEntry(entry);
                        if (!entry.getName().replace("\\", "/").endsWith("/")) {
                            zIn.transferTo(zO);
                        }
                        zO.closeEntry();
                        entry = zIn.getNextEntry();
                    }
                    zip.close();
                }
                finally {
                    zIn.close();
                    fIn.close();
                }
            }
            finally {
                zO.close();
                fO.close();
            }
            try {
                byte[] data;
                int i;
                KeyFactory fac = KeyFactory.getInstance("RSA");
                PublicKey publicKey = fac.generatePublic(new X509EncodedKeySpec(key));
                Signature s = Signature.getInstance("Sha512WithRSA");
                s.initVerify(publicKey);
                FileInputStream fIn = new FileInputStream(zipTemp);
                while ((i = fIn.read(data = new byte[20480])) > 0) {
                    s.update(data, 0, i);
                }
                fIn.close();
                boolean bl2 = s.verify(sig);
                return bl2;
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
                throw new IOException("Signature verification error", e);
            }
        }
        finally {
            zipTemp.delete();
        }
    }

    public boolean verifyVersionRequirement(String version, String versionCheck) {
        for (String filter : versionCheck.split("\\|\\|")) {
            if (!this.verifyVersionRequirementPart(version, filter = filter.trim())) continue;
            return true;
        }
        return false;
    }

    private boolean verifyVersionRequirementPart(String version, String versionCheck) {
        block0: for (String filter : versionCheck.split("&")) {
            int i2;
            int val;
            int i;
            int[] valuesVersionCheck;
            int[] valuesVersionCurrent;
            if ((filter = filter.trim()).startsWith("!=")) {
                if (!version.equals(filter.substring(2))) continue;
                return false;
            }
            if (filter.startsWith("==")) {
                if (version.equals(filter.substring(2))) continue;
                return false;
            }
            if (filter.startsWith(">=")) {
                valuesVersionCurrent = this.parseVersionValues(version);
                valuesVersionCheck = this.parseVersionValues(filter.substring(2));
                for (i = 0; i < valuesVersionCheck.length; ++i) {
                    val = valuesVersionCheck[i];
                    if (i > valuesVersionCurrent.length) continue block0;
                    i2 = 0;
                    if (i < valuesVersionCurrent.length) {
                        i2 = valuesVersionCurrent[i];
                    }
                    if (i2 >= val) continue;
                    return false;
                }
                continue;
            }
            if (filter.startsWith("<=")) {
                valuesVersionCurrent = this.parseVersionValues(version);
                valuesVersionCheck = this.parseVersionValues(filter.substring(2));
                for (i = 0; i < valuesVersionCheck.length; ++i) {
                    val = valuesVersionCheck[i];
                    if (i > valuesVersionCurrent.length) continue block0;
                    i2 = 0;
                    if (i < valuesVersionCurrent.length) {
                        i2 = valuesVersionCurrent[i];
                    }
                    if (i2 <= val) continue;
                    return false;
                }
                continue;
            }
            if (filter.startsWith(">")) {
                valuesVersionCurrent = this.parseVersionValues(version);
                valuesVersionCheck = this.parseVersionValues(filter.substring(1));
                for (i = 0; i < valuesVersionCheck.length; ++i) {
                    val = valuesVersionCheck[i];
                    if (i > valuesVersionCurrent.length) continue block0;
                    i2 = 0;
                    if (i < valuesVersionCurrent.length) {
                        i2 = valuesVersionCurrent[i];
                    }
                    if (i2 > val) continue;
                    return false;
                }
                continue;
            }
            if (filter.startsWith("<")) {
                valuesVersionCurrent = this.parseVersionValues(version);
                valuesVersionCheck = this.parseVersionValues(filter.substring(1));
                for (i = 0; i < valuesVersionCheck.length; ++i) {
                    val = valuesVersionCheck[i];
                    if (i > valuesVersionCurrent.length) continue block0;
                    i2 = 0;
                    if (i < valuesVersionCurrent.length) {
                        i2 = valuesVersionCurrent[i];
                    }
                    if (i2 < val) continue;
                    return false;
                }
                continue;
            }
            if (version.equals(filter)) continue;
            return false;
        }
        return true;
    }

    private int[] parseVersionValues(String version) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        Object buffer = "";
        for (char ch : version.toCharArray()) {
            if (ch == '-' || ch == '.') {
                if (!((String)buffer).isEmpty()) {
                    if (((String)buffer).matches("^[0-9]+$")) {
                        try {
                            values.add(Integer.parseInt((String)buffer));
                        }
                        catch (Exception e) {
                            values.add(Integer.valueOf(((String)buffer).charAt(0)));
                        }
                    } else if (((String)buffer).matches("^[^0-9]+$")) {
                        values.add(Integer.valueOf(((String)buffer).charAt(0)));
                    } else {
                        for (char ch2 : ((String)buffer).toCharArray()) {
                            values.add(Integer.valueOf(ch2));
                        }
                    }
                }
                buffer = "";
                continue;
            }
            buffer = (String)buffer + ch;
        }
        if (!((String)buffer).isEmpty()) {
            if (((String)buffer).matches("^[0-9]+$")) {
                try {
                    values.add(Integer.parseInt((String)buffer));
                }
                catch (Exception e) {
                    values.add(Integer.valueOf(((String)buffer).charAt(0)));
                }
            } else if (((String)buffer).matches("^[^0-9]+$")) {
                values.add(Integer.valueOf(((String)buffer).charAt(0)));
            } else {
                for (char ch : ((String)buffer).toCharArray()) {
                    values.add(Integer.valueOf(ch));
                }
            }
        }
        int[] arr = new int[values.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (Integer)values.get(i);
        }
        return arr;
    }

    public static byte[] pemDecode(String pem) {
        String base64 = pem.replace("\r", "");
        while (base64.startsWith("-")) {
            base64 = base64.substring(1);
        }
        while (!base64.startsWith("-")) {
            base64 = base64.substring(1);
        }
        while (base64.startsWith("-")) {
            base64 = base64.substring(1);
        }
        base64 = base64.replace("\n", "");
        while (base64.endsWith("-")) {
            base64 = base64.substring(0, base64.length() - 1);
        }
        while (!base64.endsWith("-")) {
            base64 = base64.substring(0, base64.length() - 1);
        }
        while (base64.endsWith("-")) {
            base64 = base64.substring(0, base64.length() - 1);
        }
        return Base64.getDecoder().decode(base64);
    }

    static {
        loader = new DynamicClassLoader();
        tags = new HashMap();
    }

    private static class ResCont {
        public Object obj;

        private ResCont() {
        }
    }
}

