/*
 * Decompiled with CFR 0.152.
 */
package org.asf.sentinel.launcher;

import com.sun.javafx.application.PlatformImpl;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.function.Consumer;
import javafx.beans.property.ReadOnlyProperty;
import javafx.collections.ObservableList;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.asf.sentinel.launcher.LauncherUtils;
import org.w3c.dom.Document;

public class LauncherWindow {
    private JFrame frmSentinelLauncher;
    private WebView browser;
    private WebEngine engine;
    private Scene scene;
    private ArrayList<Runnable> postInitListeners = new ArrayList();
    private ArrayList<Consumer<String>> listeners = new ArrayList();
    private ArrayList<Consumer<Document>> loadListeners = new ArrayList();

    public LauncherWindow() {
        this.initialize();
    }

    private void initialize() {
        LauncherUtils.getInstance().log("Initializing UI...");
        this.frmSentinelLauncher = new JFrame("Sentinel Launcher");
        this.frmSentinelLauncher.setResizable(true);
        this.frmSentinelLauncher.setMinimumSize(new Dimension(800, 600));
        this.frmSentinelLauncher.setBounds(100, 100, 800, 600);
        this.frmSentinelLauncher.setDefaultCloseOperation(3);
        this.frmSentinelLauncher.setLocationRelativeTo(null);
        final JFXPanel panel = new JFXPanel();
        this.frmSentinelLauncher.setContentPane((Container)panel);
        panel.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (LauncherWindow.this.browser != null) {
                    LauncherWindow.this.browser.setPrefSize((double)panel.getWidth(), (double)panel.getHeight());
                }
            }
        });
        SwingUtilities.invokeLater(() -> PlatformImpl.startup(() -> {
            LauncherUtils.getInstance().log("Starting JavaFX webview...");
            Stage stage = new Stage();
            stage.setResizable(true);
            Group root = new Group();
            this.scene = new Scene((Parent)root, (double)panel.getWidth(), (double)panel.getHeight());
            stage.setScene(this.scene);
            this.browser = new WebView();
            this.browser.setContextMenuEnabled(false);
            this.engine = this.browser.getEngine();
            this.engine.setJavaScriptEnabled(true);
            this.listeners.forEach((Consumer<Consumer<String>>)((Consumer<Consumer>)listener -> this.engine.locationProperty().addListener((url, o, v) -> {
                LauncherUtils.getInstance().log("Navigating to " + url);
                ReadOnlyProperty prop = (ReadOnlyProperty)url;
                listener.accept((String)prop.getValue());
            })));
            this.listeners.clear();
            this.loadListeners.forEach((Consumer<Consumer<Document>>)((Consumer<Consumer>)listener -> this.engine.documentProperty().addListener((t, o, v) -> {
                if (v != null) {
                    listener.accept(this.engine.getDocument());
                }
            })));
            this.loadListeners.clear();
            ObservableList children = root.getChildren();
            children.add((Object)this.browser);
            panel.setScene(this.scene);
            LauncherUtils.getInstance().log("Post-initializing...");
            for (Runnable run : this.postInitListeners) {
                run.run();
            }
            this.postInitListeners.clear();
        }));
    }

    public void navigate(String url) {
        PlatformImpl.startup(() -> this.engine.load(url));
    }

    public void addUrlListener(Consumer<String> listener) {
        if (this.engine == null) {
            this.listeners.add(listener);
            return;
        }
        this.engine.locationProperty().addListener((url, o, v) -> {
            ReadOnlyProperty prop = (ReadOnlyProperty)url;
            listener.accept((String)prop.getValue());
        });
    }

    public void addPostLoadListener(Consumer<Document> listener) {
        if (this.engine == null) {
            this.loadListeners.add(listener);
            return;
        }
        this.engine.documentProperty().addListener((t, o, v) -> {
            if (v != null) {
                listener.accept((Document)v);
            }
        });
    }

    public void addPostInitListener(Runnable listener) {
        if (this.engine != null) {
            PlatformImpl.startup(() -> listener.run());
            return;
        }
        this.postInitListeners.add(listener);
    }

    public WebEngine getWebEngine() {
        return this.engine;
    }

    public WebView getWebView() {
        return this.browser;
    }

    public JFrame getFrame() {
        return this.frmSentinelLauncher;
    }
}

