/*
 * Decompiled with CFR 0.152.
 */
package org.asf.sentinel.launcher.bindings;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import org.asf.sentinel.launcher.LauncherMain;
import org.asf.sentinel.launcher.LauncherUtils;
import org.asf.sentinel.launcher.bindings.experiments.ExperimentsInterfaceBindings;
import org.asf.sentinel.launcher.bindings.servers.ServersInterfaceBindings;

public class SentinelLauncherJsBindings {
    public LauncherMain launcher;
    public String launcherVersion;
    public LauncherUtils launcherUtils;
    public String ipcServerUrl;
    public boolean bindFailure = false;
    public ServersInterfaceBindings servers;
    public ExperimentsInterfaceBindings experiments;

    public SentinelLauncherJsBindings(LauncherMain launcher) {
        this.launcher = launcher;
        this.launcherUtils = launcher.getUtils();
        this.ipcServerUrl = launcher.getIpcServerBaseUrl();
        this.launcherVersion = LauncherMain.LAUNCHER_VERSION;
        this.servers = new ServersInterfaceBindings();
        this.experiments = new ExperimentsInterfaceBindings();
    }

    public void setIcon(String iconSourceUrl) throws IOException {
        if (iconSourceUrl == null) {
            return;
        }
        if (!((String)iconSourceUrl).contains(":")) {
            iconSourceUrl = this.ipcServerUrl + (String)iconSourceUrl;
        }
        URL u = new URL((String)iconSourceUrl);
        InputStream strm = u.openStream();
        this.launcherUtils.getLauncherFrame().setIconImage(ImageIO.read(strm));
        strm.close();
    }

    public void log(String message) {
        this.launcherUtils.log("[UI MESSAGE] " + message);
    }

    public void logDebug(String message) {
        this.launcherUtils.log("[UI DEBUG] " + message);
    }

    public void logError(String message) {
        this.launcherUtils.log("[UI ERROR] " + message);
    }

    public void sentinelBind() {
        this.launcherUtils.getLauncherWindow().getWebEngine().executeScript("bind()");
    }
}

