/*
 * Decompiled with CFR 0.152.
 */
package org.asf.sentinel.launcher.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import org.asf.connective.RemoteClient;
import org.asf.connective.processors.HttpRequestProcessor;
import org.asf.sentinel.launcher.LauncherMain;
import org.asf.sentinel.launcher.LauncherUtils;

public class UiContentProcessor
extends HttpRequestProcessor {
    public HttpRequestProcessor createNewInstance() {
        return new UiContentProcessor();
    }

    public String path() {
        return "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(String path, String method, RemoteClient client) throws IOException {
        try {
            InputStream source = null;
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            String scope = "launcher";
            if (this.getRequestQueryParameters().containsKey("scope")) {
                scope = (String)this.getRequestQueryParameters().get("scope");
            }
            Class<LauncherMain> cls = LauncherMain.class;
            switch (scope) {
                case "launcher": {
                    cls = LauncherMain.class;
                    break;
                }
                default: {
                    this.setResponseStatus(404, "Scope not recognized");
                    return;
                }
            }
            try {
                URL loc = cls.getProtectionDomain().getCodeSource().getLocation();
                File f = new File(loc.toURI());
                source = f.isFile() ? new URL("jar:" + f.toURI() + "!/" + path).openStream() : new FileInputStream(new File(f, path));
                String type = MainFileMap.getInstance().getContentType(path);
                this.setResponseContent(type, source);
            }
            catch (Exception e) {
                if (source != null) {
                    source.close();
                }
                this.setResponseStatus(404, "File not found");
                LauncherUtils.getInstance().log(this.getRequest().getRequestMethod() + " /" + path + " : " + this.getResponse().getResponseCode() + " " + this.getResponse().getResponseMessage() + " [" + client.getRemoteAddress() + "]");
                return;
            }
        }
        finally {
            LauncherUtils.getInstance().log(this.getRequest().getRequestMethod() + " /" + path + " : " + this.getResponse().getResponseCode() + " " + this.getResponse().getResponseMessage() + " [" + client.getRemoteAddress() + "]");
        }
    }

    public boolean supportsChildPaths() {
        return true;
    }

    private static class MainFileMap
    extends MimetypesFileTypeMap {
        private static MainFileMap instance;
        private FileTypeMap parent;

        public static MainFileMap getInstance() {
            if (instance == null) {
                instance = new MainFileMap(MimetypesFileTypeMap.getDefaultFileTypeMap());
            }
            return instance;
        }

        public MainFileMap(FileTypeMap parent) {
            this.parent = parent;
            this.addMimeTypes("application/xml\txml");
            this.addMimeTypes("application/json\tjson");
            this.addMimeTypes("text/ini\tini\tini");
            this.addMimeTypes("text/css\tcss");
            this.addMimeTypes("text/javascript\tjs");
            if (new File(".mime.types").exists()) {
                try {
                    this.addMimeTypes(Files.readString(Path.of(".mime.types", new String[0])));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (new File("mime.types").exists()) {
                try {
                    this.addMimeTypes(Files.readString(Path.of("mime.types", new String[0])));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public String getContentType(String filename) {
            String type = super.getContentType(filename);
            if (type.equals("application/octet-stream")) {
                type = this.parent.getContentType(filename);
            }
            return type;
        }
    }
}

